" Vim syntax file
" Language:	Vim 5.4b script
" Maintainer:	Dr. Charles E. Campbell, Jr. <cec@gryphon.gsfc.nasa.gov>
" Last Change:	December 21, 1998
" Version:	5.4b-01

" Remove old syntax
syn clear

syn keyword vimTodo contained	COMBAK	NOT	RELEASED	TODO

" regular vim commands
syn keyword vimCommand contained	N[ext]	cnoremenu	imenu	onoreme	sts[elect]
syn keyword vimCommand contained	P[rint]	co[py]	ino[remap]	onoremenu	sun[hide]
syn keyword vimCommand contained	X	col[der]	inorea[bbrev]	ou[nmap]	sus[pend]
syn keyword vimCommand contained	a[ppend]	com[mand]	inoreme	ounme	sv[iew]
syn keyword vimCommand contained	ab[breviate]	comc[lear]	inoremenu	ounmenu	sy[ntax]
syn keyword vimCommand contained	abc[lear]	con[tinue]	is[earch]	p[rint]	syncbind
syn keyword vimCommand contained	al[l]	conf[irm]	isp[lit]	pe[rl]	syntax
syn keyword vimCommand contained	am	cp[revious]	iu[nmap]	perld[o]	t
syn keyword vimCommand contained	amenu	cq[uit]	iuna[bbrev]	po[p]	tN[ext]
syn keyword vimCommand contained	an	cr[ewind]	iunme	pre[serve]	ta[g]
syn keyword vimCommand contained	anoremenu	cu[nmap]	iunmenu	prev[ious]	tags
syn keyword vimCommand contained	ar[gs]	cuna[bbrev]	j[oin]	promptf[ind]	tc[l]
syn keyword vimCommand contained	argu[ment]	cunme	ju[mps]	promptr[epl]	tcld[o]
syn keyword vimCommand contained	as[cii]	cunmenu	k	pu[t]	tclf[ile]
syn keyword vimCommand contained	au[tocmd]	d[elete]	l[ist]	pw[d]	te[aroff]
syn keyword vimCommand contained	aug[roup]	delc[ommand]	la[st]	py[thon]	tj[ump]
syn keyword vimCommand contained	aun	delf[unction]	le[ft]	pyf[ile]	tl[ast]
syn keyword vimCommand contained	aunmenu	di[splay]	let	q[uit]	tm[enu]
syn keyword vimCommand contained	autocmd	dig[raphs]	ls	qa[ll]	tn[ext]
syn keyword vimCommand contained	bN[ext]	display	m[ove]	r[ead]	tp[revious]
syn keyword vimCommand contained	b[uffer]	dj[ump]	ma[rk]	rec[over]	tr[ewind]
syn keyword vimCommand contained	ba[ll]	dl[ist]	mak[e]	red[o]	ts[elect]
syn keyword vimCommand contained	bad[d]	do[autocmd]	map	redi[r]	tu[nmenu]
syn keyword vimCommand contained	bd[elete]	doautoa[ll]	mapc[lear]	reg[isters]	u[ndo]
syn keyword vimCommand contained	be[have]	ds[earch]	marks	res[ize]	una[bbreviate]
syn keyword vimCommand contained	bl[ast]	dsp[lit]	me	ret[ab]	unh[ide]
syn keyword vimCommand contained	bm[odified]	e[dit]	menu	retu[rn]	unl[et]
syn keyword vimCommand contained	bn[ext]	ec[ho]	mk[exrc]	rew[ind]	unm[ap]
syn keyword vimCommand contained	bp[revious]	echoh[l]	mks[ession]	ri[ght]	unme
syn keyword vimCommand contained	br[ewind]	echon	mkv[imrc]	rv[iminfo]	unmenu
syn keyword vimCommand contained	brea[k]	el[se]	mod[e]	sN[ext]	v[global]
syn keyword vimCommand contained	bro[wse]	elsei[f]	n[ext]	s[ubstitute]	ve[rsion]
syn keyword vimCommand contained	buffers	en[dif]	new	sa[rgument]	vi[sual]
syn keyword vimCommand contained	bun[load]	endf[unction]	nm[ap]	sal[l]	vie[w]
syn keyword vimCommand contained	cN[ext]	endw[hile]	nmapc[lear]	sbN[ext]	vm[ap]
syn keyword vimCommand contained	c[hange]	ex	nme	sb[uffer]	vmapc[lear]
syn keyword vimCommand contained	ca[bbrev]	exe[cute]	nmenu	sba[ll]	vme
syn keyword vimCommand contained	cabc[lear]	exi[t]	nn[oremap]	sbl[ast]	vmenu
syn keyword vimCommand contained	cal[l]	f[ile]	nnoreme	sbm[odified]	vn[oremap]
syn keyword vimCommand contained	cc	files	nnoremenu	sbn[ext]	vnoreme
syn keyword vimCommand contained	cd	fix[del]	no[remap]	sbp[revious]	vnoremenu
syn keyword vimCommand contained	ce[nter]	fu[nction]	noh[lsearch]	sbr[ewind]	vu[nmap]
syn keyword vimCommand contained	cf[ile]	g[lobal]	norea[bbrev]	se[t]	vunme
syn keyword vimCommand contained	chd[ir]	gr[ep]	noreme	sh[ell]	vunmenu
syn keyword vimCommand contained	che[ckpath]	h[elp]	noremenu	si[malt]	wN[ext]
syn keyword vimCommand contained	cl[ist]	helpf[ind]	norm[al]	sl[eep]	w[rite]
syn keyword vimCommand contained	cla[st]	hi[ghlight]	nu[mber]	sla[st]	wa[ll]
syn keyword vimCommand contained	clo[se]	hid[e]	nun[map]	sm[agic]	wh[ile]
syn keyword vimCommand contained	cm[ap]	i[nsert]	nunme	sn[ext]	wn[ext]
syn keyword vimCommand contained	cmapc[lear]	ia[bbrev]	nunmenu	sno[magic]	wp[revous]
syn keyword vimCommand contained	cme	iabc[lear]	o[pen]	so[urce]	wq
syn keyword vimCommand contained	cmenu	if	om[ap]	sp[lit]	wqa[ll]
syn keyword vimCommand contained	cn[ext]	ij[ump]	omapc[lear]	spr[evious]	wv[iminfo]
syn keyword vimCommand contained	cnew[er]	il[ist]	ome	sr[ewind]	x[it]
syn keyword vimCommand contained	cno[remap]	im[ap]	omenu	st[op]	xa[ll]
syn keyword vimCommand contained	cnorea[bbrev]	imapc[lear]	on[ly]	sta[g]	y[ank]
syn keyword vimCommand contained	cnoreme	ime	ono[remap]	stj[ump]
syn match   vimCommand contained	"z[-+^.=]"

" All vimCommands are contained by vimIsCommands.
syn match vimIsCommand	"^\s*[a-zA-Z]\+"		transparent contains=vimCommand
syn match vimIsCommand	"[:|]\s*[a-zA-Z]\+"	transparent contains=vimCommand

" vimOptions are caught only when contained in a vimSet
syn keyword vimOption contained	ai	equalalways	keymodel	sbr	tagrelative
syn keyword vimOption contained	akm	equalprg	keywordprg	sc	tags
syn keyword vimOption contained	al	errorbells	km	scb	tb
syn keyword vimOption contained	aleph	errorfile	kp	scr	tbi
syn keyword vimOption contained	allowrevins	errorformat	langmap	scroll	tbs
syn keyword vimOption contained	altkeymap	esckeys	laststatus	scrollbind	term
syn keyword vimOption contained	ari	et	lazyredraw	scrolljump	terse
syn keyword vimOption contained	autoindent	eventignore	lbr	scrolloff	textauto
syn keyword vimOption contained	autowrite	ex	lcs	scrollopt	textmode
syn keyword vimOption contained	aw	expandtab	linebreak	scs	textwidth
syn keyword vimOption contained	background	exrc	lines	sect	tf
syn keyword vimOption contained	backspace	fe	lisp	sections	tildeop
syn keyword vimOption contained	backup	ff	list	secure	timeout
syn keyword vimOption contained	backupdir	ffs	listchars	sel	timeoutlen
syn keyword vimOption contained	backupext	fileencoding	lmap	selection	title
syn keyword vimOption contained	bdir	fileformat	ls	selectmode	titlelen
syn keyword vimOption contained	bex	fileformats	lz	sessionoptions	titlestring
syn keyword vimOption contained	bg	filetype	magic	sft	tl
syn keyword vimOption contained	bin	fk	makeef	sh	tm
syn keyword vimOption contained	binary	fkmap	makeprg	shcf	to
syn keyword vimOption contained	biosk	fo	mat	shell	toolbar
syn keyword vimOption contained	bioskey	formatoptions	matchpairs	shellcmdflag	top
syn keyword vimOption contained	bk	formatprg	matchtime	shellpipe	tr
syn keyword vimOption contained	breakat	fp	maxfuncdepth	shellquote	ts
syn keyword vimOption contained	brk	ft	maxmapdepth	shellredir	tsl
syn keyword vimOption contained	browsedir	gcr	maxmem	shelltype	ttimeout
syn keyword vimOption contained	bs	gd	maxmemtot	shellxquote	ttimeoutlen
syn keyword vimOption contained	bsdir	gdefault	mef	shiftround	ttm
syn keyword vimOption contained	cf	gfm	mfd	shiftwidth	ttybuiltin
syn keyword vimOption contained	ch	gfn	mh	shm	ttyfast
syn keyword vimOption contained	cin	go	ml	shortmess	ttym
syn keyword vimOption contained	cindent	gp	mls	shortname	ttymouse
syn keyword vimOption contained	cink	grepformat	mm	showbreak	ttyscroll
syn keyword vimOption contained	cinkeys	grepprg	mmd	showcmd	ttytype
syn keyword vimOption contained	cino	guicursor	mmt	showfulltag	tw
syn keyword vimOption contained	cinoptions	guifont	mod	showmatch	tx
syn keyword vimOption contained	cinw	guioptions	modeline	showmode	uc
syn keyword vimOption contained	cinwords	guipty	modelines	shq	ul
syn keyword vimOption contained	cmdheight	helpfile	modified	si	undolevels
syn keyword vimOption contained	co	helpheight	more	sidescroll	updatecount
syn keyword vimOption contained	columns	hf	mouse	sj	updatetime
syn keyword vimOption contained	com	hh	mousef	slm	ut
syn keyword vimOption contained	comments	hi	mousefocus	sm	vb
syn keyword vimOption contained	compatible	hid	mousehide	smartcase	vbs
syn keyword vimOption contained	complete	hidden	mousem	smartindent	verbose
syn keyword vimOption contained	confirm	highlight	mousemodel	smarttab	vi
syn keyword vimOption contained	cp	history	mouset	smd	viminfo
syn keyword vimOption contained	cpo	hk	mousetime	sn	visualbell
syn keyword vimOption contained	cpoptions	hkmap	mp	so	wa
syn keyword vimOption contained	cpt	hkmapp	mps	softtabstop	wak
syn keyword vimOption contained	cscopeprg	hkp	nf	sol	warn
syn keyword vimOption contained	cscopetag	hl	nrformats	sp	wb
syn keyword vimOption contained	cscopetagorder	hls	nu	splitbelow	wc
syn keyword vimOption contained	cscopeverbose	hlsearch	number	sr	wd
syn keyword vimOption contained	csprg	ic	oft	srr	weirdinvert
syn keyword vimOption contained	cst	icon	osfiletype	ss	wh
syn keyword vimOption contained	csto	iconstring	pa	ssop	whichwrap
syn keyword vimOption contained	csverb	ignorecase	para	st	wig
syn keyword vimOption contained	def	im	paragraphs	sta	wildchar
syn keyword vimOption contained	define	inc	paste	startofline	wildignore
syn keyword vimOption contained	dg	include	patchmode	sts	wildmode
syn keyword vimOption contained	dict	incsearch	path	su	wim
syn keyword vimOption contained	dictionary	inf	pm	suffixes	winaltkeys
syn keyword vimOption contained	digraph	infercase	readonly	sw	winheight
syn keyword vimOption contained	dir	insertmode	remap	swapfile	winminheight
syn keyword vimOption contained	directory	is	report	swapsync	wiv
syn keyword vimOption contained	ea	isf	restorescreen	swf	wm
syn keyword vimOption contained	eb	isfname	revins	sws	wmh
syn keyword vimOption contained	ed	isi	ri	sxq	wrap
syn keyword vimOption contained	edcompatible	isident	rightleft	syn	wrapmargin
syn keyword vimOption contained	ef	isk	rl	syntax	wrapscan
syn keyword vimOption contained	efm	iskeyword	ro	ta	writeany
syn keyword vimOption contained	ei	isp	rs	tabstop	writebackup
syn keyword vimOption contained	ek	isprint	ru	tag	writedelay
syn keyword vimOption contained	endofline	joinspaces	ruler	tagbsearch	ws
syn keyword vimOption contained	eol	js	sb	taglength	ww
syn keyword vimOption contained	ep	key	sbo

" These are the turn-off setting variants
syn keyword vimOption contained	noai	noek	noinsertmode	noro	notagrelative
syn keyword vimOption contained	noakm	noendofline	nois	nors	notbi
syn keyword vimOption contained	noalkeymap	noeol	nojoinspaces	noru	notbs
syn keyword vimOption contained	noallowrevins	noequalalways	nojs	noruler	noterse
syn keyword vimOption contained	noari	noerrorbells	nolazyredraw	nosb	notextauto
syn keyword vimOption contained	noautoindent	noesckeys	nolbr	nosc	notextmode
syn keyword vimOption contained	noautowrite	noet	nolinebreak	noscs	notf
syn keyword vimOption contained	noaw	noex	nolisp	nosecure	notildeop
syn keyword vimOption contained	nobackup	noexpandtab	nolist	noshiftround	notimeout
syn keyword vimOption contained	nobin	noexrc	nolz	noshortname	notitle
syn keyword vimOption contained	nobinary	nofk	nomagic	noshowcmd	noto
syn keyword vimOption contained	nobiosk	nofkmap	nomh	noshowmatch	notop
syn keyword vimOption contained	nobioskey	nogd	noml	noshowmode	notr
syn keyword vimOption contained	nobk	nogdefault	nomod	nosi	nottimeout
syn keyword vimOption contained	nocf	noguipty	nomodeline	nosm	nottybuiltin
syn keyword vimOption contained	nocin	nohid	nomodified	nosmartcase	nottyfast
syn keyword vimOption contained	nocindent	nohidden	nomore	nosmartindent	notx
syn keyword vimOption contained	nocompatible	nohk	nomousef	nosmarttab	novb
syn keyword vimOption contained	noconfirm	nohkmap	nomousefocus	nosmd	novisualbell
syn keyword vimOption contained	nocp	nohkmapp	nomousehide	nosn	nowa
syn keyword vimOption contained	nocscopetag	nohkp	nonu	nosol	nowarn
syn keyword vimOption contained	nocscopeverbose	nohls	nonumber	nosplitbelow	nowb
syn keyword vimOption contained	nocst	nohlsearch	nopaste	nosr	noweirdinvert
syn keyword vimOption contained	nocsverb	noic	noreadonly	nosta	nowiv
syn keyword vimOption contained	nodg	noicon	noremap	nostartofline	nowrap
syn keyword vimOption contained	nodigraph	noignorecase	norestorescreen	noswapfile	nowrapscan
syn keyword vimOption contained	noea	noim	norevins	noswf	nowriteany
syn keyword vimOption contained	noeb	noincsearch	nori	nota	nowritebackup
syn keyword vimOption contained	noed	noinf	norightleft	notagbsearch	nows
syn keyword vimOption contained	noedcompatible	noinfercase	norl

" termcap codes (which can also be set)
syn keyword vimOption contained	t_AB	t_RI	t_da	t_k9	t_ks	t_so
syn keyword vimOption contained	t_AF	t_Sb	t_db	t_kD	t_ku	t_sr
syn keyword vimOption contained	t_AL	t_Sf	t_dl	t_kI	t_le	t_te
syn keyword vimOption contained	t_CS	t_ZH	t_k1	t_kN	t_mb	t_ti
syn keyword vimOption contained	t_Co	t_ZR	t_k2	t_kP	t_md	t_ue
syn keyword vimOption contained	t_DL	t_al	t_k3	t_kb	t_me	t_us
syn keyword vimOption contained	t_F1	t_bc	t_k4	t_kd	t_mr	t_vb
syn keyword vimOption contained	t_F2	t_cd	t_k5	t_ke	t_ms	t_ve
syn keyword vimOption contained	t_K1	t_ce	t_k6	t_kh	t_nd	t_vi
syn keyword vimOption contained	t_K3	t_cl	t_k7	t_kl	t_op	t_vs
syn keyword vimOption contained	t_K4	t_cm	t_k8	t_kr	t_se	t_xs
syn keyword vimOption contained	t_K5	t_cs
syn match   vimOption contained	"t_#4"
syn match   vimOption contained	"t_%1"
syn match   vimOption contained	"t_%i"
syn match   vimOption contained	"t_&8"
syn match   vimOption contained	"t_@7"
syn match   vimOption contained	"t_k;"

" these settings don't actually cause errors in vim, but were supported by vi and don't do anything in vim
syn keyword vimErrSetting contained	hardtabs	w1200	w9600	wi	window
syn keyword vimErrSetting contained	ht	w300

" AutoBuf Events
syn keyword vimAutoEvent contained	BufDelete	BufReadPre	FileReadPost	FilterWritePost	TermChanged
syn keyword vimAutoEvent contained	BufEnter	BufUnload	FileReadPre	FilterWritePre	User
syn keyword vimAutoEvent contained	BufFilePost	BufWrite	FileType	FocusGained	VimEnter
syn keyword vimAutoEvent contained	BufFilePre	BufWritePost	FileWritePost	FocusLost	VimLeave
syn keyword vimAutoEvent contained	BufLeave	BufWritePre	FileWritePre	StdinReadPost	VimLeavePre
syn keyword vimAutoEvent contained	BufNewFile	FileAppendPost	FilterReadPost	StdinReadPre	WinEnter
syn keyword vimAutoEvent contained	BufRead	FileAppendPre	FilterReadPre	Syntax	WinLeave
syn keyword vimAutoEvent contained	BufReadPost	FileChangedShell

" Highlight commonly used Groupnames
syn keyword vimGroup	Comment	Identifier	Keyword	Type	Delimiter
syn keyword vimGroup	Constant	Function	Exception	StorageClass	SpecialComment
syn keyword vimGroup	String	Statement	PreProc	Structure	Debug
syn keyword vimGroup	Character	Conditional	Include	Typedef	Ignore
syn keyword vimGroup	Number	Repeat	Define	Special	Error
syn keyword vimGroup	Boolean	Label	Macro	SpecialChar	Todo
syn keyword vimGroup	Float	Operator	PreCondit	Tag

" Default highlighting groups
syn keyword vimHLGroup	Cursor	LineNr	NonText	Search	Title
syn keyword vimHLGroup	Directory	Menu	Normal	SpecialKey	Visual
syn keyword vimHLGroup	ErrorMsg	ModeMsg	Question	StatusLine	WarningMsg
syn keyword vimHLGroup	IncSearch	MoreMsg	Scrollbar	StatusLineNC

" Function Names
syn keyword vimFuncName contained	argc	delete	has	matchend	synID
syn keyword vimFuncName contained	argv	did_filetype	hlID	matchstr	synIDattr
syn keyword vimFuncName contained	browse	escape	hlexists	nr2char	synIDtrans
syn keyword vimFuncName contained	bufexists	exists	hostname	setline	tempname
syn keyword vimFuncName contained	bufname	expand	input	strftime	virtcol
syn keyword vimFuncName contained	bufnr	filereadable	isdirectory	strlen	winbufnr
syn keyword vimFuncName contained	char2nr	fnamemodify	line	strpart	winheight
syn keyword vimFuncName contained	col	getcwd	match	substitute	winnr
syn keyword vimFuncName contained	confirm	getline
syn match   vimFunc     contained	"\I\i*\s*("	contains=vimFuncName

"--- syntax above generated by mkvimvim ---
" Special Vim Highlighting

" Behave!
" =======
syn match   vimBehave	"^\s*\(behave\|behav\|beha\|beh\|be\)" contains=vimCommand skipwhite nextgroup=vimBehaveModel,vimBehaveError
syn match   vimBehave	"[:|]\s*\(behave\|behav\|beha\|beh\|be\)"lc=1 contains=vimCommand skipwhite nextgroup=vimBehaveModel,vimBehaveError
syn keyword vimBehaveModel contained	mswin	xterm
syn match   vimBehaveError contained	"[^ ]\+"

" Functions
" =========
syn match  vimFunction	"\(function\|functio\|functi\|funct\|func\|fun\)\s\+[A-Z][a-z]*("	contains=vimCommand nextgroup=vimFuncBody
syn match  vimFunctionError	"\(function\|functio\|functi\|funct\|func\|fun\)\s\+[a-z].*("	contains=vimCommand nextgroup=vimFuncBody
syn region vimFuncBody contained	start=")"	end="\<endf"	contains=vimIsCommand,vimGroup,vimHLGroup,vimFunction,vimFunctionError,vimFuncBody,vimSpecFile,vimConditional,vimOper,vimNumber,vimComment,vimString,vimSubst,vimMark,vimRegister,vimAddress,vimFilter,vimCmplxRepeat,vimComment,vimSet,vimAutoCmd,vimRegion,vimSynLine,vimNotation,vimIsCommand,vimCtrlChar,vimFuncVar
syn match  vimFuncVar  contained	"a:\(\I\i*\|[0-9]\+\)"

syn keyword vimPattern contained	start	skip	end

" Special Filenames and Modifiers
syn match vimSpecFile	"<\(cword\|cWORD\|[cas]file\)>"	nextgroup=vimSpecFileMod,vimSubst
syn match vimSpecFile	"#\d\+\|[#%]<"		nextgroup=vimSpecFileMod,vimSubst
syn match vimSpecFileMod	"\(:[phtre]\)\+"		contained

" Conditionals
syn match vimConditional	"^\s*\(continue\|continu\|contin\|conti\|cont\|con\)\>"
syn match vimConditional	"^\s*\(endif\|endi\|end\|en\)\>"
syn match vimConditional	"^\s*\(endwhile\|endwhil\|endwhi\|endwh\|endw\)\>"
syn match vimConditional	"^\s*\(while\|whil\|whi\|wh\)\>"
syn match vimConditional	"^\s*break\=\>"
syn match vimConditional	"^\s*else\>"
syn match vimConditional	"^\s*elseif\=\>"
syn match vimConditional	"^\s*if\>"

syn match vimConditional	"[:|]\s*\(continue\|continu\|contin\|conti\|cont\|con\)\>"lc=1
syn match vimConditional	"[:|]\s*\(endif\|endi\|end\|en\)\>"lc=1
syn match vimConditional	"[:|]\s*\(endwhile\|endwhil\|endwhi\|endwh\|endw\)\>"lc=1
syn match vimConditional	"[:|]\s*\(while\|whil\|whi\|wh\)\>"lc=1
syn match vimConditional	"[:|]\s*break\=\>"lc=1
syn match vimConditional	"[:|]\s*else\>"lc=1
syn match vimConditional	"[:|]\s*elseif\=\>"lc=1
syn match vimConditional	"[:|]\s*if\>"lc=1

" Operators
syn match vimOper	"||\|&&\|!=\|>=\|<=\|=\~\|!\~\|>\|<\|+\|-\|=\|\." skipwhite nextgroup=vimString

" User-Specified Commands
syn cluster vimUserCmdList	contains=vimAddress,vimSyntax,vimHighlight,vimAutoCmd,vimCmplxRepeat,vimComment,vimConditional,vimCtrlChar,vimEscapeBrace,vimFilter,vimFunc,vimFunction,vimGroup,vimHLGroup,vimIsCommand,vimIsCommand,vimMark,vimNotation,vimNumber,vimOper,vimRegion,vimRegister,vimSet,vimSetEqual,vimSetString,vimSpecFile,vimString,vimSubst,vimSubstEnd,vimSubstRange,vimSynLine
syn region  vimUserCmd	transparent oneline matchgroup=vimStatement start="^\s*\(command\|comman\|comma\|comm\|com\)" end="$"		contains=vimUserAttrb,@vimUserCmdList
syn region  vimUserCmd	transparent oneline matchgroup=vimStatement start="[:|]\s*\(command\|comman\|comma\|comm\|com\)"hs=s+1 end="$"	contains=vimUserAttrb,@vimUserCmdList
syn match   vimUserAttrb	contained	"-nargs=[01*?+]"		contains=vimUserAttrbKey,vimOper
syn match   vimUserAttrb	contained transparent  "-complete=\(augroup\|buffer\|command\|dir\|event\|file\|help\|highlight\|menu\|option\|tag\|var\)"	contains=vimUserAttrbCmplt,vimOper
syn match   vimUserAttrb	contained	"-range\(=%\|=[0-9]\+\)\="	contains=vimNumber,vimOper,vimUserAttrbKey
syn match   vimUserAttrb	contained	"-count=[0-9]\+"		contains=vimNumber,vimOper,vimUserAttrbKey
syn match   vimUserAttrb	contained	"-bang\|-register"	contains=vimOper,vimUserAttrbKey
syn keyword vimUserAttrbKey	contained	bang	count	range
syn keyword vimUserAttrbKey	contained	complete	nargs	register
syn keyword vimUserAttrbCmplt	contained	augroup	dir	help	menu	tag
syn keyword vimUserAttrbCmplt	contained	buffer	event	highlight	option	var
syn keyword vimUserAttrbCmplt	contained	command	file

" Numbers
syn match vimNumber	"\<\d\+.\d\+"
syn match vimNumber	"\<\d\+L\="
syn match vimNumber	"-\d\+.\d\+"
syn match vimNumber	"-\d\+L\="
syn match vimNumber	"[[;:]\d\+"lc=1
syn match vimNumber	"0[xX][0-9a-fA-F]\+"
syn match vimNumber	"#[0-9a-fA-F]\+"

" Lower Priority Comments: after some vim commands...
syn match  vimComment	+\s"[^\-:.%#=*].*$+lc=1	contains=vimTodo,vimCommentString
syn match  vimComment	+\<endif\s\+".*$+lc=5	contains=vimTodo,vimCommentString
syn match  vimComment	+\<else\s\+".*$+lc=4	contains=vimTodo,vimCommentString
syn match  vimComment	+^\s*".*$+		contains=vimTodo,vimCommentString
syn region vimCommentString	contained oneline start="\s'"ms=s+1	end="'"

" Try to catch strings, if nothing else matches (therefore it must precede the others!)
"  vmEscapeBrace handles ["]  []"] (ie. stays as string)
syn region	vimEscapeBrace	oneline contained transparent	start="[^\\]\(\\\\\)*\[\^\=\]\=" skip="\\\\\|\\\]" end="\]"me=e-1
syn match	vimPatSep	contained	"\\[|()]"
syn match	vimNotPatSep	contained	"\\\\"
syn region	vimString	oneline	start=+[^:a-zA-Z>!\\]"+lc=1 skip=+\(\\\\\)*\\"+ end=+"+	contains=vimEscapeBrace,vimPatSep,vimNotPatSep
syn region	vimString	oneline	start=+[^:a-zA-Z>!\\]'+lc=1 skip=+\(\\\\\)*\\'+ end=+'+	contains=vimEscapeBrace,vimPatSep,vimNotPatSep
syn region	vimString	oneline	start=+=!+lc=1	skip=+\(\\\\\)*\\!+ end=+!+		contains=vimEscapeBrace,vimPatSep,vimNotPatSep
syn region	vimString	oneline	start="=+"lc=1	skip="\(\\\\\)*\\+" end="+"		contains=vimEscapeBrace,vimPatSep,vimNotPatSep
syn region	vimString	oneline	start="[^\\]+\s*[^a-zA-Z0-9.]"lc=1 skip="\(\\\\\)*\\+" end="+"	contains=vimEscapeBrace,vimPatSep,vimNotPatSep
syn region	vimString	oneline	start="\s/\s*[^a-zA-Z]"lc=1 skip="\(\\\\\)*\\+" end="/"	contains=vimEscapeBrace,vimPatSep,vimNotPatSep

" Substitutions
syn region	vimSubst	oneline	 start=":\=s/.\{-}" skip="\(\\\\\)*\\/" end="/"	contains=vimPatSep,vimSubstTwoBS,vimSubstRange,vimNotation nextgroup=vimSubstEnd
syn region	vimSubstEnd	contained oneline start="."lc=1	   skip="\(\\\\\)*\\/" end="/"	contains=vimSubstPat,vimSubstTwoBS,vimNotation
syn region	vimSubst	oneline	 start=":\=s?.\{-}" skip="\(\\\\\)*\\?" end="?"	contains=vimPatSep,vimSubstTwoBS,vimSubstRange,vimNotation nextgroup=vimSubstEnd
syn region	vimSubstEnd	contained oneline start="."lc=1	   skip="\(\\\\\)*\\?" end="?"	contains=vimSubstPat,vimSubstTwoBS,vimNotation
syn region	vimSubstRange	contained oneline start="\["	   skip="\(\\\\\)*\\]" end="]"
syn match	vimSubstPat	contained	"\\\d"
syn match	vimSubstTwoBS	contained	"\\\\"

" Marks, Registers, Addresses, Filters
syn match	vimMark	"[!,:]'[a-zA-Z0-9]"lc=1
syn match	vimMark	"'[a-zA-Z0-9][,!]"me=e-1
syn match	vimMark	"'[<>][,!]"me=e-1
syn match	vimMark	"[^a-zA-Z]norm\s'[a-zA-Z0-9]"lc=6
syn match	vimMark	"[^a-zA-Z]normal\s'[a-zA-Z0-9]"lc=8
syn match	vimPlainMark	"'[a-zA-Z0-9]"		contained

syn match	vimRegister	'[^(,;]"[a-zA-Z0-9\-:.%#*=][^a-zA-Z_"]'lc=1
syn match	vimRegister	'[^a-zA-Z]norm\s\+"[a-zA-Z0-9]'lc=6
syn match	vimRegister	'[^a-zA-Z]normal\s\+"[a-zA-Z0-9]'lc=8
syn match	vimPlainRegister	'"[a-zA-Z0-9\-:.%#*=]'	contained

syn match	vimAddress	",\."lc=1
syn match	vimAddress	"[:|][%.]"lc=1
syn match	vimAddress	"<Bar>%"lc=5

syn match	vimFilter	":\s*!"ms=e
syn match	vimFilter	"[^a-zA-Z]!"lc=1

" Complex repeats (:h complex-repeat)
syn match	vimCmplxRepeat	'[^a-zA-Z_/\\]q[0-9a-zA-Z"]'lc=1
syn match	vimCmplxRepeat	'@[0-9a-z".=@:]'

" High Priority Comments: beginning of line with optional spaces then "
syn match	vimLineComment		+^\s*".*$+	contains=vimTodo,vimCommentString,vimCommentTitle
syn match	vimCommentTitle	contained	"\([A-Z][a-z]*\s*\)\+:"

" Set command and associated set-options (vimOptions) with comment
syn region	vimSet		matchgroup=vimCommand start="\s*set\>" end="|\|$"	keepend contains=vimSetEqual,vimOption,vimErrSetting,vimComment,vimSetString
syn region	vimSetEqual	contained	start="="	skip="\(\\\\\)*\\\s" end="[| \t]\|$"me=e-1 contains=vimCtrlChar
syn region	vimSetString	contained	start=+="+hs=s+1	skip=+\(\\\\\)\\"+   end=+"+	contains=vimCtrlChar

" Autocmd
syn cluster vimAutoCmdCluster	contains=vimAutoCmdOpt,vimAutoEvent,vimComment,vimFilter,vimAuHighlight,vimIsCommand,vimIsCommand2,vimNotation,vimSet,vimSpecFile,vimString,vimAuSyntax
syn match   vimIsCommand2	contained transparent "[ \t<Bar>][a-zA-Z_]\+"lc=1  contains=vimCommand
syn keyword vimAutoCmdOpt	contained	nested
syn region  vimAutoCmd		matchgroup=vimAutoSet start=+^\s*\(autocmd\|au\|doautocmd\|doau\)\>+	end="$" keepend contains=@vimAutoCmdCluster
syn region  vimAutoCmd		matchgroup=vimAutoSet start=+[:|]\s*\(autocmd\|au\|doautocmd\|doau\)\>+	end="$" keepend contains=@vimAutoCmdCluster
syn region  vimAutoCmd		matchgroup=vimAutoSet start=+^\s*\(doautoa\|doautoall\)\>+		end="$" keepend contains=@vimAutoCmdCluster
syn region  vimAutoCmd		matchgroup=vimAutoSet start=+[:|]\s*\(autocmd\|au\|doautocmd\|doau\)\>+lc=1	end="$" keepend contains=@vimAutoCmdCluster

" Echo -- prefer strings!
syn region  vimEcho	oneline	start="\<\(echo\|ech\|ec\)\>"   skip="\(\\\\\)*|" end="$\||" contains=vimCommand,vimString,vimOper
syn region  vimEcho	oneline	start="^\s*\(echo\|ech\|ec\)\>" skip="\(\\\\\)*|" end="$\||" contains=vimCommand,vimString,vimOper

" Syntax
"=======
syn match   vimGroupList	contained	"@\=[^ \t,]*"	contains=vimGroupSpecial,vimPatSep
syn match   vimGroupList	contained	"@\=[^ \t,]*,"	nextgroup=vimGroupList contains=vimGroupSpecial,vimPatSep
syn keyword vimGroupSpecial	contained	ALL	ALLBUT
syn match   vimSynError	contained	"\i\+"
syn match   vimSynError	contained	"\i\+="	nextgroup=vimGroupList
syn match   vimSynContains	contained	"contains="	nextgroup=vimGroupList
syn match   vimSynNextgroup	contained	"nextgroup="	nextgroup=vimGroupList

syn match   vimSyntax	"^\s*\(syntax\|synta\|synt\|syn\|sy\)"	contains=vimCommand skipwhite nextgroup=vimSynType,vimComment
syn match   vimSyntax	"[:|]\s*\(syntax\|synta\|synt\|syn\|sy\)"	contains=vimCommand skipwhite nextgroup=vimSynType,vimComment
syn match   vimAuSyntax	contained	"\s+\(syntax\|synta\|synt\|syn\|sy\)"	contains=vimCommand skipwhite nextgroup=vimSynType,vimComment

" Syntax: case
syn keyword vimSynType		contained	case	skipwhite nextgroup=vimSynCase,vimSynCaseError
syn match   vimSynCaseError	contained	"\i\+"
syn keyword vimSynCase		contained	ignore	match

" Syntax: clear
syn keyword vimSynType		contained	clear	skipwhite nextgroup=vimGroupList

" Syntax: cluster
syn keyword vimSynType		contained	cluster		skipwhite nextgroup=vimClusterName
syn region  vimClusterName	contained	matchgroup=vimGroupName start="\k\+" skip="\(\\\\\)*\\|" end="$\||" contains=vimGroupAdd,vimGroupRem,vimSynContains,vimSynError
syn match   vimGroupAdd		contained	"add="		nextgroup=vimGroupList
syn match   vimGroupRem		contained	"remove="	nextgroup=vimGroupList

" Syntax: include
syn keyword vimSynType		contained	include		skipwhite nextgroup=vimGroupList

" Syntax: keyword
syn keyword vimSynType		contained	keyword		skipwhite nextgroup=vimSynKeyRegion
syn region  vimSynKeyRegion	contained oneline matchgroup=vimGroupName start="\k\+" skip="\(\\\\\)*\\|" end="$\||" contains=vimSynNextgroup,vimSynKeyOpt
syn match   vimSynKeyOpt	contained	"\<\(contained\|transparent\|skipempty\|skipwhite\|skipnl\)\>"

" Syntax: match
syn keyword vimSynType		contained	match	skipwhite nextgroup=vimSynMatchRegion
syn region  vimSynMatchRegion	contained oneline keepend matchgroup=vimGroupName start="\k\+" end="$" contains=vimComment,vimSynContains,vimSynError,vimSynKeyOpt,vimSynNextgroup,vimSynRegPat

" Syntax: off
syn keyword vimSynType		contained	off

" Syntax: region
syn keyword vimSynType		contained	region	skipwhite nextgroup=vimSynRegion
syn region  vimSynRegion	contained oneline matchgroup=vimGroupName start="\k\+" skip="\(\\\\\)*\\|" end="$\||" contains=vimSynContains,vimSynNextgroup,vimSynRegOpt,vimSynReg,vimSynMtchGrp
syn match   vimSynRegOpt	contained	"\<\(contained\|transparent\|skipempty\|skipwhite\|skipnl\|oneline\|keepend\)\>"
syn match   vimSynReg		contained	"\(start\|skip\|end\)="he=e-1	nextgroup=vimSynRegPat
syn match   vimSynMtchGrp	contained	"matchgroup="
syn region  vimSynRegPat	contained oneline	start="!" skip="\(\\\\\)*\\!" end="!" contains=vimPatSep,vimNotPatSep,vimSynPatRange,vimSynNotPatRange nextgroup=vimSynPatMod
syn region  vimSynRegPat	contained oneline	start="%" skip="\(\\\\\)*\\-" end="%" contains=vimPatSep,vimNotPatSep,vimSynPatRange,vimSynNotPatRange nextgroup=vimSynPatMod
syn region  vimSynRegPat	contained oneline	start="'" skip="\(\\\\\)*\\'" end="'" contains=vimPatSep,vimNotPatSep,vimSynPatRange,vimSynNotPatRange nextgroup=vimSynPatMod
syn region  vimSynRegPat	contained oneline	start="+" skip="\(\\\\\)*\\+" end="+" contains=vimPatSep,vimNotPatSep,vimSynPatRange,vimSynNotPatRange nextgroup=vimSynPatMod
syn region  vimSynRegPat	contained oneline	start="@" skip="\(\\\\\)*\\@" end="@" contains=vimPatSep,vimNotPatSep,vimSynPatRange,vimSynNotPatRange nextgroup=vimSynPatMod
syn region  vimSynRegPat	contained oneline	start='"' skip='\(\\\\\)*\\"' end='"' contains=vimPatSep,vimNotPatSep,vimSynPatRange,vimSynNotPatRange nextgroup=vimSynPatMod
syn region  vimSynRegPat	contained oneline	start='/' skip='\(\\\\\)*\\/' end='/' contains=vimPatSep,vimNotPatSep,vimSynPatRange,vimSynNotPatRange nextgroup=vimSynPatMod
syn region  vimSynRegPat	contained oneline	start=',' skip='\(\\\\\)*\\,' end=',' contains=vimPatSep,vimNotPatSep,vimSynPatRange,vimSynNotPatRange nextgroup=vimSynPatMod
syn region  vimSynRegPat	contained oneline	start='\$' skip='\(\\\\\)*\\\$' end='\$' contains=vimPatSep,vimNotPatSep,vimSynPatRange,vimSynNotPatRange nextgroup=vimSynPatMod
syn match   vimSynPatMod	contained	"\(hs\|ms\|me\|hs\|he\|rs\|re\)=[se]\([-+][0-9]\+\)\="
syn match   vimSynPatMod	contained	"\(hs\|ms\|me\|hs\|he\|rs\|re\)=[se]\([-+][0-9]\+\)\=," nextgroup=vimSynPatMod
syn match   vimSynPatMod	contained	"lc=[0-9]"
syn match   vimSynPatMod	contained	"lc=[0-9]," nextgroup=vimSynPatMod
syn region  vimSynPatRange	contained oneline start="\["	skip="\(\\\\\)*\\]"   end="]"
syn match   vimSynNotPatRange	contained	"\(\\\\\)*\\\["

" Syntax: sync
syn keyword vimSynType		contained	sync	skipwhite nextgroup=vimSyncC,vimSyncLines,vimSyncMatch,vimSyncError,vimSyncLinecont
syn match   vimSyncError	contained	"\i\+"
syn keyword vimSyncC	contained	ccomment	clear
syn keyword vimSyncMatch	contained	match	skipwhite nextgroup=vimSyncGroupName
syn keyword vimSyncLinecont	contained	linecont	skipwhite nextgroup=vimSynRegPat
syn match   vimSyncLines	contained	"\(minlines\|maxlines\|lines\)=" nextgroup=vimNumber
syn match   vimSyncGroupName	contained	"\k\+" skipwhite nextgroup=vimSyncKey
syn match   vimSyncKey		contained	"\<groupthere\|grouphere\>"	skipwhite nextgroup=vimSyncGroup
syn match   vimSyncGroup	contained	"\k\+" skipwhite nextgroup=vimSynRegPat,vimSyncNone
syn keyword vimSyncNone		contained	NONE

" Additional IsCommand stuff, here by reasons of precedence
" ====================
syn match vimIsCommand	"<Bar>\s*[a-zA-Z]\+"	transparent contains=vimCommand,vimNotation

" Highlighting
" ============
syn match   vimHighlight	"^\s*\(highlight\|highligh\|highlig\|highli\|highl\|high\|hig\|hi\)"	skipwhite nextgroup=vimHiLink,vimHiClear,vimHiKeyList,vimComment
syn match   vimHighlight	"[:|]\s*\(highlight\|highligh\|highlig\|highli\|highl\|high\|hig\|hi\)"	skipwhite nextgroup=vimHiLink,vimHiClear,vimHiKeyList,vimComment
syn match   vimAuHighlight	contained	"\s+\(highlight\|highligh\|highlig\|highli\|highl\|high\|hig\|hi\)"	skipwhite nextgroup=vimHiLink,vimHiClear,vimHiKeyList,vimComment

syn match   vimHiGroup	contained	"\i\+"
syn case ignore
syn keyword vimHiAttrib	contained	none bold inverse italic reverse standout underline
syn case match
syn match   vimHiAttribList	contained	"\i\+"	contains=vimHiAttrib
syn match   vimHiAttribList	contained	"\i\+,"he=e-1	contains=vimHiAttrib nextgroup=vimHiAttribList,vimHiAttrib
syn case ignore
syn keyword vimHiCtermColor	contained	black	darkcyan	darkred	lightcyan	lightred
syn keyword vimHiCtermColor	contained	blue	darkgray	gray	lightgray	magenta
syn keyword vimHiCtermColor	contained	brown	darkgreen	green	lightgreen	red
syn keyword vimHiCtermColor	contained	cyan	darkgrey	grey	lightgrey	white
syn keyword vimHiCtermColor	contained	darkBlue	darkmagenta	lightblue	lightmagenta	yellow
syn case match
syn match   vimHiFontname	contained	"[a-zA-z\-*]\+"
syn match   vimHiGuiFontname	contained	"'[a-zA-z\-* ]\+'"
syn match   vimHiGuiRgb	contained	"#\x\{6}"
syn match   vimHiCtermError	contained	"[^0-9]\i*"

" Highlighting: hi group key=arg ...
syn cluster vimHiCluster contains=vimHiGroup,vimHiTerm,vimHiCTerm,vimHiStartStop,vimHiCtermFgBg,vimHiGui,vimHiGuiFont,vimHiGuiFgBg,vimHiKeyError
syn region vimHiKeyList	contained oneline start="\i\+" skip="\(\\\\\)*\\|" end="$\||"	contains=@vimHiCluster
syn match  vimHiKeyError	contained	"\i\+="he=e-1
syn match  vimHiTerm	contained	"[tT][eE][rR][mM]="he=e-1			nextgroup=vimHiAttribList
syn match  vimHiStartStop	contained	"\([sS][tT][aA][rR][tT]\|[sS][tT][oO][pP]\)="he=e-1	nextgroup=vimHiTermcap,vimOption
syn match  vimHiCTerm	contained	"[cC][tT][eE][rR][mM]="he=e-1			nextgroup=vimHiAttribList
syn match  vimHiCtermFgBg	contained	"[cC][tT][eE][rR][mM][fFbB][gG]="he=e-1		nextgroup=vimNumber,vimHiCtermColor,vimHiCtermError
syn match  vimHiGui	contained	"[gG][uU][iI]="he=e-1			nextgroup=vimHiAttribList
syn match  vimHiGuiFont	contained	"[fF][oO][nN][tT]="he=e-1			nextgroup=vimHiFontname
syn match  vimHiGuiFgBg	contained	"[gG][uU][iI][fFbB][gG]="he=e-1			nextgroup=vimHiGroup,vimHiGuiFontname,vimHiGuiRgb
syn match  vimHiTermcap	contained	"\S\+"		contains=vimNotation

" Highlight: clear
syn keyword vimHiClear	contained	clear		nextgroup=vimHiGroup

" Highlight: link
syn region vimHiLink	contained oneline matchgroup=vimCommand start="link" end="$"	contains=vimHiGroup,vimGroup

" Angle-Bracket Notation (tnx to Michael Geddes)
" ======================
syn case ignore
syn match vimNotation	"<\([scam]-\)\{0,4}\(f[0-9]\{1,2}\|\S\|cr\|lf\|linefeed\|return\|del\(ete\)\ =\|bs\|backspace\|tab\|esc\|right\|left\|Help\|Undo\|Insert\|Ins\|k\=Home\|k \=End\|kPlus\|kMinus\|kDivide\|kMultiply\|kEnter\|k\=\(page\)\=\(\|down\|up\)\)>" contains=vimBracket
syn match vimNotation	"<\([scam2-4]-\)\{0,4}\(right\|left\|middle\)\(mouse\|drag\|release\)>" contains=vimBracket
syn match vimNotation	"<\(nul\|bar\|bslash\|lt\|space\)>"		contains=vimBracket
syn match vimNotation	'<C-R>[0-9a-z"%#:.\-=]'he=e-1			contains=vimBracket
syn match vimBracket contained	"[<>]"
syn match vimBracket contained	"[<>]"
syn case match

" Control Characters
" ==================
syn match vimCtrlChar	"[--]"

" Highlighting Settings
" ====================
if !exists("did_vim_syntax_inits")
  let did_vim_syntax_inits = 1

  " The default methods for highlighting.  Can be overridden later
  hi link vimAuHighlight	vimHighlight

  hi link vimAddress	vimMark
  hi link vimAutoCmdOpt	vimOption
  hi link vimAutoSet	vimCommand
  hi link vimBehaveError	vimError
  hi link vimCommentString	vimString
  hi link vimConditional	vimStatement
  hi link vimErrSetting	vimError
  hi link vimFilter	vimOper
  hi link vimFunctionError	vimError
  hi link vimGroupAdd	vimSynOption
  hi link vimGroupRem	vimSynOption
  hi link vimHLGroup	vimGroup
  hi link vimHiAttribList	vimError
  hi link vimHiCTerm	vimHiTerm
  hi link vimHiCtermError	vimError
  hi link vimHiCtermFgBg	vimHiTerm
  hi link vimHiGroup	vimGroupName
  hi link vimHiGui	vimHiTerm
  hi link vimHiGuiFgBg	vimHiTerm
  hi link vimHiGuiFont	vimHiTerm
  hi link vimHiGuiRgb	vimNumber
  hi link vimHiKeyError	vimError
  hi link vimHiStartStop	vimHiTerm
  hi link vimHighlight	vimCommand
  hi link vimKeyCode	vimSpecFile
  hi link vimKeyCodeError	vimError
  hi link vimLineComment	vimComment
  hi link vimNotPatSep	vimString
  hi link vimPlainMark	vimMark
  hi link vimPlainRegister	vimRegister
  hi link vimSetString	vimString
  hi link vimSpecFileMod	vimSpecFile
  hi link vimSynCaseError	vimError
  hi link vimSynContains	vimSynOption
  hi link vimSynKeyOpt	vimSynOption
  hi link vimSynMtchGrp	vimSynOption
  hi link vimSynNextgroup	vimSynOption
  hi link vimSynNotPatRange	vimSynRegPat
  hi link vimSynPatRange	vimString
  hi link vimSynRegOpt	vimSynOption
  hi link vimSynRegPat	vimString
  hi link vimSynType	vimSpecial
  hi link vimSyncGroup	vimGroupName
  hi link vimSyncGroupName	vimGroupName
  hi link vimUserAttrb	vimSpecial
  hi link vimUserAttrbCmplt	vimSpecial
  hi link vimUserAttrbKey	vimOption
  hi link vimUserCmd	vimCommand

  hi link vimAutoEvent	Type
  hi link vimBracket	Delimiter
  hi link vimCmplxRepeat	SpecialChar
  hi link vimCommand	Statement
  hi link vimComment	Comment
  hi link vimCommentTitle	PreProc
  hi link vimCtrlChar	SpecialChar
  hi link vimError	Error
  hi link vimFuncName	Function
  hi link vimFuncVar	Identifier
  hi link vimGroup	Type
  hi link vimGroupSpecial	Special
  hi link vimHLMod	PreProc
  hi link vimHiAttrib	PreProc
  hi link vimHiTerm	Type
  hi link vimKeyword	Statement
  hi link vimMark	Number
  hi link vimNotation	Special
  hi link vimNumber	Number
  hi link vimOper	Operator
  hi link vimOption	PreProc
  hi link vimPatSep	SpecialChar
  hi link vimPattern	Type
  hi link vimRegister	SpecialChar
  hi link vimSpecFile	Identifier
  hi link vimSpecial	Type
  hi link vimStatement	Statement
  hi link vimString	String
  hi link vimSubstPat	SpecialChar
  hi link vimSynCase	Type
  hi link vimSynCaseError	Error
  hi link vimSynError	Error
  hi link vimSynOption	Special
  hi link vimSynReg	Type
  hi link vimSyncC	Type
  hi link vimSyncError	Error
  hi link vimSyncKey	Type
  hi link vimSyncNone	Type
  hi link vimTodo	Todo
endif

let b:current_syntax = "vim"

" vim: ts=17
