" Vim syntax support file
" Maintainer:	Bram Moolenaar <Bram@vim.org>
" Last change:	1998 Dec 6

" This file sets up for syntax highlighting.
" It is loaded from "syntax.vim" and "manual.vim".
" 1. Set the default highlight groups.
" 2. Install Syntax autocommands for all the available syntax files.

if has("syntax")

" let others know that syntax has been switched on
let syntax_on = 1

" The default methods for highlighting.  Can be overridden later.
" Many terminals can only use six different colors (plus black and white).
" Therefore the number of colors used is kept low. It doesn't look nice with
" too many colors anyway.
" Careful with "cterm=bold", it may change the color to bright.

" There are two sets of defaults: for a dark and a light background.
if &background == "dark"
  hi Comment	term=bold ctermfg=Cyan guifg=#80a0ff
  hi Constant	term=underline ctermfg=Magenta guifg=#ffa0a0
  hi Special	term=bold ctermfg=LightRed guifg=Orange
  hi Identifier term=underline cterm=bold ctermfg=Cyan guifg=#40ffff
  hi Statement	term=bold ctermfg=Yellow guifg=#ffff60 gui=bold
  hi PreProc	term=underline ctermfg=LightBlue guifg=#ff80ff
  hi Type	term=underline ctermfg=LightGreen guifg=#60ff60 gui=bold
  hi Ignore	ctermfg=black guifg=bg
else
  hi Comment	term=bold ctermfg=DarkBlue guifg=Blue
  hi Constant	term=underline ctermfg=DarkRed guifg=Magenta
  hi Special	term=bold ctermfg=DarkMagenta guifg=SlateBlue
  hi Identifier term=underline ctermfg=DarkCyan guifg=DarkCyan
  hi Statement	term=bold ctermfg=Brown gui=bold guifg=Brown
  hi PreProc	term=underline ctermfg=DarkMagenta guifg=Purple
  hi Type	term=underline ctermfg=DarkGreen guifg=SeaGreen gui=bold
  hi Ignore	ctermfg=white guifg=bg
endif
hi Error term=reverse ctermbg=Red ctermfg=White guibg=Red guifg=White
hi Todo	 term=standout ctermbg=Yellow ctermfg=Black guifg=Blue guibg=Yellow

" Common groups that link to default highlighting.
" You can specify other highlighting easily.
hi link String		Constant
hi link Character	Constant
hi link Number		Constant
hi link Boolean		Constant
hi link Float		Number
hi link Function	Identifier
hi link Conditional	Statement
hi link Repeat		Statement
hi link Label		Statement
hi link Operator	Statement
hi link Keyword		Statement
hi link Exception	Statement
hi link Include		PreProc
hi link Define		PreProc
hi link Macro		PreProc
hi link PreCondit	PreProc
hi link StorageClass	Type
hi link Structure	Type
hi link Typedef		Type
hi link Tag		Special
hi link SpecialChar	Special
hi link Delimiter	Special
hi link SpecialComment	Special
hi link Debug		Special


" First remove all old syntax autocommands.
au! Syntax


" OFF
au Syntax OFF		syn clear

" ON
au Syntax ON		if &filetype != "" | exe "set syntax=" . &filetype | else | echohl ErrorMsg | echo "filetype unknown" | echohl None | endif


" The Syntax autocommands are all listed here, so that the user can remove,
" change or add his own for each syntax separately.

" Ada (83, 9X, 95)
au Syntax ada		so $VIMRUNTIME/syntax/ada.vim

" Assembly - GNU
au Syntax asm		so $VIMRUNTIME/syntax/asm.vim

" Assembly - H8300
au Syntax asmh8300	so $VIMRUNTIME/syntax/asmh8300.vim

" AHDL
au Syntax ahdl		so $VIMRUNTIME/syntax/ahdl.vim

" ASN.1
au Syntax asn		so $VIMRUNTIME/syntax/asn.vim

" Atlas
au Syntax atlas		so $VIMRUNTIME/syntax/atlas.vim

" Avenue
au Syntax ave		so $VIMRUNTIME/syntax/ave.vim

" Awk
au Syntax awk		so $VIMRUNTIME/syntax/awk.vim

" BASIC
au Syntax basic		so $VIMRUNTIME/syntax/basic.vim

" Batch file for MSDOS
au Syntax dosbatch	so $VIMRUNTIME/syntax/dosbatch.vim

" Batch file for 4DOS
au Syntax btm		so $VIMRUNTIME/syntax/btm.vim

" BibTeX bibliography database file
au Syntax bib		so $VIMRUNTIME/syntax/bib.vim

" C
au Syntax c		so $VIMRUNTIME/syntax/c.vim

" C++
au Syntax cpp		so $VIMRUNTIME/syntax/cpp.vim

" Cascading Style Sheets
au Syntax css		so $VIMRUNTIME/syntax/css.vim

" Century Term Command Scripts
au Syntax cterm		so $VIMRUNTIME/syntax/cterm.vim

" Clean
au Syntax clean		so $VIMRUNTIME/syntax/clean.vim

" Clipper
au Syntax clipper	so $VIMRUNTIME/syntax/clipper.vim

" Cobol
au Syntax cobol		so $VIMRUNTIME/syntax/cobol.vim

" Diff files
au Syntax diff		so $VIMRUNTIME/syntax/diff.vim

" DCL (Digital Command Language - vms)
au Syntax dcl		so $VIMRUNTIME/syntax/dcl.vim

" Dracula
au Syntax dracula	so $VIMRUNTIME/syntax/dracula.vim

" DTD (Document Type Definition for XML)
au Syntax dtd		so $VIMRUNTIME/syntax/dtd.vim

" Eiffel
au Syntax eiffel	so $VIMRUNTIME/syntax/eiffel.vim

" Elm Filter Rules file
au Syntax elmfilt	so $VIMRUNTIME/syntax/elmfilt.vim

" ESQL-C
au Syntax esqlc		so $VIMRUNTIME/syntax/esqlc.vim

" Exports
au Syntax exports	so $VIMRUNTIME/syntax/exports.vim

" Fortran
au Syntax fortran	so $VIMRUNTIME/syntax/fortran.vim

" Fvwm
au Syntax fvwm		so $VIMRUNTIME/syntax/fvwm.vim

" GP scripts (2.0 and onward)
au Syntax gp		so $VIMRUNTIME/syntax/gp.vim

" Gnuplot scripts
au Syntax gnuplot	so $VIMRUNTIME/syntax/gnuplot.vim

" Haskell
au Syntax haskell	so $VIMRUNTIME/syntax/haskell.vim
au Syntax lhaskell	so $VIMRUNTIME/syntax/lhaskell.vim

" HTML (.shtml for server side)
au Syntax html		so $VIMRUNTIME/syntax/html.vim

" IDL (Interface Description Language)
au Syntax idl		so $VIMRUNTIME/syntax/idl.vim

" Inform
au Syntax inform	so $VIMRUNTIME/syntax/inform.vim

" .INI file for MSDOS
au Syntax dosini	so $VIMRUNTIME/syntax/dosini.vim

" Java
au Syntax java		so $VIMRUNTIME/syntax/java.vim

" JavaCC
au Syntax javacc	so $VIMRUNTIME/syntax/javacc.vim

" JavaScript
au Syntax javascript	so $VIMRUNTIME/syntax/javascript.vim

" Jgraph
au Syntax jgraph	so $VIMRUNTIME/syntax/jgraph.vim

" Lace (ISE)
au Syntax lace		so $VIMRUNTIME/syntax/lace.vim

" Lex
au Syntax lex		so $VIMRUNTIME/syntax/lex.vim

" Lisp
au Syntax lisp		so $VIMRUNTIME/syntax/lisp.vim

" Lite
au Syntax lite		so $VIMRUNTIME/syntax/lite.vim

" LOTOS
au Syntax lotos		so $VIMRUNTIME/syntax/lotos.vim

" Lua
au Syntax lua		so $VIMRUNTIME/syntax/lua.vim

" Lynx style file
au Syntax lss		so $VIMRUNTIME/syntax/lss.vim

" M4
au Syntax m4		so $VIMRUNTIME/syntax/m4.vim

" Mail (for Elm, trn and rn)
au Syntax mail		so $VIMRUNTIME/syntax/mail.vim

" Makefile
au Syntax make		so $VIMRUNTIME/syntax/make.vim

" Manpage
au Syntax man		so $VIMRUNTIME/syntax/man.vim

" Maple V
au Syntax maple		so $VIMRUNTIME/syntax/maple.vim

" Matlab
au Syntax matlab	so $VIMRUNTIME/syntax/matlab.vim

" Metafont
au Syntax mf		so $VIMRUNTIME/syntax/mf.vim

" MetaPost
au Syntax mp		so $VIMRUNTIME/syntax/mp.vim

" Modula 2
au Syntax modula2	so $VIMRUNTIME/syntax/modula2.vim

" Msql
au Syntax msql		so $VIMRUNTIME/syntax/msql.vim

" Nasm
au Syntax nasm		so $VIMRUNTIME/syntax/nasm.vim

" M$ Resource files
au Syntax rc		so $VIMRUNTIME/syntax/rc.vim

" Mutt setup file
au Syntax muttrc	so $VIMRUNTIME/syntax/muttrc.vim

" Nroff/Troff (*.ms is checked below)
au Syntax nroff		so $VIMRUNTIME/syntax/nroff.vim

" OCAML
au Syntax ocaml		so $VIMRUNTIME/syntax/ocaml.vim

" Pascal
au Syntax pascal	so $VIMRUNTIME/syntax/pascal.vim

" Perl
au Syntax perl		so $VIMRUNTIME/syntax/perl.vim

" Perl or XPM
au Syntax pmfile	so $VIMRUNTIME/syntax/pmfile.vim

" Perl POD
au Syntax pod		so $VIMRUNTIME/syntax/pod.vim

" Php3
au Syntax php3		so $VIMRUNTIME/syntax/php3.vim

" Phtml
au Syntax phtml		so $VIMRUNTIME/syntax/phtml.vim

" Pike
au Syntax pike		so $VIMRUNTIME/syntax/pike.vim

" PL/SQL
au Syntax plsql		so $VIMRUNTIME/syntax/plsql.vim

" PO (GNU gettext)
au Syntax po		so $VIMRUNTIME/syntax/po.vim

" PostScript
au Syntax postscr	so $VIMRUNTIME/syntax/postscr.vim

" Povray
au Syntax pov		so $VIMRUNTIME/syntax/pov.vim

" Printcap and Termcap
au Syntax ptcap		so $VIMRUNTIME/syntax/ptcap.vim

" PCCTS
au Syntax pccts		so $VIMRUNTIME/syntax/pccts.vim

" Procmail
au Syntax procmail	so $VIMRUNTIME/syntax/procmail.vim

" Prolog
au Syntax prolog	so $VIMRUNTIME/syntax/prolog.vim

" Python
au Syntax python	so $VIMRUNTIME/syntax/python.vim

" Radiance
au Syntax radiance	so $VIMRUNTIME/syntax/radiance.vim

" Rebol
au Syntax rebol		so $VIMRUNTIME/syntax/rebol.vim

" Rexx
au Syntax rexx		so $VIMRUNTIME/syntax/rexx.vim

" S-lang
au Syntax slang		so $VIMRUNTIME/syntax/slang.vim

" Sather
au Syntax sather	so $VIMRUNTIME/syntax/sather.vim

" SDL
au Syntax sdl		so $VIMRUNTIME/syntax/sdl.vim

" sed
au Syntax sed		so $VIMRUNTIME/syntax/sed.vim

" Sendmail
au Syntax sm		so $VIMRUNTIME/syntax/sm.vim

" SGML
au Syntax sgml		so $VIMRUNTIME/syntax/sgml.vim

" Shell scripts (sh, ksh, bash, csh)
au Syntax sh		so $VIMRUNTIME/syntax/sh.vim
au Syntax csh		so $VIMRUNTIME/syntax/csh.vim

" Z-Shell script
au Syntax zsh		so $VIMRUNTIME/syntax/zsh.vim

" Scheme
au Syntax scheme	so $VIMRUNTIME/syntax/scheme.vim

" Simula
au Syntax simula	so $VIMRUNTIME/syntax/simula.vim

" SKILL
au Syntax skill		so $VIMRUNTIME/syntax/skill.vim

" SLRN
au Syntax slrnrc	so $VIMRUNTIME/syntax/slrnrc.vim
au Syntax slrnsc	so $VIMRUNTIME/syntax/slrnsc.vim

" Smalltalk
au Syntax st		so $VIMRUNTIME/syntax/st.vim

" SMIL
au Syntax smil		so $VIMRUNTIME/syntax/smil.vim

" SNMP MIB files
au Syntax mib		so $VIMRUNTIME/syntax/mib.vim

" Spec (Linux RPM)
au Syntax spec		so $VIMRUNTIME/syntax/spec.vim

" Squid
au Syntax squid		so $VIMRUNTIME/syntax/squid.vim

" SQL
au Syntax sql		so $VIMRUNTIME/syntax/sql.vim

" Tags
au Syntax tags		so $VIMRUNTIME/syntax/tags.vim

" Tcl
au Syntax tcl		so $VIMRUNTIME/syntax/tcl.vim

" Telix Salt
au Syntax tsalt		so $VIMRUNTIME/syntax/tsalt.vim

" TeX
au Syntax tex		so $VIMRUNTIME/syntax/tex.vim

" TF mud client
au Syntax tf		so $VIMRUNTIME/syntax/tf.vim

" Motif UIT/UIL files
au Syntax uil		so $VIMRUNTIME/syntax/uil.vim

" Verilog HDL
au Syntax verilog	so $VIMRUNTIME/syntax/verilog.vim

" VHDL
au Syntax vhdl		so $VIMRUNTIME/syntax/vhdl.vim

" Vim Help file
au Syntax help		so $VIMRUNTIME/syntax/help.vim

" Vim script
au Syntax vim		so $VIMRUNTIME/syntax/vim.vim

" Viminfo file
au Syntax viminfo	so $VIMRUNTIME/syntax/viminfo.vim

" Vgrindefs file
au Syntax vgrindefs	so $VIMRUNTIME/syntax/vgrindefs.vim

" VRML V1.0c
au Syntax vrml		so $VIMRUNTIME/syntax/vrml.vim

" X Pixmap (dynamically sets colors, use BufEnter to make it work better)
au Syntax xpm		so $VIMRUNTIME/syntax/xpm.vim

" X resources file
au Syntax xdefaults	so $VIMRUNTIME/syntax/xdefaults.vim

" Xmath
au Syntax xmath		so $VIMRUNTIME/syntax/xmath.vim
au Syntax mstype	so $VIMRUNTIME/syntax/mstype.vim

" XML
au Syntax xml		so $VIMRUNTIME/syntax/xml.vim

" Yacc
au Syntax yacc		so $VIMRUNTIME/syntax/yacc.vim


" Source the user-specified syntax highlighting file
if exists("mysyntaxfile")
  if file_readable(expand(mysyntaxfile))
    execute "source " . mysyntaxfile
  endif
endif

endif " has("syntax")

" vim: ts=8 sts=0
