" Vim support file to detect file types in scripts
" Maintainer:	Bram Moolenaar <Bram@vim.org>
" Last change:	1998 Dec 3

" This file is called by an autocommand for every file that has just been
" loaded into a buffer.  It checks if the type of file can be recognized by
" the file contents.  The autocommand is in $VIMRUNTIME/filetype.vim.


" Load the user defined scripts file
" Only do this when the FileType autocommand has not been triggered yet
if !did_filetype()
  if exists("myscriptsfile")
    if file_readable(expand(myscriptsfile))
      execute "source " . myscriptsfile
    endif
  endif
endif

" Only do this when the FileType autocommand has not been triggered yet
if !did_filetype()

" Bourne-like shell scripts: sh ksh bash
if getline(1) =~ '^#!.*[/\\][bk]\=a\=sh\>'
  if exists("is_bash")
    unlet is_bash
  endif
  if exists("is_kornshell")
    unlet is_kornshell
  endif
  " if bash is sh on your system as on Linux, you may prefer to
  " add the following in your .vimrc file:
  " let bash_is_sh=1
  if exists("bash_is_sh") || getline(1) =~ '^#!.*[/\\]bash\>'
    let is_bash=1
  elseif getline(1) =~ '^#!.*[/\\]ksh\>'
    let is_kornshell=1
  endif
  set ft=sh

" csh and tcsh scripts
elseif getline(1) =~ '^#!.*[/\\]t\=csh\>'
  set ft=csh

" Z shell scripts
elseif getline(1) =~ '^#!.*[/\\]zsh\>'
  set ft=zsh

" ELM Mail files
elseif getline(1) =~ '^From [a-zA-Z][a-zA-Z_0-9\.=-]*\(@[^ ]*\)\= .*[12][09]\d\d$'
  set ft=mail

" Expect scripts
elseif getline(1) =~ '^#!.*[/\\]expect\>'
  set ft=expect

" Gnuplot scripts
elseif getline(1) =~ '^#!.*[/\\]gnuplot\>'
  set ft=gnuplot

" Makefiles
elseif getline(1) =~ '^#!.*[/\\][^/\\]*make\>'
  set ft=make

" Perl
elseif getline(1) =~ '^#!.*[/\\][^/\\]*perl[^/\\]*\>'
  set ft=perl

" sed
elseif getline(1) =~ '^#!.*sed\>'
  set ft=sed

" Vim scripts (must have '" vim' as the first line to trigger this)
elseif getline(1) =~ '^" *[vV]im$'
  set ft=vim

" Diff file:
" - "diff" in first line (context diff)
" - "--- " in first line and "+++ " in second line (unified diff).
" - "*** " in first line and "--- " in second line (context diff).
elseif getline(1) =~ '^diff\>' || (getline(1) =~ '^--- ' && getline(2) =~ '^+++ ') || (getline(1) =~ '^\*\*\* ' && getline(2) =~ '^--- ')
  set ft=diff

" PostScript Files (must have %!PS as the first line, like a2ps output)
elseif getline(1) =~ '^%![ \t]*PS'
  set ft=postscr

" Awk scripts
elseif getline(1) =~ '^#!.*awk\>'
  set ft=awk

" AmigaDos scripts
elseif $TERM == "amiga" && (getline(1) =~ "^;" || getline(1) =~ '^\.[bB][rR][aA]')
  set ft=amiga

" Rebol script file
elseif getline(1) =~ '^REBOL'
  set ft=rebol

" SiCAD scripts (must have procn or procd as the first line to trigger this)
elseif getline(1) =~ '^ *[pP][rR][oO][cC][nNdD] *$'
  set ft=sicad

" Purify log files start with "****  Purify"
elseif getline(1) =~ '^\*\*\*\*  Purify'
  set ft=purifylog

endif

endif " !did_filetype()

" vim: ts=8 tw=0 sts=0
