" These menu commands create the default Vim menus.
" You can also use this as a start for your own set of menus.
" Note that ":amenu" is often used to make a menu work in all modes.

" Make sure the '<' flag is not included in 'cpoptions', otherwise <CR> would
" not be recognized.  See ":help 'cpoptions'".
let menu_cpo_save = &cpo
let &cpo = ""

" Avoid installing the menus twice
if !exists("did_install_default_menus")
let did_install_default_menus = 1

" Help menu
amenu 9999.10 &Help.&Overview<Tab><F1>		:help<CR>
amenu 9999.20 &Help.&How-to\ links		:help how-to<CR>
amenu 9999.30 &Help.&GUI			:help gui<CR>
amenu 9999.40 &Help.&Version			:version<CR>
amenu 9999.50 &Help.&Credits			:help credits<CR>
amenu 9999.60 &Help.Co&pying			:help uganda<CR>
amenu 9999.70 &Help.&About			:intro<CR>

" File menu
amenu 10.310 &File.&Open\.\.\.<Tab>:e		:browse confirm e<CR>
amenu 10.320 &File.Sp&lit-Open\.\.\.<Tab>:sp	:browse sp<CR>
amenu 10.330 &File.&Close<Tab>:q		:confirm q<CR>
amenu 10.335 &File.-SEP1-  	    	    	:
amenu 10.340 &File.&Save<Tab>:w			:confirm w<CR>
amenu 10.350 &File.Save\ &As\.\.\.<Tab>:w	:browse confirm w<CR>
amenu 10.355 &File.-SEP2-  	    	    	:
if has("win32")
" Use Notepad for printing.
  amenu 10.360 &File.&Print :let smod=&mod<Bar>:let ttt=tempname()<Bar>exec ":w! ".ttt<Bar>let &mod=smod<Bar>exec "!notepad /p ".ttt<Bar>exec "!del ".ttt<CR>
  vunmenu &File.&Print
  vmenu &File.&Print <Esc>:let smod=&mod<Bar>:let ttt=tempname()<Bar>exec ":'<,'>w! ".ttt<Bar>let &mod=smod<Bar>exec "!notepad /p ".ttt<Bar>exec "!del ".ttt<CR>
elseif has("unix")
  amenu 10.360 &File.&Print			:w !lpr<CR>
  vunmenu &File.&Print
  vmenu &File.&Print				:w !lpr<CR>
endif
amenu 10.361 &File.-SEP3-       	    	:
amenu 10.370 &File.Sa&ve-Exit<Tab>:wqa		:confirm wqa<CR>
amenu 10.380 &File.E&xit<Tab>:qa		:confirm qa<CR>


" Edit menu
amenu 20.310 &Edit.&Undo<Tab>u			u
amenu 20.320 &Edit.&Redo<Tab>Ctrl+R		<C-R>
amenu 20.330 &Edit.&Repeat<Tab>\.		.
amenu 20.331 &Edit.-SEP1-       	    	:
vmenu 20.340 &Edit.Cu&t<Tab>"*x			"*x
vmenu 20.350 &Edit.&Copy<Tab>"*y		"*y
nmenu 20.360 &Edit.&Paste<Tab>"*p		"*p
vmenu	     &Edit.&Paste<Tab>"*p		"*P`]:if col(".")!=1<Bar>exe "norm l"<Bar>endif<CR>
imenu	     &Edit.&Paste<Tab>"*p		<Esc>:if col(".")!=1<Bar>exe 'norm "*p'<Bar>else<Bar>exe 'norm "*P'<Bar>endif<CR>`]a
cmenu	     &Edit.&Paste<Tab>"*p		<C-R>*
nmenu 20.370 &Edit.Put\ &Before<Tab>[p		[p
imenu	     &Edit.Put\ &Before<Tab>[p		<C-O>[p
nmenu 20.380 &Edit.Put\ &After<Tab>]p		]p
imenu	     &Edit.Put\ &After<Tab>]p		<C-O>]p
if has("win32")
  vmenu 20.390 &Edit.&Delete<Tab>x		x
endif
amenu 20.400 &Edit.&Select\ all<Tab>ggvG	:if &slm != ""<Bar>exe ":norm gggH<C-O>G"<Bar>else<Bar>exe ":norm ggVG"<Bar>endif<CR>
amenu 20.401 &Edit.-SEP2-       	    	:
if has("win32") || has("gui_gtk")
  amenu 20.410 &Edit.&Find\.\.\.		:promptfind<CR>
  amenu 20.420 &Edit.Find\ and\ R&eplace\.\.\.	:promptrepl<CR>
  vunmenu      &Edit.Find\ and\ R&eplace\.\.\.
  vmenu	       &Edit.Find\ and\ R&eplace\.\.\.	y:promptrepl <C-R>"<CR>
  if has("gui_gtk")
    amenu 20.421 &Edit.-SEP3-			:
    amenu 20.422 &Edit.Options\.\.\.		:browse set<CR>
  endif
else
  amenu 20.410 &Edit.&Find<Tab>/			/
  amenu 20.420 &Edit.Find\ and\ R&eplace<Tab>:%s	:%s/
  vunmenu      &Edit.Find\ and\ R&eplace
  vmenu	       &Edit.Find\ and\ R&eplace<Tab>:s		:s/
endif

" Window menu
amenu 30.300 &Window.&New		<C-W>n
amenu 30.310 &Window.S&plit		<C-W>s
amenu 30.320 &Window.Sp&lit\ To\ #	<C-W><C-^>
amenu 30.321 &Window.-SEP1-       	    	:
amenu 30.330 &Window.&Close		<C-W>c
amenu 30.340 &Window.Close\ &Other(s)	<C-W>o
amenu 30.341 &Window.-SEP2-       	    	:
amenu 30.350 &Window.Ne&xt		<C-W>w
amenu 30.360 &Window.P&revious		<C-W>W
amenu 30.361 &Window.-SEP3-       	    	:
amenu 30.370 &Window.&Equal\ Height	<C-W>=
amenu 30.380 &Window.Rotate\ &Up	<C-W>R
amenu 30.390 &Window.Rotate\ &Down	<C-W>r
if has("win32") || has("gui_gtk")
  amenu 30.391 &Window.-SEP4-     	:
  amenu 30.400 &Window.Select\ &Font\.\.\.	:set guifont=*<CR>
  if has("gui_gtk")
    amenu 30.401 &Window.-SEP5-     	:
    amenu 30.402 &Window.Buffer\ &List\.\.\.	:browse ls<CR>
  endif
endif

" Programming menu
amenu 40.300 &Tools.&Jump\ to\ this\ tag	g<C-]>
vunmenu &Tools.&Jump\ to\ this\ tag
vmenu &Tools.&Jump\ to\ this\ tag	g<C-]>
amenu 40.310 &Tools.Jump\ &back			<C-T>
amenu 40.320 &Tools.Build\ &Tags\ File		:!ctags -R .<CR>
amenu 40.330 &Tools.&Make			:make<CR>
amenu 40.340 &Tools.&List\ Errors		:cl<CR>
amenu 40.350 &Tools.L&ist\ Messages		:cl!<CR>
amenu 40.360 &Tools.&Next\ Error		:cn<CR>
amenu 40.370 &Tools.&Previous\ Error		:cp<CR>
amenu 40.380 &Tools.&Older\ List		:colder<CR>
amenu 40.390 &Tools.N&ewer\ List		:cnewer<CR>

" The popup menu
amenu 1.10 PopUp.&Undo		u
amenu 1.11 PopUp.-SEP1-     	:
vmenu 1.20 PopUp.Cu&t		"*x
vmenu 1.30 PopUp.&Copy		"*y
nmenu 1.40 PopUp.&Paste		"*P`]:if col(".")!=1<Bar>exe "norm l"<Bar>endif<CR>
vmenu      PopUp.&Paste		"-x"*P`]
imenu      PopUp.&Paste		<Esc>:if col(".")!=1<Bar>exe 'norm "*p'<Bar>else<Bar>exe 'norm "*P'<Bar>endif<CR>`]a
cmenu      PopUp.&Paste		<C-R>*
vmenu 1.50 PopUp.&Delete	x
amenu 1.60 PopUp.Select\ &Word	vaw
amenu 1.70 PopUp.Select\ &Line	V
amenu 1.80 PopUp.Select\ &All	ggVG

" The GUI toolbar (for Win32 or GTK)
if has("win32") || has("gui_gtk")
  amenu ToolBar.Open		:browse e<CR>
  tmenu ToolBar.Open		Open file
  amenu ToolBar.Save		:w<CR>
  tmenu ToolBar.Save		Save current file
  amenu ToolBar.SaveAll		:wa<CR>
  tmenu ToolBar.SaveAll		Save all files

  if has("win32")
    amenu ToolBar.Print		:let smod=&mod<Bar>:let ttt=tempname()<Bar>exec ":w! ".ttt<Bar>let &mod=smod<Bar>exec "!notepad /p ".ttt<Bar>exec "!del ".ttt<CR>
    vunmenu ToolBar.Print
    vmenu ToolBar.Print		<Esc>:let smod=&mod<Bar>:let ttt=tempname()<Bar>exec ":'<,'>w! ".ttt<Bar>let &mod=smod<Bar>exec "!notepad /p ".ttt<Bar>exec "!del ".ttt<CR>
  else
    amenu ToolBar.Print		:w !lpr<CR>
    vunmenu ToolBar.Print
    vmenu ToolBar.Print		<Esc>:w !lpr<CR>
  endif
  tmenu ToolBar.Print		Print

  amenu ToolBar.Undo		u
  tmenu ToolBar.Undo		Undo
  amenu ToolBar.Redo		<C-R>
  tmenu ToolBar.Redo		Redo
  vmenu ToolBar.Cut		"*x
  tmenu ToolBar.Cut		Cut to clipboard
  vmenu ToolBar.Copy		"*y
  tmenu ToolBar.Copy		Copy to clipboard
  nmenu ToolBar.Paste		i<C-R>*<Esc>
  vmenu ToolBar.Paste		"-xi<C-R>*<Esc>
  menu! ToolBar.Paste		<C-R>*
  tmenu ToolBar.Paste		Paste from Clipboard

  amenu ToolBar.Find		:promptfind<CR>
  tmenu ToolBar.Find		Find...
  amenu ToolBar.FindNext	n
  tmenu ToolBar.FindNext	Find Next
  amenu ToolBar.FindPrev	N
  tmenu ToolBar.FindPrev	Find Previous
  amenu ToolBar.Replace		:promptrepl<CR>
  vunmenu ToolBar.Replace
  vmenu ToolBar.Replace		y:promptrepl <C-R>"<CR>
  tmenu ToolBar.Replace		Find && Replace...

  amenu ToolBar.New		<C-W>n
  tmenu ToolBar.New		New Window
  amenu ToolBar.WinSplit	<C-W>s
  tmenu ToolBar.WinSplit	Split Window
  amenu ToolBar.WinMax		:resize 200<CR>
  tmenu ToolBar.WinMax		Maximise Window
  amenu ToolBar.WinMin		:resize 1<CR>
  tmenu ToolBar.WinMin		Minimise Window
  amenu ToolBar.WinClose	:close<CR>
  tmenu ToolBar.WinClose	Close Window

  if has("win32")
    amenu ToolBar.LoadSesn	:browse so $vim\\session<CR>
  else
    amenu ToolBar.LoadSesn	:browse so $vim/session<CR>
  endif
  tmenu ToolBar.LoadSesn	Load session
  amenu ToolBar.SaveSesn	:execute ("mksession " . this_session)
  tmenu ToolBar.SaveSesn	Save current session
  amenu ToolBar.RunScript	:browse so<CR>
  tmenu ToolBar.RunScript	Run a Vim Script

  amenu ToolBar.Make		:make<CR>
  tmenu ToolBar.Make		Make current project
  amenu ToolBar.Shell		:sh<CR>
  tmenu ToolBar.Shell		Open a command shell
  amenu ToolBar.RunCtags	:!ctags -R .<CR>
  tmenu ToolBar.RunCtags	Build tags in current directory tree
  amenu ToolBar.TagJump		g]
  tmenu ToolBar.TagJump		Jump to tag under cursor

  amenu ToolBar.Help		:help<CR>
  tmenu ToolBar.Help		Vim Help
  if has("gui_gtk")
    amenu ToolBar.FindHelp	:helpfind<CR>
  else
    amenu ToolBar.FindHelp	:help 
  endif
  tmenu ToolBar.FindHelp	Search Vim Help
endif " has("win32")

endif " !exists("did_install_default_menus")

" Install the Syntax menu only when filetype.vim has been loaded or when
" manual syntax highlighting is enabled.
" Avoid installing the Syntax menu twice.
if (exists("did_load_filetypes") || exists("syntax_on")) && !exists("did_install_syntax_menu")
let did_install_syntax_menu = 1

" Define the SetSyn function, used for the Syntax menu entries.
" Set 'filetype' and also 'syntax' if it is manually selected.
fun! SetSyn(name)
  if !exists("g:syntax_menu_synonly")
    exe "set ft=" . a:name
    if exists("g:syntax_manual")
      exe "set syn=" . a:name
    endif
  else
    exe "set syn=" . a:name
  endif
endfun

am 50.10.10 &Syntax.&ABCD.Ada			:cal SetSyn("ada")<CR>
am 50.10.11 &Syntax.&ABCD.AHDL			:cal SetSyn("ahdl")<CR>
am 50.10.12 &Syntax.&ABCD.Amiga\ DOS		:cal SetSyn("amiga")<CR>
am 50.10.13 &Syntax.&ABCD.assembly\ (GNU)	:cal SetSyn("asm")<CR>
am 50.10.13 &Syntax.&ABCD.assembly\ (H8300)	:cal SetSyn("asm8300")<CR>
am 50.10.14 &Syntax.&ABCD.ASN\.1		:cal SetSyn("asn")<CR>
am 50.10.15 &Syntax.&ABCD.Atlas			:cal SetSyn("atlas")<CR>
am 50.10.16 &Syntax.&ABCD.Avenue		:cal SetSyn("ave")<CR>
am 50.10.17 &Syntax.&ABCD.Awk			:cal SetSyn("awk")<CR>
am 50.10.18 &Syntax.&ABCD.BASIC			:cal SetSyn("basic")<CR>
am 50.10.19 &Syntax.&ABCD.BibFile		:cal SetSyn("bib")<CR>
am 50.10.20 &Syntax.&ABCD.C			:cal SetSyn("c")<CR>
am 50.10.21 &Syntax.&ABCD.C++			:cal SetSyn("cpp")<CR>
am 50.10.22 &Syntax.&ABCD.Cascading\ Style\ Sheets :cal SetSyn("css")<CR>
am 50.10.23 &Syntax.&ABCD.Century\ Term		:cal SetSyn("cterm")<CR>
am 50.10.24 &Syntax.&ABCD.Clean			:cal SetSyn("clean")<CR>
am 50.10.25 &Syntax.&ABCD.Clipper		:cal SetSyn("clipper")<CR>
am 50.10.26 &Syntax.&ABCD.Csh\ shell\ script	:cal SetSyn("csh")<CR>
am 50.10.27 &Syntax.&ABCD.Cobol			:cal SetSyn("cobol")<CR>
am 50.10.28 &Syntax.&ABCD.Diff			:cal SetSyn("diff")<CR>
am 50.10.29 &Syntax.&ABCD.Dracula		:cal SetSyn("dracula")<CR>
am 50.10.30 &Syntax.&ABCD.DTD			:cal SetSyn("dtd")<CR>

am 50.20.10 &Syntax.&EFGHIJ.Eiffel		:cal SetSyn("eiffel")<CR>
am 50.20.11 &Syntax.&EFGHIJ.Elm\ Filter		:cal SetSyn("elmfilt")<CR>
am 50.20.12 &Syntax.&EFGHIJ.ESQL-C		:cal SetSyn("esqlc")<CR>
am 50.20.13 &Syntax.&EFGHIJ.Expect		:cal SetSyn("expect")<CR>
am 50.20.14 &Syntax.&EFGHIJ.Exports		:cal SetSyn("exports")<CR>
am 50.20.15 &Syntax.&EFGHIJ.Fortran		:cal SetSyn("fortran")<CR>
am 50.20.16 &Syntax.&EFGHIJ.Fvwm\ configuration	:cal SetSyn("fvwm")<CR>
am 50.20.17 &Syntax.&EFGHIJ.GP			:cal SetSyn("gp")<CR>
am 50.20.18 &Syntax.&EFGHIJ.GNUplot		:cal SetSyn("gnuplot")<CR>
am 50.20.19 &Syntax.&EFGHIJ.Haskell		:cal SetSyn("haskell")<CR>
am 50.20.20 &Syntax.&EFGHIJ.Haskell-literal	:cal SetSyn("lhaskell")<CR>
am 50.20.21 &Syntax.&EFGHIJ.HTML		:cal SetSyn("html")<CR>
am 50.20.22 &Syntax.&EFGHIJ.IDL			:cal SetSyn("idl")<CR>
am 50.20.23 &Syntax.&EFGHIJ.Inform		:cal SetSyn("inform")<CR>
am 50.20.24 &Syntax.&EFGHIJ.Java		:cal SetSyn("java")<CR>
am 50.20.25 &Syntax.&EFGHIJ.JavaCC		:cal SetSyn("javacc")<CR>
am 50.20.26 &Syntax.&EFGHIJ.JavaScript		:cal SetSyn("javascript")<CR>
am 50.20.27 &Syntax.&EFGHIJ.Jgraph		:cal SetSyn("jgraph")<CR>

am 50.30.10 &Syntax.&KLM.Lace			:cal SetSyn("lace")<CR>
am 50.30.11 &Syntax.&KLM.Lex			:cal SetSyn("lex")<CR>
am 50.30.12 &Syntax.&KLM.Lilo			:cal SetSyn("lilo")<CR>
am 50.30.13 &Syntax.&KLM.Lisp			:cal SetSyn("lisp")<CR>
am 50.30.14 &Syntax.&KLM.Lite			:cal SetSyn("lite")<CR>
am 50.30.15 &Syntax.&KLM.LOTOS			:cal SetSyn("lotos")<CR>
am 50.30.16 &Syntax.&KLM.Lua			:cal SetSyn("lua")<CR>
am 50.30.17 &Syntax.&KLM.Lynx\ Style		:cal SetSyn("lss")<CR>
am 50.30.18 &Syntax.&KLM.M4			:cal SetSyn("m4")<CR>
am 50.30.19 &Syntax.&KLM.Mail			:cal SetSyn("mail")<CR>
am 50.30.20 &Syntax.&KLM.Makefile		:cal SetSyn("make")<CR>
am 50.30.21 &Syntax.&KLM.Man\ page		:cal SetSyn("man")<CR>
am 50.30.22 &Syntax.&KLM.Maple			:cal SetSyn("maple")<CR>
am 50.30.23 &Syntax.&KLM.Matlab			:cal SetSyn("matlab")<CR>
am 50.30.24 &Syntax.&KLM.Metafont		:cal SetSyn("mf")<CR>
am 50.30.25 &Syntax.&KLM.MetaPost		:cal SetSyn("mp")<CR>
am 50.30.26 &Syntax.&KLM.Model			:cal SetSyn("model")<CR>
am 50.30.27 &Syntax.&KLM.Modula\ 2		:cal SetSyn("modula2")<CR>
am 50.30.28 &Syntax.&KLM.Msql			:cal SetSyn("msql")<CR>
am 50.30.29 &Syntax.&KLM.MS-DOS\ \.bat\ file	:cal SetSyn("dosbatch")<CR>
am 50.30.30 &Syntax.&KLM.4DOS\ \.bat\ file	:cal SetSyn("btm")<CR>
am 50.30.31 &Syntax.&KLM.MS-DOS\ \.ini\ file	:cal SetSyn("dosini")<CR>
am 50.30.32 &Syntax.&KLM.MS\ Resource\ file	:cal SetSyn("rc")<CR>
am 50.30.33 &Syntax.&KLM.Muttrc			:cal SetSyn("muttrc")<CR>

am 50.40.10 &Syntax.&NOPQ.NASM			:cal SetSyn("nasm")<CR>
am 50.40.11 &Syntax.&NOPQ.Nroff			:cal SetSyn("nroff")<CR>
am 50.40.12 &Syntax.&NOPQ.Objective\ C		:cal SetSyn("objc")<CR>
am 50.40.13 &Syntax.&NOPQ.OCAML			:cal SetSyn("ocaml")<CR>
am 50.40.14 &Syntax.&NOPQ.Pascal		:cal SetSyn("pascal")<CR>
am 50.40.15 &Syntax.&NOPQ.PCCTS			:cal SetSyn("pccts")<CR>
am 50.40.16 &Syntax.&NOPQ.Perl			:cal SetSyn("perl")<CR>
am 50.40.17 &Syntax.&NOPQ.Perl\ POD		:cal SetSyn("pod")<CR>
am 50.40.18 &Syntax.&NOPQ.PHP\ 3		:cal SetSyn("php3")<CR>
am 50.40.19 &Syntax.&NOPQ.Phtml			:cal SetSyn("phtml")<CR>
am 50.40.20 &Syntax.&NOPQ.Pike			:cal SetSyn("pike")<CR>
am 50.40.21 &Syntax.&NOPQ.PL/SQL		:cal SetSyn("plsql")<CR>
am 50.40.22 &Syntax.&NOPQ.PO\ (GNU\ gettext)	:cal SetSyn("po")<CR>
am 50.40.23 &Syntax.&NOPQ.PostScript		:cal SetSyn("postscr")<CR>
am 50.40.24 &Syntax.&NOPQ.Povray		:cal SetSyn("pov")<CR>
am 50.40.25 &Syntax.&NOPQ.Printcap		:cal SetSyn("ptcap")<CR>
am 50.40.26 &Syntax.&NOPQ.Procmail		:cal SetSyn("procmail")<CR>
am 50.40.27 &Syntax.&NOPQ.Prolog		:cal SetSyn("prolog")<CR>
am 50.40.28 &Syntax.&NOPQ.Purify\ log		:cal SetSyn("purifylog")<CR>
am 50.40.29 &Syntax.&NOPQ.Python		:cal SetSyn("python")<CR>

am 50.50.10 &Syntax.&RS.Radiance		:cal SetSyn("radiance")<CR>
am 50.50.11 &Syntax.&RS.Rebol			:cal SetSyn("rebol")<CR>
am 50.50.12 &Syntax.&RS.Rexx			:cal SetSyn("rexx")<CR>
am 50.50.13 &Syntax.&RS.S-lang			:cal SetSyn("slang")<CR>
am 50.50.14 &Syntax.&RS.Sather			:cal SetSyn("sather")<CR>
am 50.50.15 &Syntax.&RS.Scheme			:cal SetSyn("scheme")<CR>
am 50.50.16 &Syntax.&RS.SDL			:cal SetSyn("sdl")<CR>
am 50.50.17 &Syntax.&RS.sed			:cal SetSyn("sed")<CR>
am 50.50.18 &Syntax.&RS.Sendmail\.cf		:cal SetSyn("sm")<CR>
am 50.50.19 &Syntax.&RS.SGML			:cal SetSyn("sgml")<CR>
am 50.50.20 &Syntax.&RS.Sh\ shell\ script	:cal SetSyn("sh")<CR>
am 50.50.21 &Syntax.&RS.SiCAD			:cal SetSyn("sicad")<CR>
am 50.50.22 &Syntax.&RS.Simula			:cal SetSyn("simula")<CR>
am 50.50.23 &Syntax.&RS.SKILL			:cal SetSyn("skill")<CR>
am 50.50.24 &Syntax.&RS.SLRN\ rc		:cal SetSyn("slrnrc")<CR>
am 50.50.25 &Syntax.&RS.SLRN\ score		:cal SetSyn("slrnsc")<CR>
am 50.50.26 &Syntax.&RS.SmallTalk		:cal SetSyn("st")<CR>
am 50.50.27 &Syntax.&RS.SMIL			:cal SetSyn("smil")<CR>
am 50.50.28 &Syntax.&RS.SNMP\ MIB		:cal SetSyn("mib")<CR>
am 50.50.29 &Syntax.&RS.SPEC\ (Linux\ RPM)	:cal SetSyn("spec")<CR>
am 50.50.30 &Syntax.&RS.Squid			:cal SetSyn("squid")<CR>
am 50.50.31 &Syntax.&RS.SQL			:cal SetSyn("sql")<CR>

am 50.60.10 &Syntax.&TU.Tags			:cal SetSyn("tags")<CR>
am 50.60.11 &Syntax.&TU.Tcl/Tk			:cal SetSyn("tcl")<CR>
am 50.60.12 &Syntax.&TU.Telix\ Salt		:cal SetSyn("tsalt")<CR>
am 50.60.13 &Syntax.&TU.Termcap			:cal SetSyn("ptcap")<CR>
am 50.60.14 &Syntax.&TU.Tex			:cal SetSyn("tex")<CR>
am 50.60.15 &Syntax.&TU.TF\ mud\ client		:cal SetSyn("tf")<CR>
am 50.60.16 &Syntax.&TU.UIT/UIL			:cal SetSyn("uil")<CR>

am 50.70.10 &Syntax.&VWXYZ.Verilog\ HDL		:cal SetSyn("verilog")<CR>
am 50.70.11 &Syntax.&VWXYZ.vgrindefs		:cal SetSyn("vgrindefs")<CR>
am 50.70.12 &Syntax.&VWXYZ.VHDL			:cal SetSyn("vhdl")<CR>
am 50.70.13 &Syntax.&VWXYZ.Vim\ help\ file	:cal SetSyn("help")<CR>
am 50.70.14 &Syntax.&VWXYZ.Vim\ script		:cal SetSyn("vim")<CR>
am 50.70.15 &Syntax.&VWXYZ.Viminfo\ file	:cal SetSyn("viminfo")<CR>
am 50.70.16 &Syntax.&VWXYZ.VRML			:cal SetSyn("vrml")<CR>
am 50.70.17 &Syntax.&VWXYZ.whitespace		:cal SetSyn("whitespace")<CR>
am 50.70.18 &Syntax.&VWXYZ.X\ Pixmap		:cal SetSyn("xpm")<CR>
am 50.70.19 &Syntax.&VWXYZ.X\ resources		:cal SetSyn("xdefaults")<CR>
am 50.70.20 &Syntax.&VWXYZ.Xmath		:cal SetSyn("xmath")<CR>
am 50.70.21 &Syntax.&VWXYZ.XML			:cal SetSyn("xml")<CR>
am 50.70.22 &Syntax.&VWXYZ.Yacc			:cal SetSyn("yacc")<CR>
am 50.70.23 &Syntax.&VWXYZ.Zsh\ shell\ script	:cal SetSyn("zsh")<CR>
am 50.71 &Syntax.-SEP1-				:

am 50.80 &Syntax.Set\ 'syntax'\ only		:let syntax_menu_synonly=1<CR>
am 50.81 &Syntax.Set\ 'filetype'\ too		:if exists("syntax_menu_synonly")<Bar>unlet syntax_menu_synonly<Bar>endif<CR>

am 50.90 &Syntax.&off			:syn off<CR>
am 50.92 &Syntax.&manual		:syn manual<CR>
am 50.94 &Syntax.auto&matic		:syn on<CR>

am 50.96 &Syntax.&on\ (this\ file)	:if !exists("syntax_on")<Bar>syn manual<Bar>endif<Bar>set syn=ON<CR>
am 50.98 &Syntax.o&ff\ (this\ file)	:syn clear<CR>

am 50.700 &Syntax.-SEP3-		:
am 50.710 &Syntax.color\ &test		:sp $VIMRUNTIME/syntax/colortest.vim<Bar>so %<CR>
am 50.720 &Syntax.&highlight\ test	:new<Bar>so $VIMRUNTIME/syntax/hitest.vim<CR>
am 50.730 &Syntax.&convert\ to\ HTML	:so $VIMRUNTIME/syntax/2html.vim<CR>

endif " !exists("did_install_syntax_menu")

" Restore the previous value of 'cpoptions'.
let &cpo = menu_cpo_save
unlet menu_cpo_save
