" Vim support file to detect file types
" Maintainer:	Bram Moolenaar <Bram@vim.org>
" Last change:	1998 Dec 22

if !exists("did_load_filetypes")
let did_load_filetypes = 1

augroup filetype

" Ada (83, 9X, 95)
au BufNewFile,BufRead *.adb,*.ads		set ft=ada

" AHDL
au BufNewFile,BufRead *.tdf			set ft=ahdl

" Assembly (all kinds)
au BufNewFile,BufRead *.asm,*.s,*.i,*.mac	call FTCheck_asm()

" This function checks for the kind of assembly that is wanted by the user, or
" can be detected from the first five lines of the file.
fun! FTCheck_asm()
  " make sure b:asmsyntax exists
  if !exists("b:asmsyntax")
    let b:asmsyntax = ""
  endif

  if b:asmsyntax == ""
    " see if file contains any asmsyntax=foo overrides. If so, change
    " b:asmsyntax appropriately
    let head = " ".getline(1)." ".getline(2)." ".getline(3)." ".getline(4)." ".getline(5)." "
    if head =~ '\sasmsyntax=\S\+\s'
      let b:asmsyntax = substitute(head, '.*\sasmsyntax=\(\S\+\)\s.*','\1', "")
    endif
  endif

  " if b:asmsyntax still isn't set, default to asmsyntax or GNU
  if b:asmsyntax == ""
    if exists("g:asmsyntax")
      let b:asmsyntax = g:asmsyntax
    else
      let b:asmsyntax = "asm"
    endif
  endif

  exe "set ft=" . b:asmsyntax
endfun

" ASN.1
au BufNewFile,BufRead *.asn,*.asn1		set ft=asn

" Atlas
au BufNewFile,BufRead *.atl,*.as		set ft=atlas

" Avenue
au BufNewFile,BufRead *.ave			set ft=ave

" Awk
au BufNewFile,BufRead *.awk			set ft=awk

" BASIC
au BufNewFile,BufRead *.bas			set ft=basic

" Batch file for MSDOS
au BufNewFile,BufRead *.bat,*.sys		set ft=dosbatch

" Batch file for 4DOS
au BufNewFile,BufRead *.btm			set ft=btm

" BibTeX bibliography database file
au BufNewFile,BufRead *.bib			set ft=bib

" C
au BufNewFile,BufRead *.c			set ft=c

" C++
if has("fname_case")
  au BufNewFile,BufRead *.cpp,*.cc,*.cxx,*.c++,*.C,*.H,*.hh,*.hxx,*.hpp,*.inl set ft=cpp
else
  au BufNewFile,BufRead *.cpp,*.cc,*.cxx,*.c++,*.hh,*.hxx,*.hpp,*.inl set ft=cpp
endif

" .h files can be C or C++, set c_syntax_for_h if you want C
au BufNewFile,BufRead *.h			if exists("c_syntax_for_h")|set ft=c|else|set ft=cpp|endif

" Cascading Style Sheets
au BufNewFile,BufRead *.css			set ft=css

" Century Term Command Scripts
au BufNewFile,BufRead *.cmd,*.con		set ft=cterm

" Clean
au BufNewFile,BufReadPost *.dcl,*.icl		set ft=clean

" Clipper
au BufNewFile,BufRead *.prg			set ft=clipper

" Cobol
au BufNewFile,BufRead *.cbl,*.cob,*.cpy,*.lib	set ft=cobol

" Diff files
au BufNewFile,BufRead *.diff,*.rej		set ft=diff

" DCL (Digital Command Language - vms)
au BufNewFile,BufRead *.com			set ft=dcl

" Dracula
au BufNewFile,BufRead drac.*,*.drac,*.drc,*lvs,*lpe set ft=dracula

" DTD (Document Type Definition for XML)
au BufNewFile,BufRead *.dtd			set ft=dtd

" Eiffel
au BufNewFile,BufRead *.e,*.E			set ft=eiffel

" Elm Filter Rules file
au BufNewFile,BufReadPost filter-rules		set ft=elmfilt

" ESQL-C
au BufNewFile,BufRead *.ec,*.EC			set ft=esqlc

" Exports
au BufNewFile,BufRead exports			set ft=exports

" Fortran
au BufNewFile,BufRead *.f,*.F,*.for,*.fpp	set ft=fortran

" Fvwm
au BufNewFile,BufRead *fvwm*rc*			set ft=fvwm

" GP scripts (2.0 and onward)
au BufNewFile,BufRead *.gp			set ft=gp

" Gnuplot scripts
au BufNewFile,BufRead *.gpi			set ft=gnuplot

" Haskell
au BufNewFile,BufRead *.hs			set ft=haskell
au BufNewFile,BufRead *.lhs			set ft=lhaskell

" HTML (.shtml for server side)
au BufNewFile,BufRead *.html,*.htm,*.shtml	set ft=html

" IDL (Interface Description Language)
au BufNewFile,BufRead *.idl			set ft=idl

" Inform
au BufNewFile,BufRead *.inf,*.INF		set ft=inform

" .INI file for MSDOS
au BufNewFile,BufRead *.ini			set ft=dosini

" Java
au BufNewFile,BufRead *.java,*.jav		set ft=java

" JavaCC
au BufNewFile,BufRead *.jj,*.jjt		set ft=javacc

" JavaScript
au BufNewFile,BufRead *.js,*.javascript		set ft=javascript

" Jgraph
au BufNewFile,BufRead *.jgr			set ft=jgraph

" Lace (ISE)
au BufNewFile,BufRead *.ace,*.ACE		set ft=lace

" Lex
au BufNewFile,BufRead *.lex,*.l			set ft=lex

" Lisp
if has("fname_case")
  au BufNewFile,BufRead *.lsp,*.L		set ft=lisp
else
  au BufNewFile,BufRead *.lsp			set ft=lisp
endif

" Lite
au BufNewFile,BufRead *.lite,*.lt		set ft=lite

" LOTOS
au BufNewFile,BufRead *.lot,*.lotos		set ft=lotos

" Lua
au BufNewFile,BufRead *.lua			set ft=lua

" Lynx style file
au BufNewFile,BufRead *.lss			set ft=lss

" M4
au BufNewFile,BufRead *.m4			set ft=m4

" Mail (for Elm, trn and rn)
au BufNewFile,BufRead snd.*,.letter,.followup,.article,.article.[0-9]\+,pico.[0-9]\+,mutt*[0-9],ae[0-9]\+.txt set ft=mail

" Makefile
au BufNewFile,BufRead [mM]akefile*,GNUmakefile,*.mk,*.mak set ft=make

" Manpage
au BufNewFile,BufRead *.man			set ft=man

" Maple V
au BufNewFile,BufRead *.mv,*.mpl,*.mws		set ft=maple

" Matlab
au BufNewFile,BufRead *.m			set ft=matlab

" Metafont
au BufNewFile,BufRead *.mf			set ft=mf

" MetaPost
au BufNewFile,BufRead *.mp			set ft=mp

" Modula 2
au BufNewFile,BufRead *.m2			set ft=modula2

" Msql
au BufNewFile,BufRead *.msql			set ft=msql

" M$ Resource files
au BufNewFile,BufRead *.rc			set ft=rc

" Mutt setup file
au BufNewFile,BufRead .muttrc			set ft=muttrc

" Nroff/Troff (*.ms is checked below)
au BufNewFile,BufRead *.me,*.mm,*.tr,*.nr,*.[1-9] set ft=nroff

" OCAML
au BufNewFile,BufRead *.ml			set ft=ocaml

" Pascal
au BufNewFile,BufRead *.p,*.pas			set ft=pascal

" Perl
if has("fname_case")
  au BufNewFile,BufRead *.pl,*.PL		set ft=perl
else
  au BufNewFile,BufRead *.pl			set ft=perl
endif

" Perl or XPM
au BufNewFile,BufRead *.pm		if getline(1) =~ "XPM"|set ft=xpm|else|set ft=perl|endif

" Perl POD
au BufNewFile,BufRead *.pod			set ft=pod

" Php3
au BufNewFile,BufRead *.php3			set ft=php3

" Phtml
au BufNewFile,BufRead *.phtml			set ft=phtml

" Pike
au BufNewFile,BufRead *.pike,*.lpc,*.ulpc,*.pmod set ft=pike

" PL/SQL
au BufNewFile,BufRead *.pls,*.plsql		set ft=plsql

" PO (GNU gettext)
au BufNewFile,BufRead *.po			set ft=po

" PostScript
au BufNewFile,BufRead *.ps,*.eps		set ft=postscr

" Povray
au BufNewFile,BufRead *.pov,*.inc		set ft=pov

" Printcap and Termcap
au BufNewFile,BufRead *printcap*,*termcap*	set ft=ptcap

" PCCTS
au BufNewFile,BufRead *.g			set ft=pccts

" Procmail
au BufNewFile,BufRead .procmail,.procmailrc	set ft=procmail

" Prolog
au BufNewFile,BufRead *.pdb			set ft=prolog

" Python
au BufNewFile,BufRead *.py			set ft=python

" Radiance
au BufNewFile,BufRead *.rad,*.mat		set ft=radiance

" Rexx
au BufNewFile,BufRead *.rexx,*.rex,*.r		set ft=rexx

" S-lang
au BufNewFile,BufRead *.sl			set ft=slang

" Sather
au BufNewFile,BufRead *.sa			set ft=sather

" SDL
au BufNewFile,BufRead *.sdl,*.pr		set ft=sdl

" sed
au BufNewFile,BufRead *.sed			set ft=sed

" Sendmail
au BufNewFile,BufRead sendmail.cf		set ft=sm

" SGML
au BufNewFile,BufRead *.sgm,*.sgml		set ft=sgml

" Shell scripts (sh, ksh, bash, csh)
au BufNewFile,BufRead .profile,.bashrc,.kshrc,*.sh,*.ksh,*.bash,*.env set ft=sh
au BufNewFile,BufRead .login,.cshrc,.tcshrc,*.csh,*.tcsh set ft=csh

" Z-Shell script
au BufNewFile,BufRead .z*,zsh*,zlog*		set ft=zsh

" Scheme
au BufNewFile,BufRead *.scm			set ft=scheme

" Simula
au BufNewFile,BufRead *.sim			set ft=simula

" SKILL
au BufNewFile,BufRead *.il,*.rul		set ft=skill

" SLRN
au BufNewFile,BufRead .slrnrc			set ft=slrnrc
au BufNewFile,BufRead *.score			set ft=slrnsc

" Smalltalk
au BufNewFile,BufRead *.st,*.cls		set ft=st

" SMIL
au BufNewFile,BufReadPost *.smil		set ft=smil

" SMIL or SNMP MIB file
au BufNewFile,BufRead *.smi		if getline(1) =~ '\<smil\>'|set ft=smil|else|set ft=mib|endif

" SNMP MIB files
au BufNewFile,BufReadPost *.mib			set ft=mib

" Spec (Linux RPM)
au BufNewFile,BufRead *.spec			set ft=spec

" Squid
au BufNewFile,BufRead *.conf			set ft=squid

" SQL
au BufNewFile,BufRead *.sql			set ft=sql

" Tags
au BufNewFile,BufRead tags			set ft=tags

" Tcl
au BufNewFile,BufRead *.tcl,*.tk		set ft=tcl

" Telix Salt
au BufNewFile,BufRead *.slt			set ft=tsalt

" TeX
au BufNewFile,BufRead *.tex,*.sty		set ft=tex

" TF mud client
au BufNewFile,BufRead *.tf			set ft=tf

" Motif UIT/UIL files
au BufNewFile,BufRead *.uit,*.uil		set ft=uil

" Verilog HDL
au BufNewFile,BufRead *.v			set ft=verilog

" VHDL
au BufNewFile,BufRead *.hdl,*.vhd,*.vhdl,*.vhdl_[0-9]*,*.vbe,*.vst  set ft=vhdl

" Vim Help file
if has("mac")
  au BufNewFile,BufRead *[/:]vim*[/:]doc[/:]*.txt set ft=help
else
  au BufNewFile,BufRead */vim*/doc/*.txt	set ft=help
endif

" Vim script
au BufNewFile,BufRead *vimrc*,*.vim,.exrc,_exrc set ft=vim

" Viminfo file
au BufNewFile,BufRead .viminfo,_viminfo		set ft=viminfo

" Vgrindefs file
au BufNewFile,BufRead vgrindefs			set ft=vgrindefs

" VRML V1.0c
au BufNewFile,BufRead *.wrl			set ft=vrml

" X Pixmap (dynamically sets colors, use BufEnter to make it work better)
au BufEnter *.xpm				set ft=xpm

" X resources file
au BufNewFile,BufRead *.Xdefaults,*/app-defaults/* set ft=xdefaults

" Xmath
au BufNewFile,BufRead *.msc,*.msf		set ft=xmath
au BufNewFile,BufRead *.ms			call FTCheck_ms()

" This function checks if one of the first five lines start with a dot.  In
" that case it is probably an nroff file.  Otherwise it's assumed to be Xmath.
fun! FTCheck_ms()
  let lnum = 1
  while lnum <= 5
    if getline(lnum) =~ '^\.'
      set ft=nroff
      let lnum = 99
    endif
    let lnum = lnum + 1
  endwhile
  if lnum < 99
    set ft=xmath
  endif
endfun

" vim: ts=8
" XML
au BufNewFile,BufRead *.xml			set ft=xml

" Yacc
au BufNewFile,BufRead *.y			set ft=yacc

augroup END


" Source the user-specified filetype file
if exists("myfiletypefile")
  if file_readable(expand(myfiletypefile))
    execute "source " . myfiletypefile
  endif
endif


" Check for "*" after loading myfiletypefile, so that scripts.vim is only used
" when there are no matching file name extensions.
augroup filetype
  au BufNewFile,BufRead,StdinReadPost *		if !did_filetype()|so <sfile>:p:h/scripts.vim|endif
augroup END


" If the GUI is already running, may still need to install the Syntax menu.
if has("gui_running") && !exists("did_install_syntax_menu")
  source <sfile>:p:h/menu.vim
endif


endif " !exists("did_load_filetypes")

" vim: ts=8
