
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef TEAROFF_H
#define TEAROFF_H

#include <gtk/gtk.h>
#ifdef GTK_HAVE_FEATURES_1_1_0

#include <gdk/gdk.h>
#include <gtk/gtkmenuitem.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif				/* __cplusplus */


#define TYPE_TEAROFF_MENU_ITEM	      (tearoff_menu_item_get_type ())
#define TEAROFF_MENU_ITEM(obj)	      (GTK_CHECK_CAST ((obj), TYPE_TEAROFF_MENU_ITEM, TearoffMenuItem))
#define TEAROFF_MENU_ITEM_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_TEAROFF_MENU_ITEM, TearoffMenuItemClass))
#define IS_TEAROFF_MENU_ITEM(obj)	      (GTK_CHECK_TYPE ((obj), TYPE_TEAROFF_MENU_ITEM))
#define IS_TEAROFF_MENU_ITEM_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_TEAROFF_MENU_ITEM))


    typedef struct _TearoffMenuItem TearoffMenuItem;
    typedef struct _TearoffMenuItemClass TearoffMenuItemClass;

    struct _TearoffMenuItem {
	GtkMenuItem menu_item;

	guint torn_off:1;
    };

    struct _TearoffMenuItemClass {
	GtkMenuItemClass parent_class;
    };


    GtkType tearoff_menu_item_get_type(void);
    GtkWidget *tearoff_menu_item_new(void);

#ifdef __cplusplus
}

#endif				/* __cplusplus */
#endif	/* GTK_HAVE_FEATURES_1_1_0 */
#endif	/* TEAROFF_H */
