/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __GTK_FORM_H__
#define __GTK_FORM_H__


#include <gdk/gdk.h>
#include <gtk/gtkcontainer.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_TYPE_FORM                  (gtk_form_get_type ())
#define GTK_FORM(obj)                  (GTK_CHECK_CAST ((obj), GTK_TYPE_FORM, GtkForm))
#define GTK_FORM_CLASS(klass)          (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_FORM, GtkFormClass))
#define GTK_IS_FORM(obj)               (GTK_CHECK_TYPE ((obj), GTK_TYPE_FORM))
#define GTK_IS_FORM_CLASS(klass)       (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_FORM))


typedef struct _GtkForm        GtkForm;
typedef struct _GtkFormClass   GtkFormClass;
typedef struct _GtkFormChild   GtkFormChild;

struct _GtkForm
{
  GtkContainer container;

  GList *children;
};

struct _GtkFormClass
{
  GtkContainerClass parent_class;
};

struct _GtkFormChild
{
  GtkWidget *widget;
  gint16 x;	/* relative subwidget x position */
  gint16 y;	/* relative subwidget y position */
  gint16 w;	/* subwidget width */
  gint16 h;	/* subwidget height */
};


GtkType    gtk_form_get_type          (void);
GtkWidget* gtk_form_new               (void);
void       gtk_form_put               (GtkForm       *form,
                                        GtkWidget      *widget,
                                        gint16         x,
                                        gint16         y);
void       gtk_form_move_resize        (GtkForm       *form,
                                        GtkWidget      *widget,
                                        gint16         x,
                                        gint16         y,
                                        gint16	       w,
                                        gint16	       h);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_FORM_H__ */
