" Vim syntax support file
" Maintainer:	Bram Moolenaar <Bram@vim.org>
" Last change:	1998 Dec 6

" This file sets up for syntax highlighting.
" It is loaded from "syntax.vim" and "manual.vim".
" 1. Set the default highlight groups.
" 2. Install Syntax autocommands for all the available syntax files.

if has("syntax")

" let others know that syntax has been switched on
let syntax_on = 1

" The default methods for highlighting.  Can be overridden later.
" Many terminals can only use six different colors (plus black and white).
" Therefore the number of colors used is kept low. It doesn't look nice with
" too many colors anyway.
" Careful with "cterm=bold", it may change the color to bright.

" There are two sets of defaults: for a dark and a light background.
if &background == "dark"
  hi Comment	term=bold ctermfg=Cyan guifg=#80a0ff
  hi Constant	term=underline ctermfg=Magenta guifg=#ffa0a0
  hi Special	term=bold ctermfg=LightRed guifg=Orange
  hi Identifier term=underline cterm=bold ctermfg=Cyan guifg=#40ffff
  hi Statement	term=bold ctermfg=Yellow guifg=#ffff60 gui=bold
  hi PreProc	term=underline ctermfg=LightBlue guifg=#ff80ff
  hi Type	term=underline ctermfg=LightGreen guifg=#60ff60 gui=bold
  hi Ignore	ctermfg=black guifg=bg
else
  hi Comment	term=bold ctermfg=DarkBlue guifg=Blue
  hi Constant	term=underline ctermfg=DarkRed guifg=Magenta
  hi Special	term=bold ctermfg=DarkMagenta guifg=SlateBlue
  hi Identifier term=underline ctermfg=DarkCyan guifg=DarkCyan
  hi Statement	term=bold ctermfg=Brown gui=bold guifg=Brown
  hi PreProc	term=underline ctermfg=DarkMagenta guifg=Purple
  hi Type	term=underline ctermfg=DarkGreen guifg=SeaGreen gui=bold
  hi Ignore	ctermfg=white guifg=bg
endif
hi Error term=reverse ctermbg=Red ctermfg=White guibg=Red guifg=White
hi Todo	 term=standout ctermbg=Yellow ctermfg=Black guifg=Blue guibg=Yellow

" Common groups that link to default highlighting.
" You can specify other highlighting easily.
hi link String		Constant
hi link Character	Constant
hi link Number		Constant
hi link Boolean		Constant
hi link Float		Number
hi link Function	Identifier
hi link Conditional	Statement
hi link Repeat		Statement
hi link Label		Statement
hi link Operator	Statement
hi link Keyword		Statement
hi link Exception	Statement
hi link Include		PreProc
hi link Define		PreProc
hi link Macro		PreProc
hi link PreCondit	PreProc
hi link StorageClass	Type
hi link Structure	Type
hi link Typedef		Type
hi link Tag		Special
hi link SpecialChar	Special
hi link Delimiter	Special
hi link SpecialComment	Special
hi link Debug		Special


" First remove all old syntax autocommands.
au! Syntax


" OFF
au Syntax OFF		syn clear

" ON
au Syntax ON		if &filetype != "" | exe "set syntax=" . &filetype | else | echohl ErrorMsg | echo "filetype unknown" | echohl None | endif


" The Syntax autocommands are all listed here, so that the user can remove,
" change or add his own for each syntax separately.

" Ada (83, 9X, 95)
au Syntax ada		so $VIM/syntax/ada.vim

" Assembly (all kinds)
au Syntax asmselect	so $VIM/syntax/asmselect.vim

" ASN.1
au Syntax asn		so $VIM/syntax/asn.vim

" Atlas
au Syntax atlas		so $VIM/syntax/atlas.vim

" Avenue
au Syntax ave		so $VIM/syntax/ave.vim

" Awk
au Syntax awk		so $VIM/syntax/awk.vim

" BASIC
au Syntax basic		so $VIM/syntax/basic.vim

" Batch file for MSDOS
au Syntax dosbatch	so $VIM/syntax/dosbatch.vim

" Batch file for 4DOS
au Syntax btm		so $VIM/syntax/btm.vim

" BibTeX bibliography database file
au Syntax bib		so $VIM/syntax/bib.vim

" C
au Syntax c		so $VIM/syntax/c.vim

" C++
au Syntax cpp		so $VIM/syntax/cpp.vim

" Cascading Style Sheets
au Syntax css		so $VIM/syntax/css.vim

" Century Term Command Scripts
au Syntax cterm		so $VIM/syntax/cterm.vim

" Clean
au Syntax clean		so $VIM/syntax/clean.vim

" Clipper
au Syntax clipper	so $VIM/syntax/clipper.vim

" Cobol
au Syntax cobol		so $VIM/syntax/cobol.vim

" Diff files
au Syntax diff		so $VIM/syntax/diff.vim

" DCL (Digital Command Language - vms)
au Syntax dcl		so $VIM/syntax/dcl.vim

" Dracula
au Syntax dracula	so $VIM/syntax/dracula.vim

" DTD (Document Type Definition for XML)
au Syntax dtd		so $VIM/syntax/dtd.vim

" Eiffel
au Syntax eiffel	so $VIM/syntax/eiffel.vim

" Elm Filter Rules file
au Syntax elmfilt	so $VIM/syntax/elmfilt.vim

" ESQL-C
au Syntax esqlc		so $VIM/syntax/esqlc.vim

" Exports
au Syntax exports	so $VIM/syntax/exports.vim

" Fortran
au Syntax fortran	so $VIM/syntax/fortran.vim

" Fvwm
au Syntax fvwm		so $VIM/syntax/fvwm.vim

" GP scripts (2.0 and onward)
au Syntax gp		so $VIM/syntax/gp.vim

" Gnuplot scripts
au Syntax gnuplot	so $VIM/syntax/gnuplot.vim

" Haskell
au Syntax haskell	so $VIM/syntax/haskell.vim
au Syntax lhaskell	so $VIM/syntax/lhaskell.vim

" HTML (.shtml for server side)
au Syntax html		so $VIM/syntax/html.vim

" IDL (Interface Description Language)
au Syntax idl		so $VIM/syntax/idl.vim

" Inform
au Syntax inform	so $VIM/syntax/inform.vim

" .INI file for MSDOS
au Syntax dosini	so $VIM/syntax/dosini.vim

" Java
au Syntax java		so $VIM/syntax/java.vim

" JavaCC
au Syntax javacc	so $VIM/syntax/javacc.vim

" JavaScript
au Syntax javascript	so $VIM/syntax/javascript.vim

" Jgraph
au Syntax jgraph	so $VIM/syntax/jgraph.vim

" Lace (ISE)
au Syntax lace		so $VIM/syntax/lace.vim

" Lex
au Syntax lex		so $VIM/syntax/lex.vim

" Lisp
au Syntax lisp		so $VIM/syntax/lisp.vim

" Lite
au Syntax lite		so $VIM/syntax/lite.vim

" LOTOS
au Syntax lotos		so $VIM/syntax/lotos.vim

" Lua
au Syntax lua		so $VIM/syntax/lua.vim

" Lynx style file
au Syntax lss		so $VIM/syntax/lss.vim

" M4
au Syntax m4		so $VIM/syntax/m4.vim

" Mail (for Elm, trn and rn)
au Syntax mail		so $VIM/syntax/mail.vim

" Makefile
au Syntax make		so $VIM/syntax/make.vim

" Manpage
au Syntax man		so $VIM/syntax/man.vim

" Maple V
au Syntax maple		so $VIM/syntax/maple.vim

" Matlab
au Syntax matlab	so $VIM/syntax/matlab.vim

" Metafont
au Syntax mf		so $VIM/syntax/mf.vim

" MetaPost
au Syntax mp		so $VIM/syntax/mp.vim

" Modula 2
au Syntax modula2	so $VIM/syntax/modula2.vim

" Msql
au Syntax msql		so $VIM/syntax/msql.vim

" M$ Resource files
au Syntax rc		so $VIM/syntax/rc.vim

" Mutt setup file
au Syntax muttrc	so $VIM/syntax/muttrc.vim

" Nroff/Troff (*.ms is checked below)
au Syntax nroff		so $VIM/syntax/nroff.vim

" OCAML
au Syntax ocaml		so $VIM/syntax/ocaml.vim

" Pascal
au Syntax pascal	so $VIM/syntax/pascal.vim

" Perl
au Syntax perl		so $VIM/syntax/perl.vim

" Perl or XPM
au Syntax pmfile	so $VIM/syntax/pmfile.vim

" Perl POD
au Syntax pod		so $VIM/syntax/pod.vim

" Php3
au Syntax php3		so $VIM/syntax/php3.vim

" Phtml
au Syntax phtml		so $VIM/syntax/phtml.vim

" Pike
au Syntax pike		so $VIM/syntax/pike.vim

" PL/SQL
au Syntax plsql		so $VIM/syntax/plsql.vim

" PO (GNU gettext)
au Syntax po		so $VIM/syntax/po.vim

" PostScript
au Syntax postscr	so $VIM/syntax/postscr.vim

" Povray
au Syntax pov		so $VIM/syntax/pov.vim

" Printcap and Termcap
au Syntax ptcap		so $VIM/syntax/ptcap.vim

" PCCTS
au Syntax pccts		so $VIM/syntax/pccts.vim

" Procmail
au Syntax procmail	so $VIM/syntax/procmail.vim

" Prolog
au Syntax prolog	so $VIM/syntax/prolog.vim

" Python
au Syntax python	so $VIM/syntax/python.vim

" Radiance
au Syntax radiance	so $VIM/syntax/radiance.vim

" Rebol
au Syntax rebol		so $VIM/syntax/rebol.vim

" Rexx
au Syntax rexx		so $VIM/syntax/rexx.vim

" S-lang
au Syntax slang		so $VIM/syntax/slang.vim

" Sather
au Syntax sather	so $VIM/syntax/sather.vim

" SDL
au Syntax sdl		so $VIM/syntax/sdl.vim

" sed
au Syntax sed		so $VIM/syntax/sed.vim

" Sendmail
au Syntax sm		so $VIM/syntax/sm.vim

" SGML
au Syntax sgml		so $VIM/syntax/sgml.vim

" Shell scripts (sh, ksh, bash, csh)
au Syntax sh		so $VIM/syntax/sh.vim
au Syntax csh		so $VIM/syntax/csh.vim

" Z-Shell script
au Syntax zsh		so $VIM/syntax/zsh.vim

" Scheme
au Syntax scheme	so $VIM/syntax/scheme.vim

" Simula
au Syntax simula	so $VIM/syntax/simula.vim

" SKILL
au Syntax skill		so $VIM/syntax/skill.vim

" SLRN
au Syntax slrnrc	so $VIM/syntax/slrnrc.vim
au Syntax slrnsc	so $VIM/syntax/slrnsc.vim

" Smalltalk
au Syntax st		so $VIM/syntax/st.vim

" SMIL
au Syntax smil		so $VIM/syntax/smil.vim

" SNMP MIB files
au Syntax mib		so $VIM/syntax/mib.vim

" Spec (Linux RPM)
au Syntax spec		so $VIM/syntax/spec.vim

" Squid
au Syntax squid		so $VIM/syntax/squid.vim

" SQL
au Syntax sql		so $VIM/syntax/sql.vim

" Tags
au Syntax tags		so $VIM/syntax/tags.vim

" Tcl
au Syntax tcl		so $VIM/syntax/tcl.vim

" Telix Salt
au Syntax tsalt		so $VIM/syntax/tsalt.vim

" TeX
au Syntax tex		so $VIM/syntax/tex.vim

" TF mud client
au Syntax tf		so $VIM/syntax/tf.vim

" Motif UIT/UIL files
au Syntax uil		so $VIM/syntax/uil.vim

" Verilog HDL
au Syntax verilog	so $VIM/syntax/verilog.vim

" VHDL
au Syntax vhdl		so $VIM/syntax/vhdl.vim

" Vim Help file
au Syntax help		so $VIM/syntax/help.vim

" Vim script
au Syntax vim		so $VIM/syntax/vim.vim

" Viminfo file
au Syntax viminfo	so $VIM/syntax/viminfo.vim

" Vgrindefs file
au Syntax vgrindefs	so $VIM/syntax/vgrindefs.vim

" VRML V1.0c
au Syntax vrml		so $VIM/syntax/vrml.vim

" X Pixmap (dynamically sets colors, use BufEnter to make it work better)
au Syntax xpm		so $VIM/syntax/xpm.vim

" X resources file
au Syntax xdefaults	so $VIM/syntax/xdefaults.vim

" Xmath
au Syntax xmath		so $VIM/syntax/xmath.vim
au Syntax mstype	so $VIM/syntax/mstype.vim

" XML
au Syntax xml		so $VIM/syntax/xml.vim

" Yacc
au Syntax yacc		so $VIM/syntax/yacc.vim


" Source the user-specified syntax highlighting file
if exists("mysyntaxfile")
  if file_readable(expand(mysyntaxfile))
    execute "source " . mysyntaxfile
  endif
endif

endif " has("syntax")

" vim: ts=8 sts=0
