" Vim syntax file
" Language:	msql
" Maintainer:	Lutz Eymers <ixtab@polzin.com>
" URL:		http://www-public.rz.uni-duesseldorf.de/~eymers/vim/syntax
" Email:        Subject: send syntax_vim.tgz
" Last change:	1998 Nov 28

" Remove any old syntax stuff hanging around
syn clear

so $VIM/syntax/html.vim
syn region  htmlTag start=+<[^/]+ end=+>+              contains=htmlTagN,htmlString,htmlArg,htmlValue,htmlTagError,htmlEvent,htmlCssDefinition,msqlRegion 
syn region  htmlString contained start=+"+ skip=+\\\\\|\\"+ end=+"+ contains=htmlSpecial,javaScriptExpression,msqlRegion
syn region  htmlString contained start=+'+ skip=+\\\\\|\\'+ end=+'+ contains=htmlSpecial,javaScriptExpression,msqlRegion
syn region  javaScript  start=+<script[^>]*>+ keepend end=+</script>+me=s-1 contains=@htmlJavaScript,htmlCssStyleComment,htmlScriptTag,msqlRegion
syn region  javaScriptStringD          contained start=+"+  skip=+\\\\\|\\"+  end=+"+  contains=javaScriptSpecial,msqlRegion
syn region  javaScriptStringS          contained start=+'+  skip=+\\\\\|\\'+  end=+'+  contains=javaScriptSpecial,msqlRegion

syn case match

" Internal Variables
syn keyword msqlIntVar ERRMSG contained

" Env Variables
syn keyword msqlEnvVar SERVER_SOFTWARE SERVER_NAME SERVER_URL GATEWAY_INTERFACE contained
syn keyword msqlEnvVar SERVER_PROTOCOL SERVER_PORT REQUEST_METHOD PATH_INFO  contained
syn keyword msqlEnvVar PATH_TRANSLATED SCRIPT_NAME QUERY_STRING REMOTE_HOST contained
syn keyword msqlEnvVar REMOTE_ADDR AUTH_TYPE REMOTE_USER CONTEN_TYPE  contained
syn keyword msqlEnvVar CONTENT_LENGTH HTTPS HTTPS_KEYSIZE HTTPS_SECRETKEYSIZE  contained
syn keyword msqlEnvVar HTTP_ACCECT HTTP_USER_AGENT HTTP_IF_MODIFIED_SINCE  contained
syn keyword msqlEnvVar HTTP_FROM HTTP_REFERER contained

" Inlclude Lite
syn include @Lite <sfile>:p:h/lite.vim

" Msql Region
syn region msqlRegion matchgroup=Delimiter start="<!$" start="<![^!->D]" end=">" contains=@Lite,msql.*

if !exists("did_msql_syntax_inits")
  let did_msql_syntax_inits = 1
  " The default methods for highlighting.  Can be overridden later
  hi link msqlComment                   Comment
  hi link msqlString                    String
  hi link msqlNumber                    Number
  hi link msqlFloat                     Float
  hi msqlIdentifier guifg=DarkGrey ctermfg=Brown
  hi msqlGlobalIdentifier guifg=DarkGrey ctermfg=Brown
  hi link msqlFunctions                 Function
  hi link msqlRepeat                    Repeat 
  hi link msqlConditional               Conditional 
  hi link msqlStatement                 Statement
  hi link msqlType                      Type
  hi link msqlInclude                   Include
  hi link msqlDefine                    Define
  hi link msqlSpecialChar               SpecialChar
  hi link msqlParentError	        Error
  hi link msqlTodo                      Todo
  hi msqlRelation guifg=SeaGreen ctermfg=DarkGreen
  hi msqlOperator guifg=SeaGreen ctermfg=DarkGreen
  hi msqlIntVar guifg=Red ctermfg=DarkRed
  hi msqlEnvVar guifg=Red ctermfg=DarkRed
endif
 
let b:current_syntax = "msql"
 
" vim: ts=8
