" Vim syntax support file
" Maintainer:	Bram Moolenaar <Bram@vim.org>
" Last change:	1998 Nov 1

" This is the startup file for syntax highlighting.
" 1. Set the default highlight groups.
" 2. Install FileType autocommands for all the available syntax files.
" 3. Install the Syntax menu.

if has("syntax")

" Make sure the '<' flag is not included in 'cpoptions', otherwise <CR> would
" not be recognized.  See ":help 'cpoptions'".
let syntax_cpo_save = &cpo
let &cpo = ""

" let others know that syntax has been switched on
let syntax_on = 1

" The default methods for highlighting.  Can be overridden later.
" Many terminals can only use six different colors (plus black and white).
" Therefore the number of colors used is kept low. It doesn't look nice with
" too many colors anyway.
" Careful with "cterm=bold", it may change the color to bright.

" There are two sets of defaults: for a dark and a light background.
if &background == "dark"
  hi Comment	term=bold ctermfg=Cyan guifg=#80a0ff
  hi Constant	term=underline ctermfg=Magenta guifg=#ffa0a0
  hi Special	term=bold ctermfg=LightRed guifg=Orange
  hi Identifier term=underline cterm=bold ctermfg=Cyan guifg=#40ffff
  hi Statement	term=bold ctermfg=Yellow guifg=#ffff60 gui=bold
  hi PreProc	term=underline ctermfg=LightBlue guifg=#ff80ff
  hi Type	term=underline ctermfg=LightGreen guifg=#60ff60 gui=bold
  hi Ignore	ctermfg=black guifg=bg
else
  hi Comment	term=bold ctermfg=DarkBlue guifg=Blue
  hi Constant	term=underline ctermfg=DarkRed guifg=Magenta
  hi Special	term=bold ctermfg=DarkMagenta guifg=SlateBlue
  hi Identifier term=underline ctermfg=DarkCyan guifg=DarkCyan
  hi Statement	term=bold ctermfg=Brown gui=bold guifg=Brown
  hi PreProc	term=underline ctermfg=DarkMagenta guifg=Purple
  hi Type	term=underline ctermfg=DarkGreen guifg=SeaGreen gui=bold
  hi Ignore	ctermfg=white guifg=bg
endif
hi Error	term=reverse ctermbg=Red ctermfg=White guibg=Red guifg=White
hi Todo	term=standout ctermbg=Yellow ctermfg=Black guifg=Blue guibg=Yellow

" Common groups that link to default highlighting.
" You can specify other highlighting easily.
hi link String		Constant
hi link Character	Constant
hi link Number		Constant
hi link Boolean		Constant
hi link Float		Number
hi link Function	Identifier
hi link Conditional	Statement
hi link Repeat		Statement
hi link Label		Statement
hi link Operator	Statement
hi link Keyword		Statement
hi link Exception	Statement
hi link Include		PreProc
hi link Define		PreProc
hi link Macro		PreProc
hi link PreCondit	PreProc
hi link StorageClass	Type
hi link Structure	Type
hi link Typedef		Type
hi link Tag		Special
hi link SpecialChar	Special
hi link Delimiter	Special
hi link SpecialComment	Special
hi link Debug		Special


augroup syntax

" First remove all old syntax autocommands.
au!


" OFF
au FileType OFF		syn clear

" ON
au FileType ON		if &filetype != "" | exe "so $VIM/syntax/" . &filetype . ".vim" | exe "set syntax=" . &filetype | else | echohl ErrorMsg | echo "filetype unknown" | echohl None | endif

" Ada (83, 9X, 95)
au FileType ada		so $VIM/syntax/ada.vim

" Assembly (all kinds)
au FileType asmselect	so $VIM/syntax/asmselect.vim

" ASN.1
au FileType asn		so $VIM/syntax/asn.vim

" Atlas
au FileType atlas	so $VIM/syntax/atlas.vim

" Avenue
au FileType ave		so $VIM/syntax/ave.vim

" Awk
au FileType awk		so $VIM/syntax/awk.vim

" BASIC
au FileType basic	so $VIM/syntax/basic.vim

" Batch file for MSDOS
au FileType dosbatch	so $VIM/syntax/dosbatch.vim

" Batch file for 4DOS
au FileType btm		so $VIM/syntax/btm.vim

" BibTeX bibliography database file
au FileType bib		so $VIM/syntax/bib.vim

" C
au FileType c		so $VIM/syntax/c.vim

" C++
au FileType cpp		so $VIM/syntax/cpp.vim

" Cascading Style Sheets
au FileType css		so $VIM/syntax/css.vim

" Century Term Command Scripts
au FileType cterm	so $VIM/syntax/cterm.vim

" Clean
au FileType clean	so $VIM/syntax/clean.vim

" Clipper
au FileType clipper	so $VIM/syntax/clipper.vim

" Cobol
au FileType cobol	so $VIM/syntax/cobol.vim

" Diff files
au FileType diff	so $VIM/syntax/diff.vim

" DCL (Digital Command Language - vms)
au FileType dcl		so $VIM/syntax/dcl.vim

" Dracula
au FileType dracula	so $VIM/syntax/dracula.vim

" DTD (Document Type Definition for XML)
au FileType dtd		so $VIM/syntax/dtd.vim

" Eiffel
au FileType eiffel	so $VIM/syntax/eiffel.vim

" Elm Filter Rules file
au FileType elmfilt	so $VIM/syntax/elmfilt.vim

" ESQL-C
au FileType esqlc	so $VIM/syntax/esqlc.vim

" Exports
au FileType exports	so $VIM/syntax/exports.vim

" Fortran
au FileType fortran	so $VIM/syntax/fortran.vim

" Fvwm
au FileType fvwm	so $VIM/syntax/fvwm.vim

" GP scripts (2.0 and onward)
au FileType gp		so $VIM/syntax/gp.vim

" HTML (.shtml for server side)
au FileType html	so $VIM/syntax/html.vim

" IDL (Interface Description Language)
au FileType idl		so $VIM/syntax/idl.vim

" Inform
au FileType inform	so $VIM/syntax/inform.vim

" .INI file for MSDOS
au FileType dosini	so $VIM/syntax/dosini.vim

" Java
au FileType java	so $VIM/syntax/java.vim

" JavaCC
au FileType javacc	so $VIM/syntax/javacc.vim

" JavaScript
au FileType javascript	so $VIM/syntax/javascript.vim

" Jgraph
au FileType jgraph	so $VIM/syntax/jgraph.vim

" Lace (ISE)
au FileType lace	so $VIM/syntax/lace.vim

" Lex
au FileType lex		so $VIM/syntax/lex.vim

" Lisp
au FileType lisp	so $VIM/syntax/lisp.vim

" Lite
au FileType lite	so $VIM/syntax/lite.vim

" LOTOS
au FileType lotos	so $VIM/syntax/lotos.vim

" Lua
au FileType lua		so $VIM/syntax/lua.vim

" Lynx style file
au FileType lss		so $VIM/syntax/lss.vim

" M4
au FileType m4		so $VIM/syntax/m4.vim

" Mail (for Elm, trn and rn)
au FileType mail	so $VIM/syntax/mail.vim

" Makefile
au FileType make	so $VIM/syntax/make.vim

" Manpage
au FileType man		so $VIM/syntax/man.vim

" Maple V
au FileType maple	so $VIM/syntax/maple.vim

" Matlab
au FileType matlab	so $VIM/syntax/matlab.vim

" Metafont
au FileType mf		so $VIM/syntax/mf.vim

" MetaPost
au FileType mp		so $VIM/syntax/mp.vim

" Modula 2
au FileType modula2	so $VIM/syntax/modula2.vim

" Msql
au FileType msql	so $VIM/syntax/msql.vim

" M$ Resource files
au FileType rc		so $VIM/syntax/rc.vim

" Mutt setup file
au FileType muttrc	so $VIM/syntax/muttrc.vim

" Nroff/Troff (*.ms is checked below)
au FileType nroff	so $VIM/syntax/nroff.vim

" OCAML
au FileType ocaml	so $VIM/syntax/ocaml.vim

" Pascal
au FileType pascal	so $VIM/syntax/pascal.vim

" Perl
au FileType perl	so $VIM/syntax/perl.vim

" Perl or XPM
au FileType pmfile	so $VIM/syntax/pmfile.vim

" Perl POD
au FileType pod		so $VIM/syntax/pod.vim

" Php3
au FileType php3	so $VIM/syntax/php3.vim

" Phtml
au FileType phtml	so $VIM/syntax/phtml.vim

" Pike
au FileType pike	so $VIM/syntax/pike.vim

" PO (GNU gettext)
au FileType po		so $VIM/syntax/po.vim

" PostScript
au FileType postscr	so $VIM/syntax/postscr.vim

" Povray
au FileType pov		so $VIM/syntax/pov.vim

" Printcap and Termcap
au FileType ptcap	so $VIM/syntax/ptcap.vim

" PCCTS
au FileType pccts	so $VIM/syntax/pccts.vim

" Procmail
au FileType procmail	so $VIM/syntax/procmail.vim

" Prolog
au FileType prolog	so $VIM/syntax/prolog.vim

" Python
au FileType python	so $VIM/syntax/python.vim

" Rexx
au FileType rexx	so $VIM/syntax/rexx.vim

" S-lang
au FileType slang	so $VIM/syntax/slang.vim

" Sather
au FileType sather	so $VIM/syntax/sather.vim

" SDL
au FileType sdl		so $VIM/syntax/sdl.vim

" sed
au FileType sed		so $VIM/syntax/sed.vim

" Sendmail
au FileType sm		so $VIM/syntax/sm.vim

" SGML
au FileType sgml	so $VIM/syntax/sgml.vim

" Shell scripts (sh, ksh, bash, csh)
au FileType sh		so $VIM/syntax/sh.vim
au FileType csh		so $VIM/syntax/csh.vim

" Z-Shell script
au FileType zsh		so $VIM/syntax/zsh.vim

" Scheme
au FileType scheme	so $VIM/syntax/scheme.vim

" Simula
au FileType simula	so $VIM/syntax/simula.vim

" SKILL
au FileType skill	so $VIM/syntax/skill.vim

" SLRN
au FileType slrnrc	so $VIM/syntax/slrnrc.vim
au FileType slrnsc	so $VIM/syntax/slrnsc.vim

" Smalltalk
au FileType st		so $VIM/syntax/st.vim

" SNMP MIB files
au FileType mib		so $VIM/syntax/mib.vim

" Spec (Linux RPM)
au FileType spec	so $VIM/syntax/spec.vim

" SQL
au FileType sql		so $VIM/syntax/sql.vim

" Tags
au FileType tags	so $VIM/syntax/tags.vim

" Tcl
au FileType tcl		so $VIM/syntax/tcl.vim

" Telix Salt
au FileType tsalt	so $VIM/syntax/tsalt.vim

" TeX
au FileType tex		so $VIM/syntax/tex.vim

" TF mud client
au FileType tf		so $VIM/syntax/tf.vim

" Motif UIT/UIL files
au FileType uil		so $VIM/syntax/uil.vim

" Verilog HDL
au FileType verilog	so $VIM/syntax/verilog.vim

" VHDL
au FileType vhdl	so $VIM/syntax/vhdl.vim

" Vim Help file
au FileType help	so $VIM/syntax/help.vim

" Vim script
au FileType vim		so $VIM/syntax/vim.vim

" Viminfo file
au FileType viminfo	so $VIM/syntax/viminfo.vim

" Vgrindefs file
au FileType vgrindefs	so $VIM/syntax/vgrindefs.vim

" VRML V1.0c
au FileType vrml	so $VIM/syntax/vrml.vim

" X Pixmap (dynamically sets colors, use BufEnter to make it work better)
au FileType	xpm	so $VIM/syntax/xpm.vim

" X resources file
au FileType xdefaults	so $VIM/syntax/xdefaults.vim

" Xmath
au FileType xmath	so $VIM/syntax/xmath.vim
au FileType mstype	so $VIM/syntax/mstype.vim

" XML
au FileType xml		so $VIM/syntax/xml.vim

" Yacc
au FileType yacc	so $VIM/syntax/yacc.vim

augroup END

if has("gui")

amenu 50.10.100 &Syntax.&ABCD.Ada			:set syn=ada<CR>
amenu 50.10.110 &Syntax.&ABCD.Amiga\ DOS		:set syn=amiga<CR>
amenu 50.10.120 &Syntax.&ABCD.assembly			:set syn=asm<CR>
amenu 50.10.130 &Syntax.&ABCD.ASN\.1			:set syn=asn<CR>
amenu 50.10.140 &Syntax.&ABCD.Atlas			:set syn=atlas<CR>
amenu 50.10.150 &Syntax.&ABCD.Avenue			:set syn=ave<CR>
amenu 50.10.160 &Syntax.&ABCD.Awk			:set syn=awk<CR>
amenu 50.10.170 &Syntax.&ABCD.BASIC			:set syn=basic<CR>
amenu 50.10.180 &Syntax.&ABCD.BibFile			:set syn=bib<CR>
amenu 50.10.190 &Syntax.&ABCD.C				:set syn=c<CR>
amenu 50.10.200 &Syntax.&ABCD.C++			:set syn=cpp<CR>
amenu 50.10.210 &Syntax.&ABCD.Cascading\ Style\ Sheets	:set syn=css<CR>
amenu 50.10.220 &Syntax.&ABCD.Century\ Term		:set syn=cterm<CR>
amenu 50.10.230 &Syntax.&ABCD.Clean			:set syn=clean<CR>
amenu 50.10.240 &Syntax.&ABCD.Clipper			:set syn=clipper<CR>
amenu 50.10.250 &Syntax.&ABCD.Csh\ shell\ script	:set syn=csh<CR>
amenu 50.10.260 &Syntax.&ABCD.Cobol			:set syn=cobol<CR>
amenu 50.10.270 &Syntax.&ABCD.Diff			:set syn=diff<CR>
amenu 50.10.280 &Syntax.&ABCD.Dracula			:set syn=dracula<CR>
amenu 50.10.290 &Syntax.&ABCD.DTD			:set syn=dtd<CR>
amenu 50.20.100 &Syntax.&EFGHIJ.Eiffel			:set syn=eiffel<CR>
amenu 50.20.110 &Syntax.&EFGHIJ.Elm\ Filter		:set syn=elmfilt<CR>
amenu 50.20.120 &Syntax.&EFGHIJ.ESQL-C			:set syn=esqlc<CR>
amenu 50.20.130 &Syntax.&EFGHIJ.Expect			:set syn=expect<CR>
amenu 50.20.140 &Syntax.&EFGHIJ.Exports			:set syn=exports<CR>
amenu 50.20.150 &Syntax.&EFGHIJ.Fortran			:set syn=fortran<CR>
amenu 50.20.160 &Syntax.&EFGHIJ.Fvwm\ configuration	:set syn=fvwm<CR>
amenu 50.20.170 &Syntax.&EFGHIJ.GP			:set syn=gp<CR>
amenu 50.20.180 &Syntax.&EFGHIJ.HTML			:set syn=html<CR>
amenu 50.20.190 &Syntax.&EFGHIJ.IDL			:set syn=idl<CR>
amenu 50.20.200 &Syntax.&EFGHIJ.Inform			:set syn=inform<CR>
amenu 50.20.210 &Syntax.&EFGHIJ.Java			:set syn=java<CR>
amenu 50.20.220 &Syntax.&EFGHIJ.JavaCC			:set syn=javacc<CR>
amenu 50.20.230 &Syntax.&EFGHIJ.JavaScript		:set syn=javascript<CR>
amenu 50.20.240 &Syntax.&EFGHIJ.Jgraph			:set syn=jgraph<CR>
amenu 50.30.100 &Syntax.&KLM.Lace			:set syn=lace<CR>
amenu 50.30.110 &Syntax.&KLM.Lex			:set syn=lex<CR>
amenu 50.30.120 &Syntax.&KLM.Lilo			:set syn=lilo<CR>
amenu 50.30.130 &Syntax.&KLM.Lisp			:set syn=lisp<CR>
amenu 50.30.140 &Syntax.&KLM.Lite			:set syn=lite<CR>
amenu 50.30.150 &Syntax.&KLM.LOTOS			:set syn=lotos<CR>
amenu 50.30.160 &Syntax.&KLM.Lua			:set syn=lua<CR>
amenu 50.30.170 &Syntax.&KLM.Lynx\ Style		:set syn=lss<CR>
amenu 50.30.180 &Syntax.&KLM.M4				:set syn=m4<CR>
amenu 50.30.190 &Syntax.&KLM.Mail			:set syn=mail<CR>
amenu 50.30.200 &Syntax.&KLM.Makefile			:set syn=make<CR>
amenu 50.30.210 &Syntax.&KLM.Man\ page			:set syn=man<CR>
amenu 50.30.220 &Syntax.&KLM.Maple			:set syn=maple<CR>
amenu 50.30.230 &Syntax.&KLM.Matlab			:set syn=matlab<CR>
amenu 50.30.240 &Syntax.&KLM.Metafont			:set syn=mf<CR>
amenu 50.30.250 &Syntax.&KLM.MetaPost			:set syn=mp<CR>
amenu 50.30.260 &Syntax.&KLM.Model			:set syn=model<CR>
amenu 50.30.270 &Syntax.&KLM.Modula\ 2			:set syn=modula2<CR>
amenu 50.30.280 &Syntax.&KLM.Msql			:set syn=msql<CR>
amenu 50.30.290 &Syntax.&KLM.MS-DOS\ \.bat\ file	:set syn=dosbatch<CR>
amenu 50.30.300 &Syntax.&KLM.4DOS\ \.bat\ file		:set syn=btm<CR>
amenu 50.30.310 &Syntax.&KLM.MS-DOS\ \.ini\ file	:set syn=dosini<CR>
amenu 50.30.320 &Syntax.&KLM.MS\ Resource\ file		:set syn=rc<CR>
amenu 50.30.330 &Syntax.&KLM.Muttrc			:set syn=muttrc<CR>
amenu 50.40.100 &Syntax.&NOPQ.NASM			:set syn=nasm<CR>
amenu 50.40.110 &Syntax.&NOPQ.Nroff			:set syn=nroff<CR>
amenu 50.40.120 &Syntax.&NOPQ.Objective\ C		:set syn=objc<CR>
amenu 50.40.130 &Syntax.&NOPQ.OCAML			:set syn=ocaml<CR>
amenu 50.40.140 &Syntax.&NOPQ.Pascal			:set syn=pascal<CR>
amenu 50.40.150 &Syntax.&NOPQ.PCCTS			:set syn=pccts<CR>
amenu 50.40.160 &Syntax.&NOPQ.Perl			:set syn=perl<CR>
amenu 50.40.170 &Syntax.&NOPQ.Perl\ POD			:set syn=pod<CR>
amenu 50.40.180 &Syntax.&NOPQ.PHP\ 3			:set syn=php3<CR>
amenu 50.40.190 &Syntax.&NOPQ.Phtml			:set syn=phtml<CR>
amenu 50.40.200 &Syntax.&NOPQ.Pike			:set syn=pike<CR>
amenu 50.40.210 &Syntax.&NOPQ.PO\ (GNU\ gettext)	:set syn=po<CR>
amenu 50.40.220 &Syntax.&NOPQ.PostScript		:set syn=postscr<CR>
amenu 50.40.230 &Syntax.&NOPQ.Povray			:set syn=pov<CR>
amenu 50.40.240 &Syntax.&NOPQ.Printcap			:set syn=ptcap<CR>
amenu 50.40.250 &Syntax.&NOPQ.Procmail			:set syn=procmail<CR>
amenu 50.40.260 &Syntax.&NOPQ.Prolog			:set syn=prolog<CR>
amenu 50.40.270 &Syntax.&NOPQ.Purify\ log		:set syn=purifylog<CR>
amenu 50.40.280 &Syntax.&NOPQ.Python			:set syn=python<CR>
amenu 50.50.100 &Syntax.&RS.Rexx			:set syn=rexx<CR>
amenu 50.50.110 &Syntax.&RS.S-lang			:set syn=slang<CR>
amenu 50.50.120 &Syntax.&RS.Sather			:set syn=sather<CR>
amenu 50.50.130 &Syntax.&RS.Scheme			:set syn=scheme<CR>
amenu 50.50.140 &Syntax.&RS.SDL				:set syn=sdl<CR>
amenu 50.50.150 &Syntax.&RS.sed				:set syn=sed<CR>
amenu 50.50.160 &Syntax.&RS.Sendmail\.cf		:set syn=sm<CR>
amenu 50.50.170 &Syntax.&RS.SGML			:set syn=sgml<CR>
amenu 50.50.180 &Syntax.&RS.Sh\ shell\ script		:set syn=sh<CR>
amenu 50.50.190 &Syntax.&RS.SiCAD			:set syn=sicad<CR>
amenu 50.50.200 &Syntax.&RS.Simula			:set syn=simula<CR>
amenu 50.50.210 &Syntax.&RS.SKILL			:set syn=skill<CR>
amenu 50.50.220 &Syntax.&RS.SLRN\ rc			:set syn=slrnrc<CR>
amenu 50.50.230 &Syntax.&RS.SLRN\ score			:set syn=slrnsc<CR>
amenu 50.50.240 &Syntax.&RS.SmallTalk			:set syn=st<CR>
amenu 50.50.250 &Syntax.&RS.SNMP\ MIB			:set syn=mib<CR>
amenu 50.50.260 &Syntax.&RS.SPEC\ (Linux\ RPM)		:set syn=spec<CR>
amenu 50.50.270 &Syntax.&RS.SQL				:set syn=sql<CR>
amenu 50.60.100 &Syntax.&TU.Tags			:set syn=tags<CR>
amenu 50.60.110 &Syntax.&TU.Tcl/Tk			:set syn=tcl<CR>
amenu 50.60.120 &Syntax.&TU.Telix\ Salt			:set syn=tsalt<CR>
amenu 50.60.130 &Syntax.&TU.Termcap			:set syn=ptcap<CR>
amenu 50.60.140 &Syntax.&TU.Tex				:set syn=tex<CR>
amenu 50.60.150 &Syntax.&TU.TF\ mud\ client		:set syn=tf<CR>
amenu 50.60.160 &Syntax.&TU.UIT/UIL			:set syn=uil<CR>
amenu 50.70.110 &Syntax.&VWXYZ.Verilog\ HDL		:set syn=verilog<CR>
amenu 50.70.120 &Syntax.&VWXYZ.vgrindefs		:set syn=vgrindefs<CR>
amenu 50.70.130 &Syntax.&VWXYZ.VHDL			:set syn=vhdl<CR>
amenu 50.70.140 &Syntax.&VWXYZ.Vim\ help\ file		:set syn=help<CR>
amenu 50.70.150 &Syntax.&VWXYZ.Vim\ script		:set syn=vim<CR>
amenu 50.70.160 &Syntax.&VWXYZ.Viminfo\ file		:set syn=viminfo<CR>
amenu 50.70.170 &Syntax.&VWXYZ.VRML			:set syn=vrml<CR>
amenu 50.70.180 &Syntax.&VWXYZ.whitespace		:set syn=whitespace<CR>
amenu 50.70.190 &Syntax.&VWXYZ.X\ Pixmap		:set syn=xpm<CR>
amenu 50.70.200 &Syntax.&VWXYZ.X\ resources		:set syn=xdefaults<CR>
amenu 50.70.210 &Syntax.&VWXYZ.Xmath			:set syn=xmath<CR>
amenu 50.70.220 &Syntax.&VWXYZ.XML			:set syn=xml<CR>
amenu 50.70.230 &Syntax.&VWXYZ.Yacc			:set syn=yacc<CR>
amenu 50.70.240 &Syntax.&VWXYZ.Zsh\ shell\ script :set syn=zsh<CR>
amenu 50.80 &Syntax.&on\ (this\ file)	:normal :if exists("syntax_on")<Bar>doau syntax FileType ON<Bar>else<Bar>syn on<Bar>doau syntax FileType ON<Bar>au! syntax<C-V><CR>:unlet syntax_on<Bar>aunmenu &Syntax.&manual<Bar>endif<C-V><CR><CR>
amenu 50.82 &Syntax.o&ff\ (this\ file)	:syn clear<CR>
amenu 50.84 &Syntax.&manual			:normal :au! syntax<C-V><CR>:unlet syntax_on<Bar>aunmenu &Syntax.&manual<Bar>amenu 50.30 &Syntax.auto&matic :aunmenu &Syntax.auto&matic<C-V><C-V><C-V><C-V><Bar>so $VIM/syntax/syntax.vim<C-V><C-V><C-V><CR><C-V><CR><CR>
amenu 50.710 &Syntax.color\ &test		:sp $VIM/syntax/colortest.vim<Bar>so %<CR>
amenu 50.720 &Syntax.&highlight\ test	:new<Bar>so $VIM/syntax/hitest.vim<CR>
amenu 50.730 &Syntax.&convert\ to\ HTML	:so $VIM/syntax/2html.vim<CR>

endif " has("gui")


" Source the user-specified syntax highlighting file
if exists("mysyntaxfile")
  if file_readable(expand(mysyntaxfile))
    execute "source " . mysyntaxfile
  endif
endif


" Execute the syntax autocommands for the each buffer.
doautoall filetype BufRead

" Restore the previous value of 'cpoptions'.
let &cpo = syntax_cpo_save
unlet syntax_cpo_save

endif " has("syntax")

" vim: ts=8
