" Vim syntax file
" Language:	sed
" Maintainer:	Haakon Riiser <hakonrk@fys.uio.no>
" Last change:	1998 Oct 9

" Clear old syntax defs
syn clear

syn match sedAddress	"[[:digit:]$]"
syn match sedComment	"^\s*#.*$"
syn match sedFunction	"[dDgGhHlnNpPqx=]$"
syn match sedLabel	"^\s*:\S.*$"
syn match sedLineCont	"\\$" contained
syn match sedPattern	"/.\{-}[^\\]/"
syn match sedSpecial	"[{},!]"
syn region sedAppend	matchgroup=sedFunction start="a\\$" skip="^.*\\$" matchgroup=NONE end="^.*$" contains=sedLineCont
syn region sedBranch	matchgroup=sedFunction start="b\|t " end="$"
syn region sedChange	matchgroup=sedFunction start="c\\$" skip="^.*\\$" matchgroup=NONE end="^.*$" contains=sedLineCont
syn region sedInsert	matchgroup=sedFunction start="i\\$" skip="^.*\\$" matchgroup=NONE end="^.*$" contains=sedLineCont
syn region sedRead	matchgroup=sedFunction start="r\s" end="$"
syn region sedSubst	matchgroup=sedFunction start="s" matchgroup=sedFlag skip="\\$" end="\([[:digit:]gp]\+\|[[:digit:]gp]*w\s\+[[:alnum:]._-~]\+\|\)$" contains=sedLineCont
syn region sedTransform matchgroup=sedFunction start="y" skip="\\$" end="$" contains=sedLineCont
syn region sedWrite	matchgroup=sedFunction start="w\s" end="$"

if !exists("did_sed_syntax_inits")
  let did_sed_syntax_inits = 1
  hi link sedAddress	Macro
  hi link sedAppend	String
  hi link sedBranch	Label
  hi link sedChange	String
  hi link sedComment	Comment
  hi link sedDelete	Function
  hi link sedFlag	Type
  hi link sedFunction	Function
  hi link sedInsert	String
  hi link sedLabel	Label
  hi link sedLineCont	Special
  hi link sedPattern	Macro
  hi link sedPutHoldspc Function
  hi link sedSpecial	Special
  hi link sedSubst	Macro
  hi link sedTransform	Macro
endif

let b:current_syntax = "sed"

" vim: ts=8
