" Vim syntax file
" Language:	PCCTS
" Maintainer:	Scott Bigham <dsb@cs.duke.edu>
" Last change:	18 Oct 1998

" Remove any old syntax stuff hanging around
syn clear

" Read the C++ syntax to start with
syn include @cppTopLevel $VIM/syntax/cpp.vim

syn region pcctsAction matchgroup=pcctsDelim start="<<" end=">>?\=" contains=@cppTopLevel,pcctsRuleRef

syn region pcctsArgBlock matchgroup=pcctsDelim start="\(>\s*\)\=\[" end="\]" contains=@cppTopLevel,pcctsRuleRef

syn region pcctsString start=+"+ skip=+\\\\\|\\"+ end=+"+ contains=pcctsSpecialChar
syn match pcctsSpecialChar "\\\\\|\\\"" contained

syn region pcctsComment start="/\*" end="\*/" contains=cTodo
syn match  pcctsComment "//.*$" contains=cTodo

syn region pcctsDirective start="^\s*#header\s\+<<" end=">>" contains=pcctsAction keepend
syn match pcctsDirective "^\s*#parser.*$" contains=pcctsString,pcctsComment
syn match pcctsDirective "^\s*#tokdefs.*$" contains=pcctsString,pcctsComment
syn match pcctsDirective "^\s*#token.*$" contains=pcctsString,pcctsAction,pcctsTokenName
syn match pcctsDirective "^\s*#lexclass.*$" contains=pcctsTokenName

syn cluster pcctsInRule contains=pcctsString,pcctsRuleName,pcctsTokenName,pcctsAction,pcctsArgBlock,pcctsSubRule,pcctsLabel

syn region pcctsRule start="\<[a-z][A-Za-z0-9_]*\>\(\s*\[[^]]*\]\)\=\(\s*>\s*\[[^]]*\]\)\=\s*:" end=";" contains=@pcctsInRule

syn region pcctsSubRule matchgroup=pcctsDelim start="(" end=")\(+\|\*\|?\(\s*=>\)\)\=" contains=@pcctsInRule contained
syn region pcctsSubRule matchgroup=pcctsDelim start="{" end="}" contains=@pcctsInRule contained

syn match pcctsRuleName  "\<[a-z][A-Za-z0-9_]*\>" contained
syn match pcctsTokenName "\<[A-Z][A-Za-z0-9_]*\>" contained

syn match pcctsLabel "\<[A-Za-z][A-Za-z0-9_]*:[A-Za-z][A-Za-z0-9_]*" contained contains=pcctsLabelHack,pcctsRuleName,pcctsTokenName
syn match pcctsLabel "\<[A-Za-z][A-Za-z0-9_]*:\"\([^\\]\|\\.\)*\"" contained contains=pcctsLabelHack,pcctsString
syn match pcctsLabelHack "\<[A-Za-z][A-Za-z0-9_]*:" contained

syn match pcctsRuleRef "\$[A-Za-z][A-Za-z0-9_]*\>" contained
syn match pcctsRuleRef "\$[0-9]\+\(\.[0-9]\+\)\>" contained

syn keyword pcctsClass     class   nextgroup=pcctsClassName skipwhite
syn match   pcctsClassName "\<[A-Za-z][A-Za-z0-9_]*\>" contained nextgroup=pcctsClassBlock skipwhite skipnl
syn region pcctsClassBlock start="{" end="}" contained contains=pcctsRule,pcctsComment,pcctsDirective,pcctsAction

syn sync clear
syn sync match pcctsSyncAction grouphere pcctsAction "<<"
syn sync match pcctsSyncAction "<<\([^>]\|>[^>]\)*>>"
syn sync match pcctsSyncRule grouphere pcctsRule "\<[a-z][A-Za-z0-9_]*\>\s*\[[^]]*\]\s*:"
syn sync match pcctsSyncRule grouphere pcctsRule "\<[a-z][A-Za-z0-9_]*\>\(\s*\[[^]]*\]\)\=\s*>\s*\[[^]]*\]\s*:"

if !exists("did_pccts_syntax_inits")
  let did_pccts_syntax_inits = 1
  " The default methods for highlighting. Can be overriden later.
  hi link pcctsDelim		Special
  hi link pcctsTokenName	Identifier
  hi link pcctsRuleName		Statement
  hi link pcctsLabelHack	Label
  hi link pcctsDirective	PreProc
  hi link pcctsString		String
  hi link pcctsComment		Comment
  hi link pcctsClass		Statement
  hi link pcctsClassName	Identifier
  hi link pcctsRuleRef		Identifier
  hi link pcctsSpecialChar	SpecialChar
endif

let b:current_syntax = "pccts"
