" Vim syntax support file
" Maintainer:	Bram Moolenaar <Bram@vim.org>
" Last change:	1998 Oct 25

" This file is called by an autocommand for *.ms files.
" It checks if one of the first five lines start with a dot.  In that case
" it is probably an nroff file.  Otherwise it's assumed to be Xmath.

let b:lnum = 1
while b:lnum <= 5
  if getline(b:lnum) =~ '^\.'
    so <sfile>:p:h/nroff.vim
    let b:lnum = 99
  endif
  let b:lnum = b:lnum + 1
endwhile
if b:lnum < 99
  so <sfile>:p:h/xmath.vim
endif
unlet b:lnum

" vim: ts=8
