" Vim syntax file
" Language:	Fvwm{1,2} configuration file
" Maintainer:	Haakon Riiser <hakonrk@fys.uio.no>
" Last change:	1998 Sep 21
"
" Put
"
"	let is_fvwm1 = 1
"
" in your vimrc for more specific Fvwm1 syntax, or
"
"	let is_fvwm2 = 1
"
" if you're using Fvwm2.

set iskeyword=_,-,+,a-z,A-Z,48-57

" Clear old syntax defs
syn clear

" Case insensitive
syn case ignore

syn match fvwmArguments		"\w\s\+\w\+\s\+\w\+\s\+\w\+"ms=s+1 contained
syn match fvwmComment		"^#.*$"
syn match fvwmDimension		"\<\d\+\(x\d\+\)\=\>"
syn match fvwmDirectory		"/[-+./[:alnum:]_~@,$~/]*/\=" contains=fvwmEnvVar
syn match fvwmEnvVar		"\${\=\w\+}\="
syn match fvwmKeyDef		"^\s*Key\s\+\w\+\s\+\w\+\s\+\w\+" contains=fvwmArguments
syn match fvwmModule		"^\*\w\+"
syn match fvwmMouseDef		"^\s*Mouse\s\+\w\+\s\+\w\+\s\+\w\+" contains=fvwmArguments
syn match fvwmNumber		"\(+\|-\)\d\+\(+\|-\)\d\+\>"
syn match fvwmNumber		"\<\(+\|-\)\d\+\>"
syn match fvwmNumber		"\<\d\+\>"
syn match fvwmRGBValue		"rgb:\x\{1,4}/\x\{1,4}/\x\{1,4}"
syn match fvwmRGBValue		"\s#\x\{12}"
syn match fvwmRGBValue		"\s#\x\{3}"
syn match fvwmRGBValue		"\s#\x\{6}"
syn match fvwmRGBValue		"\s#\x\{9}"
syn match fvwmShortcutKey	"&."hs=s+1 contained
syn match fvwmSpecial		"[:,()!@]"
syn match fvwmString		"'.\{-}'" contains=fvwmExec
syn match fvwmString		"`.\{-}`" contains=fvwmExec
syn match fvwmString		'".\{-}"' contains=fvwmExec,fvwmShortcutKey,fvwmMenuIcon

if exists("is_fvwm1")
 " Fvwm1 functions
 syn keyword fvwmFunctions	CirculateDown CirculateUp EndFunction
 syn keyword fvwmFunctions	EndPopup TogglePage Warp

 " Fvwm1 commands
 syn keyword fvwmKeywords	AppsBackingStore AutoRaise BackingStore
 syn keyword fvwmKeywords	BoundaryWidth CenterOnCirculate
 syn keyword fvwmKeywords	CirculateSkipIcons Cursor
 syn keyword fvwmKeywords	DecorateTransients DeskTopScale
 syn keyword fvwmKeywords	DontMoveOff Font HiBackColor
 syn keyword fvwmKeywords	HiForeColor MenuBackColor MenuForeColor
 syn keyword fvwmKeywords	MenuStippleColor MWMBorders MWMDecorHints
 syn keyword fvwmKeywords	MWMFunctionHints MWMHintOverride
 syn keyword fvwmKeywords	MWMMenus NoBoundaryWidth OpaqueMove
 syn keyword fvwmKeywords	OpaqueResize Pager PagerBackColor
 syn keyword fvwmKeywords	PagerFont PagerForeColor PagingDefault
 syn keyword fvwmKeywords	SaveUnders StdBackColor StdForeColor
 syn keyword fvwmKeywords	StickyBackColor StickyForeColor
 syn keyword fvwmKeywords	StickyIcons StubbornIconPlacement
 syn keyword fvwmKeywords	StubbornIcons StubbornPlacement
 syn keyword fvwmKeywords	SuppressIcons
elseif exists("is_fvwm2")
 syn match fvwmMenuIcon		"%.\{-}%" contained
 syn match fvwmMenuIcon		"\*.\{-}\*" contained

 " Fvwm2 functions
 syn keyword fvwmFunctions	Current Destroy DestroyDecor DestroyFunc
 syn keyword fvwmFunctions	DestroyMenu DestroyModuleConfig Echo
 syn keyword fvwmFunctions	FlipFocus KillModule Menu Next None
 syn keyword fvwmFunctions	PipeRead Prev Read Recapture RefreshWindow
 syn keyword fvwmFunctions	SendToModule

 " Fvwm2 keywords
 syn keyword fvwmKeywords	Active ActiveDown ActivePlacement ActiveUp
 syn keyword fvwmKeywords	AddButtonStyle AddTitleStyle AddToDecor
 syn keyword fvwmKeywords	AddToFunc AddToMenu All BackColor
 syn keyword fvwmKeywords	BorderStyle Bottom Centered ChangeDecor
 syn keyword fvwmKeywords	CirculateSkipIcon ColormapFocus
 syn keyword fvwmKeywords	CursorStyle DecorateTransient Default
 syn keyword fvwmKeywords	DumbPlacement ExecUseShell Flat
 syn keyword fvwmKeywords	FocusFollowsMouse FollowsFocus ForeColor
 syn keyword fvwmKeywords	FvwmBorder GlobalOpts Height HGradient
 syn keyword fvwmKeywords	HiddenHandles HilightColor HintOverride
 syn keyword fvwmKeywords	Inactive Left LeftJustified MenuStyle
 syn keyword fvwmKeywords	MiniIcon MouseFocus MWMBorder MWMButtons
 syn keyword fvwmKeywords	MWMDecor MWMDecorMax MWMDecorMenu
 syn keyword fvwmKeywords	MWMDecorMin MWMFunctions NakedTransient
 syn keyword fvwmKeywords	NoDecorHint NoFuncHint NoIcon NoInsets
 syn keyword fvwmKeywords	NoLenience NoOLDecor NoOverride
 syn keyword fvwmKeywords	OLDecor OpaqueMoveSize Raised Reset
 syn keyword fvwmKeywords	Right RightJustified ShowMapping Simple
 syn keyword fvwmKeywords	SkipMapping Slippery SlipperyIcon Solid
 syn keyword fvwmKeywords	StickyIcon Sunk TiledPixmap TitleStyle
 syn keyword fvwmKeywords	Top UpdateDecor UseBorderStyle UseDecor
 syn keyword fvwmKeywords	UsePPosition UseStyle UseTitleStyle Vector
 syn keyword fvwmKeywords	VGradient Width WindowId WindowListHit
endif

" Functions common in Fvwm{1,2}
syn keyword fvwmCommonFuncs	Beep Close CursorMove Delete Desk Destroy
syn keyword fvwmCommonFuncs	Focus Function GotoPage Iconify Lower
syn keyword fvwmCommonFuncs	Maximize Module Move Nop Popup Quit Raise
syn keyword fvwmCommonFuncs	RaiseLower Refresh Resize Restart Scroll
syn keyword fvwmCommonFuncs	Stick Title Wait WindowList WindowsDesk
syn keyword fvwmCommonFuncs	WindowShade

" Keywords common in Fvwm{1,2}
syn keyword fvwmCommonKeywords	BorderWidth Button ButtonStyle
syn keyword fvwmCommonKeywords	CirculateHit CirculateSkip ClickTime
syn keyword fvwmCommonKeywords	ClickToFocus Color DeskTopSize
syn keyword fvwmCommonKeywords	EdgeResistance EdgeScroll Handles
syn keyword fvwmCommonKeywords	HandleWidth Icon IconBox IconFont
syn keyword fvwmCommonKeywords	IconPath IconTitle Lenience ModulePath
syn keyword fvwmCommonKeywords	MWMButtons NoBorder NoButton NoHandles
syn keyword fvwmCommonKeywords	NoIconTitle NoPPosition NoTitle PixmapPath
syn keyword fvwmCommonKeywords	RandomPlacement SloppyFocus SmartPlacement
syn keyword fvwmCommonKeywords	StartIconic StartNormal StartsAnyWhere
syn keyword fvwmCommonKeywords	StartsOnDesk StaysOnTop StaysPut Sticky
syn keyword fvwmCommonKeywords	Style WindowFont WindowListSkip XORvalue

" System colors
syn keyword fvwmColors		alice AliceBlue almond antique
syn keyword fvwmColors		AntiqueWhite AntiqueWhite1 AntiqueWhite2
syn keyword fvwmColors		AntiqueWhite3 AntiqueWhite4 aquamarine
syn keyword fvwmColors		aquamarine1 aquamarine2 aquamarine3
syn keyword fvwmColors		aquamarine4 azure azure1 azure2
syn keyword fvwmColors		azure3 azure4 beige bisque bisque1
syn keyword fvwmColors		bisque2 bisque3 bisque4 black blanched
syn keyword fvwmColors		BlanchedAlmond blue blue1 blue2 blue3
syn keyword fvwmColors		blue4 BlueViolet blush brown brown1
syn keyword fvwmColors		brown2 brown3 brown4 burlywood burlywood1
syn keyword fvwmColors		burlywood2 burlywood3 burlywood4 cadet
syn keyword fvwmColors		CadetBlue CadetBlue1 CadetBlue2 CadetBlue3
syn keyword fvwmColors		CadetBlue4 chartreuse chartreuse1
syn keyword fvwmColors		chartreuse2 chartreuse3 chartreuse4
syn keyword fvwmColors		chiffon chocolate chocolate1 chocolate2
syn keyword fvwmColors		chocolate3 chocolate4 coral coral1 coral2
syn keyword fvwmColors		coral3 coral4 cornflower CornflowerBlue
syn keyword fvwmColors		cornsilk cornsilk1 cornsilk2 cornsilk3
syn keyword fvwmColors		cornsilk4 cream cyan cyan1 cyan2 cyan3
syn keyword fvwmColors		cyan4 dark DarkBlue DarkCyan DarkGoldenrod
syn keyword fvwmColors		DarkGoldenrod1 DarkGoldenrod2
syn keyword fvwmColors		DarkGoldenrod3 DarkGoldenrod4 DarkGray
syn keyword fvwmColors		DarkGreen DarkGrey DarkKhaki DarkMagenta
syn keyword fvwmColors		DarkOliveGreen DarkOliveGreen1
syn keyword fvwmColors		DarkOliveGreen2 DarkOliveGreen3
syn keyword fvwmColors		DarkOliveGreen4 DarkOrange DarkOrange1
syn keyword fvwmColors		DarkOrange2 DarkOrange3 DarkOrange4
syn keyword fvwmColors		DarkOrchid DarkOrchid1 DarkOrchid2
syn keyword fvwmColors		DarkOrchid3 DarkOrchid4 DarkRed
syn keyword fvwmColors		DarkSalmon DarkSeaGreen DarkSeaGreen1
syn keyword fvwmColors		DarkSeaGreen2 DarkSeaGreen3 DarkSeaGreen4
syn keyword fvwmColors		DarkSlateBlue DarkSlateGray DarkSlateGray1
syn keyword fvwmColors		DarkSlateGray2 DarkSlateGray3
syn keyword fvwmColors		DarkSlateGray4 DarkSlateGrey
syn keyword fvwmColors		DarkTurquoise DarkViolet deep DeepPink
syn keyword fvwmColors		DeepPink1 DeepPink2 DeepPink3 DeepPink4
syn keyword fvwmColors		DeepSkyBlue DeepSkyBlue1 DeepSkyBlue2
syn keyword fvwmColors		DeepSkyBlue3 DeepSkyBlue4 dim DimGray
syn keyword fvwmColors		DimGrey dodger DodgerBlue DodgerBlue1
syn keyword fvwmColors		DodgerBlue2 DodgerBlue3 DodgerBlue4
syn keyword fvwmColors		drab firebrick firebrick1 firebrick2
syn keyword fvwmColors		firebrick3 firebrick4 floral FloralWhite
syn keyword fvwmColors		forest ForestGreen gainsboro ghost
syn keyword fvwmColors		GhostWhite gold gold1 gold2 gold3 gold4
syn keyword fvwmColors		goldenrod goldenrod1 goldenrod2 goldenrod3
syn keyword fvwmColors		goldenrod4 gray gray0 gray1 gray10 gray100
syn keyword fvwmColors		gray11 gray12 gray13 gray14 gray15 gray16
syn keyword fvwmColors		gray17 gray18 gray19 gray2 gray20 gray21
syn keyword fvwmColors		gray22 gray23 gray24 gray25 gray26 gray27
syn keyword fvwmColors		gray28 gray29 gray3 gray30 gray31 gray32
syn keyword fvwmColors		gray33 gray34 gray35 gray36 gray37 gray38
syn keyword fvwmColors		gray39 gray4 gray40 gray41 gray42 gray43
syn keyword fvwmColors		gray44 gray45 gray46 gray47 gray48 gray49
syn keyword fvwmColors		gray5 gray50 gray51 gray52 gray53 gray54
syn keyword fvwmColors		gray55 gray56 gray57 gray58 gray59 gray6
syn keyword fvwmColors		gray60 gray61 gray62 gray63 gray64 gray65
syn keyword fvwmColors		gray66 gray67 gray68 gray69 gray7 gray70
syn keyword fvwmColors		gray71 gray72 gray73 gray74 gray75 gray76
syn keyword fvwmColors		gray77 gray78 gray79 gray8 gray80 gray81
syn keyword fvwmColors		gray82 gray83 gray84 gray85 gray86 gray87
syn keyword fvwmColors		gray88 gray89 gray9 gray90 gray91 gray92
syn keyword fvwmColors		gray93 gray94 gray95 gray96 gray97 gray98
syn keyword fvwmColors		gray99 green green1 green2 green3 green4
syn keyword fvwmColors		GreenYellow grey grey0 grey1 grey10
syn keyword fvwmColors		grey100 grey11 grey12 grey13 grey14
syn keyword fvwmColors		grey15 grey16 grey17 grey18 grey19 grey2
syn keyword fvwmColors		grey20 grey21 grey22 grey23 grey24 grey25
syn keyword fvwmColors		grey26 grey27 grey28 grey29 grey3 grey30
syn keyword fvwmColors		grey31 grey32 grey33 grey34 grey35 grey36
syn keyword fvwmColors		grey37 grey38 grey39 grey4 grey40 grey41
syn keyword fvwmColors		grey42 grey43 grey44 grey45 grey46 grey47
syn keyword fvwmColors		grey48 grey49 grey5 grey50 grey51 grey52
syn keyword fvwmColors		grey53 grey54 grey55 grey56 grey57 grey58
syn keyword fvwmColors		grey59 grey6 grey60 grey61 grey62 grey63
syn keyword fvwmColors		grey64 grey65 grey66 grey67 grey68 grey69
syn keyword fvwmColors		grey7 grey70 grey71 grey72 grey73 grey74
syn keyword fvwmColors		grey75 grey76 grey77 grey78 grey79 grey8
syn keyword fvwmColors		grey80 grey81 grey82 grey83 grey84 grey85
syn keyword fvwmColors		grey86 grey87 grey88 grey89 grey9 grey90
syn keyword fvwmColors		grey91 grey92 grey93 grey94 grey95 grey96
syn keyword fvwmColors		grey97 grey98 grey99 honeydew honeydew1
syn keyword fvwmColors		honeydew2 honeydew3 honeydew4 hot HotPink
syn keyword fvwmColors		HotPink1 HotPink2 HotPink3 HotPink4
syn keyword fvwmColors		indian IndianRed IndianRed1 IndianRed2
syn keyword fvwmColors		IndianRed3 IndianRed4 ivory ivory1 ivory2
syn keyword fvwmColors		ivory3 ivory4 khaki khaki1 khaki2 khaki3
syn keyword fvwmColors		khaki4 lace lavender LavenderBlush
syn keyword fvwmColors		LavenderBlush1 LavenderBlush2
syn keyword fvwmColors		LavenderBlush3 LavenderBlush4 lawn
syn keyword fvwmColors		LawnGreen lemon LemonChiffon LemonChiffon1
syn keyword fvwmColors		LemonChiffon2 LemonChiffon3 LemonChiffon4
syn keyword fvwmColors		light LightBlue LightBlue1 LightBlue2
syn keyword fvwmColors		LightBlue3 LightBlue4 LightCoral
syn keyword fvwmColors		LightCyan LightCyan1 LightCyan2 LightCyan3
syn keyword fvwmColors		LightCyan4 LightGoldenrod LightGoldenrod1
syn keyword fvwmColors		LightGoldenrod2 LightGoldenrod3
syn keyword fvwmColors		LightGoldenrod4 LightGoldenrodYellow
syn keyword fvwmColors		LightGray LightGreen LightGrey LightPink
syn keyword fvwmColors		LightPink1 LightPink2 LightPink3
syn keyword fvwmColors		LightPink4 LightSalmon LightSalmon1
syn keyword fvwmColors		LightSalmon2 LightSalmon3 LightSalmon4
syn keyword fvwmColors		LightSeaGreen LightSkyBlue LightSkyBlue1
syn keyword fvwmColors		LightSkyBlue2 LightSkyBlue3 LightSkyBlue4
syn keyword fvwmColors		LightSlateBlue LightSlateGray
syn keyword fvwmColors		LightSlateGrey LightSteelBlue
syn keyword fvwmColors		LightSteelBlue1 LightSteelBlue2
syn keyword fvwmColors		LightSteelBlue3 LightSteelBlue4
syn keyword fvwmColors		LightYellow LightYellow1 LightYellow2
syn keyword fvwmColors		LightYellow3 LightYellow4 lime
syn keyword fvwmColors		LimeGreen linen magenta magenta1 magenta2
syn keyword fvwmColors		magenta3 magenta4 maroon maroon1 maroon2
syn keyword fvwmColors		maroon3 maroon4 medium MediumAquamarine
syn keyword fvwmColors		MediumBlue MediumOrchid MediumOrchid1
syn keyword fvwmColors		MediumOrchid2 MediumOrchid3 MediumOrchid4
syn keyword fvwmColors		MediumPurple MediumPurple1 MediumPurple2
syn keyword fvwmColors		MediumPurple3 MediumPurple4 MediumSeaGreen
syn keyword fvwmColors		MediumSlateBlue MediumSpringGreen
syn keyword fvwmColors		MediumTurquoise MediumVioletRed midnight
syn keyword fvwmColors		MidnightBlue mint MintCream misty
syn keyword fvwmColors		MistyRose MistyRose1 MistyRose2 MistyRose3
syn keyword fvwmColors		MistyRose4 moccasin navajo NavajoWhite
syn keyword fvwmColors		NavajoWhite1 NavajoWhite2 NavajoWhite3
syn keyword fvwmColors		NavajoWhite4 navy NavyBlue old OldLace
syn keyword fvwmColors		olive OliveDrab OliveDrab1 OliveDrab2
syn keyword fvwmColors		OliveDrab3 OliveDrab4 orange orange1
syn keyword fvwmColors		orange2 orange3 orange4 OrangeRed
syn keyword fvwmColors		OrangeRed1 OrangeRed2 OrangeRed3
syn keyword fvwmColors		OrangeRed4 orchid orchid1 orchid2
syn keyword fvwmColors		orchid3 orchid4 pale PaleGoldenrod
syn keyword fvwmColors		PaleGreen PaleGreen1 PaleGreen2 PaleGreen3
syn keyword fvwmColors		PaleGreen4 PaleTurquoise PaleTurquoise1
syn keyword fvwmColors		PaleTurquoise2 PaleTurquoise3
syn keyword fvwmColors		PaleTurquoise4 PaleVioletRed
syn keyword fvwmColors		PaleVioletRed1 PaleVioletRed2
syn keyword fvwmColors		PaleVioletRed3 PaleVioletRed4 papaya
syn keyword fvwmColors		PapayaWhip peach PeachPuff PeachPuff1
syn keyword fvwmColors		PeachPuff2 PeachPuff3 PeachPuff4 peru
syn keyword fvwmColors		pink pink1 pink2 pink3 pink4 plum plum1
syn keyword fvwmColors		plum2 plum3 plum4 powder PowderBlue
syn keyword fvwmColors		puff purple purple1 purple2 purple3
syn keyword fvwmColors		purple4 red red1 red2 red3 red4 rose rosy
syn keyword fvwmColors		RosyBrown RosyBrown1 RosyBrown2 RosyBrown3
syn keyword fvwmColors		RosyBrown4 royal RoyalBlue RoyalBlue1
syn keyword fvwmColors		RoyalBlue2 RoyalBlue3 RoyalBlue4 saddle
syn keyword fvwmColors		SaddleBrown salmon salmon1 salmon2 salmon3
syn keyword fvwmColors		salmon4 sandy SandyBrown sea SeaGreen
syn keyword fvwmColors		SeaGreen1 SeaGreen2 SeaGreen3 SeaGreen4
syn keyword fvwmColors		seashell seashell1 seashell2 seashell3
syn keyword fvwmColors		seashell4 sienna sienna1 sienna2 sienna3
syn keyword fvwmColors		sienna4 sky SkyBlue SkyBlue1 SkyBlue2
syn keyword fvwmColors		SkyBlue3 SkyBlue4 slate SlateBlue
syn keyword fvwmColors		SlateBlue1 SlateBlue2 SlateBlue3
syn keyword fvwmColors		SlateBlue4 SlateGray SlateGray1 SlateGray2
syn keyword fvwmColors		SlateGray3 SlateGray4 SlateGrey smoke snow
syn keyword fvwmColors		snow1 snow2 snow3 snow4 spring SpringGreen
syn keyword fvwmColors		SpringGreen1 SpringGreen2 SpringGreen3
syn keyword fvwmColors		SpringGreen4 steel SteelBlue SteelBlue1
syn keyword fvwmColors		SteelBlue2 SteelBlue3 SteelBlue4
syn keyword fvwmColors		tan tan1 tan2 tan3 tan4 thistle
syn keyword fvwmColors		thistle1 thistle2 thistle3 thistle4
syn keyword fvwmColors		tomato tomato1 tomato2 tomato3 tomato4
syn keyword fvwmColors		turquoise turquoise1 turquoise2 turquoise3
syn keyword fvwmColors		turquoise4 violet VioletRed VioletRed1
syn keyword fvwmColors		VioletRed2 VioletRed3 VioletRed4 wheat
syn keyword fvwmColors		wheat1 wheat2 wheat3 wheat4 whip white
syn keyword fvwmColors		WhiteSmoke yellow yellow1 yellow2 yellow3
syn keyword fvwmColors		yellow4 YellowGreen

syn keyword fvwmExec		Exec

if !exists("did_fvwm_syntax_inits")
 let did_fvwm_syntax_inits = 1
 hi link fvwmArguments		Constant
 hi link fvwmColors		Type
 hi link fvwmComment		Comment
 hi link fvwmCommonFuncs	Function
 hi link fvwmCommonKeywords	Statement
 hi link fvwmDimension		Number
 hi link fvwmDirectory		String
 hi link fvwmEnvVar		Macro
 hi link fvwmExec		Function
 hi link fvwmFunctions		Function
 hi link fvwmKeyDef		Statement
 hi link fvwmKeywords		Keyword
 hi link fvwmMenuIcon		Comment
 hi link fvwmModule		Macro
 hi link fvwmMouseDef		Statement
 hi link fvwmNumber		Number
 hi link fvwmRGBValue		Type
 hi link fvwmShortcutKey	Special
 hi link fvwmSpecial		Special
 hi link fvwmString		String
endif

let b:current_syntax = "fvwm"
" vim: ts=8 nowrap
