" Vim support file to detect file types
" Maintainer:	Bram Moolenaar <Bram@vim.org>
" Last change:	1998 Nov 1

if !exists("did_load_filetypes")
let did_load_filetypes = 1

augroup filetype

" Ada (83, 9X, 95)
au BufNewFile,BufRead *.adb,*.ads		set ft=ada

" Assembly (all kinds)
au BufNewFile,BufRead *.asm,*.s,*.i,*.mac	set ft=asmselect

" ASN.1
au BufNewFile,BufRead *.asn,*.asn1		set ft=asn

" Atlas
au BufNewFile,BufRead *.atl,*.as		set ft=atlas

" Avenue
au BufNewFile,BufRead *.ave			set ft=ave

" Awk
au BufNewFile,BufRead *.awk			set ft=awk

" BASIC
au BufNewFile,BufRead *.bas			set ft=basic

" Batch file for MSDOS
au BufNewFile,BufRead *.bat,*.sys		set ft=dosbatch

" Batch file for 4DOS
au BufNewFile,BufRead *.btm			set ft=btm

" BibTeX bibliography database file
au BufNewFile,BufRead *.bib			set ft=bib

" C
au BufNewFile,BufRead *.c			set ft=c

" C++
if has("fname_case")
  au BufNewFile,BufRead *.cpp,*.cc,*.cxx,*.c++,*.C,*.h,*.H,*.hh,*.hxx,*.hpp,*.inl set ft=cpp
else
  au BufNewFile,BufRead *.cpp,*.cc,*.cxx,*.c++,*.h,*.hh,*.hxx,*.hpp,*.inl set
  ft=cpp
endif

" Cascading Style Sheets
au BufNewFile,BufRead *.css			set ft=css

" Century Term Command Scripts
au BufNewFile,BufRead *.cmd,*.con		set ft=cterm

" Clean
au BufNewFile,BufReadPost *.dcl,*.icl		set ft=clean

" Clipper
au BufNewFile,BufRead *.prg			set ft=clipper

" Cobol
au BufNewFile,BufRead *.cbl,*.cob,*.cpy,*.lib	set ft=cobol

" Diff files
au BufNewFile,BufRead *.diff,*.rej		set ft=diff

" DCL (Digital Command Language - vms)
au BufNewFile,BufRead *.com			set ft=dcl

" Dracula
au BufNewFile,BufRead drac.*,*.drac,*.drc,*lvs,*lpe set ft=dracula

" DTD (Document Type Definition for XML)
au BufNewFile,BufRead *.dtd			set ft=dtd

" Eiffel
au BufNewFile,BufRead *.e,*.E			set ft=eiffel

" Elm Filter Rules file
au BufNewFile,BufReadPost filter-rules		set ft=elmfilt

" ESQL-C
au BufNewFile,BufRead *.ec,*.EC			set ft=esqlc

" Exports
au BufNewFile,BufRead exports			set ft=exports

" Fortran
au BufNewFile,BufRead *.f,*.F,*.for,*.fpp	set ft=fortran

" Fvwm
au BufNewFile,BufRead *fvwm*rc*			set ft=fvwm

" GP scripts (2.0 and onward)
au BufNewFile,BufRead *.gp			set ft=gp

" HTML (.shtml for server side)
au BufNewFile,BufRead *.html,*.htm,*.shtml	set ft=html

" IDL (Interface Description Language)
au BufNewFile,BufRead *.idl			set ft=idl

" Inform
au BufNewFile,BufRead *.inf,*.INF		set ft=inform

" .INI file for MSDOS
au BufNewFile,BufRead *.ini			set ft=dosini

" Java
au BufNewFile,BufRead *.java,*.jav		set ft=java

" JavaCC
au BufNewFile,BufRead *.jj,*.jjt		set ft=javacc

" JavaScript
au BufNewFile,BufRead *.js,*.javascript		set ft=javascript

" Jgraph
au BufNewFile,BufRead *.jgr			set ft=jgraph

" Lace (ISE)
au BufNewFile,BufRead *.ace,*.ACE		set ft=lace

" Lex
au BufNewFile,BufRead *.lex,*.l			set ft=lex

" Lisp
if has("fname_case")
  au BufNewFile,BufRead *.lsp,*.L		set ft=lisp
else
  au BufNewFile,BufRead *.lsp			set ft=lisp
endif

" Lite
au BufNewFile,BufRead *.lite,*.lt		set ft=lite

" LOTOS
au BufNewFile,BufRead *.lot,*.lotos		set ft=lotos

" Lua
au BufNewFile,BufRead *.lua			set ft=lua

" Lynx style file
au BufNewFile,BufRead *.lss			set ft=lss

" M4
au BufNewFile,BufRead *.m4			set ft=m4

" Mail (for Elm, trn and rn)
au BufNewFile,BufRead snd.*,.letter,.followup,.article,.article.[0-9]\+,pico.[0-9]\+,mutt*[0-9] set ft=mail

" Makefile
au BufNewFile,BufRead [mM]akefile*,GNUmakefile,*.mk,*.mak set ft=make

" Manpage
au BufNewFile,BufRead *.man			set ft=man

" Maple V
au BufNewFile,BufRead *.mv,*.mpl,*.mws		set ft=maple

" Matlab
au BufNewFile,BufRead *.m			set ft=matlab

" Metafont
au BufNewFile,BufRead *.mf			set ft=mf

" MetaPost
au BufNewFile,BufRead *.mp			set ft=mp

" Modula 2
au BufNewFile,BufRead *.m2			set ft=modula2

" Msql
au BufNewFile,BufRead *.msql			set ft=msql

" M$ Resource files
au BufNewFile,BufRead *.rc			set ft=rc

" Mutt setup file
au BufNewFile,BufRead .muttrc			set ft=muttrc

" Nroff/Troff (*.ms is checked below)
au BufNewFile,BufRead *.me,*.mm,*.tr,*.nr,*.[1-9] set ft=nroff

" OCAML
au BufNewFile,BufRead *.ml			set ft=ocaml

" Pascal
au BufNewFile,BufRead *.p,*.pas			set ft=pascal

" Perl
if has("fname_case")
  au BufNewFile,BufRead *.pl,*.PL		set ft=perl
else
  au BufNewFile,BufRead *.pl			set ft=perl
endif

" Perl or XPM
au BufNewFile,BufRead *.pm			set ft=pmfile

" Perl POD
au BufNewFile,BufRead *.pod			set ft=pod

" Php3
au BufNewFile,BufRead *.php3			set ft=php3

" Phtml
au BufNewFile,BufRead *.phtml			set ft=phtml

" Pike
au BufNewFile,BufRead *.pike,*.lpc,*.ulpc,*.pmod set ft=pike

" PO (GNU gettext)
au BufNewFile,BufRead *.po			set ft=po

" PostScript
au BufNewFile,BufRead *.ps,*.eps		set ft=postscr

" Povray
au BufNewFile,BufRead *.pov,*.inc		set ft=pov

" Printcap and Termcap
au BufNewFile,BufRead *printcap*,*termcap*	set ft=ptcap

" PCCTS
au BufNewFile,BufRead *.g			set ft=pccts

" Procmail
au BufNewFile,BufRead .procmail,.procmailrc	set ft=procmail

" Prolog
au BufNewFile,BufRead *.pdb			set ft=prolog

" Python
au BufNewFile,BufRead *.py			set ft=python

" Rexx
au BufNewFile,BufRead *.rexx,*.rex,*.r		set ft=rexx

" S-lang
au BufNewFile,BufRead *.sl			set ft=slang

" Sather
au BufNewFile,BufRead *.sa			set ft=sather

" SDL
au BufNewFile,BufRead *.sdl,*.pr		set ft=sdl

" sed
au BufNewFile,BufRead *.sed			set ft=sed

" Sendmail
au BufNewFile,BufRead sendmail.cf		set ft=sm

" SGML
au BufNewFile,BufRead *.sgm,*.sgml		set ft=sgml

" Shell scripts (sh, ksh, bash, csh)
au BufNewFile,BufRead .profile,.bashrc,.kshrc,*.sh,*.ksh,*.bash,*.env set ft=sh
au BufNewFile,BufRead .login,.cshrc,.tcshrc,*.csh,*.tcsh set ft=csh

" Z-Shell script
au BufNewFile,BufRead .z*,zsh*,zlog*		set ft=zsh

" Scheme
au BufNewFile,BufRead *.scm			set ft=scheme

" Simula
au BufNewFile,BufRead *.sim			set ft=simula

" SKILL
au BufNewFile,BufRead *.il,*.rul		set ft=skill

" SLRN
au BufNewFile,BufRead .slrnrc			set ft=slrnrc
au BufNewFile,BufRead *.score			set ft=slrnsc

" Smalltalk
au BufNewFile,BufRead *.st,*.cls		set ft=st

" SNMP MIB files
au BufNewFile,BufReadPost *.mib,*.smi		set ft=mib

" Spec (Linux RPM)
au BufNewFile,BufRead *.spec			set ft=spec

" SQL
au BufNewFile,BufRead *.sql			set ft=sql

" Tags
au BufNewFile,BufRead tags			set ft=tags

" Tcl
au BufNewFile,BufRead *.tcl,*.tk		set ft=tcl

" Telix Salt
au BufNewFile,BufRead *.slt			set ft=tsalt

" TeX
au BufNewFile,BufRead *.tex,*.sty		set ft=tex

" TF mud client
au BufNewFile,BufRead *.tf			set ft=tf

" Motif UIT/UIL files
au BufNewFile,BufRead *.uit,*.uil		set ft=uil

" Verilog HDL
au BufNewFile,BufRead *.v			set ft=verilog

" VHDL
au BufNewFile,BufRead *.hdl,*.vhd,*.vhdl,*.vhdl_[0-9]*,*.vbe,*.vst  set ft=vhdl

" Vim Help file
if has("mac")
  au BufNewFile,BufRead *[/:]vim*[/:]doc[/:]*.txt set ft=help
else
  au BufNewFile,BufRead */vim*/doc/*.txt	set ft=help
endif

" Vim script
au BufNewFile,BufRead *vimrc*,*.vim,.exrc,_exrc set ft=vim

" Viminfo file
au BufNewFile,BufRead .viminfo,_viminfo		set ft=viminfo

" Vgrindefs file
au BufNewFile,BufRead vgrindefs			set ft=vgrindefs

" VRML V1.0c
au BufNewFile,BufRead *.wrl			set ft=vrml

" X Pixmap (dynamically sets colors, use BufEnter to make it work better)
au BufEnter *.xpm				set ft=xpm

" X resources file
au BufNewFile,BufRead *.Xdefaults,*/app-defaults/* set ft=xdefaults

" Xmath
au BufNewFile,BufRead *.msc,*.msf		set ft=xmath
au BufNewFile,BufRead *.ms			set ft=mstype

" XML
au BufNewFile,BufRead *.xml			set ft=xml

" Yacc
au BufNewFile,BufRead *.y			set ft=yacc

" Various scripts, without a specific extension
au BufNewFile,BufRead,StdinReadPost *		so <sfile>:p:h/scripts.vim

augroup END

endif " !exists("did_load_filetypes")

" vim: ts=8
