/*****************************************************************************
*   $Id: debug.c,v 6.3 1998/07/06 06:23:44 darren Exp $
*
*   Copyright (c) 1996-1998, Darren Hiebert
*
*   This source code is released for free distribution under the terms of the
*   GNU General Public License.
*
*   This module contains debugging functions.
*****************************************************************************/

/*============================================================================
=   Include files
============================================================================*/
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "ctags.h"

/*============================================================================
=   Function definitions
============================================================================*/

#ifdef DEBUG

extern void lineBreak() {}	/* provides a line-specified break point */

extern void debugOpen( fileName, isHeader, language )
    const char *const fileName;
    const boolean isHeader;
    const langType language;
{
    if (debug(DEBUG_STATUS))
    {
	if (language == LANG_IGNORE)
	    printf("  ignoring %s (unknown extension)\n", fileName);
	else
	{
	    const char *name = getLanguageName(language);

	    printf("OPENING %s as a %c%s language %sfile\n",
		fileName, toupper(name[0]), name + 1, isHeader ? "header ":"");
	}
	fflush(stdout);
    }
}

extern void debugPutc( c, level )
    const int c;
    const int level;
{
    if (debug(level)  &&  c != EOF)
    {
    	     if (c == STRING_SYMBOL)	printf("\"string\"");
    	else if (c == CHAR_SYMBOL)	printf("'c'");
	else				putchar(c);

	fflush(stdout);
    }
}

extern void debugEntry( scope, type, tagName, pMember )
    const tagScope scope;
    const tagType type;
    const char *const tagName;
    const memberInfo *const pMember;
{
    if (debug(DEBUG_PARSE))
    {
	printf("<#%s%s:%s", (scope == SCOPE_STATIC ? "static:" : ""),
	       tagTypeName(type), tagName);

	if (pMember->type != MEMBER_NONE)
	{
	    printf("[%s:%s]", getTypeString(pMember->type), pMember->parent);

	    if ((File.language == LANG_CPP  ||  File.language == LANG_JAVA) &&
		pMember->visibility != VIS_UNDEFINED)
	    {
		printf("{visibility:%s}",
		       getVisibilityString(pMember->visibility));
	    }
	}
	printf("#>");
	fflush(stdout);
    }
}

extern void debugParseNest( increase, level )
    const boolean increase;
    const unsigned int level;
{
    if (debug(DEBUG_PARSE))
    {
	printf("<*%snesting:%d*>", increase ? "++" : "--", level);
	fflush(stdout);
    }
}

extern void debugCppNest( begin, level )
    const boolean begin;
    const unsigned int level;
{
    if (debug(DEBUG_CPP))
    {
	printf("<*cpp:%s level %d*>", begin ? "begin" : "end", level);
	fflush(stdout);
    }
}

extern void debugCppIgnore( ignore )
    const boolean ignore;
{
    if (debug(DEBUG_CPP))
    {
	printf("<*cpp:%s ignore*>", ignore ? "begin" : "end");
	fflush(stdout);
    }
}

extern void clearString( string, length )
    char *const string;
    const int length;
{
    int i;

    for (i = 0 ; i < length ; ++i)
	string[i] = '\0';
}

#endif

/* vi:set tabstop=8 shiftwidth=4: */
