" Vim syntax file
" Language:	Fvwm{1,2} configuration file
" Maintainer:	Haakon Riiser <hakonrk@fys.uio.no>
" Last change:	1998 Jun 15
"
" Put
"
"	let is_fvwm1 = 1
"
" in your vimrc for more specific Fvwm1 syntax, or
"
"	let is_fvwm2 = 1
"
" if you're using Fvwm2.

set iskeyword=_,-,+,a-z,A-Z,48-57

" Clear old syntax defs
syn clear

" Case sensitive
syn case match

syn match fvwmComment		"^#.*$"
syn match fvwmDimension		"\<\d\+\(x\d\+\)\=\>"
syn match fvwmDirectory		"/[@a-zA-Z0-9/.-_+,$~]*/\=" contains=fvwmEnvVar
syn match fvwmEnvVar		"\${\=[a-zA-Z0-9_]\+}\="
syn match fvwmModule		"^\*[a-zA-Z0-9]\+"
syn match fvwmNumber		"\(+\|-\)\d\+\(+\|-\)\d\+\>"
syn match fvwmNumber		"\<\d\+\>"
syn match fvwmNumber		"\<\(+\|-\)\d\+\>"
syn match fvwmRGBValue		"\s#[a-f0-9]\+"
syn match fvwmRGBValue		"rgb:[0-9a-fA-F]\+/[0-9a-fA-F]\+/[0-9a-fA-F]\+"
syn match fvwmSpecial		"[,()!@]"
syn match fvwmString		"'.\{-}'" contains=fvwmExec
syn match fvwmString		"`.\{-}`" contains=fvwmExec
syn match fvwmString		'".\{-}"' contains=fvwmExec

if exists("is_fvwm1")
 " Fvwm1 commands
 syn keyword fvwmCommands	AppsBackingStore AutoRaise BackingStore
 syn keyword fvwmCommands	BoundaryWidth CenterOnCirculate
 syn keyword fvwmCommands	CirculateSkipIcons Cursor DecorateTransients
 syn keyword fvwmCommands	DeskTopScale DontMoveOff Font HiBackColor
 syn keyword fvwmCommands	HiForeColor MWMBorders MWMDecorHints
 syn keyword fvwmCommands	MWMFunctionHints MWMHintOverride MWMMenus
 syn keyword fvwmCommands	MenuBackColor MenuForeColor MenuStippleColor
 syn keyword fvwmCommands	NoBoundaryWidth OpaqueMove OpaqueResize Pager
 syn keyword fvwmCommands	PagerBackColor PagerFont PagerForeColor
 syn keyword fvwmCommands	PagingDefault SaveUnders StdBackColor
 syn keyword fvwmCommands	StdForeColor StickyBackColor StickyForeColor
 syn keyword fvwmCommands	StickyIcons StubbornIconPlacement StubbornIcons
 syn keyword fvwmCommands	StubbornPlacement SuppressIcons

 " Fvwm1 functions
 syn keyword fvwmFunctions	CirculateDown CirculateUp TogglePage Warp
 syn keyword fvwmFunctions	EndFunction EndPopup
elseif exists("is_fvwm2")
 " Fvwm2 commands
 syn keyword fvwmCommands	Active ActiveDown ActiveUp AddButtonStyle
 syn keyword fvwmCommands	AddTitleStyle AddToDecor AddToFunc
 syn keyword fvwmCommands	AddToMenu BackColor BorderStyle
 syn keyword fvwmCommands	ChangeDecor CirculateSkipIcon
 syn keyword fvwmCommands	ColormapFocus CursorStyle
 syn keyword fvwmCommands	DecorateTransient Default ExecUseShell
 syn keyword fvwmCommands	Flat FollowsFocus ForeColor GlobalOpts
 syn keyword fvwmCommands	HGradient HilightColor
 syn keyword fvwmCommands	HintOverride Inactive MWMBorder MWMButtons
 syn keyword fvwmCommands	MWMDecor MWMDecorMax MWMDecorMenu
 syn keyword fvwmCommands	MWMDecorMin MWMFunctions MenuStyle
 syn keyword fvwmCommands	MiniIcon NoIcon OLDecor OpaqueMoveSize
 syn keyword fvwmCommands	Raised Simple SkipMapping Solid StickyIcon
 syn keyword fvwmCommands	Sunk TiledPixmap TitleStyle
 syn keyword fvwmCommands	UpdateDecor UseBorderStyle UseDecor
 syn keyword fvwmCommands	UseTitleStyle VGradient Vector WindowId
 syn keyword fvwmCommands	ActivePlacement DumbPlacement
 syn keyword fvwmCommands	FocusFollowsMouse FvwmBorder
 syn keyword fvwmCommands	MouseFocus NakedTransient NoDecorHint
 syn keyword fvwmCommands	NoFuncHint NoLenience NoOLDecor NoOverride
 syn keyword fvwmCommands	ShowMapping Slippery SlipperyIcon
 syn keyword fvwmCommands	UsePPosition UseStyle WindowListHit

 " Fvwm2 functions
 syn keyword fvwmFunctions	Current Destroy DestroyDecor DestroyFunc
 syn keyword fvwmFunctions	DestroyMenu DestroyModuleConfig Echo
 syn keyword fvwmFunctions	FlipFocus KillModule Menu Next
 syn keyword fvwmFunctions	None PipeRead Prev Read Recapture
 syn keyword fvwmFunctions	RefreshWindow SendToModule Right Left Up Down
 syn keyword fvwmFunctions	Top Bottom
endif

" Commands common in Fvwm{1,2}
syn keyword fvwmCommonCmds	ButtonStyle CirculateSkip ClickTime
syn keyword fvwmCommonCmds	ClickToFocus DeskTopSize EdgeResistance
syn keyword fvwmCommonCmds	EdgeScroll Icon IconBox IconFont IconPath
syn keyword fvwmCommonCmds	Key Lenience MWMButtons ModulePath Mouse
syn keyword fvwmCommonCmds	NoBorder NoPPosition NoTitle PixmapPath
syn keyword fvwmCommonCmds	RandomPlacement SloppyFocus SmartPlacement
syn keyword fvwmCommonCmds	StartsOnDesk StaysOnTop Sticky WindowFont
syn keyword fvwmCommonCmds	WindowListSkip XORvalue Style HandleWidth 
syn keyword fvwmCommonCmds	Button CirculateHit Handles IconTitle
syn keyword fvwmCommonCmds	NoButton NoHandles NoIconTitle StartIconic
syn keyword fvwmCommonCmds	StartNormal StartsAnyWhere StaysPut
syn keyword fvwmCommonCmds	BorderWidth Color 

" Functions common in Fvwm{1,2}
syn keyword fvwmCommonFuncs	Beep Close CursorMove Delete Desk Destroy
syn keyword fvwmCommonFuncs	Focus Function GotoPage Iconify
syn keyword fvwmCommonFuncs	Lower Maximize Move Nop Popup Quit Raise
syn keyword fvwmCommonFuncs	RaiseLower Refresh Resize Restart Scroll
syn keyword fvwmCommonFuncs	Stick Title Wait WindowList WindowsDesk
syn keyword fvwmCommonFuncs	WindowShade Module

syn keyword fvwmExec		Exec

if !exists("did_fvwm_syntax_inits")
	let did_fvwm_syntax_inits = 1
	hi link fvwmComment	Comment
	hi link fvwmDimension	Number
	hi link fvwmDirectory	String
	hi link fvwmEnvVar	Macro
	hi link fvwmExec	Function
	hi link fvwmModule	Statement
	hi link fvwmNumber	Number
	hi link fvwmRGBValue	Number
	hi link fvwmSpecial	Special
	hi link fvwmString	String
	hi link fvwmFunctions	Function
	hi link fvwmCommands	Macro
	hi link fvwmCommonFuncs Function
	hi link fvwmCommonCmds	Macro
endif

let b:current_syntax = "fvwm"
" vim: ts=8 nowrap
