" Vim syntax file
" Language:	Mutt setup files
" Maintainer:	Preben "Peppe" Guldberg (c928400@student.dtu.dk)
" Last change:	Sat Apr 11 21:44:11 1998

" This file covers mutt version 0.74 and up (non developer)
" It has been updated for version 0.91i
" Over the time some features have vanished but are still included
" To get a syntax file for your specific version, see
"	http://www.student.dtu.dk/~c928400/vim

" Remove any old syntax stuff hanging around
syn clear

" Set the keyword characters
set isk=@,48-57,_,-

syn match muttrcComment		"^#.*$"
syn match muttrcComment		"[^\\]#.*$"lc=1

" Escape sequences (back-tick and pipe goes here too)
syn match muttrcEscape		+\\[#tnr"'Cc]+
syn match muttrcEscape		+[`|]+

" The variables takes the following arguments
syn match  muttrcString		"=\s*[^ #"']\+"lc=1 contains=muttrcEscape
syn region muttrcString		start=+"+ms=e skip=+\\"+ end=+"+ contains=muttrcEscape,muttrcSet,muttrcCommand
syn region muttrcString		start=+'+ms=e skip=+\\'+ end=+'+ contains=muttrcEscape,muttrcSet,muttrcCommand

syn match muttrcSpecial		+\(['"]\)!\1+

" Numbers and Quadoptions may be surrounded by " or '
syn match muttrcNumber		/=\s*[0-9]\+/lc=1
syn match muttrcNumber		/"=\s*[0-9]\+"/lc=2
syn match muttrcNumber		/'=\s*[0-9]\+'/lc=2
syn match muttrcQuadopt		+=\s*\(ask-\)\=\(yes\|no\)+lc=1
syn match muttrcQuadopt		+"=\s*\(ask-\)\=\(yes\|no\)"+lc=2
syn match muttrcQuadopt		+'=\s*\(ask-\)\=\(yes\|no\)'+lc=2

" Now catch some email addresses and headers (purified version from mail.vim)
syn match muttrcEmail		"[a-zA-Z0-9._-]\+@[a-zA-Z0-9./-]\+"
syn match muttrcHeader		"\<\(From\|To\|Cc\|Bcc\|Reply-To\|Subject\)\>:\="
syn match muttrcHeader		"\<\(Return-Path\|Received\|Date\|Replied\|Attach\)\>:\="

syn match   muttrcKeySpecial	contained +\(\\[Cc'"]\|\^\|\\[01][0-9]\{2}\)+
syn match   muttrcKey		contained "\S\+"			contains=muttrcKeySpecial
syn region  muttrcKey		contained start=+"+ skip=+\\"+ end=+"+	contains=muttrcKeySpecial
syn region  muttrcKey		contained start=+'+ skip=+\\'+ end=+'+	contains=muttrcKeySpecial
syn match   muttrcKeyName	contained "\<f\([1-9]\|10\)\>"
syn match   muttrcKeyName	contained "\\[trne]"
syn keyword muttrcKeyName	contained backspace delete down end enter home insert left pagedown
syn keyword muttrcKeyName	contained pageup return right up

syn keyword muttrcVarBool	contained allow_8bit arrow_cursor ascii_chars askbcc askcc
syn keyword muttrcVarBool	contained attach_split auto_tag autoedit beep beep_new check_new
syn keyword muttrcVarBool	contained confirmappend confirmcreate edit_hdrs fast_reply
syn keyword muttrcVarBool	contained fcc_attach force_name forw_decode forw_quote hdrs header
syn keyword muttrcVarBool	contained help ignore_list_reply_to mark_old markers menu_scroll
syn keyword muttrcVarBool	contained meta_key metoo mime_fwd pager_stop pgp_autoencrypt
syn keyword muttrcVarBool	contained pgp_autosign pgp_encryptself pgp_long_ids pgp_replyencrypt
syn keyword muttrcVarBool	contained pgp_replysign pgp_strict_enc pipe_decode pipe_split
syn keyword muttrcVarBool	contained pop_delete prompt_after read_only resolve reverse_alias
syn keyword muttrcVarBool	contained reverse_name save_address save_empty save_name sig_dashes
syn keyword muttrcVarBool	contained smart_wrap sort_re status_on_top strict_threads suspend
syn keyword muttrcVarBool	contained thorough_search tilde use_8bitmime use_domain use_from
syn keyword muttrcVarBool	contained wait_key

syn keyword muttrcVarBool	contained noallow_8bit noarrow_cursor noascii_chars noaskbcc noaskcc
syn keyword muttrcVarBool	contained noattach_split noauto_tag noautoedit nobeep nobeep_new
syn keyword muttrcVarBool	contained nocheck_new noconfirmappend noconfirmcreate noedit_hdrs
syn keyword muttrcVarBool	contained nofast_reply nofcc_attach noforce_name noforw_decode
syn keyword muttrcVarBool	contained noforw_quote nohdrs noheader nohelp noignore_list_reply_to
syn keyword muttrcVarBool	contained nomark_old nomarkers nomenu_scroll nometa_key nometoo
syn keyword muttrcVarBool	contained nomime_fwd nopager_stop nopgp_autoencrypt nopgp_autosign
syn keyword muttrcVarBool	contained nopgp_encryptself nopgp_long_ids nopgp_replyencrypt
syn keyword muttrcVarBool	contained nopgp_replysign nopgp_strict_enc nopipe_decode
syn keyword muttrcVarBool	contained nopipe_split nopop_delete noprompt_after noread_only
syn keyword muttrcVarBool	contained noresolve noreverse_alias noreverse_name nosave_address
syn keyword muttrcVarBool	contained nosave_empty nosave_name nosig_dashes nosmart_wrap
syn keyword muttrcVarBool	contained nosort_re nostatus_on_top nostrict_threads nosuspend
syn keyword muttrcVarBool	contained nothorough_search notilde nouse_8bitmime nouse_domain
syn keyword muttrcVarBool	contained nouse_from nowait_key

syn keyword muttrcVarBool	contained invallow_8bit invarrow_cursor invascii_chars invaskbcc
syn keyword muttrcVarBool	contained invaskcc invattach_split invauto_tag invautoedit invbeep
syn keyword muttrcVarBool	contained invbeep_new invcheck_new invconfirmappend invconfirmcreate
syn keyword muttrcVarBool	contained invedit_hdrs invfast_reply invfcc_attach invforce_name
syn keyword muttrcVarBool	contained invforw_decode invforw_quote invhdrs invheader invhelp
syn keyword muttrcVarBool	contained invignore_list_reply_to invmark_old invmarkers
syn keyword muttrcVarBool	contained invmenu_scroll invmeta_key invmetoo invmime_fwd
syn keyword muttrcVarBool	contained invpager_stop invpgp_autoencrypt invpgp_autosign
syn keyword muttrcVarBool	contained invpgp_encryptself invpgp_long_ids invpgp_replyencrypt
syn keyword muttrcVarBool	contained invpgp_replysign invpgp_strict_enc invpipe_decode
syn keyword muttrcVarBool	contained invpipe_split invpop_delete invprompt_after invread_only
syn keyword muttrcVarBool	contained invresolve invreverse_alias invreverse_name
syn keyword muttrcVarBool	contained invsave_address invsave_empty invsave_name invsig_dashes
syn keyword muttrcVarBool	contained invsmart_wrap invsort_re invstatus_on_top
syn keyword muttrcVarBool	contained invstrict_threads invsuspend invthorough_search invtilde
syn keyword muttrcVarBool	contained invuse_8bitmime invuse_domain invuse_from invwait_key

syn keyword muttrcVarQuad	contained abort_nosubject abort_unmodified copy delete include move
syn keyword muttrcVarQuad	contained postpone print recall reply_to use_mailcap verify_sig

syn keyword muttrcVarQuad	contained noabort_nosubject noabort_unmodified nocopy nodelete
syn keyword muttrcVarQuad	contained noinclude nomove nopostpone noprint norecall noreply_to
syn keyword muttrcVarQuad	contained nouse_mailcap noverify_sig

syn keyword muttrcVarQuad	contained invabort_nosubject invabort_unmodified invcopy invdelete
syn keyword muttrcVarQuad	contained invinclude invmove invpostpone invprint invrecall
syn keyword muttrcVarQuad	contained invreply_to invuse_mailcap invverify_sig

syn keyword muttrcVarNum	contained history mail_check pager_context pager_index_lines
syn keyword muttrcVarNum	contained pgp_timeout pop_port read_inc references timeout write_inc

syn keyword muttrcVarStr	contained alias_file alias_format alternates attach_sep attribution
syn keyword muttrcVarStr	contained charset date_format decode_format default_hook dsn_notify
syn keyword muttrcVarStr	contained dsn_return editor escape folder forw_format hdr_format
syn keyword muttrcVarStr	contained hostname in_reply_to indent_str ispell locale mailcap_path
syn keyword muttrcVarStr	contained mask mbox mbox_type msg_format pager pager_format
syn keyword muttrcVarStr	contained pgp_default_version pgp_key_version pgp_receive_version
syn keyword muttrcVarStr	contained pgp_send_version pgp_sign_as pgp_sign_micalg pgp_v2
syn keyword muttrcVarStr	contained pgp_v2_language pgp_v2_pubring pgp_v2_secring pgp_v3
syn keyword muttrcVarStr	contained pgp_v3_language pgp_v3_pubring pgp_v3_secring pgp_v5
syn keyword muttrcVarStr	contained pgp_v5_language pgp_v5_pubring pgp_v5_secring pipe_sep
syn keyword muttrcVarStr	contained pop_host pop_pass pop_user post_indent_str postponed
syn keyword muttrcVarStr	contained print_cmd quote_regexp realname record reply_regexp
syn keyword muttrcVarStr	contained sendmail sendmail_bounce shell signature simple_search
syn keyword muttrcVarStr	contained sort sort_alias sort_aux sort_browser spoolfile
syn keyword muttrcVarStr	contained status_chars status_format tmpdir to_chars visual

syn keyword muttrcMenu		contained alias attach browser compose editor generic index pager
syn keyword muttrcMenu		contained pgp

syn keyword muttrcCommand	auto_view fcc-hook fcc-save-hook folder-hook hdr_order ignore lists
syn keyword muttrcCommand	mailboxes mbox-hook my_hdr push save-hook score send-hook source
syn keyword muttrcCommand	toggle unalias unignore unlists unmy_hdr unscore unset

syn keyword muttrcSet		set     skipwhite nextgroup=muttrcVar.*
syn keyword muttrcUnset		unset   skipwhite nextgroup=muttrcVar.*

syn keyword muttrcBind		contained bind		skipwhite nextgroup=muttrcMenu
syn match   muttrcBindLine	"^\s*bind\s\+\S\+"	skipwhite nextgroup=muttrcKey\(Name\)\= contains=muttrcBind

syn keyword muttrcMacro		contained macro		skipwhite nextgroup=muttrcMenu
syn match   muttrcMacroLine	"^\s*macro\s\+\S\+"	skipwhite nextgroup=muttrcKey\(Name\)\= contains=muttrcMacro

syn keyword muttrcAlias		contained alias
syn match   muttrcAliasLine	"^\s*alias\s\+\S\+" contains=muttrcAlias

" Colour definitions takes object, foreground and background arguments (regexps excluded).
syn keyword muttrcColorField	contained attachment body bold error hdrdefault header indicator
syn keyword muttrcColorField	contained markers message normal quoted search signature status
syn keyword muttrcColorField	contained tilde tree underline
syn match   muttrcColorField	contained "\<quoted[1-9]\=\>"
syn keyword muttrcColorFG	contained black blue cyan default green magenta red white yellow
syn keyword muttrcColorFG	contained brightblue brightcyan brightdefault brightgreen
syn keyword muttrcColorFG	contained brightmagenta brightred brightwhite brightyellow
syn match   muttrcColorFG	contained "\<\(bright\)\=color[0-9]\{1,2}\>"
syn keyword muttrcColorBG	contained black blue cyan default green magenta red white yellow
syn match   muttrcColorBG	contained "\<color[0-9]\{1,2}\>"
" Now for the match
syn keyword muttrcColor		contained color			skipwhite nextgroup=muttrcColorField
syn match   muttrcColorInit	contained "^\s*color\s\+\S\+"	skipwhite nextgroup=muttrcColorFG contains=muttrcColor
syn match   muttrcColorLine	"^\s*color\s\+\S\+\s\+\S"	skipwhite nextgroup=muttrcColorBG contains=muttrcColorInit

" Mono are almost like color (ojects inherited from color)
syn keyword muttrcMonoAttrib	contained bold none normal reverse standout underline
syn keyword muttrcMono		contained mono		skipwhite nextgroup=muttrcColorField
syn match   muttrcMonoLine	"^\s*mono\s\+\S\+"	skipwhite nextgroup=muttrcMonoAttrib contains=muttrcMono

" obsolete
syn keyword muttrcVarBool 	contained confirmfiles confirmfolders hold no_hdrs pgp_replypgp point_new
syn keyword muttrcVarBool 	contained noconfirmfiles noconfirmfolders nohold nono_hdrs nopgp_replypgp nopoint_new
syn keyword muttrcVarBool 	contained invconfirmfiles invconfirmfolders invhold invno_hdrs invpgp_replypgp invpoint_new
syn keyword muttrcVarStr	contained local_sig local_site pgp pgp_pubring pgp_secring
syn keyword muttrcVarStr	contained pgp_version remote_sig thread_chars url_regexp web_browser
syn keyword muttrcMenu		contained url
syn keyword muttrcCommand 	alternates localsite unlocalsite

if !exists("did_muttrc_syntax_inits")
  let did_muttrc_syntax_inits = 1
  " The default methods for highlighting.  Can be overridden later
  hi link muttrcComment		Comment
  hi link muttrcEscape		SpecialChar
  hi link muttrcString		String
  hi link muttrcSpecial		Special
  hi link muttrcNumber		Number
  hi link muttrcQuadopt		Boolean
  hi link muttrcEmail		Special
  hi link muttrcHeader		Type
  hi link muttrcKeySpecial	SpecialChar
  hi link muttrcKey		Type
  hi link muttrcKeyName		Macro
  hi link muttrcVarBool		Identifier
  hi link muttrcVarQuad		Identifier
  hi link muttrcVarNum		Identifier
  hi link muttrcVarStr		Identifier
  hi link muttrcMenu		Identifier
  hi link muttrcCommand		Keyword
  hi link muttrcSet		muttrcCommand
  hi link muttrcUnset		muttrcCommand
  hi link muttrcBind		muttrcCommand
  hi link muttrcMacro		muttrcCommand
  hi link muttrcAlias		muttrcCommand
  hi link muttrcAliasLine	Identifier
  hi link muttrcColorField	Identifier
  hi link muttrcColorFG		String
  hi link muttrcColorBG		muttrcColorFG
  hi link muttrcColor		muttrcCommand
  hi link muttrcMonoAttrib	muttrcColorFG
  hi link muttrcMono		muttrcCommand
endif

let b:current_syntax = "muttrc"

"EOF	vim: ts=8 noet tw=100 sw=8 sts=0
