" These menu commands create the default Vim menus.

" You can use this as a start for your own set of menus.

" Make sure the '<' flag is not included in 'cpoptions', otherwise <CR> would
" not be recognized.  See ":help 'cpoptions'".
let cpo_save = &cpo
let &cpo = ""

" Help menu
" Note that "amenu" is used to make it work in all modes
9999amenu &Help.&Overview\ \ <F1>	:help<CR>
9999amenu &Help.&How\ to\.\.\.		:help how-to<CR>
9999amenu &Help.&GUI			:help gui<CR>
9999amenu &Help.&Version		:version<CR>
9999amenu &Help.&Credits		:help credits<CR>
9999amenu &Help.Co&pying		:help uganda<CR>
9999amenu &Help.&About			:intro<CR>

" File menu
if has("win32")
  10amenu &File.&Open\	:e		:browse confirm e<CR>
  10amenu &File.Sp&lit-Open\	:sp	:browse sp<CR>
  10amenu &File.&Save\	:w		:confirm w<CR>
  10amenu &File.Save\ &As\	:w		:browse w<CR>
  10amenu &File.&Close\	:q		:confirm q<CR>
  " Use Notepad for printing.
  10amenu &File.&Print :let smod=&mod<Bar>:let ttt=tempname()<Bar>exec ":w! ".ttt<Bar>let &mod=smod<Bar>exec "!notepad /p ".ttt<Bar>exec "!del ".ttt<CR>
  10vmenu &File.&Print <Esc>:let smod=&mod<Bar>:let ttt=tempname()<Bar>exec ":'<,'>w! ".ttt<Bar>let &mod=smod<Bar>exec "!notepad /p ".ttt<Bar>exec "!del ".ttt<CR>
  10amenu &File.Sa&ve-Exit\	:wqa	:confirm wqa<CR>
  10amenu &File.E&xit\	:qa		:confirm qa<CR>
else
  if has("gui_motif")
    10amenu &File.&Open\ \ \ \ \ \ \ \ \ :e	:browse confirm e<CR>
    10amenu &File.Sp&lit-Open\ \ \ :sp	:browse sp<CR>
    10amenu &File.&Save\ \ \ \ \ \ \ \ \ :w	:confirm w<CR>
    10amenu &File.Save\ &As\ \ \ \ \ \ :w	:browse w<CR>
  else
    10amenu &File.&Open\ \ \ \ \ \ \ \ \ :e	:confirm e<Space>
    10amenu &File.Sp&lit-Open\ \ \ :sp	:sp<Space>
    10amenu &File.&Save\ \ \ \ \ \ \ \ \ :w	:confirm w<CR>
    10amenu &File.Save\ &As\ \ \ \ \ \ :w	:w<Space>
  endif
  10amenu &File.&Close\ \ \ \ \ \ \ \ :q	:confirm q<CR>
  if has("unix")
    10amenu &File.&Print			:w !lpr<CR>
    10vmenu &File.&Print			:w !lpr<CR>
  endif
  10amenu &File.Sa&ve-Exit\ \ \ \ :wqa	:confirm wqa<CR>
  10amenu &File.E&xit\ \ \ \ \ \ \ \ \ :qa	:confirm qa<CR>
endif

" Edit menu
20amenu &Edit.&Undo			u
20amenu &Edit.&Redo			<C-R>
20vmenu &Edit.Cu&t			"*x
20vmenu &Edit.&Copy			"*y
20nmenu &Edit.Put\ &Before		[p
20imenu &Edit.Put\ &Before		<C-O>[p
20nmenu &Edit.Put\ &After		]p
20imenu &Edit.Put\ &After		<C-O>]p
20nmenu &Edit.&Paste			i<C-R>*<Esc>
20vmenu &Edit.&Paste			""xi<C-R>*<Esc>
20menu! &Edit.&Paste			<C-R>*
if has("win32")
20vmenu &Edit.&Delete			x
endif
20amenu &Edit.&Find			/
20amenu &Edit.Find\ and\ R&eplace	:%s/
20vmenu &Edit.Find\ and\ R&eplace	:s/

" Window menu
30amenu &Window.&New			<C-W>n
30amenu &Window.S&plit			<C-W>s
30amenu &Window.Sp&lit\ To\ #		<C-W><C-^>
30amenu &Window.&Close			<C-W>c
30amenu &Window.Close\ &Other(s)	<C-W>o
30amenu &Window.Ne&xt			<C-W>w
30amenu &Window.P&revious		<C-W>W
30amenu &Window.&Equal\ Height		<C-W>=
30amenu &Window.Rotate\ &Up		<C-W>R
30amenu &Window.Rotate\ &Down		<C-W>r
if has("gui_win32")
  30amenu &Window.Select\ &Font		:set guifont=*<CR>
endif

" Programming menu
40amenu &IDE.&Make			:make<CR>
40amenu &IDE.&List\ Errors		:cl<CR>
40amenu &IDE.L&ist\ Messages		:cl!<CR>
40amenu &IDE.&Next\ Error		:cn<CR>
40amenu &IDE.&Previous\ Error		:cp<CR>

" The Win32 GUI toolbar
if has("win32")
  amenu ToolBar.Open		:browse e<CR>
  tmenu ToolBar.Open		Open file
  amenu ToolBar.Save		:w<CR>
  tmenu ToolBar.Save		Save current file
  amenu ToolBar.SaveAll		:wa<CR>
  tmenu ToolBar.SaveAll		Save all files

  amenu ToolBar.Print		:let ttt=tempname()<Bar>exec ":w! ".ttt<Bar>exec "!start notepad /p ".ttt<Bar>exec "!del ".ttt<CR>
  vmenu ToolBar.Print		<Esc>:let ttt=tempname()<Bar>exec ":'<,'>w! ".ttt<Bar>exec "!start notepad /p ".ttt<Bar>exec "!del ".ttt<CR>
  tmenu ToolBar.Print		Print

  amenu ToolBar.Undo		u
  tmenu ToolBar.Undo 		Undo
  amenu ToolBar.Redo		<C-R>
  tmenu ToolBar.Redo 		Redo
  vmenu ToolBar.Cut		"*x
  tmenu ToolBar.Cut		Cut to clipboard
  vmenu ToolBar.Copy		"*y
  tmenu ToolBar.Copy		Copy to clipboard
  nmenu ToolBar.Paste		i<C-R>*<Esc>
  vmenu ToolBar.Paste		""xi<C-R>*<Esc>
  menu! ToolBar.Paste		<C-R>*
  tmenu ToolBar.Paste		Paste from Clipboard

  amenu ToolBar.Find		/
  tmenu ToolBar.Find		Find
  amenu ToolBar.FindNext	n
  tmenu ToolBar.FindNext	Find Next
  amenu ToolBar.FindPrev	N
  tmenu ToolBar.FindPrev	Find Previous
  amenu ToolBar.Replace		:%s/
  vmenu ToolBar.Replace		:s/
  tmenu ToolBar.Replace		Find && Replace

  amenu ToolBar.New		<C-W>n
  tmenu ToolBar.New		New Window
  amenu ToolBar.WinSplit	<C-W>s
  tmenu ToolBar.WinSplit	Split Window
  amenu ToolBar.WinZoom		:resize 100<CR>
  tmenu ToolBar.WinZoom		Maximise Window
  amenu ToolBar.WinMin		:resize 1<CR>
  tmenu ToolBar.WinMin		Minimise Window
  amenu ToolBar.WinClose	:cl<CR>
  tmenu ToolBar.WinClose	Close Window

  amenu ToolBar.LoadSession	:browse so $vim\\session<CR>
  tmenu ToolBar.LoadSession	Load session
  amenu ToolBar.SaveSession	:execute ("mksession " . this_session)
  tmenu ToolBar.SaveSession	Save current session
  amenu ToolBar.RunMacro	:browse so<CR>
  tmenu ToolBar.RunMacro	Run a Macro

  amenu ToolBar.Make		:make<CR>
  tmenu ToolBar.Make		Make current project
  amenu ToolBar.Shell		:sh<CR>
  tmenu ToolBar.Shell		Open a command shell
  amenu ToolBar.TagsBuild	:!ctags *.c *.h *.i<CR>
  tmenu ToolBar.TagsBuild	Build tags in current directory
  amenu ToolBar.TagsJump	g]
  tmenu ToolBar.TagsJump	Jump to tag under cursor

  amenu ToolBar.Help		:help<CR>
  tmenu ToolBar.Help		Vim Help
  amenu ToolBar.FindHelp	:help
  tmenu ToolBar.FindHelp 	Search Vim Help
endif

" Restore the previous value of 'cpoptions'.
let &cpo = cpo_save
unlet cpo_save
