" Vim syntax file
" Language   : TeX
" Maintainer : Dr. Charles E. Campbell, Jr. <cec@gryphon.gsfc.nasa.gov>
" Last change: April 10, 1998
"
" Notes:
" 1. If you have a \begin{verbatim} that appears to overrun its boundaries,
"    use %stopzone.

" Removes any old syntax stuff hanging around
syn clear

" Try to flag {}, [], and () mismatches
syn region texMatcher matchgroup=Delimiter start="{" skip="\(\\\\\)*\\[{}]" end="}"	contains=ALLBUT,texError,texCmdName,texCmdArgs,texCmdBody,texDefName,texMathMatcher,texMathParen,texMathOper,texMathDelimKey,texMathDelimBad,texMathDelimBs,texMathDelimChr
syn region texMatcher matchgroup=Delimiter start="\["	end="]"	              contains=ALLBUT,texError,texCmdName,texCmdArgs,texCmdBody,texDefName,texMathMatcher,texMathParen,texMathOper,texMathDelimKey,texMathDelimBad,texMathDelimBs,texMathDelimChr
syn region texParen	start="("		end=")"	              contains=ALLBUT,texError,texCmdName,texCmdArgs,texCmdBody,texDefName,texMathMatcher,texMathParen,texMathOper,texMathDelimKey,texMathDelimBad,texMathDelimBs,texMathDelimChr
syn match  texError	"[}\])]"

syn region texMathMatcher   matchgroup=Delimiter start="{"  skip="\(\\\\\)*\\}"  end="}"	contained contains=ALLBUT,texError,texCmdName,texCmdArgs,texCmdBody,texDefName,texOnlyMath,texMatcher,texParen,texBadMath,texAccent,texMathDelimKey,texMathDelimBad,texMathDelimBs,texMathDelimChr
syn region texMathMatcher   matchgroup=Delimiter start="\[" skip="\(\\\\\)*\\\]" end="]"	contained contains=ALLBUT,texError,texCmdName,texCmdArgs,texCmdBody,texDefName,texOnlyMath,texMatcher,texParen,texBadMath,texAccent,texMathDelimKey,texMathDelimBad,texMathDelimBs,texMathDelimChr
syn region texMathParen	start="(" end=")"				contained contains=ALLBUT,texError,texCmdName,texCmdArgs,texCmdBody,texDefName,texOnlyMath,texMatcher,texParen,texBadMath,texAccent,texMathDelimKey,texMathDelimBad,texMathDelimBs,texMathDelimChr

" TeX/LaTeX keywords
" Instead of trying to be All Knowing, I just match \..alphameric..
syn match texStatement	"\\[a-zA-Z]\+"
if expand("%:e") == "sty"
  syn match texStatement	"\\[a-zA-Z]*@[a-zA-Z@]*"
else
  syn match texError	"\\[a-zA-Z]*@[a-zA-Z@]*"
endif
syn match texDelimiter	"&"
syn match texDelimiter	"\\\\"

" Some type styles
syn match texTypeStyle	"\\rm\>"
syn match texTypeStyle	"\\em\>"
syn match texTypeStyle	"\\bf\>"
syn match texTypeStyle	"\\it\>"
syn match texTypeStyle	"\\sl\>"
syn match texTypeStyle	"\\sf\>"
syn match texTypeStyle	"\\sc\>"
syn match texTypeStyle	"\\tt\>"

" Some type sizes
syn match texTypeSize	"\\tiny\>"
syn match texTypeSize	"\\scriptsize\>"
syn match texTypeSize	"\\footnotesize\>"
syn match texTypeSize	"\\small\>"
syn match texTypeSize	"\\normalsize\>"
syn match texTypeSize	"\\large\>"
syn match texTypeSize	"\\Large\>"
syn match texTypeSize	"\\LARGE\>"
syn match texTypeSize	"\\huge\>"
syn match texTypeSize	"\\Huge\>"

" Sections, subsections, etc
syn match texSection "\\\(sub\)*section\*\="
syn match texSection "\\\(title\|author\|part\|chapter\|paragraph\|subparagraph\)"
syn match texSection "\\begin{abstract}\|\\end{abstract}"

" Bad Math (mismatched)
syn match texBadMath	"\\end{\(split\|align\|gather\|alignat\|flalign\|multline\)"
syn match texBadMath        "\\end{\(equation\|eqnarray\|displaymath\)\*\=}"
syn match texBadMath	"\\[\])]"

" Math Zones
syn region texMathZone	start="\\begin{align\*}"	end="\\end{align\*}"	keepend contains=texTypeStyle,texTypeSize,texStatement,texDelimiter,texComment,texLength,texMathMatcher,texMathParen,texMathOper,texError,texMathDelim,texComment,texRefZone
syn region texMathZone	start="\\begin{alignat\*}"	end="\\end{alignat\*}"	keepend contains=texTypeStyle,texTypeSize,texStatement,texDelimiter,texComment,texLength,texMathMatcher,texMathParen,texMathOper,texError,texMathDelim,texComment,texRefZone
syn region texMathZone	start="\\begin{alignat}"	end="\\end{alignat}"	keepend contains=texTypeStyle,texTypeSize,texStatement,texDelimiter,texComment,texLength,texMathMatcher,texMathParen,texMathOper,texError,texMathDelim,texComment,texRefZone
syn region texMathZone	start="\\begin{align}"	end="\\end{align}"	keepend contains=texTypeStyle,texTypeSize,texStatement,texDelimiter,texComment,texLength,texMathMatcher,texMathParen,texMathOper,texError,texMathDelim,texComment,texRefZone
syn region texMathZone	start="\\begin{eqnarray\*}"	end="\\end{eqnarray\*}"	keepend contains=texTypeStyle,texTypeSize,texStatement,texDelimiter,texComment,texLength,texMathMatcher,texMathParen,texMathOper,texError,texMathDelim,texComment,texRefZone
syn region texMathZone	start="\\begin{eqnarray}"	end="\\end{eqnarray}"	keepend contains=texTypeStyle,texTypeSize,texStatement,texDelimiter,texComment,texLength,texMathMatcher,texMathParen,texMathOper,texError,texMathDelim,texComment,texRefZone
syn region texMathZone	start="\\begin{equation\*}"	end="\\end{equation\*}"	keepend contains=texTypeStyle,texTypeSize,texStatement,texDelimiter,texComment,texLength,texMathMatcher,texMathParen,texMathOper,texError,texMathDelim,texComment,texRefZone
syn region texMathZone	start="\\begin{equation}"	end="\\end{equation}"	keepend contains=texTypeStyle,texTypeSize,texStatement,texDelimiter,texComment,texLength,texMathMatcher,texMathParen,texMathOper,texError,texMathDelim,texComment,texRefZone
syn region texMathZone	start="\\begin{flalign\*}"	end="\\end{flalign\*}"	keepend contains=texTypeStyle,texTypeSize,texStatement,texDelimiter,texComment,texLength,texMathMatcher,texMathParen,texMathOper,texError,texMathDelim,texComment,texRefZone
syn region texMathZone	start="\\begin{flalign}"	end="\\end{flalign}"	keepend contains=texTypeStyle,texTypeSize,texStatement,texDelimiter,texComment,texLength,texMathMatcher,texMathParen,texMathOper,texError,texMathDelim,texComment,texRefZone
syn region texMathZone	start="\\begin{gather\*}"	end="\\end{gather\*}"	keepend contains=texTypeStyle,texTypeSize,texStatement,texDelimiter,texComment,texLength,texMathMatcher,texMathParen,texMathOper,texError,texMathDelim,texComment,texRefZone
syn region texMathZone	start="\\begin{gather}"	end="\\end{gather}"	keepend contains=texTypeStyle,texTypeSize,texStatement,texDelimiter,texComment,texLength,texMathMatcher,texMathParen,texMathOper,texError,texMathDelim,texComment,texRefZone
syn region texMathZone	start="\\begin{math\*}"	end="\\end{math\*}"	keepend contains=texTypeStyle,texTypeSize,texStatement,texDelimiter,texComment,texLength,texMathMatcher,texMathParen,texMathOper,texError,texMathDelim,texComment,texRefZone
syn region texMathZone	start="\\begin{math}"	end="\\end{math}"	keepend contains=texTypeStyle,texTypeSize,texStatement,texDelimiter,texComment,texLength,texMathMatcher,texMathParen,texMathOper,texError,texMathDelim,texComment,texRefZone
syn region texMathZone	start="\\begin{multline}"	end="\\end{multline}"	keepend contains=texTypeStyle,texTypeSize,texStatement,texDelimiter,texComment,texLength,texMathMatcher,texMathParen,texMathOper,texError,texMathDelim,texComment,texRefZone
syn region texMathZone	start="\\begin{split}"	end="\\end{split}"	keepend contains=texTypeStyle,texTypeSize,texStatement,texDelimiter,texComment,texLength,texMathMatcher,texMathParen,texMathOper,texError,texMathDelim,texComment,texRefZone
syn region texMathZone start="\\begin{displaymath\*}"	end="\\end{displaymath\*}"	keepend contains=texTypeStyle,texTypeSize,texStatement,texDelimiter,texComment,texLength,texMathMatcher,texMathParen,texMathOper,texError,texMathDelim,texComment,texRefZone
syn region texMathZone start="\\begin{displaymath}"	end="\\end{displaymath}"	keepend contains=texTypeStyle,texTypeSize,texStatement,texDelimiter,texComment,texLength,texMathMatcher,texMathParen,texMathOper,texError,texMathDelim,texComment,texRefZone
syn region texMathZone start="\\begin{multline\*}"	end="\\end{multline\*}"	keepend contains=texTypeStyle,texTypeSize,texStatement,texDelimiter,texComment,texLength,texMathMatcher,texMathParen,texMathOper,texError,texMathDelim,texComment,texRefZone

syn region texMathZone	matchgroup=Delimiter start="\\("	matchgroup=Delimiter end="\\)\|%stopzone"	keepend contains=texTypeStyle,texTypeSize,texStatement,texDelimiter,texComment,texLength,texMathMatcher,texMathParen,texMathOper,texError,texMathDelim,texRefZone,texTypeStyle,texTypeSize
syn region texMathZone	matchgroup=Delimiter start="\\\["	matchgroup=Delimiter end="\\]\|%stopzone"	keepend contains=texTypeStyle,texTypeSize,texStatement,texDelimiter,texComment,texLength,texMathMatcher,texMathParen,texMathOper,texError,texMathDelim,texRefZone,texTypeStyle,texTypeSize
syn region texMathZone	matchgroup=Delimiter start="\$"	skip="\(\\\\\)*\\\$"	matchgroup=Delimiter end="\$\|%stopzone" keepend contains=texTypeStyle,texTypeSize,texStatement,texDelimiter,texComment,texLength,texMathMatcher,texMathParen,texMathOper,texError,texMathDelim,texRefZone,texTypeStyle,texTypeSize
syn region texMathZone	matchgroup=Delimiter start="\$\$"	matchgroup=Delimiter end="\$\$\|%stopzone" keepend contains=texTypeStyle,texTypeSize,texStatement,texDelimiter,texComment,texLength,texMathMatcher,texMathParen,texMathOper,texError,texMathDelim,texRefZone,texTypeStyle,texTypeSize

syn match texMathOper	"[_^=]" contained

" \left..something.. and \right..something.. support
syn match   texMathDelimBad contained	"[^a-zA-Z0-9]"
syn match   texMathDelim	"\\\(left\|right\)[^a-zA-Z0-9]"me=e-1	nextgroup=texMathDelimBs,texMathDelimChr,texMathDelimBad
syn match   texMathDelimChr contained	"[().|\[\]]"
syn match   texMathDelimBs  contained	"\\."me=e-1	nextgroup=texMathDelimKey
syn keyword texMathDelimKey contained	Downarrow	Uparrow	downarrow	lceil	rangle	uparrow
syn keyword texMathDelimKey contained	Rfloor	backslash	langle	lfloor	rceil
syn match   texMathDelimKey contained	"[{}]"

" Comments:
syn match texComment	"%.*$"

" separate lines used for verb` and verb# so that the end conditions
" will appropriately terminate.  Ideally vim would let me save a
" character from the start pattern and re-use it in the end-pattern.
syn region texZone	start="\\begin{verbatim}"		end="\\end{verbatim}\|%stopzone"
syn region texZone	start="\\verb`"		end="`\|%stopzone"
syn region texZone	start="\\verb#"		end="#\|%stopzone"
syn region texZone	start="@samp{"		end="}\|%stopzone"
syn region texRefZone	matchgroup=texStatement start="\\ref{"	keepend end="}\|%stopzone"  contains=texComment,texDelimiter
syn region texRefZone	matchgroup=texStatement start="\\label{"	keepend end="}\|%stopzone"  contains=texComment,texDelimiter
syn region texRefZone	matchgroup=texStatement start="\\cite{"	keepend end="}\|%stopzone"  contains=texComment,texDelimiter

" special TeX characters  ( \$ \& \% \# \{ \} \_ \S \P )
syn match texSpecialChar	"\\[$&%#{}_]"
syn match texSpecialChar	"\\[SP@][^a-zA-Z]"me=e-1
syn match texSpecialChar	"\\\\"
syn match texOnlyMath	"[_^]"

" texAccent (tnx to Karim Belabas) avoids annoying highlighting for accents
syn match texAccent	"\\[bcdvuH][^a-zA-Z]"me=e-1
syn match texAccent	"\\[bcdvuH]$"
syn match texAccent	+\\[=^.\~"`']+
syn match texLigature	"\\\([ijolL]\|ae\|oe\|ss\|AA\|AE\|OE\)[^a-zA-Z]"me=e-1
syn match texLigature	"\\\([ijolL]\|ae\|oe\|ss\|AA\|AE\|OE\)$"

" handle newcommands
syn match  texNewCmd		"\\newcommand"		nextgroup=texCmdName skipwhite skipnl
syn region texCmdName contained matchgroup=Delimiter start="{"rs=s+1  end="}"	nextgroup=texCmdArgs,texCmdBody skipwhite skipnl
syn region texCmdArgs contained matchgroup=Delimiter start="\["rs=s+1 end="]"	nextgroup=texCmdBody skipwhite skipnl
syn region texCmdBody contained matchgroup=Delimiter start="{"rs=s+1 skip="\(\\\\\)\\[{}]" matchgroup=Delimiter end="}" contains=ALLBUT,texZone,texMatcher,texError,texCmdName,texCmdArgs,texDefCmd,texDefName,texMathZone,texParen,texMathParen,texMathMatcher,texBadMath,texOnlyMath,texAccent,texMathDelimKey,texMathDelimBad,texMathDelimBs,texMathDelimChr

syn match texDefCmd		"\\def"			nextgroup=texDefName skipwhite skipnl
syn match texDefName contained	"\\[a-zA-Z]\+"		nextgroup=texCmdBody skipwhite skipnl

" TeX input
syn match texInput	"\\input [a-zA-Z]\+"hs=s+7	contains=texStatement

" TeX Lengths
syn match  texLength	"[0-9]\+\(\.[0-9]\+\)\=\(cm\|em\|ex\|in\|pc\|pt\|mm\)"

" TeX String Delimiters
syn match texString	"\(``\|''\)"

" synchronizing
syn sync maxlines=200

if !exists("did_tex_syntax_inits")
 let did_tex_syntax_inits = 1

 " TeX highlighting groups which should share similar highlighting
 hi link texBadMath         texError
 hi link texDefCmd	texDef
 hi link texDefName	texDef
 hi link texLigature	texSpecialChar
 hi link texMathDelimBad	texError
 hi link texMathDelimBs	texMathDelim
 hi link texMathDelimChr	texMathDelim
 hi link texMathDelimKey	texMathDelim
 hi link texMathMatcher     texMath
 hi link texMathParen       texMath
 hi link texMathZone	texMath
 hi link texOnlyMath	texError
 hi link texTypeSize	texStatement
 hi link texTypeStyle	texStatement

 " Basic TeX highlighting groups
 hi link texCmdArgs	Number
 hi link texCmdName	Statement
 hi link texComment	Comment
 hi link texDef	Statement
 hi link texDelimiter	Delimiter
 hi link texError	Error
 hi link texInput	Todo
 hi link texLength	Number
 hi link texMath	Special
 hi link texMathDelim	Statement
 hi link texMathOper	Operator
 hi link texNewCmd	Statement
 hi link texRefZone	Special
 hi link texSection	Todo
 hi link texSpecialChar	SpecialChar
 hi link texStatement	Statement
 hi link texString	String
 hi link texType	Type
 hi link texZone	PreCondit
endif

let b:current_syntax = "tex"

" vim: ts=14
