Attribute VB_Name = "MainModule"
' OpenWithVim, version 1.1

' Author: Christian Schaller (sca@isogmbh.de)

' Description: opens given file with Vim (if exists, otherwise Vim is
' started first) and jumps to given line number, if supplied.

' Requires: GVim 5.3 with OLE support

' Examples:
' edit MyFile with vim:
'   OpenWithVim MyFile
' edit MyFile with vim and jump to line number 20
'   OpenWithVim +20 MyFile

' Using OpenWithVim with explorer:
' (1) Send To:
'   create a link of OpenWithVim.exe and put it in Windows\SendTo directory
'   => right mouse-click on file->SendTo->OpenWithVim opens that file with Vim
' (2) file association:
'   start explorer, menu view->options, tab types
'   select file extension, choose edit
'   edit entry "open"
'   change application to $PATH_OF_OPENWITHVIM\OpenWithVim "%1"
'   => double clicking a file with that extension will be open with Vim

'TODO: How can I cange the program icon?

Option Explicit

Sub Main()
    Dim usage As String
    Dim commandline As String
    Dim path As String
    Dim vim As Object
    Dim line As String
    Dim file As String
    Dim start As Integer
    
    line = ""
    file = ""
    start = 0
    
    usage = "OpenWithVim 1.1 (22.III.99)" _
        & vbCrLf _
        & vbCrLf & "Usage: OpenWithVim [+<line>] <file>" _
        & vbCrLf _
        & vbCrLf & "Options:" _
        & vbCrLf & "+<line>" & vbTab & "goto line number <line>"
        
    'get command line
    commandline = Command()
    
    'no arguments?
    If Len(commandline) = 0 Then
        MsgBox usage
        Exit Sub
    End If
    
    'is first parameter an option?
    If Left(commandline, 1) = "+" Then
        start = InStr(commandline, " ")
        line = Trim(Mid(commandline, 2, start - 1))
        file = Trim(Mid(commandline, start + 1))
        'no line number?
        If line = "" Or file = "" Then
            MsgBox usage
            Exit Sub
        End If
    Else
        file = Trim(commandline)
    End If
    
    'remove "s
    If Left(file, 1) = Chr(34) Then file = Mid(file, 2, Len(file) - 2)
    
    'get current path
    path = CurDir()
 
    Set vim = CreateObject("Vim.Application")
    'was there a
    If Left(file, 1) <> "\" And Left(file, 1) <> "/" _
        And Mid(file, 2, 1) <> ":" Then
        vim.SendKeys (":cd " & path & "<c-m>")
    End If
    vim.SendKeys (":e " & file & "<c-m>")
    If line <> "" Then vim.SendKeys (":" & line & "<c-m>")
    vim.SetForeground
End Sub
