/* vi:set ts=8 sts=4 sw=4:
 *
 * VIM - Vi IMproved	by Bram Moolenaar
 *
 * Do ":help uganda"  in Vim to read copying and usage conditions.
 * Do ":help credits" in Vim to see a list of people who contributed.
 */

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <termio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>

#define CASE_INSENSITIVE_FILENAME

/* 10, but 4 char margin for extension. */
#ifndef BASENAMELEN
# define BASENAMELEN 6
#endif

#ifndef TEMNAME
# define TEMPNAME	"<Wimp$ScrapDir>.v?XXXXXX"
# define TEMPNAMELEN	25
#endif

#ifndef VIM_HLP
# define VIM_HLP "<Vim$Dir>.doc.help/txt"
#endif

#ifndef DEF_BDIR
# define DEF_BDIR	".,<Wimp$ScrapDir>."	/* default for 'backupdir' */
#endif

/* Paths to try putting swap file in. */
#ifndef DEF_DIR
# define DEF_DIR	".,<Wimp$ScrapDir>."	/* default for 'directory' */
#endif

#define ERRORFILE	"errors/vim"
#define MAKEEF		"<Wimp$ScrapDir>.vim##/err"

/*
 * RISC PCs have plenty of memory, use large buffers
 */
#define CMDBUFFSIZE 1024	/* size of the command processing buffer */
#define MAXPATHL    256		/* paths are always quite short though */

#ifndef MAXMEM
# define MAXMEM		(5*1024)    /* use up to 5 Mbyte for a buffer */
#endif

#ifndef MAXMEMTOT
# define MAXMEMTOT	(10*1024)    /* use up to 10 Mbyte for Vim */
#endif

#ifdef HAVE_SIGSET
# define signal sigset
#endif

#define SIZEOF_INT 4

#define n_flag (1<<31)
#define z_flag (1<<30)
#define c_flag (1<<29)
#define v_flag (1<<28)

/* Takes r0-r6 as inputs, returns r0-r6 in global variables. */
int swi(int swinum, ...);

#include <sys/swis.h>

#ifdef USE_GUI
# define USE_GUI_ALWAYS
#endif

#define mch_memmove(to, from, len) memmove((char *)(to), (char *)(from), len)
#define mch_rename(src, dst) rename(src, dst)
#define mch_chdir(s) chdir(s)
#define mch_getenv(x) (char_u *)getenv((char *)x)
#define mch_setenv(name, val, x) setenv(name, val, x)
