" Vim syntax file
" Language:	SiCAD (procedure language)
" Maintainer:	Zsolt Branyiczky <zbranyiczky@lmark.mgx.hu>
" Last change:	1997 Nov 08

" remove any old syntax stuff hanging around
syn clear

" ignore case 
syn case ignore

" spaces are used in (auto)indents
set expandtab

" most important commands
syn keyword sicadStatement	define
syn keyword sicadStatement	dialog
syn keyword sicadStatement	do
syn keyword sicadStatement	dop
syn keyword sicadStatement	end
syn keyword sicadStatement	enddo
syn keyword sicadStatement	endp
syn keyword sicadStatement	erroff
syn keyword sicadStatement	erron
syn keyword sicadStatement	exitp
syn keyword sicadGoto		goto contained
syn keyword sicadStatement	hh
syn keyword sicadStatement	if
syn keyword sicadStatement	in
syn keyword sicadStatement	msgsup
syn keyword sicadStatement	out
syn keyword sicadStatement	padd
syn keyword sicadStatement	parbeg
syn keyword sicadStatement	parend
syn keyword sicadStatement	pdoc
syn keyword sicadStatement	pprot
syn keyword sicadStatement	procd
syn keyword sicadStatement	procn
syn keyword sicadStatement	psav
syn keyword sicadStatement	psel
syn keyword sicadStatement	psymb
syn keyword sicadStatement	ptrace
syn keyword sicadStatement	ptstat
syn keyword sicadStatement	set
syn keyword sicadStatement	step
syn keyword sicadStatement	ww

" functions
syn keyword sicadStatement	atan
syn keyword sicadStatement	atan2
syn keyword sicadStatement	cos
syn keyword sicadStatement	dist
syn keyword sicadStatement	exp
syn keyword sicadStatement	log
syn keyword sicadStatement	log10
syn keyword sicadStatement	sin
syn keyword sicadStatement	sqrt
syn keyword sicadStatement	tanh
syn keyword sicadStatement	x
syn keyword sicadStatement	y

" other keywords
syn match sicadOperator	"\.and\."
syn match sicadOperator	"\.ne\."
syn match sicadOperator	"\.not\."
syn match sicadOperator	"\.eq\."
syn match sicadOperator	"\.ge\."
syn match sicadOperator	"\.gt\."
syn match sicadOperator	"\.le\."
syn match sicadOperator	"\.lt\."
syn match sicadOperator	"\.or\."

"catch error caused by tabulator key
syn match sicadError		"	"

" variable name
syn match sicadIdentifier	"%[g]\=[irpt]\d\{1,2}"
syn match sicadIdentifier	"%[g]\=l\d"
syn match sicadIdentifier	"%[g]\=[irptl]("me=e-1
syn match sicadIdentifier	"%error\>"
syn match sicadIdentifier	"%nsel\>"
syn match sicadIdentifier	"%nvar\>"
syn match sicadIdentifier	"%scl\>"
syn match sicadIdentifier	"%wd\>"

" label
syn match sicadLabel	"^ *\.[a-z0-9]\{1,8}"
syn match sicadLabel	"\<goto \.\=[a-z0-9]\{1,8}\>" contains=sicadGoto

" boolean
syn match sicadBoolean	"\.f\."
syn match sicadBoolean	"\.t\."
"integer without sign
syn match sicadNumber	"\<\d\+\>"
"floating point number, with dot, optional exponent
syn match sicadFloat	"\<\d\+\.\d*\(e[-+]\=\d\+\)\=\>"
"floating point number, starting with a dot, optional exponent
syn match sicadFloat	"\.\d\+\(e[-+]\=\d\+\)\=\>"
"floating point number, without dot, with exponent
syn match sicadFloat	"\<\d\+e[-+]\=\d\+\>"

" string
syn region sicadString		start=+'+ end=+'+

" comment between docbeg and docend
syn region sicadComment	matchgroup=sicadStatement start="\<docbeg\>" end="\<docend\>"
syn match sicadComment "^ *\*.*"
syn match sicadComment "[ ;]\*.*"

" catch \ at the end of line
syn match sicadStatement "\\$"

"catch errors caused by wrong parenthesis
syn region sicadParen transparent start='(' end=')' contains=ALLBUT,sicadParenError
syn match sicadParenError ")"

" synchronizing
syn sync match sicadSyncComment groupthere NONE "\<docend\>"
syn sync match sicadSyncComment grouphere sicadComment "\<docbeg\>"
"syn sync match sicadSyncParen groupthere NONE ')'
"syn sync match sicadSyncParen grouphere sicadParen '('
syn sync linecont "\\$"

"other keywords
syn keyword sicadStatement	abst
syn keyword sicadStatement	add
syn keyword sicadStatement	adrin
syn keyword sicadStatement	aib
syn keyword sicadStatement	aibzsn
syn keyword sicadStatement	aidump
syn keyword sicadStatement	aifgeo
syn keyword sicadStatement	aisbrk
syn keyword sicadStatement	alknam
syn keyword sicadStatement	alknr
syn keyword sicadStatement	alksav
syn keyword sicadStatement	alksel
syn keyword sicadStatement	alktrc
syn keyword sicadStatement	alopen
syn keyword sicadStatement	ansbo
syn keyword sicadStatement	aractiv
syn keyword sicadStatement	ararea
syn keyword sicadStatement	arareao
syn keyword sicadStatement	arbuffer
syn keyword sicadStatement	archeck
syn keyword sicadStatement	arcomv
syn keyword sicadStatement	arcont
syn keyword sicadStatement	arconv
syn keyword sicadStatement	arcopy
syn keyword sicadStatement	arcopyo
syn keyword sicadStatement	arcorr
syn keyword sicadStatement	arcreate
syn keyword sicadStatement	arerror
syn keyword sicadStatement	areval
syn keyword sicadStatement	arflfm
syn keyword sicadStatement	arflop
syn keyword sicadStatement	arfrast
syn keyword sicadStatement	argbkey
syn keyword sicadStatement	argenf
syn keyword sicadStatement	argraph
syn keyword sicadStatement	argrapho
syn keyword sicadStatement	arinters
syn keyword sicadStatement	arkompfl
syn keyword sicadStatement	arlisly
syn keyword sicadStatement	arnext
syn keyword sicadStatement	aroverl
syn keyword sicadStatement	arovers
syn keyword sicadStatement	arpars
syn keyword sicadStatement	arrefp
syn keyword sicadStatement	arselect
syn keyword sicadStatement	arset
syn keyword sicadStatement	arstruct
syn keyword sicadStatement	arunify
syn keyword sicadStatement	arupdate
syn keyword sicadStatement	arvector
syn keyword sicadStatement	arveinfl
syn keyword sicadStatement	arvflfl
syn keyword sicadStatement	arvoroni
syn keyword sicadStatement	ausku
syn keyword sicadStatement	basis
syn keyword sicadStatement	basisaus
syn keyword sicadStatement	basisdar
syn keyword sicadStatement	basisnr
syn keyword sicadStatement	bebos
syn keyword sicadStatement	befl
syn keyword sicadStatement	befli
syn keyword sicadStatement	befls
syn keyword sicadStatement	beo
syn keyword sicadStatement	beorta
syn keyword sicadStatement	beortn
syn keyword sicadStatement	bep
syn keyword sicadStatement	bepan
syn keyword sicadStatement	bepap
syn keyword sicadStatement	bepola
syn keyword sicadStatement	bepoln
syn keyword sicadStatement	bepsn
syn keyword sicadStatement	bepsp
syn keyword sicadStatement	ber
syn keyword sicadStatement	berili
syn keyword sicadStatement	berk
syn keyword sicadStatement	bewz
syn keyword sicadStatement	bkl
syn keyword sicadStatement	bli
syn keyword sicadStatement	bma
syn keyword sicadStatement	bmakt
syn keyword sicadStatement	bmbm
syn keyword sicadStatement	bmerk
syn keyword sicadStatement	bmerw
syn keyword sicadStatement	bminit
syn keyword sicadStatement	bmk
syn keyword sicadStatement	bmorth
syn keyword sicadStatement	bmos
syn keyword sicadStatement	bmpar
syn keyword sicadStatement	bmsl
syn keyword sicadStatement	bmsum
syn keyword sicadStatement	bmver
syn keyword sicadStatement	bmvero
syn keyword sicadStatement	bmw
syn keyword sicadStatement	bo
syn keyword sicadStatement	bta
syn keyword sicadStatement	buffer
syn keyword sicadStatement	bvl
syn keyword sicadStatement	bw
syn keyword sicadStatement	bza
syn keyword sicadStatement	bzap
syn keyword sicadStatement	bzd
syn keyword sicadStatement	bzgera
syn keyword sicadStatement	bzorth
syn keyword sicadStatement	cat
syn keyword sicadStatement	catel
syn keyword sicadStatement	cdbdiff
syn keyword sicadStatement	ce
syn keyword sicadStatement	close
syn keyword sicadStatement	comp
syn keyword sicadStatement	conclose
syn keyword sicadStatement	coninfo
syn keyword sicadStatement	conopen
syn keyword sicadStatement	conread
syn keyword sicadStatement	contour
syn keyword sicadStatement	conwrite
syn keyword sicadStatement	cop
syn keyword sicadStatement	copel
syn keyword sicadStatement	cr
syn keyword sicadStatement	cs
syn keyword sicadStatement	cstat
syn keyword sicadStatement	cursor
syn keyword sicadStatement	d
syn keyword sicadStatement	da
syn keyword sicadStatement	dal
syn keyword sicadStatement	dasp
syn keyword sicadStatement	dasps
syn keyword sicadStatement	dataout
syn keyword sicadStatement	dcol
syn keyword sicadStatement	dd
syn keyword sicadStatement	defsr
syn keyword sicadStatement	del
syn keyword sicadStatement	delel
syn keyword sicadStatement	deskrdef
syn keyword sicadStatement	df
syn keyword sicadStatement	dfn
syn keyword sicadStatement	dfns
syn keyword sicadStatement	dfpos
syn keyword sicadStatement	dfr
syn keyword sicadStatement	dgd
syn keyword sicadStatement	dgm
syn keyword sicadStatement	dgp
syn keyword sicadStatement	dgr
syn keyword sicadStatement	dh
syn keyword sicadStatement	diaus
syn keyword sicadStatement	dir
syn keyword sicadStatement	disbsd
syn keyword sicadStatement	dkl
syn keyword sicadStatement	dktx
syn keyword sicadStatement	dkur
syn keyword sicadStatement	dlgfix
syn keyword sicadStatement	dlgfre
syn keyword sicadStatement	dma
syn keyword sicadStatement	dprio
syn keyword sicadStatement	dr
syn keyword sicadStatement	druse
syn keyword sicadStatement	dsel
syn keyword sicadStatement	dskinfo
syn keyword sicadStatement	dsr
syn keyword sicadStatement	dv
syn keyword sicadStatement	dve
syn keyword sicadStatement	eba
syn keyword sicadStatement	ebd
syn keyword sicadStatement	ebs
syn keyword sicadStatement	edbsdbin
syn keyword sicadStatement	edbssnin
syn keyword sicadStatement	edbsvtin
syn keyword sicadStatement	edt
syn keyword sicadStatement	egaus
syn keyword sicadStatement	egdef
syn keyword sicadStatement	egdefs
syn keyword sicadStatement	eglist
syn keyword sicadStatement	egloe
syn keyword sicadStatement	egloenp
syn keyword sicadStatement	egloes
syn keyword sicadStatement	egxx
syn keyword sicadStatement	eib
syn keyword sicadStatement	ekur
syn keyword sicadStatement	ekuradd
syn keyword sicadStatement	elpos
syn keyword sicadStatement	epg
syn keyword sicadStatement	esau
syn keyword sicadStatement	esauadd
syn keyword sicadStatement	esek
syn keyword sicadStatement	eta
syn keyword sicadStatement	etap
syn keyword sicadStatement	feparam
syn keyword sicadStatement	ficonv
syn keyword sicadStatement	filse
syn keyword sicadStatement	fl
syn keyword sicadStatement	fli
syn keyword sicadStatement	flinit
syn keyword sicadStatement	flkor
syn keyword sicadStatement	fln
syn keyword sicadStatement	flnli
syn keyword sicadStatement	flop
syn keyword sicadStatement	flowert
syn keyword sicadStatement	flparam
syn keyword sicadStatement	flraster
syn keyword sicadStatement	flsy
syn keyword sicadStatement	flsyd
syn keyword sicadStatement	flsym
syn keyword sicadStatement	flsyms
syn keyword sicadStatement	flsymt
syn keyword sicadStatement	fmtatt
syn keyword sicadStatement	fmtdia
syn keyword sicadStatement	fmtlib
syn keyword sicadStatement	fpg
syn keyword sicadStatement	gbadddb
syn keyword sicadStatement	gbanrs
syn keyword sicadStatement	gbatw
syn keyword sicadStatement	gbau
syn keyword sicadStatement	gbaudit
syn keyword sicadStatement	gbclosp
syn keyword sicadStatement	gbcreem
syn keyword sicadStatement	gbcreld
syn keyword sicadStatement	gbcresdb
syn keyword sicadStatement	gbcretd
syn keyword sicadStatement	gbde
syn keyword sicadStatement	gbdeldb
syn keyword sicadStatement	gbdelem
syn keyword sicadStatement	gbdelld
syn keyword sicadStatement	gbdeltd
syn keyword sicadStatement	gbdisdb
syn keyword sicadStatement	gbdisem
syn keyword sicadStatement	gbdisld
syn keyword sicadStatement	gbdistd
syn keyword sicadStatement	gbebn
syn keyword sicadStatement	gbemau
syn keyword sicadStatement	gbepsv
syn keyword sicadStatement	gbgetdet
syn keyword sicadStatement	gbgetmas
syn keyword sicadStatement	gbgqel
syn keyword sicadStatement	gbgqelr
syn keyword sicadStatement	gbgqsa
syn keyword sicadStatement	gbgrant
syn keyword sicadStatement	gbler
syn keyword sicadStatement	gblerb
syn keyword sicadStatement	gblerf
syn keyword sicadStatement	gbles
syn keyword sicadStatement	gblocdic
syn keyword sicadStatement	gbmgmg
syn keyword sicadStatement	gbmntdb
syn keyword sicadStatement	gbmoddb
syn keyword sicadStatement	gbnam
syn keyword sicadStatement	gbneu
syn keyword sicadStatement	gbopenp
syn keyword sicadStatement	gbpoly
syn keyword sicadStatement	gbpos
syn keyword sicadStatement	gbpruef
syn keyword sicadStatement	gbps
syn keyword sicadStatement	gbqgel
syn keyword sicadStatement	gbqgsa
syn keyword sicadStatement	gbreldic
syn keyword sicadStatement	gbresem
syn keyword sicadStatement	gbrevoke
syn keyword sicadStatement	gbsav
syn keyword sicadStatement	gbsbef
syn keyword sicadStatement	gbsddk
syn keyword sicadStatement	gbsicu
syn keyword sicadStatement	gbsrt
syn keyword sicadStatement	gbss
syn keyword sicadStatement	gbstat
syn keyword sicadStatement	gbsysp
syn keyword sicadStatement	gbszau
syn keyword sicadStatement	gbubp
syn keyword sicadStatement	gbueb
syn keyword sicadStatement	gbunmdb
syn keyword sicadStatement	gbuseem
syn keyword sicadStatement	gbw
syn keyword sicadStatement	gbweg
syn keyword sicadStatement	gbwieh
syn keyword sicadStatement	gbzt
syn keyword sicadStatement	gelp
syn keyword sicadStatement	gera
syn keyword sicadStatement	hgw
syn keyword sicadStatement	hpg
syn keyword sicadStatement	hr0
syn keyword sicadStatement	hra
syn keyword sicadStatement	hrar
syn keyword sicadStatement	inchk
syn keyword sicadStatement	inf
syn keyword sicadStatement	infd
syn keyword sicadStatement	inst
syn keyword sicadStatement	kbml
syn keyword sicadStatement	kbmm
syn keyword sicadStatement	kbmt
syn keyword sicadStatement	khboe
syn keyword sicadStatement	khbol
syn keyword sicadStatement	khdob
syn keyword sicadStatement	khe
syn keyword sicadStatement	khetap
syn keyword sicadStatement	khfrw
syn keyword sicadStatement	khlang
syn keyword sicadStatement	khld
syn keyword sicadStatement	khmfrp
syn keyword sicadStatement	khmks
syn keyword sicadStatement	khpd
syn keyword sicadStatement	khpfeil
syn keyword sicadStatement	khpl
syn keyword sicadStatement	khprofil
syn keyword sicadStatement	khsa
syn keyword sicadStatement	khsabs
syn keyword sicadStatement	khse
syn keyword sicadStatement	khskbz
syn keyword sicadStatement	khsna
syn keyword sicadStatement	khsnum
syn keyword sicadStatement	khsob
syn keyword sicadStatement	khspos
syn keyword sicadStatement	khzpe
syn keyword sicadStatement	khzpl
syn keyword sicadStatement	kib
syn keyword sicadStatement	kldat
syn keyword sicadStatement	klleg
syn keyword sicadStatement	klsch
syn keyword sicadStatement	klsym
syn keyword sicadStatement	klvert
syn keyword sicadStatement	kmpg
syn keyword sicadStatement	kmtlage
syn keyword sicadStatement	kmtp
syn keyword sicadStatement	kodef
syn keyword sicadStatement	kodefp
syn keyword sicadStatement	kok
syn keyword sicadStatement	kokp
syn keyword sicadStatement	kolae
syn keyword sicadStatement	kom
syn keyword sicadStatement	kopar
syn keyword sicadStatement	koparp
syn keyword sicadStatement	kopg
syn keyword sicadStatement	kosy
syn keyword sicadStatement	kp
syn keyword sicadStatement	kr
syn keyword sicadStatement	krsek
syn keyword sicadStatement	krtclose
syn keyword sicadStatement	krtopen
syn keyword sicadStatement	ktk
syn keyword sicadStatement	lad
syn keyword sicadStatement	lae
syn keyword sicadStatement	laesel
syn keyword sicadStatement	language
syn keyword sicadStatement	lasso
syn keyword sicadStatement	lbdes
syn keyword sicadStatement	lcs
syn keyword sicadStatement	ldesk
syn keyword sicadStatement	ldesks
syn keyword sicadStatement	le
syn keyword sicadStatement	leak
syn keyword sicadStatement	leattdes
syn keyword sicadStatement	leba
syn keyword sicadStatement	lebas
syn keyword sicadStatement	lebaznp
syn keyword sicadStatement	lebd
syn keyword sicadStatement	lebm
syn keyword sicadStatement	lebv
syn keyword sicadStatement	lebvaus
syn keyword sicadStatement	lebvlist
syn keyword sicadStatement	lede
syn keyword sicadStatement	ledel
syn keyword sicadStatement	ledepo
syn keyword sicadStatement	ledepol
syn keyword sicadStatement	ledepos
syn keyword sicadStatement	leder
syn keyword sicadStatement	ledm
syn keyword sicadStatement	lee
syn keyword sicadStatement	leeins
syn keyword sicadStatement	lees
syn keyword sicadStatement	lege
syn keyword sicadStatement	lekr
syn keyword sicadStatement	lekrend
syn keyword sicadStatement	lekwa
syn keyword sicadStatement	lekwas
syn keyword sicadStatement	lel
syn keyword sicadStatement	lelh
syn keyword sicadStatement	lell
syn keyword sicadStatement	lelp
syn keyword sicadStatement	lem
syn keyword sicadStatement	lena
syn keyword sicadStatement	lend
syn keyword sicadStatement	lenm
syn keyword sicadStatement	lep
syn keyword sicadStatement	lepe
syn keyword sicadStatement	lepee
syn keyword sicadStatement	lepko
syn keyword sicadStatement	lepl
syn keyword sicadStatement	lepmko
syn keyword sicadStatement	lepmkop
syn keyword sicadStatement	lepos
syn keyword sicadStatement	leqs
syn keyword sicadStatement	leqsl
syn keyword sicadStatement	leqssp
syn keyword sicadStatement	leqsv
syn keyword sicadStatement	leqsvov
syn keyword sicadStatement	les
syn keyword sicadStatement	lesch
syn keyword sicadStatement	lesr
syn keyword sicadStatement	less
syn keyword sicadStatement	lestd
syn keyword sicadStatement	let
syn keyword sicadStatement	letaum
syn keyword sicadStatement	letl
syn keyword sicadStatement	lev
syn keyword sicadStatement	levtm
syn keyword sicadStatement	levtp
syn keyword sicadStatement	levtr
syn keyword sicadStatement	lew
syn keyword sicadStatement	lewm
syn keyword sicadStatement	lexx
syn keyword sicadStatement	lfs
syn keyword sicadStatement	li
syn keyword sicadStatement	lldes
syn keyword sicadStatement	lmode
syn keyword sicadStatement	loedk
syn keyword sicadStatement	loepkt
syn keyword sicadStatement	lop
syn keyword sicadStatement	lose
syn keyword sicadStatement	lp
syn keyword sicadStatement	lppg
syn keyword sicadStatement	lppruef
syn keyword sicadStatement	lr
syn keyword sicadStatement	ls
syn keyword sicadStatement	lsop
syn keyword sicadStatement	lsta
syn keyword sicadStatement	lstat
syn keyword sicadStatement	ly
syn keyword sicadStatement	lyaus
syn keyword sicadStatement	lz
syn keyword sicadStatement	lza
syn keyword sicadStatement	lzae
syn keyword sicadStatement	lzbz
syn keyword sicadStatement	lze
syn keyword sicadStatement	lznr
syn keyword sicadStatement	lzo
syn keyword sicadStatement	lzpos
syn keyword sicadStatement	ma
syn keyword sicadStatement	ma0
syn keyword sicadStatement	ma1
syn keyword sicadStatement	mad
syn keyword sicadStatement	map
syn keyword sicadStatement	mapoly
syn keyword sicadStatement	mcarp
syn keyword sicadStatement	mccfr
syn keyword sicadStatement	mccgr
syn keyword sicadStatement	mcclr
syn keyword sicadStatement	mccrf
syn keyword sicadStatement	mcdf
syn keyword sicadStatement	mcdma
syn keyword sicadStatement	mcdr
syn keyword sicadStatement	mcdrp
syn keyword sicadStatement	mcdve
syn keyword sicadStatement	mcebd
syn keyword sicadStatement	mcgse
syn keyword sicadStatement	mcinfo
syn keyword sicadStatement	mcldrp
syn keyword sicadStatement	md
syn keyword sicadStatement	me
syn keyword sicadStatement	mefd
syn keyword sicadStatement	mefds
syn keyword sicadStatement	minmax
syn keyword sicadStatement	mipg
syn keyword sicadStatement	ml
syn keyword sicadStatement	mmdbf
syn keyword sicadStatement	mmdellb
syn keyword sicadStatement	mmfsb
syn keyword sicadStatement	mminfolb
syn keyword sicadStatement	mmlapp
syn keyword sicadStatement	mmlbf
syn keyword sicadStatement	mmlistlb
syn keyword sicadStatement	mmreadlb
syn keyword sicadStatement	mmsetlb
syn keyword sicadStatement	mnp
syn keyword sicadStatement	mpo
syn keyword sicadStatement	mr
syn keyword sicadStatement	mra
syn keyword sicadStatement	ms
syn keyword sicadStatement	msav
syn keyword sicadStatement	msgout
syn keyword sicadStatement	msgsnd
syn keyword sicadStatement	msp
syn keyword sicadStatement	mspf
syn keyword sicadStatement	mtd
syn keyword sicadStatement	nasel
syn keyword sicadStatement	ncomp
syn keyword sicadStatement	new
syn keyword sicadStatement	nlist
syn keyword sicadStatement	nlistlt
syn keyword sicadStatement	nlistly
syn keyword sicadStatement	nlistnp
syn keyword sicadStatement	nlistpo
syn keyword sicadStatement	np
syn keyword sicadStatement	npa
syn keyword sicadStatement	npdes
syn keyword sicadStatement	npe
syn keyword sicadStatement	npem
syn keyword sicadStatement	npinfa
syn keyword sicadStatement	npruef
syn keyword sicadStatement	npsat
syn keyword sicadStatement	npss
syn keyword sicadStatement	npssa
syn keyword sicadStatement	ntz
syn keyword sicadStatement	oa
syn keyword sicadStatement	oan
syn keyword sicadStatement	odel
syn keyword sicadStatement	odf
syn keyword sicadStatement	odfx
syn keyword sicadStatement	oj
syn keyword sicadStatement	oja
syn keyword sicadStatement	ojaddsk
syn keyword sicadStatement	ojaef
syn keyword sicadStatement	ojaefs
syn keyword sicadStatement	ojaen
syn keyword sicadStatement	ojak
syn keyword sicadStatement	ojaks
syn keyword sicadStatement	ojakt
syn keyword sicadStatement	ojakz
syn keyword sicadStatement	ojalm
syn keyword sicadStatement	ojatkis
syn keyword sicadStatement	ojatt
syn keyword sicadStatement	ojbsel
syn keyword sicadStatement	ojckon
syn keyword sicadStatement	ojde
syn keyword sicadStatement	ojdtl
syn keyword sicadStatement	ojeb
syn keyword sicadStatement	ojebd
syn keyword sicadStatement	ojel
syn keyword sicadStatement	ojesb
syn keyword sicadStatement	ojesbd
syn keyword sicadStatement	ojex
syn keyword sicadStatement	ojezge
syn keyword sicadStatement	ojko
syn keyword sicadStatement	ojlb
syn keyword sicadStatement	ojloe
syn keyword sicadStatement	ojlsb
syn keyword sicadStatement	ojmos
syn keyword sicadStatement	ojnam
syn keyword sicadStatement	ojpda
syn keyword sicadStatement	ojpoly
syn keyword sicadStatement	ojprae
syn keyword sicadStatement	ojs
syn keyword sicadStatement	ojsak
syn keyword sicadStatement	ojsort
syn keyword sicadStatement	ojstrukt
syn keyword sicadStatement	ojsub
syn keyword sicadStatement	ojtdef
syn keyword sicadStatement	ojx
syn keyword sicadStatement	old
syn keyword sicadStatement	op
syn keyword sicadStatement	opa
syn keyword sicadStatement	opa1
syn keyword sicadStatement	open
syn keyword sicadStatement	opnbsd
syn keyword sicadStatement	orth
syn keyword sicadStatement	osanz
syn keyword sicadStatement	ot
syn keyword sicadStatement	otp
syn keyword sicadStatement	otrefp
syn keyword sicadStatement	paranf
syn keyword sicadStatement	pas
syn keyword sicadStatement	passw
syn keyword sicadStatement	pda
syn keyword sicadStatement	pg
syn keyword sicadStatement	pg0
syn keyword sicadStatement	pgauf
syn keyword sicadStatement	pgaufsel
syn keyword sicadStatement	pgb
syn keyword sicadStatement	pgko
syn keyword sicadStatement	pgm
syn keyword sicadStatement	pgr
syn keyword sicadStatement	pgvs
syn keyword sicadStatement	pily
syn keyword sicadStatement	pkpg
syn keyword sicadStatement	plot
syn keyword sicadStatement	plotf
syn keyword sicadStatement	plotfr
syn keyword sicadStatement	pnrver
syn keyword sicadStatement	poa
syn keyword sicadStatement	pos
syn keyword sicadStatement	posa
syn keyword sicadStatement	posaus
syn keyword sicadStatement	post
syn keyword sicadStatement	protect
syn keyword sicadStatement	prs
syn keyword sicadStatement	prsym
syn keyword sicadStatement	ps
syn keyword sicadStatement	psadd
syn keyword sicadStatement	psclose
syn keyword sicadStatement	psopen
syn keyword sicadStatement	psparam
syn keyword sicadStatement	psprw
syn keyword sicadStatement	psres
syn keyword sicadStatement	psstat
syn keyword sicadStatement	psw
syn keyword sicadStatement	pswr
syn keyword sicadStatement	qualif
syn keyword sicadStatement	rahmen
syn keyword sicadStatement	raster
syn keyword sicadStatement	rasterd
syn keyword sicadStatement	rbbackup
syn keyword sicadStatement	rbchange
syn keyword sicadStatement	rbcmd
syn keyword sicadStatement	rbcopy
syn keyword sicadStatement	rbcut
syn keyword sicadStatement	rbdbcl
syn keyword sicadStatement	rbdbload
syn keyword sicadStatement	rbdbop
syn keyword sicadStatement	rbdbwin
syn keyword sicadStatement	rbdefs
syn keyword sicadStatement	rbedit
syn keyword sicadStatement	rbfill
syn keyword sicadStatement	rbfload
syn keyword sicadStatement	rbfree
syn keyword sicadStatement	rbg
syn keyword sicadStatement	rbinfo
syn keyword sicadStatement	rbpaste
syn keyword sicadStatement	rbrstore
syn keyword sicadStatement	rbsnap
syn keyword sicadStatement	rbsta
syn keyword sicadStatement	rbvtor
syn keyword sicadStatement	rcol
syn keyword sicadStatement	re
syn keyword sicadStatement	reb
syn keyword sicadStatement	refunc
syn keyword sicadStatement	ren
syn keyword sicadStatement	renel
syn keyword sicadStatement	rk
syn keyword sicadStatement	rkpos
syn keyword sicadStatement	rohr
syn keyword sicadStatement	rohrpos
syn keyword sicadStatement	rpr
syn keyword sicadStatement	rr
syn keyword sicadStatement	rr0
syn keyword sicadStatement	rra
syn keyword sicadStatement	rrar
syn keyword sicadStatement	rs
syn keyword sicadStatement	samtosdb
syn keyword sicadStatement	sav
syn keyword sicadStatement	savx
syn keyword sicadStatement	scol
syn keyword sicadStatement	scopy
syn keyword sicadStatement	scopye
syn keyword sicadStatement	sddk
syn keyword sicadStatement	sdwr
syn keyword sicadStatement	se
syn keyword sicadStatement	selaus
syn keyword sicadStatement	selpos
syn keyword sicadStatement	seman
syn keyword sicadStatement	semi
syn keyword sicadStatement	sesch
syn keyword sicadStatement	setscl
syn keyword sicadStatement	sge
syn keyword sicadStatement	sid
syn keyword sicadStatement	sie
syn keyword sicadStatement	sig
syn keyword sicadStatement	sigp
syn keyword sicadStatement	skk
syn keyword sicadStatement	skks
syn keyword sicadStatement	sn
syn keyword sicadStatement	sn21
syn keyword sicadStatement	snpa
syn keyword sicadStatement	snpar
syn keyword sicadStatement	snpd
syn keyword sicadStatement	snpi
syn keyword sicadStatement	snpkor
syn keyword sicadStatement	snpl
syn keyword sicadStatement	snpm
syn keyword sicadStatement	sof
syn keyword sicadStatement	sop
syn keyword sicadStatement	split
syn keyword sicadStatement	spr
syn keyword sicadStatement	sqdadd
syn keyword sicadStatement	sqdlad
syn keyword sicadStatement	sqdold
syn keyword sicadStatement	sqdsav
syn keyword sicadStatement	sql
syn keyword sicadStatement	sr
syn keyword sicadStatement	sres
syn keyword sicadStatement	srt
syn keyword sicadStatement	sset
syn keyword sicadStatement	stat
syn keyword sicadStatement	stdtxt
syn keyword sicadStatement	string
syn keyword sicadStatement	strukt
syn keyword sicadStatement	strupru
syn keyword sicadStatement	suinfl
syn keyword sicadStatement	suinfls
syn keyword sicadStatement	supo
syn keyword sicadStatement	supo1
syn keyword sicadStatement	sva
syn keyword sicadStatement	svr
syn keyword sicadStatement	sy
syn keyword sicadStatement	sya
syn keyword sicadStatement	syly
syn keyword sicadStatement	sys
syn keyword sicadStatement	sysout
syn keyword sicadStatement	syu
syn keyword sicadStatement	syux
syn keyword sicadStatement	taa
syn keyword sicadStatement	tabeg
syn keyword sicadStatement	tabl
syn keyword sicadStatement	tabm
syn keyword sicadStatement	tam
syn keyword sicadStatement	tanr
syn keyword sicadStatement	tapg
syn keyword sicadStatement	tapos
syn keyword sicadStatement	tarkd
syn keyword sicadStatement	tas
syn keyword sicadStatement	tase
syn keyword sicadStatement	tb
syn keyword sicadStatement	tbadd
syn keyword sicadStatement	tbd
syn keyword sicadStatement	tbext
syn keyword sicadStatement	tbget
syn keyword sicadStatement	tbint
syn keyword sicadStatement	tbout
syn keyword sicadStatement	tbput
syn keyword sicadStatement	tbsat
syn keyword sicadStatement	tbsel
syn keyword sicadStatement	tbstr
syn keyword sicadStatement	tcaux
syn keyword sicadStatement	tccable
syn keyword sicadStatement	tcchkrep
syn keyword sicadStatement	tccond
syn keyword sicadStatement	tcinit
syn keyword sicadStatement	tcmodel
syn keyword sicadStatement	tcnwe
syn keyword sicadStatement	tcpairs
syn keyword sicadStatement	tcpath
syn keyword sicadStatement	tcscheme
syn keyword sicadStatement	tcse
syn keyword sicadStatement	tcselc
syn keyword sicadStatement	tcstar
syn keyword sicadStatement	tcstrman
syn keyword sicadStatement	tcsymbol
syn keyword sicadStatement	tctable
syn keyword sicadStatement	tctest
syn keyword sicadStatement	tcthrcab
syn keyword sicadStatement	tctrans
syn keyword sicadStatement	tctst
syn keyword sicadStatement	tdb
syn keyword sicadStatement	tdbdel
syn keyword sicadStatement	tdbget
syn keyword sicadStatement	tdblist
syn keyword sicadStatement	tdbput
syn keyword sicadStatement	tgmod
syn keyword sicadStatement	titel
syn keyword sicadStatement	tmoff
syn keyword sicadStatement	tmon
syn keyword sicadStatement	tp
syn keyword sicadStatement	tpa
syn keyword sicadStatement	tps
syn keyword sicadStatement	tpta
syn keyword sicadStatement	tra
syn keyword sicadStatement	trans
syn keyword sicadStatement	transkdo
syn keyword sicadStatement	transopt
syn keyword sicadStatement	transpro
syn keyword sicadStatement	trm
syn keyword sicadStatement	trpg
syn keyword sicadStatement	trrkd
syn keyword sicadStatement	trs
syn keyword sicadStatement	ts
syn keyword sicadStatement	tsa
syn keyword sicadStatement	tx
syn keyword sicadStatement	txa
syn keyword sicadStatement	txchk
"syn match sicadParTXT " txt="me=e-1 contained
"syn match sicadParVA " va="me=e-1 contained
"syn keyword sicadStatement	txcng nextgroup=sicadParTXT,sicadParVA skipwhite
syn keyword sicadStatement	txcng
syn keyword sicadStatement	txju
syn keyword sicadStatement	txl
syn keyword sicadStatement	txp
syn keyword sicadStatement	txtcmp
syn keyword sicadStatement	txz
syn keyword sicadStatement	uiinfo
syn keyword sicadStatement	uistatus
syn keyword sicadStatement	umdk
syn keyword sicadStatement	umdk1
syn keyword sicadStatement	umdka
syn keyword sicadStatement	umge
syn keyword sicadStatement	umr
syn keyword sicadStatement	verbo
syn keyword sicadStatement	verflli
syn keyword sicadStatement	verif
syn keyword sicadStatement	verly
syn keyword sicadStatement	versinfo
syn keyword sicadStatement	vfg
syn keyword sicadStatement	wabsym
syn keyword sicadStatement	wzmerk
syn keyword sicadStatement	zdrhf
syn keyword sicadStatement	zdrhfn
syn keyword sicadStatement	zdrhfw
syn keyword sicadStatement	zdrhfwn
syn keyword sicadStatement	zefp
syn keyword sicadStatement	zfl
syn keyword sicadStatement	zflaus
syn keyword sicadStatement	zka
syn keyword sicadStatement	zlel
syn keyword sicadStatement	zlels
syn keyword sicadStatement	zortf
syn keyword sicadStatement	zortfn
syn keyword sicadStatement	zortfw
syn keyword sicadStatement	zortfwn
syn keyword sicadStatement	zortp
syn keyword sicadStatement	zortpn
syn keyword sicadStatement	zparb
syn keyword sicadStatement	zparbn
syn keyword sicadStatement	zparf
syn keyword sicadStatement	zparfn
syn keyword sicadStatement	zparfw
syn keyword sicadStatement	zparfwn
syn keyword sicadStatement	zparp
syn keyword sicadStatement	zparpn
syn keyword sicadStatement	zwinkp
syn keyword sicadStatement	zwinkpn

if !exists("did_sicad_syntax_inits")
  let did_c_syntax_inits = 1
  hi link sicadLabel		PreProc
  hi link sicadConditional	Conditional
  hi link sicadRepeat		Repeat
  hi link sicadCharacter	Character
  hi link sicadSpecialCharacter sicadSpecial
  hi link sicadBoolean		Boolean
  hi link sicadNumber		Number
  hi link sicadFloat		Float
  hi link sicadCommentError	sicadError
  hi link sicadOperator		Operator
  hi link sicadParenError	sicadError
  hi link sicadError		Error
  hi link sicadStatement	Statement
  hi link sicadGoto		Statement
  hi link sicadType		Type
  hi link sicadString		String
  hi link sicadComment		Comment
  hi link sicadSpecial		Special
  "hi link sicadIdentifier	Identifier
  hi link sicadIdentifier	Type
endif

let b:current_syntax = "sicad"

" vim: ts=8
