" Vim syntax file
" Language:	Slrn setup file
" Maintainer:	Preben "Peppe" Guldberg (c928400@student.dtu.dk)
" Last change:	Mon Mar 16 01:27:36 1998

" Remove any old syntax stuff hanging around
syn clear

syn keyword slrnrcTodo		contained Todo

" in some places white space is illegal
syn match slrnrcSpaceError	contained "\s"

syn match slrnrcNumber		contained "-\=\<[0-9]\+\>"
syn match slrnrcNumber		contained +'[^']\+'+

syn match slrnrcSpecKey		contained +\(\\[e"']\|\^[a-zA-Z]\)+

syn match  slrnrcKey		contained "\S\+"	contains=slrnrcSpecKey
syn region slrnrcKey		contained start=+"+ skip=+\\"+ end=+"+ oneline contains=slrnrcSpecKey
syn region slrnrcKey		contained start=+'+ skip=+\\'+ end=+'+ oneline contains=slrnrcSpecKey

syn match slrnrcSpecChar	contained +'+
syn match slrnrcSpecChar	contained +\\[n"]+
syn match slrnrcSpecChar	contained "%[dfmnrs%]"

syn match  slrnrcString		contained /[^ \t%"']\+/	contains=slrnrcSpecChar
syn region slrnrcString		contained start=+"+ skip=+\\"+ end=+"+ oneline contains=slrnrcSpecChar

syn region slrnrcIfRegion	matchgroup=slrnrcIf start="#if" end="#endif\>" transparent keepend

syn match slrnrcComment		"%.*$"	contains=slrnrcTodo

syn keyword slrnrcVarInt	contained author_display beep cc_followup confirm_actions
syn keyword slrnrcVarInt	contained display_author_realname display_score
syn keyword slrnrcVarInt	contained group_dsc_start_column kill_score lines_per_update
syn keyword slrnrcVarInt	contained max_low_score min_high_score mouse
syn keyword slrnrcVarInt	contained new_subject_breaks_threads no_backups prompt_next_group
syn keyword slrnrcVarInt	contained query_next_article query_next_group
syn keyword slrnrcVarInt	contained query_read_group_cutoff query_reconnect read_active
syn keyword slrnrcVarInt	contained reject_long_lines scroll_by_page show_article
syn keyword slrnrcVarInt	contained show_descriptions show_thread_subject sorting_method
syn keyword slrnrcVarInt	contained spoiler_char spoiler_display_mode spool_check_up_on_nov
syn keyword slrnrcVarInt	contained uncollapse_threads unsubscribe_new_groups
syn keyword slrnrcVarInt	contained use_header_numbers use_metamail use_mime use_tilde
syn keyword slrnrcVarInt	contained use_tmpdir use_xgtitle wrap_flags write_newsrc_flags
syn keyword slrnrcVarInt	contained ignore_signature use_color use_blink use_grouplens
syn keyword slrnrcVarInt	contained use_inews use_slrn_pull grouplens_port
" match as a "string" too
syn region  slrnrcVarIntStr	contained matchgroup=slrnrcVarInt start=+"+ end=+"+ contains=slrnrcVarInt,slrnrcSpaceError

syn keyword slrnrcVarStr	Xbrowser art_help_line cc_followup_string charset custom_headers
syn keyword slrnrcVarStr	decode_directory editor_command followup_custom_headers
syn keyword slrnrcVarStr	followup_string group_help_line grouplens_host
syn keyword slrnrcVarStr	grouplens_pseudoname eeader_help_line inews_program
syn keyword slrnrcVarStr	macro_directory mail_editor_command metamail_command
syn keyword slrnrcVarStr	mime_charset non_Xbrowser organization post_editor_command
syn keyword slrnrcVarStr	post_object postpone_directory quote_string realname
syn keyword slrnrcVarStr	reply_custom_headers reply_string replyto save_directory
syn keyword slrnrcVarStr	save_posts save_replies score_editor_command sendmail_command
syn keyword slrnrcVarStr	server_object signature spool_active_file spool_activetimes_file
syn keyword slrnrcVarStr	spool_inn_root spool_newsgroups_file spool_nov_file
syn keyword slrnrcVarStr	spool_nov_root spool_root username
" obsolete
"syn keyword slrnrcVarStr	followup
" match as a "string" too
syn region  slrnrcVarStrStr	contained matchgroup=slrnrcVarStr start=+"+ end=+"+ contains=slrnrcVarStr,slrnrcSpaceError

" various commands
syn region slrnrcCmdLine	matchgroup=slrnrcCmd start="^\s*\(autobaud\|grouplens_add\|hostname\|ignore_quotes\|include\|interpret\|nnrpaccess\|scorefile\|server\)\>" end="$" contains=slrnrc\(String\|Comment\) transparent oneline

" setting variables
syn keyword slrnrcSet		contained set
syn match   slrnrcSetStr	"^\s*set\s\+\S\+\s\+" nextgroup=slrnrcString contains=slrnrcSet,slrnrcVarStr\(Str\)\=
syn match   slrnrcSetInt	contained "^\s*set\s\+\S\+" contains=slrnrcSet,slrnrcVarInt\(Str\)\=
syn match   slrnrcSetIntLine	"^\s*set\s\+\S\+\s\+\(-\=[0-9]\+\>\|'[^']\+'\)" contains=slrnrcSetInt,slrnrcNumber,slrnrcVarInt

" color definitions
syn keyword slrnrcColorObj	contained article author box cursor description error frame
syn keyword slrnrcColorObj	contained group grouplens_display header_name header_number
syn keyword slrnrcColorObj	contained headers high_score menu menu_press normal quotes
syn keyword slrnrcColorObj	contained response_char selection signature status subject
syn keyword slrnrcColorObj	contained thread_number tilde tree
syn region  slrnrcColorObjStr	contained matchgroup=slrnrcColorObj start=+"+ end=+"+ contains=slrnrcColorObj,slrnrcSpaceError oneline
syn keyword slrnrcColorVal	contained black red green brown blue magenta cyan lightgray
syn keyword slrnrcColorVal	contained gray brightred brightgreen yellow brightblue brightmagenta brightcyan white
syn region  slrnrcColorValStr	contained matchgroup=slrnrcColorVal start=+"+ end=+"+ contains=slrnrcColorVal,slrnrcSpaceError oneline
" mathcing a function with three arguments
syn keyword slrnrcColor		contained color	
syn match   slrnrcColorInit	contained "^\s*color\s\+\S\+" skipwhite nextgroup=slrnrcColorVal\(Str\)\= contains=slrnrcColor\(Obj\|ObjStr\)\=
syn match   slrnrcColorLine	"^\s*color\s\+\S\+\s\+\S\+\s\+" nextgroup=slrnrcColorVal\(Str\)\= contains=slrnrcColor\(Init\|Val\|ValStr\)

" mono settings
syn keyword slrnrcMonoVal	contained blink bold none reverse underline
syn region  slrnrcMonoValStr	contained matchgroup=slrnrcMonoVal start=+"+ end=+"+ contains=slrnrcMonoVal,slrnrcSpaceError oneline
" color object is inherited
" mono needs at least one argument
syn keyword slrnrcMono		contained mono 
syn match   slrnrcMonoInit	contained "^\s*mono\s\+\S\+" contains=slrnrcMono,slrnrcColorObj\(Str\)\=
syn match   slrnrcMonoLine	"^\s*mono\s\+\S\+\s\+\S.*" contains=slrnrcMono\(Init\|Val\|ValStr\),slrnrcComment

" Functions in article mode
syn keyword slrnrcFunArt	contained art_bob art_eob art_xpunge article_linedn article_lineup
syn keyword slrnrcFunArt	contained article_pagedn article_pageup article_search
syn keyword slrnrcFunArt	contained author_search_backward author_search_forward browse_url
syn keyword slrnrcFunArt	contained cancel catchup catchup_all create_score decode delete
syn keyword slrnrcFunArt	contained delete_thread digit_arg down enlarge_window exchange_mark
syn keyword slrnrcFunArt	contained fast_quit followup forward forward_digest
syn keyword slrnrcFunArt	contained get_children_headers get_parent_header goto_article
syn keyword slrnrcFunArt	contained goto_beginning goto_end goto_last_read
syn keyword slrnrcFunArt	contained grouplens_rate_article header_bob header_eob help
syn keyword slrnrcFunArt	contained hide_article left locate_article locate_header_by_msgid
syn keyword slrnrcFunArt	contained mark_spot next next_high_score next_same_subject pagedn
syn keyword slrnrcFunArt	contained pageup pipe_article post post_postponed prev quit redraw
syn keyword slrnrcFunArt	contained repeat_last_key reply right save scroll_dn scroll_up
syn keyword slrnrcFunArt	contained show_spoilers shrink_window skip_quotes
syn keyword slrnrcFunArt	contained skip_to_next_group skip_to_prev_group
syn keyword slrnrcFunArt	contained subject_search_backward subject_search_forward suspend
syn keyword slrnrcFunArt	contained tag_header toggle_collapse_threads toggle_header_tag
syn keyword slrnrcFunArt	contained toggle_headers toggle_quotes toggle_rot13
syn keyword slrnrcFunArt	contained toggle_show_author toggle_sort uncatchup uncatchup_all
syn keyword slrnrcFunArt	contained undelete untag_headers up wrap_article

" Functions in group mode
syn keyword slrnrcFunGroup	contained add_group bob catchup digit_arg down eob group_bob
syn keyword slrnrcFunGroup	contained group_eob group_search group_search_forward help
syn keyword slrnrcFunGroup	contained move_group pagedown pageup post post_postponed quit
syn keyword slrnrcFunGroup	contained redraw refresh_groups repeat_last_key save_newsrc
syn keyword slrnrcFunGroup	contained select_group subscribe suspend toggle_group_display
syn keyword slrnrcFunGroup	contained toggle_hidden toggle_list_all toggle_scoring
syn keyword slrnrcFunGroup	contained transpose_groups uncatch_up unsubscribe up

" Functions in readline mode (actually from slang's slrline.c)
syn keyword slrnrcFunReadline	contained bdel bol del deleol down enter eol left
syn keyword slrnrcFunReadline	contained quoted_insert right self_insert trim up

" key bindings
syn keyword slrnrcSetkey	contained setkey
syn match   slrnrcSetkeyArt	'^\s*setkey\s\+\("\)\=article\1\s\+\S\+\s\+' nextgroup=slrnrcKey contains=slrnrcSetkey,slrnrcFunArt
syn match   slrnrcSetkeyGroup	'^\s*setkey\s\+\("\)\=group\1\s\+\S\+\s\+' nextgroup=slrnrcKey contains=slrnrcSetkey,slrnrcFunGroup
syn match   slrnrcSetkeyReadline	'^\s*setkey\s\+\("\)\=readline\1\s\+\S\+\s\+' nextgroup=slrnrcKey contains=slrnrcSetkey,slrnrcFunReadline

" unbinding keys
syn keyword slrnrcUnsetkey	contained unsetkey
syn match   slrnrcUnsetkeyLine	'^\s*unsetkey\s\+\(article\|group\|readline\)\s\+' nextgroup=slrnrcKey contains=slrnrcUnsetkey
syn match   slrnrcUnsetkeyLine	'^\s*unsetkey\s\+"\(article\|group\|readline\)"\s\+' nextgroup=slrnrcKey contains=slrnrcUnsetkey

" uncomment these lines and the linking below to get these highlighted
"syn keyword slrnrcObsolete	ccfollowup_string decode_directory editor_command followup 
"syn keyword slrnrcObsolete	organization quote_string realname replyto signature username

if !exists("did_slrnrc_syntax_inits")
  let did_slrnrc_syntax_inits = 1
  " The default methods for highlighting.  Can be overridden later
  hi link slrnrcTodo		Todo
  hi link slrnrcSpaceError	Error
  hi link slrnrcNumber		Number
  hi link slrnrcSpecKey		SpecialChar
  hi link slrnrcKey		String
  hi link slrnrcSpecChar	SpecialChar
  hi link slrnrcString		String
  hi link slrnrcIf		Special
  hi link slrnrcComment		Comment
  hi link slrnrcVarInt		Identifier
  hi link slrnrcVarStr		Identifier
  hi link slrnrcCmd		slrnrcSet
  hi link slrnrcSet		Operator
  hi link slrnrcColor		Keyword
  hi link slrnrcColorObj	Identifier
  hi link slrnrcColorVal	String
  hi link slrnrcMono		Keyword
  hi link slrnrcMonoObj		Identifier
  hi link slrnrcMonoVal		String
  hi link slrnrcFunArt		Macro
  hi link slrnrcFunGroup	Macro
  hi link slrnrcFunReadline	Macro
  hi link slrnrcSetkey		Keyword
  hi link slrnrcSetkeyArt	Identifier
  hi link slrnrcSetkeyGroup	Identifier
  hi link slrnrcSetkeyReadline	Identifier
  hi link slrnrcUnsetkey	Keyword
  hi link slrnrcUnsetkeyLine	Identifier

  "hi link slrnrcObsolete	Special
endif

let b:current_syntax = "slrnrc"

"EOF	vim: ts=8 noet tw=120 sw=8 sts=0
