/* vi:set ts=4 sw=4:
 *
 * VIM - Vi IMproved		by Bram Moolenaar
 *                OS/2 port by Paul Slootman
 *
 * Do ":help uganda"  in Vim to read copying and usage conditions.
 * Do ":help credits" in Vim to see a list of people who contributed.
 */

/*
 * unix.c -- code for all flavors of Unix (BSD, SYSV, SVR4, POSIX, ...)
 *           Also for OS/2, using the excellent EMX package!!!
 *
 * A lot of this file was originally written by Juergen Weigert and later
 * changed beyond recognition.
 */

#include "vim.h"
#include "globals.h"
#include "option.h"
#include "proto.h"
#include <unistd.h>
#include <signal.h>
#include <errno.h>
#include <stdio.h>

#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif

#include <Memory.h>
#include <OSUtils.h>
#include <Files.h>

/*#include "unixunix.h"	*/	/* unix includes for unix.c only */

#define FL_CHUNK 50
#define USE_GETCWD
#define HAVE_STRERROR

typedef struct filelist
{
	char_u	**file;
	int		nfiles;
	int		maxfiles;
} FileList;

/*
 * Recursively build up a list of files in "gap" matching the first wildcard
 * in `path'.  Called by expand_wildcards().
 */
    int
mch_expandpath(
    struct growarray	*gap,
    char_u		*path,
    int			flags)
{
/*    char	    buf[_MAX_PATH];
    char	   *p,
		   *s,
		   *e;
    int		    start_len,
		    c = 1;
/*    WIN32_FIND_DATA fb;
    HANDLE	    hFind;*/
/*    int		    matches;

    CInfoPBRec	    theCPB;

    theCPB.dirInfo.ioNamePtr = path; /* AS pascal gosh*/
/*    theCPB.dirInfo.ioVRefNum = 0;
    theCPB.dirInfo.ioFDirIndex = 0;
    theCPB.dirInfo.io.DRDirID = 0;
    
    /* (void) PBGetCatInfo (&theCPB, false); */
    
/*    start_len = gap->ga_len;

    /*
     * Find the first part in the path name that contains a wildcard.
     * Copy it into `buf', including the preceding characters.
     */
/*    p = buf;
    s = NULL;
    e = NULL;
    while (*path)
    {
	if (*path == '\\' || *path == ':' || *path == '/')
	{
	    if (e)
		break;
	    else
		s = p;
	}
	if (*path == '*' || *path == '?')
	    e = p;
	*p++ = *path++;
    }
    e = p;
    if (s)
	s++;
    else
	s = buf;

    /* now we have one wildcard component between `s' and `e' */
/*    *e = NUL;

    /* If we are expanding wildcards, we try both files and directories *//*
    if ((hFind = FindFirstFile(buf, &fb)) != INVALID_HANDLE_VALUE)
/*	while (c)
	{
	    strlowcpy(s, fb.cFileName);

	    /*
	     * Ignore "." and "..".
	     * When more follows, this must be a directory.
	     */
/*	    if ((s[0] != '.' 
			|| (s[1] != NUL  &&  (s[1] != '.' || s[2] != NUL)))
		    && (*path == NUL || mch_isdir(buf)))
	    {
		strcat(buf, path);
		if (mch_has_wildcard(path))	    /* handle more wildcards */
/*		    (void)mch_expandpath(gap, buf, flags);
/*		else if (mch_getperm(buf) >= 0)	    /* add existing file */
/*		    addfile(gap, buf, flags);
	    }

	    c = FindNextFile(hFind, &fb);
	}
    FindClose(hFind);

    matches = gap->ga_len - start_len;
    if (matches)
	qsort(((char_u **)gap->ga_data) + start_len, matches,
						     sizeof(char *), pstrcmp);
    return matches;*/
    return FALSE;
}


int vim_chdir (char *x)
{
  return (chdir (x));
}

int vim_remove (unsigned char * x)
{
  return (unlink((char *)x));
}

void fname_case (char_u *name) /*OK*/ 
{
 /* no case to change to find or save file, but better on read to give back the true case*/
    slash_n_colon_adjust(name);
    /* TODO: find real case*/
}

/*
 * end of autoconf section. To be extended...
 */


static int	WaitForChar __ARGS((long));
static int	RealWaitForChar __ARGS((int, long));

static int		do_resize = FALSE;
static char_u	*oldtitle = NULL;
static char_u	*fixedtitle = (char_u *)"Thanks for flying Vim";
static char_u	*oldicon = NULL;
#ifndef __EMX__
static char_u	*extra_shell_arg = NULL;
static int		show_shell_mess = TRUE;
#endif
static int		deadly_signal = 0;			/* The signal we caught */

/*
 * check for an "interrupt signal": CTRL-break or CTRL-C
 */
	void
mch_breakcheck()
{
/*	if (g_fCtrlCPressed || g_fCBrkPressed)
	{
		g_fCtrlCPressed = g_fCBrkPressed = FALSE;
		got_int = TRUE;
	}*/
}

	long_u
mch_avail_mem(special)
	int special;
{
	long	temp;
	
	temp = MaxBlock();
	return 0x7fffffff;
	/* See FreeMem (on heap), PurgeSpace(), MaxBlockSys (on the Heap) */
	/* page 266 of Q&A */
 	/*return 0x7fffffff;*/		/* virtual memory eh */
}

	void
mch_delay(msec, ignoreinput) 
	long		msec;
	int			ignoreinput;
{
	long	finalTick;
	
	if (ignoreinput)
		Delay (60*msec/1000, &finalTick);
	else
		/* even thougth we should call gui stuff from here
		  it the simplest way to be safe */
		gui_mch_wait_for_chars(msec);
}

	void
mch_windinit()
{
	Columns = 80;
	Rows = 24;
}

/*
 * Check_win checks whether we have an interactive stdout.
 */
	int
mch_check_win(argc, argv)
	int		argc;
	char	**argv;
{
	/* Of course, that a Mac */
	return OK;
}

/*
 * Return TRUE if the input comes from a terminal, FALSE otherwise.
 */
	int
mch_input_isatty()
{
	/* Of course, that a Mac */
	return OK;
}



/*
 * Set the window title and icon.
 * (The icon is not taken care of).
 */
	void
mch_settitle(title, icon)
	char_u *title;
	char_u *icon;
{
	char_u   pascal_title[1024];
	
	if (title == NULL)		/* nothing to do */
		return;

	if (title != NULL)
	{
		pascal_title[0] = (char_u) STRLEN(title);
		pascal_title[1] = 0;
		STRCAT (&pascal_title, title);	
		SetWTitle(gui.VimWindow, (char_u *) &pascal_title);
	}
}

/*
 * Restore the window/icon title.
 * which is one of:
 *	1  Just restore title
 *  2  Just restore icon
 *	3  Restore title and icon
 */
	void
mch_restore_title(which)
	int which;
{
	mch_settitle((which & 1) ? oldtitle : NULL, (which & 2) ? oldicon : NULL);
}

/*
 * Insert user name in s[len].
 * Return OK if a name found.
 */
	int
mch_get_user_name(s, len)
	char_u	*s;
	int		len;
{
#if defined(HAVE_PWD_H) && defined(HAVE_GETPWUID)
	struct passwd	*pw;
#endif
	uid_t			uid;

	uid = getuid();
#if defined(HAVE_PWD_H) && defined(HAVE_GETPWUID)
	if ((pw = getpwuid(uid)) != NULL &&
								 pw->pw_name != NULL && *(pw->pw_name) != NUL)
	{
		STRNCPY(s, pw->pw_name, len);
		return OK;
	}
#endif
	sprintf((char *)s, "%d", (int)uid);		/* assumes s is long enough */
	return FAIL;							/* a number is not a name */
}

/*
 * Insert host name is s[len].
 */

#ifdef HAVE_SYS_UTSNAME_H
	void
mch_get_host_name(s, len)
	char_u	*s;
	int		len;
{
    struct utsname vutsname;

    uname(&vutsname);
    STRNCPY(s, vutsname.nodename, len);
}
#else /* HAVE_SYS_UTSNAME_H */

# ifdef HAVE_SYS_SYSTEMINFO_H
#  define gethostname(nam, len) sysinfo(SI_HOSTNAME, nam, len)
# endif

	void
mch_get_host_name(s, len)
	char_u	*s;
	int		len;
{
/*	gethostname((char *)s, len);*/
}
#endif /* HAVE_SYS_UTSNAME_H */

/*
 * return process ID
 */
	long
mch_get_pid()
{
	return (long)getpid();
}

#if !defined(HAVE_STRERROR) && defined(USE_GETCWD)
static char *strerror __ARGS((int));

	static char *
strerror(err)
	int err;
{
	extern int		sys_nerr;
	extern char		*sys_errlist[];
	static char		er[20];

	if (err > 0 && err < sys_nerr)
		return (sys_errlist[err]);
	sprintf(er, "Error %d", err);
	return er;
}
#endif

/*
 * Get name of current directory into buffer 'buf' of length 'len' bytes.
 * Return OK for success, FAIL for failure.
 */
	int 
mch_dirname(buf, len)
	char_u	*buf;
	int		len;
{
    /* Include last: */
    if (getcwd((char *)buf, len) == NULL)
	{
	    STRCPY(buf, strerror(errno));
	    return FAIL;
	}
    return OK;
}

	void
slash_n_colon_adjust (buf)
	char_u *buf;
{
	char_u	temp[MAXPATHL];
	char_u   *dot;
	char_u   *slash;
	char_u   *searching;
	
	temp[0] = 0;
	
	if (mch_isFullName (buf)) 
	{
	    if (buf[0] == '/')
		STRCAT (temp, &buf[1]);
	    else
		STRCAT (temp, buf);
	}
	else
	{
	    if (buf[0] != ':')
	    {
		temp[0] = ':';
		temp[1] = 0;
		STRCAT (temp, buf);
	    }
	    else
	    	STRCAT (temp, buf);
	}
	
	searching = temp;
	
	while (searching != NULL)
	{
	    dot = vim_strchr (searching, '.');
	    slash = vim_strchr(searching, '/');
	    
	    if (dot+1 == slash)
	    {
	    	dot[0] = 0;
	    	STRCAT (dot, slash+1);
	    	searching = dot;
	    }
	    else if ((dot+2 == slash) && (dot[1] == '.'))
	    {
	    	dot[0] = ':';
	    	dot[1] = 0;
	    	STRCAT (dot, slash+1);
	    	searching = dot;
	    }
	    else if (slash != NULL)
	    {
	    	slash[0] = ':';
	    	searching = slash;
	    }
	    else if (dot != NULL)
	    {
	    	searching = dot+1;
	    }
	    else 
	    {
	    	searching = NULL;
	    }
	}
	buf[0] = 0;
	STRCAT (buf, temp);
	
}

/*
 * Get absolute filename into buffer 'buf' of length 'len' bytes.
 *
 * return FAIL for failure, OK for success
 */
	int 
mch_FullName(fname, buf, len, force)
	char_u *fname, *buf;
	int len;
	int	force;			/* also expand when already absolute path name */
{
	int		l;
	char_u	olddir[MAXPATHL];
	char_u   newdir[MAXPATHL];
	char_u	*p;
	char_u	c;
	int		retval = OK;

	if (fname == NULL)	/* always fail */
	{
		*buf = NUL;
		return FAIL;
	}

	*buf = 0;
	if (force || !mch_isFullName(fname))	/* if forced or not an absolute path */
	{
		/*
		 * If the file name has a path, change to that directory for a moment,
		 * and then do the getwd() (and get back to where we were).
		 * This will get the correct path name with "../" things.
		 */
		
		STRCAT(buf, fname);
		slash_n_colon_adjust (buf);
		fname[0] = 0;
		STRCAT(fname, buf);
		
		if ((p = vim_strrchr(fname, ':')) != NULL)
		{
			if (mch_dirname(olddir, MAXPATHL) == FAIL)
			{
				p = NULL;		/* can't get current dir: don't chdir */
				retval = FAIL;
			}
			else
			{
				c = *p;
				*p = NUL;
				if (vim_chdir((char *)fname))
					retval = FAIL;
				else
					fname = p + 1;
				*p = c;
			}
		}
		if (mch_dirname(buf, len) == FAIL)
		{
			retval = FAIL;
			*newdir = NUL;
		}
		l = STRLEN(buf);
		if (l && buf[l - 1] != ':') /*MAC*/
			STRCAT(buf, ":");
		if (p != NULL)
		{
				vim_chdir((char *)olddir);
		}
	}
	else
	{
		STRCAT(buf, fname);
		slash_n_colon_adjust (buf);
		fname[0] = 0;
		STRCAT(fname, buf);
		buf[0] = 0;
	}
	STRCAT(buf, fname);
	slash_adjust(buf);
	return retval;
}

/*
 * return TRUE is fname is an absolute path name
 */
	int
mch_isFullName(fname)
	char_u		*fname;
{
	char_u	*first_colon = vim_strchr(fname, ':');
	char_u	*first_slash = vim_strchr(fname, '/');
	
	if (first_colon == fname)
	  return FALSE;
	if (first_slash == fname)
	  return TRUE;
	if ((first_colon < first_slash) && (first_colon != NULL))
	  return TRUE;
	if ((first_slash < first_colon) && (first_slash != NULL))
	  return FALSE;
	if ((first_colon == NULL) && (first_slash != NULL))
	  return FALSE;
	if ((first_slash == NULL) && (first_colon != NULL))
	  return TRUE;
	if ((first_colon == NULL) && (first_slash == NULL))
	  return FALSE;
	return TRUE;
}

/*
 * Replace all slashes by backslashes.
 * This used to be the other way around, but MS-DOS sometimes has problems
 * with slashes (e.g. in a command name).  We can't have mixed slashes and
 * backslashes, because comparing file names will not work correctly.  The
 * commands that use a file name should try to avoid the need to type a
 * backslash twice.
 */
    void
slash_adjust(p)
    char_u  *p;
{
    while (*p)
    {
	if (*p == '/')
	    *p = ':';
	++p;
    }
}

/*
 * get file permissions for 'name'
 */
	long 
mch_getperm(name)
	char_u *name;
{
	struct stat statb;

	if (stat((char *)name, &statb))
		return -1;
	return statb.st_mode;
}

/*
 * set file permission for 'name' to 'perm'
 *
 * return FAIL for failure, OK otherwise
 */
	int
mch_setperm(name, perm)
	char_u *name;
	int perm;
{
	/* return (chmod((char *)name, (mode_t)perm) == 0 ? OK : FAIL);*/
	return (OK);
}

/*
 * Set hidden flag for "name".
 */
    void
mch_hide(char_u *name)
{
/*    int	perm;

    perm = GetFileAttributes((char *)name);
    if (perm >= 0)
    {
	perm |= FILE_ATTRIBUTE_HIDDEN;
	SetFileAttributes((char *)name, perm);
    }*/
}


/*
 * return TRUE if "name" is a directory
 * return FALSE if "name" is not a directory
 * return FALSE for error
 */
	int 
mch_isdir(name)
	char_u *name;
{
	struct stat statb;

	if (stat((char *)name, &statb))
		return FALSE;
#ifdef _POSIX_SOURCE
	return (S_ISDIR(statb.st_mode) ? TRUE : FALSE);
#else
	return ((statb.st_mode & S_IFMT) == S_IFDIR ? TRUE : FALSE);
#endif
}

	void
mch_windexit(r)
	int r;
{
	mch_display_error();
	
	ml_close_all(TRUE); 				/* remove all memfiles */
#ifdef USE_GUI
	if (gui.in_use)
		gui_exit(r);
#endif
	exit(r);
}

static int curr_tmode = TMODE_COOK;		/* contains current terminal mode */

	void
mch_settmode(tmode)
	int				tmode;
{

}

#ifdef USE_MOUSE
/*
 * set mouse clicks on or off (only works for xterms)
 */
	void
mch_setmouse(on)
	int		on;
{
}
#endif

/*
 * set screen mode, always fails.
 */
	int
mch_screenmode(arg)
	char_u	 *arg;
{
	EMSG("Screen mode setting not supported");
	return FAIL;
}

	int 
mch_call_shell(cmd, options)
	char_u	*cmd;
	int		options;		/* SHELL_FILTER if called by do_filter() */
					/* SHELL_COOKED if term needs cooked mode */
{
	return(0);
}

	int
mch_has_wildcard(p)
	char_u	*p;
{
	for ( ; *p; ++p)
	{
		if (*p == '\\' && p[1] != NUL)
			++p;
		else if (vim_strchr((char_u *)"*?[{`~$", *p) != NULL)
			return TRUE;
	}
	return FALSE;
}

#ifndef HAVE_RENAME
/*
 * Scaled-down version of rename, which is missing in Xenix.
 * This version can only move regular files and will fail if the
 * destination exists.
 */
	int
rename(src, dest)
	/*const*/ char *src, *dest;
{
	struct stat		st;

	if (stat(dest, &st) >= 0)		/* fail if destination exists */
		return -1;
/*	if (link(src, dest) != 0)	*/	/* link file to new name */
/*		return -1;*/
	if (vim_remove((unsigned char *) src) == 0)		/* delete link to old name */
		return 0;
	return -1;
}
#endif /* !HAVE_RENAME */

