/**********************************************************************

File:		 signal_callbacks.c
Developer:	 Hoang Tran
Description:	 implementation file.


Copyright (c) 2000 Hoang M. Tran
htran@darkwing.uoregon.edu

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**********************************************************************/
#include "signal_callbacks.h"
#include "lists.h"
#include "listeners.h"
#include "mnet.h"
#include "rtp.h"
#include "queue.h"
#include <pthread.h>
#include <signal.h>

extern node *list_head,*list_tail;
extern node *list2_head,*list2_tail;
void write_cache();
GtkWidget *draw_dialog(char *title,char *contact,char *data);

void *vid_listen();
void *aud_listen();

static struct {
  u_int32 diff;
  u_int32 abase;
  u_int32 vbase;
  u_int32 prev_video_ts;
  u_int32 curr_video_ts;
  u_int32 prev_audio_ts;
  u_int32 curr_audio_ts;
  u_int32 master_ts;
  u_int32 low;
  u_int32 high;
}rtp_stats={0,0,0,0,0,0,0,0,0};
 
FILE *vout, *aout;
int showing_video=0;
pthread_t video_thread,audio_thread;
static int rtp,rtcp;
static int srtp,srtcp;
static GtkWidget *zoom_toggle, *audio_check, *video_check;
static GtkWidget *video;
char *vaddr,*vport,*saddr,*sport;
int video_port,audio_port;

void *MPGBone();


void shutdown_socks(){
  if(rtp)
    if( close(rtp)< 0 ) perror("close(rtp)");
  if(rtcp) 
    if(close(rtcp) <0) perror("close(rtcp)");
  if(srtp)
    if(close(srtp)<0) perror("close(srtp)");
  if(srtcp)
    if(close(srtcp)<0) perror("close(srtcp)");  
}


void quit_button_clicked(GtkWidget *w, gpointer data){
  write_cache();
  //shutdown_socks();
  gtk_main_quit();
}
void disable_component(GtkWidget *w, gpointer data){
  GtkWidget *gw=(GtkWidget *)data;
  gtk_widget_set_state(gw, GTK_STATE_INSENSITIVE);
}

void enable_component(GtkWidget *w, gpointer data){
  GtkWidget *gw=(GtkWidget *)data;
  gtk_widget_set_sensitive(gw,1); 
}
void help_button_clicked(GtkWidget *w, gpointer data){
  GtkWidget *dialog, *label, *dismiss_button;
  
  dialog = gtk_dialog_new();
  gtk_window_set_title(GTK_WINDOW(dialog),"Welcome to Help");
  gtk_window_set_default_size(GTK_WINDOW(dialog),300,100);
  dismiss_button = gtk_button_new_with_label("Done");
  
  gtk_signal_connect_object(GTK_OBJECT (dismiss_button), "clicked",
			    GTK_SIGNAL_FUNC (gtk_widget_destroy), 
			    GTK_OBJECT(dialog));
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),
		     dismiss_button);
  
  label=gtk_label_new("Sorry that I cannot help you at this stage of the development you're on your own.\n\n\n\n\nDeveloped by: Hoang Tran\nUniversity of Oregon\nInspired by: rsdr\n");
  gtk_label_set_line_wrap(GTK_LABEL(label),TRUE);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		     label,FALSE,FALSE,0);
  
  
  gtk_widget_show_all(dialog);
}

void dismiss_button_clicked(GtkWidget *w, gpointer data){ 
  showing_video=0;
}

void stop_button_clicked(GtkWidget *w, gpointer data){
  GtkWidget *dismiss_button=(GtkWidget *)data;
  showing_video=0;
  if(audio_thread){
    pthread_join(audio_thread,NULL);
    fprintf(stderr,"returned from audio done\n");
  }
  if(video_thread){
    pthread_join(video_thread,NULL);  
    fprintf(stderr,"return from video done\n");
  }
  sleep(1);
  //shutdown_socks();
  gtk_widget_set_sensitive(dismiss_button,1);
  gtk_widget_set_sensitive(video,1);
}

void more_info_button_clicked(GtkWidget *w, gpointer data){
  GtkWidget *dialog, *textbox, *okay_button;
  GtkWidget *vscrollbar, *hbox;
  
  dialog = gtk_dialog_new();
  gtk_window_set_title(GTK_WINDOW(dialog),"More Information");
  gtk_window_set_default_size(GTK_WINDOW(dialog),400,100);
  //label = gtk_label_new (title);
  okay_button = gtk_button_new_with_label("Dismiss");
  /* Ensure that the dialog box is destroyed when the user clicks ok. */
  gtk_signal_connect_object(GTK_OBJECT (okay_button), "clicked",
			    GTK_SIGNAL_FUNC (gtk_widget_destroy), 
			    GTK_OBJECT(dialog));

  gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),
		     okay_button);
  
  textbox=gtk_text_new(NULL,NULL);
  gtk_text_set_editable(GTK_TEXT(textbox),FALSE);
  gtk_text_set_word_wrap(GTK_TEXT(textbox),TRUE);
  
  
  
  /* horizontal box for text box and scroll bar */
  hbox=gtk_hbox_new(FALSE,0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),hbox,TRUE,TRUE,0);
  textbox=gtk_text_new(NULL,NULL);
  gtk_text_set_editable(GTK_TEXT(textbox),FALSE);
  gtk_text_set_word_wrap(GTK_TEXT(textbox),TRUE);
  gtk_box_pack_start(GTK_BOX(hbox),textbox,TRUE,TRUE,0);
  vscrollbar=gtk_vscrollbar_new (GTK_TEXT(textbox)->vadj);
  
  gtk_box_pack_start(GTK_BOX(hbox), vscrollbar, FALSE, FALSE, 0);
  gtk_text_insert(GTK_TEXT(textbox),NULL,NULL,
		  NULL,data,-1);
  gtk_widget_show (vscrollbar);
  
  
  
  gtk_widget_show_all(dialog);
}

void selection_made(GtkWidget *clist, gint row, gint column,
		    GdkEventButton *event, gpointer data){
  GtkWidget *dialog;
  node *this=NULL;
  gchar *text;
  char *duplicate=NULL;
  char *temp=NULL;
  char *name=(char *)malloc(sizeof(char));
  char *phone=(char *)malloc(sizeof(char));
  
  
  gtk_clist_get_text(GTK_CLIST(clist),row,0,&text);
  
  gtk_clist_unselect_all(GTK_CLIST(clist));
  
  //gtk_widget_set_state(clist,GTK_STATE_INSENSITIVE);
  
  
  
  if( (this=find_node_byname(list_head,text))!=NULL ){    
    /* get contact name and phone to make dialog widget */
    duplicate=(char *)strdup(this->data);
    temp=(char *)strtok(duplicate,"=\n");
    temp=(char *)strtok(NULL,"=\n");
    while( temp!=NULL ){
      if( strcmp(temp,"e")==0 )
	name=(char *)strtok(NULL,"=\n");
      if( strcmp(temp,"p")==0 )
	phone=(char *)strtok(NULL,"=\n");
      temp=(char *)strtok(NULL,"=\n");
    }
    
    
    if(phone!=NULL){
      temp=(char *)realloc(temp,sizeof(char)*
			   (strlen(name)+strlen(phone)+11+
			    (strlen("Contact Info"))) );
      sprintf(temp,"Contact Info\n%s\n%s",name,phone);
    }
    else{
      if(name!=NULL){
	temp=(char *)realloc(temp,sizeof(char)*
			     (strlen(name)+5+(strlen("Contact Info"))));
	sprintf(temp,"Contact Info\n%s",name);
      }
      else {
	temp=(char *)realloc(temp,sizeof(char)*
			     (5+(strlen("No Contact Info"))));
	sprintf(temp, "No Contact Info");
      }
	
    }
    
    dialog=draw_dialog(text,temp,this->data);
    gtk_widget_show_all (dialog);
  }
  else
    ;   
}

void selection_made_others(GtkWidget *clist, gint row, gint column,
			   GdkEventButton *event, gpointer data){
  GtkWidget *dialog;
  node *this=NULL;
  gchar *text;
  char *duplicate=NULL;
  char *temp=NULL;
  char *name=(char *)malloc(sizeof(char));
  char *phone=(char *)malloc(sizeof(char));
  
  
  gtk_clist_get_text(GTK_CLIST(clist),row,0,&text);
  
  gtk_clist_unselect_all(GTK_CLIST(clist));
  
  //gtk_widget_set_state(clist,GTK_STATE_INSENSITIVE);
  
  if( (this=find_node_byname(list2_head,text))!=NULL ){

    /* get contact name and phone to make dialog widget */
    duplicate=(char *)strdup(this->data);
    temp=(char *)strtok(duplicate,"=\n");
    temp=(char *)strtok(NULL,"=\n");
    while( temp!=NULL ){
      if( strcmp(temp,"e")==0 )
	name=(char *)strtok(NULL,"=\n");
      if( strcmp(temp,"p")==0 )
	phone=(char *)strtok(NULL,"=\n");
      temp=(char *)strtok(NULL,"=\n");
    }
#ifdef FULL_DEBUG
    printf("%s\t%s\n",name,phone);
#endif
    
    if(phone!=NULL){
      temp=(char *)realloc(temp,sizeof(char)*
			   (strlen(name)+strlen(phone)+11+
			    (strlen("Contact Info"))) );
      sprintf(temp,"Contact Info\n%s\n%s",name,phone);
    }
    else{
      temp=(char *)realloc(temp,sizeof(char)*
			   (strlen(name)+5+(strlen("Contact Info"))));
      sprintf(temp,"Contact Info\n%s",name);
    }
    
    dialog=draw_dialog(text,temp,this->data);
    gtk_widget_show_all (dialog);
  }
  else
    ;   
}

void write_cache(){
  FILE *fpout;
  node *current=NULL;
  int i=0;
  
  char *home=(char *)getenv("HOME");
  if(home==NULL)
    fprintf(stderr,"$HOME not defined, cannot write cached entries.\n\n");
  else
    {
      printf("Writing cache files...\n");
      system("rm -rf ~/.mim/cache/*");
	 	 
      for(current=list_head;current!=NULL;current=current->next){
	char filename[20];
	char fullpath[40];
	   
	strcpy(fullpath,home);
	strcat(fullpath,"/.mim/cache/");
	sprintf(filename,"0000%x",i);
	strcat(fullpath,filename);
	   
	fpout=fopen(fullpath,"w");
	if(fpout==NULL){
	  perror("fopen");
	}
	else{
	  fprintf(fpout,"%s",current->data);
	}
	fclose(fpout);
	   
	i++;
      }
	 
    }
}

GtkWidget *draw_dialog(char *title,char *contact,char *data){
  GtkWidget *dismiss_button;
  GtkWidget *dialog, *label;
  GtkWidget *hbox,*textbox,*vscrollbar,*frame;
  GtkWidget *stop,*muted;
  GtkWidget *more_info;
  GtkWidget *frame_vbox;
  char *info;
  char *temp;
  unsigned int IDKey;
  
  dialog = gtk_dialog_new();
  gtk_window_set_title(GTK_WINDOW(dialog),title);
  gtk_window_set_default_size(GTK_WINDOW(dialog),400,100);
  label = gtk_label_new (title);
  dismiss_button = gtk_button_new_with_label("Dismiss");
  /* Ensure that the dialog box is destroyed when the user clicks ok. */
  
  
  //if(!showing_video){
  // gtk_signal_connect(GTK_OBJECT (dismiss_button), "clicked",
  //GTK_SIGNAL_FUNC (dismiss_button_clicked),
  //	       NULL);
  //  gtk_signal_connect_object_after(GTK_OBJECT (dismiss_button), "clicked",
  //			    GTK_SIGNAL_FUNC (gtk_widget_destroy),
  //			    GTK_OBJECT(dialog));
  //}
  //else {
    
  gtk_signal_connect_object(GTK_OBJECT (dismiss_button), "clicked",
			    GTK_SIGNAL_FUNC (gtk_widget_destroy),
			    GTK_OBJECT(dialog));
  // }
  
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),
		     dismiss_button);
  
  stop=gtk_button_new_with_label("Stop");
  if(!showing_video){
    gtk_signal_connect(GTK_OBJECT (stop), "clicked",
		       GTK_SIGNAL_FUNC (stop_button_clicked),dismiss_button);
  }
  else{
    gtk_widget_set_state(stop, GTK_STATE_INSENSITIVE);
  }
  
  /* TO HERE */
  gtk_container_add(GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),
		    stop);
  

  
  video=gtk_button_new_with_label("Play");
  if(!showing_video){
    gtk_signal_connect(GTK_OBJECT (video), "clicked",
		       GTK_SIGNAL_FUNC (disable_component),dismiss_button);
    gtk_signal_connect(GTK_OBJECT (video), "clicked",
		       GTK_SIGNAL_FUNC (disable_component),video);
    gtk_signal_connect_after(GTK_OBJECT (video), "clicked",
			     GTK_SIGNAL_FUNC (launch_video_audio),data);    
  }
  else
    gtk_widget_set_state(video, GTK_STATE_INSENSITIVE);
  
  gtk_container_add(GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),
		    video);

  /*
    muted=gtk_button_new_with_label("Play Muted");
    if(!showing_video)
    gtk_signal_connect(GTK_OBJECT (muted), "clicked",
    GTK_SIGNAL_FUNC (launch_video_muted),data);
    else
    gtk_widget_set_state(muted, GTK_STATE_INSENSITIVE);
    gtk_container_add(GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),
    muted);
  */
  
  audio_check=gtk_check_button_new_with_label("Audio");
  gtk_container_add(GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),
		    audio_check);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(audio_check),1);
  
  
  video_check=gtk_check_button_new_with_label("Video");
  gtk_container_add(GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),
		    video_check);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(video_check),1);
			       

  zoom_toggle=gtk_check_button_new_with_label("Zoom");
  gtk_container_add(GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),
		    zoom_toggle);
  if(showing_video){
    gtk_widget_set_state(zoom_toggle, GTK_STATE_INSENSITIVE);
    gtk_widget_set_state(audio_check, GTK_STATE_INSENSITIVE);
    gtk_widget_set_state(video_check, GTK_STATE_INSENSITIVE);
  }
  /* Add the label, and show everything we've added to the dialog. */
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		     label,FALSE,FALSE,0);
	
  
  /* horizontal box for text box and scroll bar */
  hbox=gtk_hbox_new(FALSE,0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),hbox,TRUE,TRUE,0);
  textbox=gtk_text_new(NULL,NULL);
  gtk_text_set_editable(GTK_TEXT(textbox),FALSE);
  gtk_text_set_word_wrap(GTK_TEXT(textbox),TRUE);
  gtk_box_pack_start(GTK_BOX(hbox),textbox,TRUE,TRUE,0);
  vscrollbar=gtk_vscrollbar_new (GTK_TEXT(textbox)->vadj);
  gtk_box_pack_start(GTK_BOX(hbox), vscrollbar, FALSE, FALSE, 0);
  gtk_widget_show (vscrollbar);
  
    
  /* quickie to get the info */
  temp=(char *)strdup(data);
  temp=(char *)strtok(temp,"=\n");
  temp=(char *)strtok(NULL,"=\n");
  while(temp!=NULL){
    if( strcmp(temp,"i")==0 ){
      info=(char *)strtok(NULL,"=\n");
      break;
    }
    temp=(char *)strtok(NULL,"=\n");
  }

  gtk_text_insert(GTK_TEXT(textbox),NULL,NULL,
		  NULL,info,-1);
  
  frame=gtk_frame_new(NULL);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),frame,
		     FALSE,FALSE,0);
  frame_vbox=gtk_vbox_new(FALSE,0);
  gtk_container_add(GTK_CONTAINER(frame),frame_vbox);

  label=gtk_label_new(contact);
  gtk_box_pack_start(GTK_BOX(frame_vbox),label,FALSE,FALSE,0);
  


  more_info=gtk_button_new_with_label("Detailed Information");
  gtk_button_set_relief(GTK_BUTTON(more_info),GTK_RELIEF_NONE);
  gtk_signal_connect(GTK_OBJECT (more_info), "clicked",
		     GTK_SIGNAL_FUNC (more_info_button_clicked),
		     data);
  
  gtk_box_pack_start(GTK_BOX(frame_vbox),more_info,FALSE,FALSE,0);
   
  return dialog;
}

void launch_video_audio(GtkWidget *w, gpointer data){  
    
  char *temp;
  char *temp1,*temp2,*temp3,*temp4;
  char *duplicate;  
  char *this_data=(char *)data;
  int status;
  int s,v;

  s=(int)gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(audio_check));
  v=(int)gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(video_check));
  video_thread=-1;
  audio_thread=-1;
  
  //gtk_widget_set_state(dismiss_button, GTK_STATE_INSENSITIVE);
  
  if(showing_video)
    //printf("Do you REALLY want to start another video window?!?!\n");
    ;
  else{
    duplicate=(char *)strdup(data);
    temp=(char *)strtok(duplicate,"=\n");
    temp=(char *)strtok(NULL,"=\n");
    while( temp!=NULL ){
      if( strcmp(temp,"m")==0 ){
	temp=(char *)strtok(NULL,"=\n");
	if( (char *)strstr(temp,"video")!=NULL ){
	  temp1=(char *)strdup(temp);
	  temp2=(char *)strtok(NULL,"=\n");
	  temp2=(char *)strtok(NULL,"=\n");
	
	}
	else if( (char *)strstr(temp,"audio")!=NULL ){
	  temp3=(char *)strdup(temp);
	  temp4=(char *)strtok(NULL,"=\n");
	  temp4=(char *)strtok(NULL,"=\n");
	
	}
      }
      temp=(char *)strtok(NULL,"=\n");
    }
    vport=(char *)strtok(temp1," ");
    vport=(char *)strtok(NULL," ");
    
    vaddr=(char *)strtok(temp2," ");
    vaddr=(char *)strtok(NULL," ");
    vaddr=(char *)strtok(NULL," ");
    vaddr=(char *)strtok(vaddr,"/");

    sport=(char *)strtok(temp3," ");
    sport=(char *)strtok(NULL," ");
    
    saddr=(char *)strtok(temp4," ");
    saddr=(char *)strtok(NULL," ");
    saddr=(char *)strtok(NULL," ");
    saddr=(char *)strtok(saddr,"/");
    
    fprintf(stderr,"Starting video...\n");
    fprintf(stderr,"Using these parameters: %s %s %s %s\n\n",vaddr,vport,saddr,sport );
    
    video_port=atoi(vport);
    audio_port=atoi(sport);
    showing_video=1;    
    
    status=0;
    if(v){
      if( (rtcp=start_msock(vaddr,video_port+1,1,127,0)) <0 ){
	perror("rtcp:start_msock()");
	status=-1;
      }
      if( (rtp=start_msock(vaddr,video_port,1,127,0)) <0 ){
	perror("rtp:start_msock()");
	status=-1;
      }
    }
    if(s){
      if( (srtcp=start_msock(saddr,audio_port+1,1,127,0)) <0 ){
	perror("rtp:start_msock()");
	status=-1;
      }
      if( (srtp=start_msock(saddr,audio_port,1,127,0)) <0 ){
	perror("rtp:start_msock()");
	status=-1;
      }
    }
    
    if(status!=-1){
      if(v) pthread_create(&video_thread,NULL,vid_listen,NULL);
      if(s) pthread_create(&audio_thread,NULL,aud_listen,NULL);
    }

    fprintf(stderr,"started threads\n");
  }// ends else 
}

char *rtp_write_sdes( char *b, u_int32 src, int argc, 
		      rtcp_sdes_type_t type[], char *value[], int length[]){
  
  rtcp_sdes_t *s = (rtcp_sdes_t *)b;
  rtcp_sdes_item_t *rsp;
  
  
  int i; 
  int len; 
  int pad; 
  
  /* SSRC header */
  s->src = src;
  rsp = &s->item[0];
  
  /* SDES items */
  for (i = 0; i < argc; i++) {
    rsp->type = type[i];
    len = length[i];
    if (len > RTP_MAX_SDES) {
      /* invalid length, may want to take other action */
      len = RTP_MAX_SDES;
    }
    rsp->length = len;
    memcpy(rsp->data, value[i], len);
    rsp = (rtcp_sdes_item_t *)&rsp->data[len];
  }
    
  /* terminate with end marker and pad to next 4-octet boundary */
  len = ((char *) rsp) - b;
  pad = 4 - (len & 0x3);
  b = (char *) rsp;
  while (pad--) *b++ = RTCP_SDES_END;
    
  return b; 
} 

void *vid_listen(){
  rtp_video_packet_t p;
  size_t size=sizeof(p);
  struct sockaddr_in source_addr;
  int *sock=(int *)malloc(sizeof(int)*2);

  socklen_t addr_size=sizeof(struct sockaddr_in);
  //FILE *vout;
  nodeptr throw;
  int i=0;
  fd_set read_fd_set,active_fd_set;

  rtcp_t r;
  rtcp_t mine;
  size_t sizer=sizeof(r);
      
  struct sockaddr_in sendto_addr;

  char *b=(char *)malloc(sizeof(char));
  rtcp_sdes_type_t types[]={1};
  char *values[1];
  int lengths[1];
  char this_host[80];
  u_int32 mySRC;
  
  
  struct hostent *host;
  gethostname(this_host,80);
  host=gethostbyname(this_host);
  inet_ntop(AF_INET,host->h_addr_list[0],this_host,80);

  /* ASSIGN DESTINATION ADDRESS */
  sendto_addr.sin_family=AF_INET;
  sendto_addr.sin_addr.s_addr=inet_addr(vaddr);
  sendto_addr.sin_port=htons(video_port+1);
  
  /* new rtcp packet formation routine */
  srand(time(0));   
  mySRC=(unsigned long)rand();
  values[0]=(char *)strdup(this_host);
  lengths[0]=strlen(this_host)-1;
  b=rtp_write_sdes(b,mySRC,1,types,values,lengths);
  
  
  /*
    mine.common.count=1;
    mine.common.p=0;
    mine.common.version=2;
    mine.common.pt=202;
  */
  
  
  
  
  
  /* rtcp RR packet 
     mine.common.count=1;
     mine.common.p=0;
     mine.common.version=2;
     mine.common.pt=201;
     mine.common.length=htons(5);
     
     
     mine.r.rr.ssrc=(unsigned long)rand();
     mine.r.sdes.src=mine.r.rr.ssrc;
  */
  
  
  
  /* set up file descriptor sets */
  sock[0]=rtp;
  sock[1]=rtcp;
  FD_ZERO(&active_fd_set);
  FD_SET(sock[0],&active_fd_set);
  FD_SET(sock[1],&active_fd_set);
  
  signal(SIGPIPE,SIG_IGN);
  
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(zoom_toggle)))
    vout=popen("mtvp fd:0 -a0 -z","w");
  else
    vout=popen("mtvp fd:0 -a0","w");
  
  fprintf(stderr,"opened video viewerand entering loop\n");
  
  while(1){
    int i=0;
    int len=0;
    int data_size=0;
    u_int32 this_ts;
    memset(&p,0,sizeof(p));
    memset(p.data,0,2048);    
    read_fd_set=active_fd_set;
    
    if(!showing_video){
      close(sock[0]);
      close(sock[1]);
      fflush(vout);      
      if(pclose(vout)<0) perror("pclose(vout)");
      fprintf(stderr,"closing vout\n");
      
      fflush(vout);      
      vout=NULL;
      fprintf(stderr,"Video exiting\n");
      pthread_exit(&i);
    }

    
    if (select (FD_SETSIZE, &read_fd_set, NULL, NULL, NULL) < 0){
      perror ("select");
      exit (-1);
    }
    for(i=0;i<FD_SETSIZE;++i){
      if(FD_ISSET(i,&read_fd_set)){
	if(i==sock[0]){
	  if( (len=recvfrom(sock[0],(rtp_video_packet_t *)&p,size,0,
			    NULL,NULL)) < 0 ){
	    perror("rtp:recvfrom()");
	    pthread_exit(&len);
	  }
	  this_ts=(u_int32)ntohl(p.rtp_head.ts);
	  
	  if( rtp_stats.prev_video_ts==0 && rtp_stats.curr_video_ts==0 ){
	    rtp_stats.vbase=this_ts;
	    printf("Video:%lu\n", this_ts);
	  }
	  
	  if( this_ts > rtp_stats.curr_video_ts){
	    rtp_stats.prev_video_ts=rtp_stats.curr_video_ts;
	    rtp_stats.curr_video_ts=this_ts;
	  }
	  data_size=len-sizeof(rtp_header_t)-sizeof(rtp_video_header_t);
	  //if(rtp_stats.abase!=0)
	  fwrite(p.data,data_size,1,vout);
	  
	}	/* if( i==sock[0]) */
	else if(i==sock[1]){ /* we have traffic on the rtcp sock */
	  memset(&r,0,sizeof(r));
	  if( (recvfrom(sock[1],(rtcp_t *)&r,sizeof(r),0,
			(struct sockaddr *)&source_addr,&addr_size)) < 0 ){
	    perror("rtcp:recvfrom()");
	    pthread_exit(&len);
	  }
	  if(r.common.pt==200){
	    //mine.r.rr.rr[0].ssrc=r.r.sr.ssrc;
	    /* send status packet */
	    if( sendto(sock[1],b,sizeof(rtcp_sdes_item_t) ,0,
		       (struct sockaddr *)&sendto_addr,addr_size)<0 ){
	      perror("rtcp:sendto()");
	    }
	  }
	}	/* else if(i==sock[1]) */
      } /* if in fd set */
    } /*  for */
  } /* while */
} /* ends function */


     
void *aud_listen(){
  rtp_audio_packet_t p;
  size_t size=sizeof(p);
  int *sock=(int *)malloc(sizeof(int)*2);
  fd_set read_fd_set,active_fd_set;
  int data_size=0;  
  //FILE *aout;
  int start=0;
  /* rtcp */
  rtcp_t r;
  
  rtcp_t rr_report;
  size_t sizer=sizeof(r);
  struct sockaddr_in sendto_addr;
  socklen_t addr_size=sizeof(struct sockaddr_in);
  
  /* assign destination address */
  sendto_addr.sin_family=AF_INET;
  sendto_addr.sin_addr.s_addr=inet_addr(saddr);
  sendto_addr.sin_port=htons(audio_port+1);
  
  rr_report.common.count=1;
  rr_report.common.p=0;
  rr_report.common.version=2;
  rr_report.common.pt=201;
  rr_report.common.length=htons(7);
  rr_report.r.rr.ssrc=rr_report.r.rr.ssrc;
  rr_report.r.sdes.src=rr_report.r.rr.ssrc;
  
  aout=popen("mpg123 -m -", "w");
  /* set up file descriptor sets */
  sock[0]=srtp;
  sock[1]=srtcp;
  FD_ZERO(&active_fd_set);
  FD_SET(sock[0],&active_fd_set);
  FD_SET(sock[1],&active_fd_set);
  
  fprintf(stderr,"opened audio viewerand entering loop\n");
  while(1){
    int len=0;
    int i=0;
    u_int32 this_ts;
    memset(&p,0,sizeof(p));
    memset(p.data,0,2048);
    read_fd_set=active_fd_set;
    
    if(!showing_video){
      close(sock[0]);
      close(sock[1]);
      fflush(aout);
      if(pclose(aout)<0) perror("pclose(aout)");
      fprintf(stderr,"closing aout\n");
      fflush(aout);
      aout=NULL;
      fprintf(stderr,"audio exiting\n");
      pthread_exit(&i);
    }
    
    if (select (FD_SETSIZE, &read_fd_set, NULL, NULL, NULL) < 0){
      perror ("select");
      exit (-1);
    }
    for(i=0;i<FD_SETSIZE;++i){
      if(FD_ISSET(i,&read_fd_set)){
	if(i==sock[0]){
		
		
	  if( (len=recvfrom(sock[0],(rtp_audio_packet_t *)&p,size,0,
			    NULL,NULL)) < 0 ){
	    perror("rtpsound:recvfrom()");
	    pthread_exit(&len);
	  }
	  this_ts=(u_int32)ntohl(p.rtp_head.ts);
		
		
	  if(rtp_stats.prev_audio_ts==0 && rtp_stats.curr_audio_ts==0){
	    rtp_stats.abase=this_ts;	 
	    rtp_stats.diff=rtp_stats.vbase-rtp_stats.abase;
	    fprintf(stderr,"%lu %lu\n", rtp_stats.abase, rtp_stats.vbase);
	    sleep(3);
	  }
		
	  else{
	    data_size=len-sizeof(rtp_header_t)-sizeof(rtp_audio_header_t);
	    fwrite(p.data,data_size,1,aout);
	  }
	  if( this_ts > rtp_stats.curr_audio_ts){
	    rtp_stats.prev_audio_ts=rtp_stats.curr_audio_ts;
	    rtp_stats.curr_audio_ts=this_ts;
		    
	    /*fprintf(stderr,"v=%lu a=%lu diff=%lu %lu %lu\n", rtp_stats.curr_video_ts,rtp_stats.curr_audio_ts,rtp_stats.curr_video_ts-rtp_stats.curr_audio_ts,rtp_stats.diff,rtp_stats.curr_audio_ts+rtp_stats.diff);*/
		    
	  }
		
		
	}	/* if(i==sock[0]) */
	else if(i==sock[1]){
	  memset(&r,0,sizeof(r));
	  if( (len=recvfrom(sock[1],(rtcp_t *)&r,sizeof(r),0,
			    NULL,NULL)) < 0 ){
	    perror("srtcp:recvfrom()");
	    pthread_exit(&len);
	  }
	  /* send status packet */
	  if( len=
	      sendto(sock[1],(rtcp_t *)&rr_report,sizeof(rr_report),
		     0,(struct sockaddr *)&sendto_addr,addr_size)<0 ){
	    perror("srtcp:sendto()");
	  }
	  
	}	/* else if i== sock[1] */
	   
      } /* if(i is in fd set) */
    }
    
  } /* while */
} /* end aud_listen */








