/**********************************************************************

File:		 rtp.h
Copyright (c) 2000 Hoang M. Tran
htran@darkwing.uoregon.edu

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**********************************************************************/

								

#ifndef RTP_H
#define RTP_H					

#define BUFFERSIZE 2048
#define RTP_SDES_MAX 255
#define RTP_SEQ_MOD (1<<16)

typedef unsigned char u_int8;			/* unsigned int 8 bits */
typedef unsigned short u_int16;		/* unsigned int 16 bits */
typedef unsigned int u_int32;			/* unsigned int 32 bits */

/* BEGIN RTP STRUCTURES */
/* these are defined in RFC1889 */
/* rtp header */

typedef struct {
#ifdef RTP_BIG_ENDIAN				/* IF BIGENDIAN */
  unsigned int version:2;			/* proto version */
  unsigned int p:1;					/* padding */
  unsigned int x:1;					/* header extension: should be 0 */
  unsigned int cc:4;				/* CSRC count */
  unsigned int m:1;					/* marker bit */
  unsigned int pt:7;				/* payload type */
#endif
#ifdef RTP_LITTLE_ENDIAN				/* IF LILENDIAN */
  unsigned int cc:4;				/* csrc count */
  unsigned int x:1;					/* header extension should be set to 0 */
  unsigned int p:1;					/* padding */
  unsigned int version:2;			/* rtp protocol version */
  unsigned int pt:7;				/* payload type */
  unsigned int m:1;					/* marker bit */
#endif 
  u_int16  seq;				    	/* sequence number */
  u_int32  ts;						/* timestamp */
  u_int32   ssrc;					/* sync source */
}rtp_header_t;

typedef struct {
#if RTP_BIG_ENDIAN
  unsigned int MBZ:5;		  /* should be zero, unused */
  unsigned int T:1;			  /* 1 means mpeg2 ext is used,0 otherwise */
  unsigned short TR:10;		  /* temporal ref 0-1023 same for a 
							picture */
  unsigned int AN:1;		  /* should be 0 for mpeg-1 */  
  unsigned int N:1;			  /* should be 0 for mpeg-1 */
  unsigned int S:1;			  /* sequence header present bit */
  unsigned int B:1;			  /* beginning of slice bit */
  unsigned int E:1;			  
  unsigned int P:3;			  /* picture type: I,P,B,D */
  unsigned int FBV:1;		  /* */
  unsigned int BFC:3;		  
  unsigned int FFV:1;
  unsigned int FFC:3;
#elif RTP_LITTLE_ENDIAN  
  unsigned short TR:10;
  unsigned int T:1;
  unsigned int MBZ:5;
  unsigned int P:3;
  unsigned int E:1;
  unsigned int B:1;
  unsigned int S:1;
  unsigned int N:1;
  unsigned int AN:1;
  
  unsigned int FFC:3;
  unsigned int FFV:1;
  unsigned int BFC:3;
  unsigned int FBV:1;    
#endif
} rtp_video_header_t;

typedef struct {
  u_int16  MBZ;					/* should be zero, unused */
  u_int16  F_OFFSET;
}rtp_audio_header_t;


/* rtp_video_packet */
typedef struct{  
  rtp_header_t rtp_head;				/* x bit should be zero for mpeg video so 
								   we skip the rtp_hdr_ext junk */ 
  rtp_video_header_t video_head;
  unsigned char data[BUFFERSIZE]; 
}rtp_video_packet_t;

/* rtp_audio_packet*/
typedef struct{
  rtp_header_t rtp_head;
  rtp_audio_header_t audio_head;
  char data[BUFFERSIZE];  
}rtp_audio_packet_t;

/* END RTP STRUCTURES */

typedef enum {
  RTCP_SR    =200,
  RTCP_RR    =201,
  RTCP_SDES  =202,
  RTCP_BYE   =203,
  RTCP_APP   =204,
}rtcp_type_t;

typedef enum {
  RTCP_SDES_END   = 0,
  RTCP_SDES_CNAME = 1,
  RTCP_SDES_NAME  = 2,
  RTCP_SDES_EMAIL = 3,
  RTCP_SDES_PHONE = 4,
  RTCP_SDES_LOC   = 5,
  RTCP_SDES_TOOL  = 6,
  RTCP_SDES_NOTE  = 7,
  RTCP_SDES_PRIV  = 8
}rtcp_sdes_type_t;

typedef struct {
#ifdef RTP_BIG_ENDIAN
  unsigned int version:2;			/* protocol version */
  unsigned int p:1;					/* padding flag */
  unsigned int count:5;				/* varies by packet type */
#endif
#ifdef RTP_LITTLE_ENDIAN
  unsigned int count:5;				/* varies by packet type */
  unsigned int p:1;					/* padding flag */
  unsigned int version:2;			/* protocol version */
#endif
  u_int8 pt;						/* RTCP packet type */
  u_int16 length;					/* pkt len in words, w/o this word */
} rtcp_common_t;

#define RTCP_VALID_MASK (0xc000 | 0x2000 | 0xfe)
#define RTCP_VALID_VALUE ((RTP_VERSION << 14) | RTCP_SR)

typedef struct {
  u_int32 ssrc;					/* data source being reported */
  u_int8 fraction;					/* fraction lost since last SR/RR */
  int lost:24;						/* cumul. no. pkts lost (signed!) */
  u_int32 last_seq;					/* extended last seq. no. received */
  u_int32 jitter;					/* interarrival jitter */
  u_int32 lsr;						/* last SR packet from this source */
  u_int32 dlsr;					/* delay since last SR packet */
} rtcp_rr_t;

typedef struct {
  u_int8 type;						/* type of item (rtcp_sdes_type_t) */
  u_int8 length;					/* length of item (in octets) */
  char data[1];					/* text, not null-terminated */
} rtcp_sdes_item_t;


typedef struct {
  rtcp_common_t common;				/* common header */
  union {
    /* sender report (SR) */
    struct {
	 u_int32 ssrc;					/* sender generating this report */
	 u_int32 ntp_sec;				/* NTP timestamp */
	 u_int32 ntp_frac;
	 u_int32 rtp_ts;				/* RTP timestamp */
	 u_int32 psent;				/* packets sent */
	 u_int32 osent;				/* octets sent */ 
	 rtcp_rr_t rr[1];				/* variable-length list */
    } sr;
    
    /* reception report (RR) */
    struct {
	 u_int32 ssrc;					/* receiver generating this report */
	 rtcp_rr_t rr[1];				/* variable-length list */
    } rr;
    
    /* source description (SDES) */
    struct rtcp_sdes {
	 u_int32 src;      /* first SSRC/CSRC */
	 rtcp_sdes_item_t item[1];		/* list of SDES items */
    } sdes;
    
    /* BYE */
    struct {
	 unsigned int src[1];			/* list of sources */
								/* can't express trailing text for reason */
    } bye;
  } r;
} rtcp_t;

typedef struct rtcp_sdes rtcp_sdes_t;



#endif





