/**********************************************************************
File:		 queue.h
Copyright (c) 2000 Hoang M. Tran
htran@darkwing.uoregon.edu

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
**********************************************************************/

#ifndef QUEUE_H
#define QUEUE_H



struct node{
  unsigned int time;
  int size;
  char data[2048];
  struct node *next;
};

typedef struct node *nodeptr;

typedef struct{
  nodeptr head;
  nodeptr tail;
}que_t;


nodeptr newnode(unsigned int, int size, char *data);
void initq(que_t *q);
int empty(que_t q);
int qsize(que_t q);
void enq(que_t *q, nodeptr entry);
nodeptr deq(que_t *q);






#endif




