/**********************************************************************
File:		 queue.c
Copyright (c) 2000 Hoang M. Tran
htran@darkwing.uoregon.edu

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
**********************************************************************/
#include <stdio.h>
#include "queue.h"


void initq(que_t *q)
{
  q->head=NULL;
  q->tail=NULL;
}

nodeptr newnode(unsigned int time, int size, char *data)
{
  nodeptr entry=(nodeptr)malloc(sizeof(struct node));
  entry->time=time;
  entry->size=size;
  memcpy(entry->data,data,size);
  entry->next=NULL;
  return entry;
}

  


int empty(que_t q)
{
  if(q.head==NULL && q.tail==NULL)
    return 1;
  else return 0;
}

int qsize(que_t q)
{
  int i=0;
  nodeptr cursor=q.head;
  while(cursor!=NULL)
    {
	 i++;
	 cursor=cursor->next;
    }
  return i;
}


void enq(que_t *q, nodeptr entry){
  if(empty(*q))
    {
	 
	 q->head=entry;
	 q->tail=entry;
	 
	 entry=NULL;
    }
  else{

    q->tail->next=entry;
    q->tail=q->tail->next;

  }

}


nodeptr deq(que_t *q){


  if(empty(*q))
    {

	 return NULL;
    }
  else if(qsize(*q)==1)
    {
	 nodeptr tmp=q->head;

	 
	 q->head=NULL;
	 q->tail=NULL;
	 initq(q);

	 return tmp;
    }
  else
    {
	 nodeptr tmp=q->head;

	 q->head=q->head->next;
	 tmp->next=NULL;

	 return tmp;
    }

}
	 
  
 
  
	   

