/**********************************************************************

File:		 mnet.c
Copyright (c) 2000 Hoang M. Tran
htran@darkwing.uoregon.edu

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


**********************************************************************/

#include "mnet.h"

int start_msock(char *address,int port, int reuse, u_char ttl,u_char loop){
  int sock;
  struct sockaddr_in local_addr;
  struct ip_mreq mreq;
  
  /*get a datagram socket*/
  if( (sock=socket(AF_INET,SOCK_DGRAM,0)) < 0 ){
    perror("socket()");
    return -1;
  }

  /*set reuse*/
  if( (setsockopt(sock,SOL_SOCKET,SO_REUSEADDR,&reuse,sizeof(&reuse))) < 0 ){
    perror("setsockopt(SO_REUSEADDR)");
    return -1;
  }

  /*name the socket and bind*/
  local_addr.sin_family=AF_INET;
  local_addr.sin_addr.s_addr=htonl(INADDR_ANY);
  local_addr.sin_port=htons(port);
  if( (bind(sock,(struct sockaddr *)&local_addr,sizeof(local_addr))) < 0 ){
    perror("bind()");
    return -1;
  }

  /*join multicast group*/
  mreq.imr_multiaddr.s_addr=inet_addr(address);
  mreq.imr_interface.s_addr=htonl(INADDR_ANY);
  if( (setsockopt(sock,IPPROTO_IP,IP_ADD_MEMBERSHIP,
			   (char *)&mreq,sizeof(mreq))) < 0 ){
    perror("setsockopt(IP_ADD_MEMBERSHIP)");
    return -1;
  }
  
  /* set ttl=127 */
  if( setsockopt(sock,IPPROTO_IP,IP_MULTICAST_TTL,(char *)&ttl,
                 sizeof(ttl)) <0 )
    {
	 printf("error in setting ttl value\n");
	 return -1;
  }

  if( setsockopt(sock, IPPROTO_IP, IP_MULTICAST_LOOP,(char *)&loop,
			  sizeof(loop)) <0 ){
    printf("error in setting loopback\n");
    return -1;
  }



  return sock;
}
