/**********************************************************************

File:		 signal_callbacks.c
Developer:	 Hoang Tran
Description:	 implementation file.


Copyright (c) 2000 Hoang M. Tran
htran@darkwing.uoregon.edu

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**********************************************************************/
#include "signal_callbacks.h"
#include "lists.h"
#include "listeners.h"
#include "mnet.h"
#include "rtp.h"
#include "queue.h"
#include <pthread.h>
#include <signal.h>


extern node *list_head,*list_tail;
void write_cache();
GtkWidget *draw_dialog(char *title,char *contact,char *data);

void *vid_listen();
void *aud_listen();

static struct {
  u_int32 diff;
  u_int32 abase;
  u_int32 vbase;
  u_int32 prev_video_ts;
  u_int32 curr_video_ts;
  u_int32 prev_audio_ts;
  u_int32 curr_audio_ts;
  u_int32 master_ts;
  u_int32 low;
  u_int32 high;
}rtp_stats={0,0,0,0,0,0,0,0,0};
 
FILE *vout;
int showing_video=0;
pthread_t video_thread,audio_thread;
static int rtp,rtcp;
static int srtp,srtcp;

char *vaddr,*vport,*saddr,*sport;
int video_port,audio_port;

void *MPGBone();

void quit_button_clicked(GtkWidget *w, gpointer data){
  write_cache();  
  gtk_main_quit();
}
void help_button_clicked(GtkWidget *w, gpointer data){
 
}

void dismiss_button_clicked(GtkWidget *w, gpointer data){
  //gtk_widget_set_state(clist,GTK_STATE_NORMAL);
  showing_video=0;
  gtk_widget_destroy(w);
}

void stop_button_clicked(GtkWidget *w, gpointer data){
  //gtk_widget_set_state(clist,GTK_STATE_NORMAL);
  pthread_kill(video_thread,-1);
  showing_video=0;
}

void more_info_button_clicked(GtkWidget *w, gpointer data){
  GtkWidget *dialog, *label, *okay_button;

  dialog = gtk_dialog_new();
  gtk_window_set_title(GTK_WINDOW(dialog),"More Information");
  gtk_window_set_default_size(GTK_WINDOW(dialog),400,100);
  //label = gtk_label_new (title);
  okay_button = gtk_button_new_with_label("Dismiss");
  /* Ensure that the dialog box is destroyed when the user clicks ok. */
  gtk_signal_connect_object(GTK_OBJECT (okay_button), "clicked",
					   GTK_SIGNAL_FUNC (gtk_widget_destroy), 
					   GTK_OBJECT(dialog));
  
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),
				 okay_button);
  
  label=gtk_label_new(data);
  gtk_label_set_line_wrap(GTK_LABEL(label),TRUE);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
				 label,FALSE,FALSE,0);
  

  gtk_widget_show_all(dialog);
}

void selection_made(GtkWidget *clist, gint row, gint column,
				GdkEventButton *event, gpointer data){
  GtkWidget *dialog;
  node *this=NULL;
  gchar *text;
  char *duplicate=NULL;
  char *temp=NULL;
  char *name=(char *)malloc(sizeof(char));
  char *phone=(char *)malloc(sizeof(char));
  

  gtk_clist_get_text(GTK_CLIST(clist),row,0,&text);

  gtk_clist_unselect_all(GTK_CLIST(clist));
  
  //gtk_widget_set_state(clist,GTK_STATE_INSENSITIVE);
    


  if( (this=find_node_byname(list_head,text))!=NULL ){
    #ifdef FULL_DEBUG
    printf("%s\t%s\n",this->name,this->key);
    #endif
    
    /* get contact name and phone to make dialog widget */
    duplicate=(char *)strdup(this->data);
    temp=(char *)strtok(duplicate,"=\n");
    temp=(char *)strtok(NULL,"=\n");
    while( temp!=NULL ){
	 if( strcmp(temp,"e")==0 )
	   name=(char *)strtok(NULL,"=\n");
	 if( strcmp(temp,"p")==0 )
	   phone=(char *)strtok(NULL,"=\n");
	 temp=(char *)strtok(NULL,"=\n");
    }
    #ifdef FULL_DEBUG
    printf("%s\t%s\n",name,phone);
    #endif
    
    if(phone!=NULL){
	 temp=(char *)realloc(temp,sizeof(char)*
					  (strlen(name)+strlen(phone)+11+
					   (strlen("Contact Info"))) );
	 sprintf(temp,"Contact Info\n%s\n%s",name,phone);
    }
    else{
	 temp=(char *)realloc(temp,sizeof(char)*
					  (strlen(name)+5+(strlen("Contact Info"))));
	 sprintf(temp,"Contact Info\n%s",name);
    }
    
    dialog=draw_dialog(text,temp,this->data);
    gtk_widget_show_all (dialog);
  }
  else
    ;   
  
}

void write_cache(){
  FILE *fpout;
  node *current=NULL;
  int i=0;
  
  char *home=(char *)getenv("HOME");
  if(home==NULL)
    fprintf(stderr,"$HOME not defined, cannot write cached entries.\n\n");
  else
    {
	 printf("Writing cache files...\n");
	 system("rm -rf ~/.mim/cache/*");
	 	 
	 for(current=list_head;current!=NULL;current=current->next){
	   char filename[20];
	   char fullpath[40];
	   
	   strcpy(fullpath,home);
	   strcat(fullpath,"/.mim/cache/");
	   sprintf(filename,"0000%x",i);
	   strcat(fullpath,filename);
	   
	   fpout=fopen(fullpath,"w");
	   if(fpout==NULL){
		perror("fopen");
	   }
	   else{
		fprintf(fpout,"%s",current->data);
	   }
	   fclose(fpout);
	   
	   i++;
	 }
	 
    }
}

GtkWidget *draw_dialog(char *title,char *contact,char *data){
  GtkWidget *dialog, *label, *okay_button;
  GtkWidget *hbox,*textbox,*vscrollbar,*frame;
  GtkWidget *video,*stop,*muted;
  GtkWidget *more_info;
  GtkWidget *frame_vbox;
  char *info;
  char *temp;
  
  dialog = gtk_dialog_new();
  gtk_window_set_title(GTK_WINDOW(dialog),title);
  gtk_window_set_default_size(GTK_WINDOW(dialog),400,100);
  label = gtk_label_new (title);
  okay_button = gtk_button_new_with_label("Dismiss");
  /* Ensure that the dialog box is destroyed when the user clicks ok. */
  
  gtk_signal_connect_object(GTK_OBJECT (okay_button), "clicked",
					    GTK_SIGNAL_FUNC (dismiss_button_clicked), 
					    GTK_OBJECT(dialog));
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),
				 okay_button);
  
  
  video=gtk_button_new_with_label("Play");
  gtk_signal_connect(GTK_OBJECT (video), "clicked",
				 GTK_SIGNAL_FUNC (launch_video_audio),data);
  
  gtk_container_add(GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),
				video);

  muted=gtk_button_new_with_label("Play Muted");
  gtk_signal_connect(GTK_OBJECT (muted), "clicked",
				 GTK_SIGNAL_FUNC (launch_video_muted),data);
  gtk_container_add(GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),
				muted);
  
 
  stop=gtk_button_new_with_label("Stop");
  gtk_signal_connect(GTK_OBJECT (stop), "clicked",
				 GTK_SIGNAL_FUNC (stop_button_clicked),data);
  
  gtk_container_add(GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),
				stop);
	 
  /* Add the label, and show everything we've added to the dialog. */
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
				 label,FALSE,FALSE,0);
	 
  /* horizontal box for text box and scroll bar */
  hbox=gtk_hbox_new(FALSE,0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),hbox,TRUE,TRUE,0);
  textbox=gtk_text_new(NULL,NULL);
  gtk_text_set_editable(GTK_TEXT(textbox),FALSE);
  gtk_text_set_word_wrap(GTK_TEXT(textbox),TRUE);
  gtk_box_pack_start(GTK_BOX(hbox),textbox,TRUE,TRUE,0);
  vscrollbar=gtk_vscrollbar_new (GTK_TEXT(textbox)->vadj);
  gtk_box_pack_start(GTK_BOX(hbox), vscrollbar, FALSE, FALSE, 0);
  gtk_widget_show (vscrollbar);

  
  

  
  /* quickie to get the info */
  temp=(char *)strdup(data);
  temp=(char *)strtok(temp,"=\n");
  temp=(char *)strtok(NULL,"=\n");
  while(temp!=NULL){
    if( strcmp(temp,"i")==0 ){
	 info=(char *)strtok(NULL,"=\n");
	 break;
    }
    temp=(char *)strtok(NULL,"=\n");
  }

  gtk_text_insert(GTK_TEXT(textbox),NULL,NULL,
			   NULL,info,-1);
  
  frame=gtk_frame_new(NULL);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),frame,
				 FALSE,FALSE,0);
  frame_vbox=gtk_vbox_new(FALSE,0);
  gtk_container_add(GTK_CONTAINER(frame),frame_vbox);

  label=gtk_label_new(contact);
  gtk_box_pack_start(GTK_BOX(frame_vbox),label,FALSE,FALSE,0);
  
  more_info=gtk_button_new_with_label("Detailed Information");
  gtk_button_set_relief(GTK_BUTTON(more_info),GTK_RELIEF_NONE);
  gtk_signal_connect(GTK_OBJECT (more_info), "clicked",
				 GTK_SIGNAL_FUNC (more_info_button_clicked),data);
  
  gtk_box_pack_start(GTK_BOX(frame_vbox),more_info,FALSE,FALSE,0);
  
  

  return dialog;
}

void launch_video_audio(GtkWidget *w, gpointer data){  
  
  char *temp;
  char *temp1,*temp2,*temp3,*temp4;
  char *duplicate;  
  char *this_data=(char *)data;
  int status;

  
  if(showing_video)
    //printf("Do you REALLY want to start another video window?!?!\n");
    ;
  else{
    duplicate=(char *)strdup(data);
    temp=(char *)strtok(duplicate,"=\n");
    temp=(char *)strtok(NULL,"=\n");
    while( temp!=NULL ){
	 if( strcmp(temp,"m")==0 ){
	   temp=(char *)strtok(NULL,"=\n");
	   if( (char *)strstr(temp,"video")!=NULL ){
		temp1=(char *)strdup(temp);
		temp2=(char *)strtok(NULL,"=\n");
		temp2=(char *)strtok(NULL,"=\n");
	
	   }
	   else if( (char *)strstr(temp,"audio")!=NULL ){
		temp3=(char *)strdup(temp);
		temp4=(char *)strtok(NULL,"=\n");
		temp4=(char *)strtok(NULL,"=\n");
	
	   }
	 }
	 temp=(char *)strtok(NULL,"=\n");
    }
  
    /* temp1=vport
	  temp2=vaddr
	  temp3=sport
	  temp4=saddr
	  temp=reuse variable.
    */

    vport=(char *)strtok(temp1," ");
    vport=(char *)strtok(NULL," ");
    
    vaddr=(char *)strtok(temp2," ");
    vaddr=(char *)strtok(NULL," ");
    vaddr=(char *)strtok(NULL," ");
    vaddr=(char *)strtok(vaddr,"/");

    sport=(char *)strtok(temp3," ");
    sport=(char *)strtok(NULL," ");
    
    saddr=(char *)strtok(temp4," ");
    saddr=(char *)strtok(NULL," ");
    saddr=(char *)strtok(NULL," ");
    saddr=(char *)strtok(saddr,"/");
    
    printf("Starting video...\n");
    printf("Using these parameters: %s %s %s %s\n\n",vaddr,vport,saddr,sport );

    video_port=atoi(vport);
    audio_port=atoi(sport);
    showing_video=1;    
    
    status=0;
    
    if( (rtcp=start_msock(vaddr,video_port+1,1,127,0)) <0 ){
	 perror("rtcp:start_msock()");
	 status=-1;
    }
    if( (rtp=start_msock(vaddr,video_port,1,127,0)) <0 ){
	 perror("rtp:start_msock()");
	 status=-1;
    }
    if( (srtcp=start_msock(saddr,audio_port+1,1,127,0)) <0 ){
	 perror("rtp:start_msock()");
	 status=-1;
    }
    if( (srtp=start_msock(saddr,audio_port,1,127,0)) <0 ){
	 perror("rtp:start_msock()");
	 status=-1;
    }
    
    if(status!=-1){
	 pthread_create(&video_thread,NULL,vid_listen,NULL);
	 pthread_create(&audio_thread,NULL,aud_listen,NULL);
    }
  }// ends else 
    
}

void launch_video_muted(GtkWidget *w, gpointer data){  
  
  char *temp;
  char *temp1,*temp2,*temp3,*temp4;
  char *duplicate;  
  char *this_data=(char *)data;
  int status;

  
  if(showing_video)
    //printf("Do you REALLY want to start another video window?!?!\n");
    ;
  else{
    duplicate=(char *)strdup(data);
    temp=(char *)strtok(duplicate,"=\n");
    temp=(char *)strtok(NULL,"=\n");
    while( temp!=NULL ){
	 if( strcmp(temp,"m")==0 ){
	   temp=(char *)strtok(NULL,"=\n");
	   if( (char *)strstr(temp,"video")!=NULL ){
		temp1=(char *)strdup(temp);
		temp2=(char *)strtok(NULL,"=\n");
		temp2=(char *)strtok(NULL,"=\n");
	
	   }
	   else if( (char *)strstr(temp,"audio")!=NULL ){
		temp3=(char *)strdup(temp);
		temp4=(char *)strtok(NULL,"=\n");
		temp4=(char *)strtok(NULL,"=\n");
	
	   }
	 }
	 temp=(char *)strtok(NULL,"=\n");
    }
  
    /* temp1=vport
	  temp2=vaddr
	  temp3=sport
	  temp4=saddr
	  temp=reuse variable.
    */

    vport=(char *)strtok(temp1," ");
    vport=(char *)strtok(NULL," ");
    
    vaddr=(char *)strtok(temp2," ");
    vaddr=(char *)strtok(NULL," ");
    vaddr=(char *)strtok(NULL," ");
    vaddr=(char *)strtok(vaddr,"/");

    sport=(char *)strtok(temp3," ");
    sport=(char *)strtok(NULL," ");
    
    saddr=(char *)strtok(temp4," ");
    saddr=(char *)strtok(NULL," ");
    saddr=(char *)strtok(NULL," ");
    saddr=(char *)strtok(saddr,"/");
    
    printf("Starting video...\n");
    printf("Using these parameters: %s %s %s %s\n\n",vaddr,vport,saddr,sport );

    video_port=atoi(vport);
    showing_video=1;    
    
    status=0;
    if( (rtp=start_msock(vaddr,video_port,1,127,0)) <0 ){
	 perror("rtp:start_msock()");
	 status=-1;
    }
    if( (rtcp=start_msock(vaddr,video_port+1,1,127,0)) <0 ){
	 perror("rtcp:start_msock()");
	 status=-1;
    } 
    if(status!=-1)
	 pthread_create(&video_thread,NULL,(void *)vid_listen,NULL);
    
  }// ends else  
}

void *vid_listen(){
  rtp_video_packet_t p;
  size_t size=sizeof(p);
  struct sockaddr_in source_addr;
  int *sock=(int *)malloc(sizeof(int)*2);

  socklen_t addr_size=sizeof(struct sockaddr_in);
  FILE *vout;
  nodeptr throw;
  int i=0;
  fd_set read_fd_set,active_fd_set;

  rtcp_t r;
  rtcp_t mine;
  size_t sizer=sizeof(r);
  
  rtcp_sdes_item_t *sdes_item=(rtcp_sdes_item_t *)
    malloc(sizeof(rtcp_sdes_item_t));
  
  struct sockaddr_in sendto_addr;

  char *b=NULL;
  rtcp_sdes_type_t *types=(rtcp_sdes_type_t *)malloc(sizeof(rtcp_sdes_type_t));
  char **values=(char **)malloc(sizeof(char *));
  int *lengths=(int *)malloc(sizeof(int));
  char this_host[80];
  struct hostent *host;

  gethostname(this_host,80);
  host=gethostbyname(this_host);
  inet_ntop(AF_INET,host->h_addr_list[0],this_host,80);

  types[0]=1;
  values[0]=(char *)malloc(sizeof(char)*strlen(this_host));
  memcpy(values[0],this_host,strlen(this_host));
  lengths[0]=strlen(this_host);
  /* ASSIGN DESTINATION ADDRESS */
  sendto_addr.sin_family=AF_INET;
  sendto_addr.sin_addr.s_addr=inet_addr(vaddr);
  sendto_addr.sin_port=htons(video_port+1);
  
  /* rtcp RR packet */
  mine.common.count=1;
  mine.common.p=0;
  mine.common.version=2;
  mine.common.pt=201;
  mine.common.length=htons(5);
  
  srand(time(0));   
  mine.r.rr.ssrc=(unsigned long)rand();
  mine.r.sdes.src=mine.r.rr.ssrc;
  
  /* set up file descriptor sets */
  sock[0]=rtp;
  sock[1]=rtcp;
  FD_ZERO(&active_fd_set);
  FD_SET(sock[0],&active_fd_set);
  FD_SET(sock[1],&active_fd_set);
  
  vout=popen("mtvp fd:0 -a0","w");
  

  
  while(1){
    int i=0;
    int len=0;
    int data_size=0;
    u_int32 this_ts;
    memset(&p,0,sizeof(p));
    memset(p.data,0,2048);    
    read_fd_set=active_fd_set;

    if(!showing_video){
	 pclose(vout);
	 pthread_exit(&i);
    }

    if (select (FD_SETSIZE, &read_fd_set, NULL, NULL, NULL) < 0){
	 perror ("select");
	 exit (-1);
    }
    for(i=0;i<FD_SETSIZE;++i){
	 if(FD_ISSET(i,&read_fd_set)){
	   if(i==sock[0]){
		
		if( (len=recvfrom(sock[0],(rtp_video_packet_t *)&p,size,0,
					   NULL,NULL)) < 0 ){
		  perror("rtp:recvfrom()");
		  pthread_exit(&len);
		}
		this_ts=(u_int32)ntohl(p.rtp_head.ts);
		
		if( rtp_stats.prev_video_ts==0 && rtp_stats.curr_video_ts==0 ){
		  rtp_stats.vbase=this_ts;
		  printf("Video:%lu\n", this_ts);
		}
		
		if( this_ts > rtp_stats.curr_video_ts){
		  rtp_stats.prev_video_ts=rtp_stats.curr_video_ts;
		  rtp_stats.curr_video_ts=this_ts;
		}
		data_size=len-sizeof(rtp_header_t)-sizeof(rtp_video_header_t);
		//if(rtp_stats.abase!=0)
		fwrite(p.data,data_size,1,vout);
		  
	   }	/* if( i==sock[0]) */
	   else if(i==sock[1]){ /* we have traffic on the rtcp sock */
		memset(&r,0,sizeof(r));
		if( (recvfrom(sock[1],(rtcp_t *)&r,sizeof(r),0,
				    (struct sockaddr *)&source_addr,&addr_size)) < 0 ){
		  perror("rtcp:recvfrom()");
		  pthread_exit(&len);
		}
		if(r.common.pt==200){
		  mine.r.rr.rr[0].ssrc=r.r.sr.ssrc;
		  /* send status packet */
		  if( sendto(sock[1],(rtcp_t *)&mine,sizeof(mine),0,
				   (struct sockaddr *)&sendto_addr,addr_size)<0 ){
		    perror("rtcp:sendto()");
		  }
		}
	   }	/* else if(i==sock[1]) */
	 } /* if in fd set */
    } /*  for */
  } /* while */
} /* ends function */


void *aud_listen(){
  rtp_audio_packet_t p;
  size_t size=sizeof(p);
  int *sock=(int *)malloc(sizeof(int)*2);
  fd_set read_fd_set,active_fd_set;
  int data_size=0;  
  FILE *aout;
  int start=0;
  /* rtcp */
  rtcp_t r;

  rtcp_t rr_report;
  size_t sizer=sizeof(r);
  struct sockaddr_in sendto_addr;
  socklen_t addr_size=sizeof(struct sockaddr_in);
  
  
  /* assign destination address */
  sendto_addr.sin_family=AF_INET;
  sendto_addr.sin_addr.s_addr=inet_addr(saddr);
  sendto_addr.sin_port=htons(audio_port+1);
  
  rr_report.common.count=1;
  rr_report.common.p=0;
  rr_report.common.version=2;
  rr_report.common.pt=201;
  rr_report.common.length=htons(7);
  rr_report.r.rr.ssrc=rr_report.r.rr.ssrc;
  rr_report.r.sdes.src=rr_report.r.rr.ssrc;
  
  aout=popen("mpg123 -m -", "w");
  /* set up file descriptor sets */
  sock[0]=srtp;
  sock[1]=srtcp;
  FD_ZERO(&active_fd_set);
  FD_SET(sock[0],&active_fd_set);
  FD_SET(sock[1],&active_fd_set);
  
  
  while(1){
    int len=0;
    int i=0;
    u_int32 this_ts;
    memset(&p,0,sizeof(p));
    memset(p.data,0,2048);
    read_fd_set=active_fd_set;
    
    if(!showing_video){
	 pclose(aout);
	 pthread_exit(&i);
    }

    if (select (FD_SETSIZE, &read_fd_set, NULL, NULL, NULL) < 0){
	 perror ("select");
	 exit (-1);
    }
    for(i=0;i<FD_SETSIZE;++i){
	 if(FD_ISSET(i,&read_fd_set)){
	   if(i==sock[0]){
		
		
		if( (len=recvfrom(sock[0],(rtp_audio_packet_t *)&p,size,0,
					   NULL,NULL)) < 0 ){
		  perror("rtpsound:recvfrom()");
		  pthread_exit(&len);
		}
		this_ts=(u_int32)ntohl(p.rtp_head.ts);
		
		
		if(rtp_stats.prev_audio_ts==0 && rtp_stats.curr_audio_ts==0){
		  rtp_stats.abase=this_ts;	 
		  rtp_stats.diff=rtp_stats.vbase-rtp_stats.abase;
		  fprintf(stderr,"%lu %lu\n", rtp_stats.abase, rtp_stats.vbase);
		  sleep(1);
		}
		
		else{
		  data_size=len-sizeof(rtp_header_t)-sizeof(rtp_audio_header_t);
		  fwrite(p.data,data_size,1,aout);
		}
		if( this_ts > rtp_stats.curr_audio_ts){
		    rtp_stats.prev_audio_ts=rtp_stats.curr_audio_ts;
		    rtp_stats.curr_audio_ts=this_ts;
		    
		    /*fprintf(stderr,"v=%lu a=%lu diff=%lu %lu %lu\n", rtp_stats.curr_video_ts,rtp_stats.curr_audio_ts,rtp_stats.curr_video_ts-rtp_stats.curr_audio_ts,rtp_stats.diff,rtp_stats.curr_audio_ts+rtp_stats.diff);*/
		    
		}
		
		
	   }	/* if(i==sock[0]) */
	   else if(i==sock[1]){
		memset(&r,0,sizeof(r));
		if( (len=recvfrom(sock[1],(rtcp_t *)&r,sizeof(r),0,
					   NULL,NULL)) < 0 ){
		  perror("srtcp:recvfrom()");
		  pthread_exit(&len);
		}
		/* send status packet */
		if( len=sendto(sock[1],(rtcp_t *)&rr_report,sizeof(rr_report),0,
					(struct sockaddr *)&sendto_addr,addr_size)<0 ){
		  perror("srtcp:sendto()");
		}
		
	   }	/* else if i== sock[1] */
	   
	 } /* if(i is in fd set) */
    }
    
  } /* while */
} /* end aud_listen */








