/**********************************************************************

File:		 net.h
Developer:    	 Hoang Tran
Description:	 Net functions, open socket, sdp listen...

Copyright (c) 2000 Hoang M. Tran
htran@darkwing.uoregon.edu

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**********************************************************************/

#include "net.h"
#include "lists.h"

#define SAP_ADDR "224.2.127.254"
#define SAP_PORT 9875
#define BUFFERSIZE 2048



int create_msocket();
int kill_msocket(int sock);
void sdp_listen(){  
  struct sap_packet{
    unsigned int sap_hdr;
    unsigned int sap_src;
    char sap_data[1];
  }*sap_ptr;
  
  extern node *list_head,*list_tail;
  extern GtkWidget *clist;
  
  int retval;
  int sock, addr_size;
  struct sockaddr_in src_addr;

  
  char *items[]={"hello"};
  
  if( (sock=create_msocket())<0 ){
    fprintf(stderr,"Couldn't create msocket.\n");
    exit(-1);
  }
  
  
  addr_size=sizeof(struct sockaddr_in);
  while(1){
    
    u_char *data=(u_char *)malloc(sizeof(u_char)*BUFFERSIZE);
    char *duplicate,*this_key,*this_name,*this_data;
    
    data=memset(data,0,BUFFERSIZE);
    retval=recvfrom(sock,(u_char *)data,BUFFERSIZE,0,
				(struct sockaddr *)&src_addr,&addr_size);
    if(retval<0){
	 perror("recvfrom()");
	 break;
    }
    
    sap_ptr=(struct sap_packet *)data;
    
    
    duplicate=(char *)strdup(sap_ptr->sap_data);
    /* check if we have mpeg video */

    if( (char *)strstr(duplicate,"RTP/AVP 32")!=NULL )
    {
	 node *this_node;
	 /* we have mpeg defined so begin parsing for this_key, this_name, this_data */
	 this_key=(char *)strtok(duplicate,"\n");
	 this_key=(char *)strtok(NULL,"\n");
	 this_name=(char *)strtok(NULL,"\n");
	 this_name=(char *)strtok(this_name,"=");
	 this_name=(char *)strtok(NULL,"=");
	 this_data=(char *)strdup(sap_ptr->sap_data);
	 
	 this_node=new_node(this_key,this_name,this_data);
	 #ifdef FULL_DEBUG
	 printf("%s\t",this_node->name);
	 #endif
	 if( NULL==find_node(list_head,this_node->key)){
	   #ifdef FULL_DEBUG
	   printf("MISS(ADDING)\n");
#endif

	   insert_node(&list_head,&list_tail,&this_node); 
	   /* add to clist */
	   items[0]=(char *)strdup(this_name);
	   gtk_clist_append(GTK_CLIST(clist),items);
	   
	 }
	 else{
	   #ifdef FULL_DEBUG
	   printf("HIT\n");
	   #endif
	   
	 }
	 #ifdef FULL_DEBUG
	 printf("*****\n");
	 print_list(list_head);
	 printf("*****\n");
	 #endif
	 free(this_node);
    }
    else
	 ;
    
    
  } 
  
  kill_msocket(sock);
  
}
  

int create_msocket(){
  int reuse=1;
  int retval=0;
  int loopback=0;
  u_char ttl=15;
  struct ip_mreq mreq;
  struct sockaddr_in local_addr;
  int sockfd;
  
  /* get a datagram socket */
  if( (sockfd=socket(AF_INET,SOCK_DGRAM,0)) < 0 ){
    perror("socket()");
    return -1;
  }
  /* allow reuse on socket address */
  retval=setsockopt(sockfd,SOL_SOCKET,SO_REUSEADDR,&reuse,sizeof(reuse));
  if(retval<0){
    perror("setsockopt(SO_REUSEADDR)");
    return -1;
  }
  
  /* name the socket */
  local_addr.sin_family=AF_INET;
  local_addr.sin_addr.s_addr=htonl(INADDR_ANY);
  local_addr.sin_port=htons(SAP_PORT);
  if( (bind(sockfd,(struct sockaddr *)&local_addr,sizeof(local_addr)))<0 ){
    perror("bind()");
    return -1;
  }

  /* join multicast group */
  mreq.imr_multiaddr.s_addr=inet_addr(SAP_ADDR);
  mreq.imr_interface.s_addr=INADDR_ANY;
  retval=setsockopt(sockfd,IPPROTO_IP,IP_ADD_MEMBERSHIP,(char *)&mreq,
				sizeof(mreq));
  if(retval<0){
    perror("setsockopt(IP_ADD_MEMBERSHIP)");
    return -1;
  }
  
  return sockfd;
}
  

int kill_msocket(int sock){
  struct ip_mreq mreq;
  int retval;

  mreq.imr_multiaddr.s_addr=inet_addr(SAP_ADDR);
  mreq.imr_interface.s_addr=INADDR_ANY;
  retval=setsockopt(sock,IPPROTO_IP,IP_DROP_MEMBERSHIP,(char *)&mreq,
				sizeof(mreq));
  if(retval<0)
    perror("setsockopt(IP_DROP_MEMBERSHIP)");
  
  close(sock);
  return 1;
}
  


