/**********************************************************************
File:		 listeners.c
Copyright (c) 2000 Hoang M. Tran
htran@darkwing.uoregon.edu

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**********************************************************************/

#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <pthread.h>
#include "listeners.h"
#include "rtp.h"
#include "mnet.h"
#include "queue.h"

typedef struct {
  u_int16 max_seq;
  u_int32 cycles;
  u_int32 base_seq;
  u_int16 curr_seq;
  u_int32 received;
  u_int32 transit;
  u_int32 jitter;  
  u_int32 extended_max;
  u_int32 expected;
  unsigned int lost:24;
}source;

struct{
  rtcp_common_t common;
  struct {
    u_int32 src;
    rtcp_sdes_item_t item;
  }sdes;
}send_item;


static struct {
  u_int16 last_seq;
}rtcp_stats;

static int parse_rtcp(rtcp_t *r);
static void print_stats(source *s);

static int update_stats(source *s,unsigned short seq);

/* these are defined in main */

extern short zoom;
extern char vaddr[16];
extern char saddr[16];
extern int vport;
extern int sport;
extern short sound;
extern short video;

/* queue buffers */
extern que_t videoq, audioq;
extern pthread_mutex_t vq_lock,aq_lock;


void *rtp_vid_listen(int *tmpsock){
  rtp_video_packet_t p;
  size_t size=sizeof(p);
  struct sockaddr_in source_addr;
  int *sock=(int *)malloc(sizeof(int)*2);

  socklen_t addr_size=sizeof(struct sockaddr_in);
  FILE *vout;
  nodeptr throw;
  int i=0;
  fd_set read_fd_set,active_fd_set;
      
  struct sockaddr_in sendto_addr;
  size_t sendsize=0;
  source *video_source=(source *)malloc(sizeof(source));
  
  char this_host[80];
  struct hostent *host;
  
  
  gethostname(this_host,80);
  host=gethostbyname(this_host);
  inet_ntop(AF_INET,host->h_addr_list[0],this_host,80);
  
  /* set up the rtcp send item. */
  send_item.common.version=2;
  send_item.common.p=0;
  send_item.common.count=1;
  send_item.common.pt=(u_char)202;
  send_item.common.length=htons(2);
  srand(time(0));
  send_item.sdes.src=(unsigned long)rand();

  send_item.sdes.item.type=1;
  send_item.sdes.item.length=strlen(this_host);
  memcpy(send_item.sdes.item.data,this_host,strlen(this_host));
  
  /* set up destination address */
  sendto_addr.sin_family=AF_INET;
  sendto_addr.sin_addr.s_addr=inet_addr(vaddr);
  sendto_addr.sin_port=htons(vport+1);

  
  
  sendsize+=6+strlen(this_host);
  //sendsize=52;
  fprintf(stderr,"sendsize=%d\n",sendsize);
  
  /* set up file descriptor sets */
  sock=tmpsock;
  FD_ZERO(&active_fd_set);
  FD_SET(sock[0],&active_fd_set);
  FD_SET(sock[1],&active_fd_set);
  
  if(zoom)
    vout=popen("mtvp fd:0 -a0 -z","w");
  else
    vout=popen("mtvp fd:0 -a0","w");
  
  while(1){
    int i=0;
    int len=0;
    int data_size=0;
    u_int32 this_ts;
    memset(&p,0,sizeof(p));
    memset(p.data,0,2048);    
    read_fd_set=active_fd_set;

    if (select (FD_SETSIZE, &read_fd_set, NULL, NULL, NULL) < 0){
	 perror ("select");
	 exit (-1);
    }
    for(i=0;i<FD_SETSIZE;++i){
	 if(FD_ISSET(i,&read_fd_set)){
	   if(i==sock[0]){
		
		if( (len=recvfrom(sock[0],(rtp_video_packet_t *)&p,size,0,
					   NULL,NULL)) < 0 ){
		  perror("rtp:recvfrom()");
		  pthread_exit(&len);
		}
		this_ts=(u_int32)ntohl(p.rtp_head.ts);

		update_stats(video_source,p.rtp_head.seq);
		
		data_size=len-sizeof(rtp_header_t)-sizeof(rtp_video_header_t);
		fwrite(p.data,data_size,1,vout);
		
	   }	/* if( i==sock[0]) */
	   else if(i==sock[1]){ /* we have traffic on the rtcp sock */
		rtcp_t r;
		memset(&r,0,sizeof(r));
		if( (len=recvfrom(sock[1],(rtcp_t *)&r,sizeof(r),0,
				    (struct sockaddr *)&source_addr,&addr_size)) < 0 ){
		  perror("rtcp:recvfrom()");
		  pthread_exit(&len);
		}
		if(r.common.pt==200){
		  print_stats(video_source);
		  
		  /* send status packet */
		  if( sendto(sock[1],(rtcp_t *)&send_item,sendsize,0,
				   (struct sockaddr *)&sendto_addr,addr_size)<0 ){
		    perror("rtcp:sendto()");
		  }

		  
		 
		}
		if(r.common.pt==201 && r.r.sdes.item[0].type==1){
		  
		  
		}


		
	   }	/* else if(i==sock[1]) */
	 } /* if in fd set */
    } /*  for */
  } /* while */
} /* ends function */
  
void *rtp_aud_listen(int *tmpsock){
  rtp_audio_packet_t p;
  size_t size=sizeof(p);
  int *sock=(int *)malloc(sizeof(int)*2);
  fd_set read_fd_set,active_fd_set;
  int data_size=0;  
  FILE *aout;
  int start=0;
  /* rtcp */
  rtcp_t r;

  rtcp_t rr_report;
  size_t sizer=sizeof(r);
  struct sockaddr_in sendto_addr;
  socklen_t addr_size=sizeof(struct sockaddr_in);
  
  
  /* assign destination address */
  sendto_addr.sin_family=AF_INET;
  sendto_addr.sin_addr.s_addr=inet_addr(saddr);
  sendto_addr.sin_port=htons(sport+1);
  
  rr_report.common.count=1;
  rr_report.common.p=0;
  rr_report.common.version=2;
  rr_report.common.pt=201;
  rr_report.common.length=htons(7);
  rr_report.r.rr.ssrc=rr_report.r.rr.ssrc;
  rr_report.r.sdes.src=rr_report.r.rr.ssrc;
  
    

  aout=popen("mpg123 -m -", "w");
  /* set up file descriptor sets */
  sock=tmpsock;
  FD_ZERO(&active_fd_set);
  FD_SET(sock[0],&active_fd_set);
  FD_SET(sock[1],&active_fd_set);
  
  
  while(1){
    int len=0;
    int i=0;
    u_int32 this_ts;
    memset(&p,0,sizeof(p));
    memset(p.data,0,2048);
    read_fd_set=active_fd_set;
    
    if (select (FD_SETSIZE, &read_fd_set, NULL, NULL, NULL) < 0){
	 perror ("select");
	 exit (-1);
    }
    for(i=0;i<FD_SETSIZE;++i){
	 if(FD_ISSET(i,&read_fd_set)){
	   if(i==sock[0]){
		if( (len=recvfrom(sock[0],(rtp_audio_packet_t *)&p,size,0,
					   NULL,NULL)) < 0 ){
		  perror("rtpsound:recvfrom()");
		  pthread_exit(&len);
		}
		this_ts=(u_int32)ntohl(p.rtp_head.ts);

		
		
		data_size=len-sizeof(rtp_header_t)-sizeof(rtp_audio_header_t);

		fwrite(p.data,data_size,1,aout);
	   }	/* if(i==sock[0]) */
	   else if(i==sock[1]){
		memset(&r,0,sizeof(r));
		if( (len=recvfrom(sock[1],(rtcp_t *)&r,sizeof(r),0,
					   NULL,NULL)) < 0 ){
		  perror("srtcp:recvfrom()");
		  pthread_exit(&len);
		}
		/* send status packet */
		if( len=sendto(sock[1],(rtcp_t *)&rr_report,sizeof(rr_report),0,
					(struct sockaddr *)&sendto_addr,addr_size)<0 ){
		  perror("srtcp:sendto()");
		}
		
	   }	/* else if i== sock[1] */
	   
	 } /* if(i is in fd set) */
    }
    
  } /* while */
}

/*
static void print_stats(void){
  fprintf(stderr,
		"abase=%lu vbase=%lu\nprev_video=%lu curr_video=%lu\nprev_audio=%lu curr_audio=%lu\nmaster_ts=%lu low=%lu high=%lu\n\n"
		,rtp_stats.abase,rtp_stats.vbase,rtp_stats.prev_video_ts,
		rtp_stats.curr_video_ts,rtp_stats.prev_audio_ts,rtp_stats.curr_audio_ts,
		rtp_stats.master_ts,rtp_stats.low,rtp_stats.high);
	      
}
*/

static void print_stats(source *s){
  fprintf(stderr,
		"max_seq=%d last_seq=%d lost=%d\n",
		ntohs(s->max_seq),ntohs(s->curr_seq),ntohl(s->lost));

}

static int update_stats(source *s, unsigned short seq){
  unsigned short udelta=seq-s->max_seq;  
  s->curr_seq=seq;
  if(s->base_seq==0){
    s->base_seq=seq-1;
  }
  else if(seq > s->max_seq)
    s->max_seq=seq;
  else if(seq < s->max_seq){
    s->cycles+=RTP_SEQ_MOD;
    s->max_seq=seq;
  }
  s->extended_max=s->cycles + s->max_seq;
  s->expected= s->extended_max - s->base_seq;
  s->lost= s->expected - s->received;
  s->received++;
  return 1;
}



int parse_rtcp(rtcp_t *r){
  int i=0;
  int len=0;
  static struct {
    rtcp_sdes_type_t t;
    char *name;
  } map[] = {
    {RTCP_SDES_END,    "end"}, 
    {RTCP_SDES_CNAME,  "CNAME"},
    {RTCP_SDES_NAME,   "NAME"},
    {RTCP_SDES_EMAIL,  "EMAIL"},
    {RTCP_SDES_PHONE,  "PHONE"},
    {RTCP_SDES_LOC,    "LOC"},
    {RTCP_SDES_TOOL,   "TOOL"},
    {RTCP_SDES_NOTE,   "NOTE"},
    {RTCP_SDES_PRIV,   "PRIV"},
    {11,               "SOURCE"},
    {0,0}
  };

  if(r->common.version==0){
    printf("Deprecated version.\n");
    return -1;
  }
  else if( r->common.version==2 ){
  
  
  switch(r->common.pt){
  case RTCP_SR:
    printf("*****\nversion=%d padding=%d count=%d payload type=%d length=%d\n",
		 r->common.version,
		 r->common.p,
		 r->common.count,
		 r->common.pt,
		 ntohs(r->common.length));
   

    printf(" (SR ssrc=0x%lx p=%d count=%d len=%d\n", 
		 (unsigned long)ntohl(r->r.rr.ssrc),
		 r->common.p, r->common.count,
		 ntohs(r->common.length));
    
    printf("ntp=%lu.%lu ts=%lu psent=%lu osent=%lu fraction=%g\n",
		 (unsigned long)ntohl(r->r.sr.ntp_sec),
		 (unsigned long)ntohl(r->r.sr.ntp_frac),
		 (unsigned long)ntohl(r->r.sr.rtp_ts),
		 (unsigned long)ntohl(r->r.sr.psent),
		 (unsigned long)ntohl(r->r.sr.osent),
		 r->r.sr.rr[i].fraction / 256);
    
    printf("*****\n\n");
    break;
  default:
    break;

  }
  
  return 1;
  
  }
  else{
    printf("Unknown rtcp version.\n");
    return -1;
  }
  
}

#ifdef NEED_INET_NTOP
const char *inet_ntop(int family, const void *addrptr, 
				  char *strptr,size_t len){
  const u_char *p=(const u_char *)addrptr;
  int errno;

  if(family==AF_INET){
    char temp[16];
#ifdef __DECC
    sprintf(temp,"%d.%d.%d.%d",p[0],p[1],p[2],p[3]);
#else
    snprintf(temp,sizeof(temp),"%d.%d.%d.%d",p[0],p[1],p[2],p[3]);
#endif
    if(strlen(temp)>=len){
	 errno=-1;
	 return (NULL);
    }
    strcpy(strptr,temp);
    return (strptr);
  }
  errno=-2;
  return (NULL);
}
#endif














