/**********************************************************************

File:		 xmim.c
Developer :	 Hoang Tran
Description:	 MPGui: GTK frontend for mim player.

Copyright (c) 2000 Hoang M. Tran
htran@darkwing.uoregon.edu

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


**********************************************************************/

#include <gtk/gtk.h>
#include <pthread.h>

#include "lists.h"
#include "signal_callbacks.h"
#include "net.h"
#include "read_cache.h"

node *list_head=NULL,*list_tail=NULL;
GtkWidget *clist;

int main(int argc, char *argv[]){
  int i;  
  GtkWidget *text_box, *main_window;
  GtkWidget *vscrollbar;
  GtkWidget *vbox, *hbox_temp;
  GtkWidget *button;
  GtkWidget *scroll_window;
  
  char *items[]={"hello"};
  char *button_labels[]={"Help","Quit"};
  char *column_titles[]={"Public MPEG Sessions"};
  
  pthread_t socket_listener;

  void (*function_array[2])(GtkWidget *w, gpointer data)=
  {help_button_clicked,quit_button_clicked};

  fclose(stdout);

  gtk_init(&argc, &argv);
  main_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize(main_window,400,500);
  gtk_window_set_policy(GTK_WINDOW(main_window),TRUE,TRUE,FALSE);
  gtk_signal_connect(GTK_OBJECT(main_window),"destroy",
				 GTK_SIGNAL_FUNC(gtk_main_quit),NULL);
  gtk_window_set_title(GTK_WINDOW(main_window),"Mim");
  
  vbox=gtk_vbox_new(FALSE,0);
  gtk_container_set_border_width(GTK_CONTAINER(vbox),0);
  gtk_container_add(GTK_CONTAINER(main_window), vbox);
  gtk_widget_show(vbox);
  
  hbox_temp=gtk_hbox_new(TRUE,0);
  gtk_box_pack_start(GTK_BOX(vbox),hbox_temp,FALSE,FALSE,0);
  gtk_widget_show(hbox_temp);
  /* buttons */
  for(i=0;i<2;i++){
    button=gtk_button_new_with_label(button_labels[i]);
    gtk_box_pack_start(GTK_BOX(hbox_temp),button,TRUE,TRUE,0);
	
    gtk_signal_connect(GTK_OBJECT(button),"clicked",
				   GTK_SIGNAL_FUNC(function_array[i]),&list_head); 
    gtk_widget_show(button);
  }

  hbox_temp=gtk_hbox_new(FALSE,0);
  gtk_box_pack_end(GTK_BOX(vbox),hbox_temp,FALSE,FALSE,0);
  button=gtk_button_new_with_label("mim v1.0 by An anonymous troll");
  gtk_box_pack_start(GTK_BOX(hbox_temp),button,TRUE,TRUE,0);
  gtk_button_set_relief(GTK_BUTTON(button),GTK_RELIEF_NONE);
  gtk_widget_set_sensitive(button,FALSE);
  gtk_widget_show(button);
  gtk_widget_show(hbox_temp);
  
  /* clist */
  scroll_window=gtk_scrolled_window_new(NULL,NULL);
  gtk_box_pack_start(GTK_BOX(vbox),scroll_window,TRUE,TRUE,0);
  gtk_widget_show(scroll_window);
  
  clist=gtk_clist_new_with_titles(1,column_titles);
  gtk_clist_column_titles_passive(GTK_CLIST(clist));
  gtk_clist_set_sort_type(GTK_CLIST(clist),GTK_SORT_ASCENDING);
  gtk_clist_set_shadow_type(GTK_CLIST(clist),GTK_SHADOW_OUT);
  gtk_clist_set_column_auto_resize(GTK_CLIST(clist),1,TRUE);
  gtk_clist_set_selection_mode(GTK_CLIST(clist),GTK_SELECTION_SINGLE);
  gtk_container_add(GTK_CONTAINER(scroll_window),clist);
  gtk_clist_set_auto_sort(GTK_CLIST(clist),TRUE);
  gtk_clist_set_reorderable(GTK_CLIST(clist),TRUE);
  
  
  gtk_signal_connect(GTK_OBJECT(clist),"select_row",
				 GTK_SIGNAL_FUNC(selection_made),&list_head);  
  gtk_widget_show(clist);

  
  read_cache();
 
  pthread_create(&socket_listener,NULL,(void *)sdp_listen,NULL);
  gtk_widget_show(main_window);


  gtk_main();
  return 0;
}











