/**********************************************************************

File:		 read_cache.c

Copyright (c) 2000 Hoang M. Tran
htran@darkwing.uoregon.edu

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


**********************************************************************/
#include <gtk/gtk.h>
#include "read_cache.h"
#include "lists.h"

extern GtkWidget *clist;
extern node *list_head, *list_tail;

int read_cache(){
  char *items[]={"NULL"};
  node *this_entry=NULL;
  char keep_dir[80];
  FILE *fpin;
  DIR *dp;
  struct dirent *ep;
  
  char data[2048];
  char home[100];
  char *temp;
  char *duplicate;
  char *this_key, *this_name,*this_data;
  
  printf("Reading cached entries...\n");
  
  getcwd(keep_dir,80);
  strcpy(home, (char *)getenv("HOME"));
  strcat(home,"/.mim/cache");
  dp=opendir(home);
  chdir(home);
  if(dp!=NULL){
    while(ep=readdir(dp)){
	 memset(data,0,2048);
	 if( strcmp(".",ep->d_name)==0 || strcmp("..",ep->d_name)==0 ){
	   ;
	 }
	 else{
	   if( fpin=fopen(ep->d_name,"r") ){
		fread(data,2048,1,fpin);
		duplicate=(char *)strdup(data);
		/* fill this_key,this_name,this_data */
		this_key=(char *)strtok(duplicate,"\n");
		this_key=(char *)strtok(NULL,"\n");
		this_name=(char *)strtok(NULL,"\n");
		this_name=(char *)strtok(this_name,"=");
		this_name=(char *)strtok(NULL,"=");
		this_data=(char *)strdup(data);
		this_entry=new_node(this_key,this_name,this_data);

		insert_node(&list_head,&list_tail,&this_entry);

		items[0]=(char *)strdup(this_name);
		gtk_clist_append(GTK_CLIST(clist),items);
	   }
	   else
		;
	 }

    }
  }
  else{
    puts("Couldn't open cache directory.\n");
    return -1;
  }
  
  chdir(keep_dir);
  return 0;
	 
}





