/**********************************************************************
File:		 mim.c
Copyright (c) 2000 Hoang M. Tran
htran@darkwing.uoregon.edu

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**********************************************************************/

#include <stdio.h>
#include <pthread.h>
#include "listeners.h"
#include "mnet.h"
#include "queue.h"
/* UO MPEG TEST */

#define RTP_ADDR "239.192.0.2"
#define RTP_PORT 49534
#define SRTP_ADDR "239.192.0.2"
#define SRTP_PORT 23484


char vaddr[16]=RTP_ADDR;
char saddr[16]=SRTP_ADDR;
int vport=RTP_PORT;
int sport=SRTP_PORT;

short zoom=0;
short sound=0;
short video=0;

pthread_mutex_t vq_lock=PTHREAD_MUTEX_INITIALIZER;
pthread_mutex_t aq_lock=PTHREAD_MUTEX_INITIALIZER;

que_t videoq, audioq;

void usage();

int main(int argc, char *argv[]){  
  int *video_rtp=(int *)malloc(sizeof(int)*2);
  int *sound_rtp=(int *)malloc(sizeof(int)*2);
  pthread_t video_rtp_thread, video_rtcp_thread;
  pthread_t sound_rtp_thread,sound_rtcp_thread;
  pthread_t render;
  int i=0;
  size_t size;

  initq(&videoq);
  initq(&audioq);
  
  if(argc==1){
    sound=1;
    video=1;
  }
  else{
    for(i=0;i<argc;i++){
	 if( strcmp(argv[i],"-z")==0 ){
	   zoom=1;
	   if(argc==2){
		sound=1;
		video=1;
	   }
	 }
	 if( strcmp(argv[i],"-a")==0 ){
	   printf("Sound On\n");
	   sound=1;
	   if(argv[i+1]==NULL || argv[i+2]==NULL )
	   usage();
	   strcpy(saddr,argv[++i]);
	   sport=atoi(argv[++i]);	 
	 }
	 if(strcmp(argv[i],"-h")==0)
	   usage();
	 if(strcmp(argv[i],"-v")==0){
	   printf("Video On\n");
	   video=1;
	   if(argv[i+1]==NULL || argv[i+2]==NULL )
		usage();
	   strcpy(vaddr,argv[++i]);
	   vport=atoi(argv[++i]);
	 }
    }  
  }

  fprintf(stderr,"got arguments\n\n\n");

  if(sound){
    if( (sound_rtp[1]=start_msock(saddr,(sport+1),1,127,0)) <0 ){
	 perror("rtcp:start_msock()");
	 exit(-1);
    }
    if( (sound_rtp[0]=start_msock(saddr,sport,1,127,0)) <0 ){
	 perror("rtp:start_msock()");
	 exit(-1);
    }
  }
  
  if(video){
    
    if( (video_rtp[1]=start_msock(vaddr,vport+1,1,127,0)) <0 ){
	 perror("rtcp:start_msock()");
	 exit(-1);
    }
    if( (video_rtp[0]=start_msock(vaddr,vport,1,127,0)) <0 ){
	 perror("rtp:start_msock()");
	 exit(-1);
    }
  }
  
  if(sound)
    pthread_create(&sound_rtp_thread,NULL,
			    (void *)rtp_aud_listen,sound_rtp);
  if(video)
    pthread_create(&video_rtp_thread,NULL,
			    (void *)rtp_vid_listen,video_rtp);
  
  
  //pthread_create(&render,NULL,(void *)write_av,NULL);
  
  
  
  if(sound){
    //pthread_join(sound_rtcp_thread,NULL);
    pthread_join(sound_rtp_thread,NULL);
  }
    
  
  if(video){
    // pthread_join(video_rtcp_thread,NULL);
    pthread_join(video_rtp_thread,NULL);
  }

  //pthread_join(render,NULL);
  
}	   /* main */


void usage(){
  printf("Usage: mim [-v video_address video_port] [-a audio_address audio_port]\n");
  printf("Options:\n\t-z\tthis doubles the picture size.\n");
  printf("\n");
  printf("Defaults to watching UO MPEG Test with no audio.\n");
  exit(-1);
}







