/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/*
   list_fun.c: compile list of references, standard format
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "refs.h"
#include "list_bib.h"
#include "ix01_fun.h"
#include "ix02_fun.h"
#include "fl_ut.h"
#include "str_fun.h"
#include "interf.h"
#include "initial.h"

#define REFZAHL_LEN 7
#define TEXTZEILEN_LEN 65
#define TXTBUF_SIZE 15000
#define BBTBUF_SIZE 4000

 extern char journal_pix_name[PFAD_LEN+1];
 extern char journal_name[PFAD_LEN + 1];
 extern char book_name[PFAD_LEN + 1];
 extern char autorjl_name[PFAD_LEN + 1];
 extern char autorbu_name[PFAD_LEN + 1];
 extern char quell_pix_name[PFAD_LEN + 1];
 extern char quell_name[PFAD_LEN + 1];
 static char txt_name[PFAD_LEN + 1];
 extern char log_name[PFAD_LEN + 1];
 static char bbt_name[PFAD_LEN + 1];
 static char haupt_schluessel[KENNZIFFER_LEN + 1];
 static char quell_schluessel[QUELLKUERZEL_LEN + 1];
 static char txt_buf[TXTBUF_SIZE + 1];
 static char bbt_buf[BBTBUF_SIZE + 1];

 extern char textpfad[PFAD_LEN+1];
 extern char rdbpfad[PFAD_LEN+1];

 extern FILE * ix01file;
 extern FILE * ix02file;
 extern FILE * fpjournal;
 extern FILE * fpbuch;
 extern FILE * fpautorjl;
 extern FILE * fpautorbu;
 extern FILE * fpsource;
  static FILE * fpbbt;
  static FILE * fptxt;

  static char * au_zeile;
  static char * ed_zeile;
  static char * ex_au_zeile;
  static char * ausgabe_zeile;
  static char * ex_ausgabe_zeile;

 extern config_set one_config_set;
 extern char wrtxtbu[WRTXTBU_LEN+1];
 
 extern journal_rec            one_journal_rec;
 extern buch_rec               one_buch_rec;
 extern quell_rec              one_quell_rec;
 extern refspix_rec            ix01rec;
 extern quellpix_rec           ix02rec;
 extern author_rec             one_aued_rec;
 static bbatchtable_rec        one_bbt_rec;

 static int getfilenames_list_bib(void);
 static int list_bib_initialize(void);
 static int list_bib_aufraeumen(void);
 static int dateien_oeffnen_list_bib(void);
 static void dateien_schliessen_list_bib(void);
 static void machlist_list_bib(void);
 static void compile_j1_list_bib(void);
 static void compile_j2_list_bib(void);
 static void compile_b1_list_bib(void);
 static void compile_b2_list_bib(void);
 static void compile_b3_list_bib(void);
 static void compile_m1_list_bib(void);
 static void compile_m2_list_bib(void);
 static void compile_aued_list_bbt(FILE * fpaued, 
                                   char * auedstring, 
                                   long zeiger);
 static void month_for_bibtex(char * ziffer_in, char * name_out, int laenge);


int list_bib_main(char * code)
{
    int rueckgabewert;

    rueckgabewert = 1;
    
    if (!getfilenames_list_bib())
    {
       rueckgabewert=0;
       return rueckgabewert;
    }
    list_bib_initialize();
    if (dateien_oeffnen_list_bib())
    {
      machlist_list_bib();
      dateien_schliessen_list_bib();
      load_file_yn(txt_name);
    }
    list_bib_aufraeumen();
    
    return rueckgabewert;
}


static int getfilenames_list_bib(void)
{
   int rueckgabewert;
   int taste;
   char datei[PFAD_LEN+1];
   static char ein[INPUT_BU_LEN+1];

   if (!dateivornamen_holen(datei,
   "Please enter name for `.bib' text file (default `reflist')"))
   {
      strcpy(datei,"reflist");
   }
   strlimcpy(txt_name,textpfad,PFAD_LEN);
   strlimcat(txt_name,datei,PFAD_LEN);
   strlimcat(txt_name,".bib",PFAD_LEN);
   if (isfile(txt_name))
   {
     strcpy(ein,"menu");
     wrtxt("\nMenu: text file already exists, overwrite [y/n]?\n");
     taste = menu_wahl(ein,
                       "[y] yes, overwrite existing file\n"
                       "[n] no, do not overwrite existing file");
     if (taste==2)
     {
        rueckgabewert = 0;
        return rueckgabewert;
     }
   }
   /* begin new 3.12.2006 */
   wrtxt(LIST_BIB_EXPL1);
   /* end new 3.12.2006 */

   taste = datei_suchen_mit_pfad("*.bbt",rdbpfad,bbt_name);
   rueckgabewert = taste; 
   return rueckgabewert;   
}

static int list_bib_initialize(void)
{
   if ((au_zeile =  (char *) malloc((AUTORZEILE_LEN+1) * sizeof(char)))==NULL)
   {
      fprintf(stderr,"\nERROR 'List' 'StandardFormat' memory allocation\n");
      exit(1);
   }
   if ((ed_zeile =  (char *) malloc((AUTORZEILE_LEN+1) * sizeof(char)))==NULL)
   {
      fprintf(stderr,"\nERROR 'List' 'StandardFormat' memory allocation\n");
      exit(1);
   }
   if ((ex_au_zeile =  (char *) malloc((AUTORZEILE_LEN+1) * sizeof(char)))==NULL)
   {
      fprintf(stderr,"\nERROR 'List' 'StandardFormat' memory allocation\n");
      exit(1);
   }
   if ((ausgabe_zeile =  (char *) malloc((AUSGABEZEILE_LEN+1) * sizeof(char)))==NULL)
   {
      fprintf(stderr,"\nERROR 'List' 'StandardFormat' memory allocation\n");
      exit(1);
   }
   if ((ex_ausgabe_zeile =  (char *) malloc((AUSGABEZEILE_LEN+1) * sizeof(char)))==NULL)
   {
      fprintf(stderr,"\nERROR 'List' 'StandardFormat' memory allocation\n");
      exit(1);
   }
   return 1;
}

static int list_bib_aufraeumen(void)
{
   free(au_zeile);
   free(ed_zeile);
   free(ex_au_zeile);
   free(ausgabe_zeile);
   free(ex_ausgabe_zeile);
   return 1;
}

static int dateien_oeffnen_list_bib(void)
{
  if (filesize(journal_pix_name)==0)
  {
    wrtxt("ERROR: main index file is empty\n");
    return 0;
  }
  if (!read_ix01(journal_pix_name)) return 0;
  if (!read_ix02(quell_pix_name)) return 0;
  if ((fpjournal=fopen(journal_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"\nERROR: cannot read %s\n",journal_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    return 0;
  }

  if ((fpbuch=fopen(book_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"\nERROR: cannot read %s\n",book_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    return 0;
  }
  if ((fpautorjl=fopen(autorjl_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"\nERROR: cannot read %s\n",autorjl_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpbuch);
    return 0;
  }
  if ((fpautorbu=fopen(autorbu_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"\nERROR: cannot read %s\n",autorbu_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    return 0;
  }

  if ((fpbbt=fopen(bbt_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"\nERROR: cannot read %s\n",bbt_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    return 0;
  }
  if (setvbuf(fpbbt,bbt_buf,_IOFBF,BBTBUF_SIZE)!=0)
  {
    wrtxt("\nERROR: Cannot allocate memory for fpbbt\n");
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpbbt);
    return 0;
  }

  if ((fpsource=fopen(quell_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"\nERROR: cannot read %s\n",quell_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpbbt);
    return 0;
  }

  if ((fptxt=fopen(txt_name,"w"))==NULL)
  {
    sprintf(wrtxtbu,"\nERROR: write read %s\n",txt_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpbbt);
    fclose(fpsource);
    return 0;
  }
  if (setvbuf(fptxt,txt_buf,_IOFBF,TXTBUF_SIZE)!=0)
  {
    wrtxt("\nERROR: Cannot allocate memory for fptxt\n");
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpbbt);
    fclose(fpsource);
    fclose(fptxt);
    return 0;
  }
  if (logdatei_oeffnen()==0)
  {
    sprintf(wrtxtbu,"\nERROR: write read %s\n",log_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpbbt);
    fclose(fpsource);
    fclose(fptxt);
    return 0;
  }

  return 1;
}


static void dateien_schliessen_list_bib(void)
{
   close_ix01();
   close_ix02();
   fclose(fpjournal);
   fclose(fpbuch);
   fclose(fpautorjl);
   fclose(fpautorbu);
   fclose(fpbbt);
   fclose(fpsource);
   fclose(fptxt);
   logdatei_schliessen();
}

static void machlist_list_bib(void)
{
   long i, j, byte_zeiger, rec_zeiger, anzahl_records;
   static int  taste, ok;
   int schleifeok;
   char zahl[REFZAHL_LEN+1];
   static char ein[INPUT_BU_LEN+1];

   strcpy(ausgabe_zeile,""); 
   fseek(fpbbt,0L,SEEK_END);
   byte_zeiger = ftell(fpbbt);
   anzahl_records = byte_zeiger/sizeof(one_bbt_rec);
   anzahl_records--;
 
   strcpy(zahl,"1");
   if (anzahl_records==-1)
   {
      wrtxt("\nCurrent BBT-file is empty\n");
      return;
   }
   strcpy(ein,"menu");
   wrtxt("\nMenu: Reference number format [o/n/q]\n");
   taste = menu_wahl(ein,
     "[o] original reference numbers\n"
     "[n] new reference numbers\n"
     "[q] quit"
     );
   
   if (taste==3)
   {
      return;
   }
   if (taste==2)
   {
    schleifeok = 0;
    do
    {
      ein_zeile(zahl,"Number assigned to the first reference (default 1)",REFZAHL_LEN);
      if (strlen(zahl)==0)
      {
        j = 1;
        ok = 1;
      } else
      {
        string_in_long(zahl,&j,&ok);
      }
      if (ok) schleifeok=1; else schleifeok=0;
     }
     while (!schleifeok);
   }
   schleifeok = 0;
   strcpy(zahl,"0");
  
   sprintf(wrtxtbu,"\n(Compiling %li references)\n",anzahl_records+1);
   wrtxt(wrtxtbu);
   rewind(fpbbt);
   for (i=0;i<=anzahl_records;i++)
   {
        if ((i % 100)==0)
        {
           if (i==100) wrtxt("\n");
           if (i>0)
           {
             sprintf(wrtxtbu,"[%li] ",i);
             wrtxt(wrtxtbu);
           }
        }
        fread(&one_bbt_rec, sizeof(one_bbt_rec),1,fpbbt);
        strlimcpy(haupt_schluessel,one_bbt_rec.kennziffer,KENNZIFFER_LEN);
        if (locate_ix01(haupt_schluessel,&ix01rec) > -1)
        {
           rec_zeiger = ix01rec.journal_rptr;
           byte_zeiger = rec_zeiger * sizeof(one_journal_rec);
           fseek(fpjournal,byte_zeiger,SEEK_SET);
           fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);
           if (!strcmp(one_journal_rec.reftyp,"j1"))
           {
              strcpy(ausgabe_zeile,"@article{"); 
           }
           if (!strcmp(one_journal_rec.reftyp,"j2"))
           {
              strcpy(ausgabe_zeile,"@article{"); 
           }
           if (!strcmp(one_journal_rec.reftyp,"b1"))
           {
              strcpy(ausgabe_zeile,"@book{"); 
           }
           if (!strcmp(one_journal_rec.reftyp,"b2"))
           {
              strcpy(ausgabe_zeile,"@incollection{"); 
           }
           if (!strcmp(one_journal_rec.reftyp,"b3"))
           {
              strcpy(ausgabe_zeile,"@book{"); 
           }
           if (!strcmp(one_journal_rec.reftyp,"m1"))
           {
              strcpy(ausgabe_zeile,"@misc{"); 
           }
           if (!strcmp(one_journal_rec.reftyp,"m2"))
           {
              strcpy(ausgabe_zeile,"@misc{"); 
           }
           

           if (taste==2) 
           {
              sprintf(wrtxtbu,"%06li,\n",j);
           }
           if (taste==1) 
           {
              sprintf(wrtxtbu,"%s,\n",haupt_schluessel);
           }
           strlimcat(ausgabe_zeile,wrtxtbu,AUSGABEZEILE_LEN); 

           if (!strcmp(one_journal_rec.reftyp,"j1")) 
           {
            compile_j1_list_bib();
           }
           else if (!strcmp(one_journal_rec.reftyp,"m1")) 
           {
            compile_m1_list_bib();
           }
           else if (!strcmp(one_journal_rec.reftyp,"j2")) 
           {
            compile_j2_list_bib();
           }
           else if (!strcmp(one_journal_rec.reftyp,"m2")) 
           {
            compile_m2_list_bib();
           }
           else if (!strcmp(one_journal_rec.reftyp,"b1")) 
           {
            compile_b1_list_bib();
           }
           else if (!strcmp(one_journal_rec.reftyp,"b2")) 
           {
            compile_b2_list_bib();
           }
           else 
           {
            compile_b3_list_bib();
           }
           
           tr_db_to_bibtex(ausgabe_zeile,ex_ausgabe_zeile,AUSGABEZEILE_LEN);
           strlimcpy(ausgabe_zeile,ex_ausgabe_zeile,AUSGABEZEILE_LEN);

           fprintf(fptxt,"%s\n\n",ausgabe_zeile);

        }
        else
        {
          /* begin new for version 4.1g */
          fprintf(fptxt,"--%s--\n\n",one_bbt_rec.kennziffer);
          /* end new for version 4.1g */
          sprintf(wrtxtbu,"# %s: not found",haupt_schluessel);
          logdatei_schreiben(wrtxtbu);
        }
        j++;
   }
   if (i > 100) wrtxt("\n");
   sprintf(wrtxtbu,"\n(Completed, text file `%s' written)\n",txt_name);
   wrtxt(wrtxtbu);
}


static void compile_j1_list_bib(void)
{
   compile_aued_list_bbt(fpautorjl, au_zeile,ix01rec.autorjl_rptr);
   strlimcat(ausgabe_zeile,"  author = {",AUSGABEZEILE_LEN);
   strlimcat(ausgabe_zeile,au_zeile,AUSGABEZEILE_LEN);
   strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   if (strlen(one_journal_rec.titel)>0)
   {
     strlimcat(ausgabe_zeile,",\n  title = {{",AUSGABEZEILE_LEN);
     strlimcat(ausgabe_zeile,one_journal_rec.titel,AUSGABEZEILE_LEN);
     /* to be reconsidered: */
     if (satzzeichen(ausgabe_zeile))
     {
        endst_satzzeichen_entfernen(ausgabe_zeile);
     } 
     strlimcat(ausgabe_zeile,"}}",AUSGABEZEILE_LEN);
   }

   strncpy(quell_schluessel,one_journal_rec.kuerzel,KUERZEL_LEN);
   if (locate_ix02(quell_schluessel,&ix02rec) > -1)
   {
       long byte_zeiger;
       byte_zeiger = ix02rec.quell_rptr * sizeof(one_quell_rec);
       fseek(fpsource,byte_zeiger,SEEK_SET);
       fread(&one_quell_rec,sizeof(one_quell_rec),1,fpsource);
       if (strlen(one_quell_rec.quell_zeitschrift)>0)
       { 
         strlimcat(ausgabe_zeile,",\n  journal = {",AUSGABEZEILE_LEN);
         strlimcat(ausgabe_zeile,one_quell_rec.quell_zeitschrift,AUSGABEZEILE_LEN);
         strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
       }
   }
   else
   {
      sprintf(wrtxtbu,"# %s: JOURNAL name corresponding to [%s] not found",haupt_schluessel,quell_schluessel);
      logdatei_schreiben(wrtxtbu);
   }

   if (strlen(one_journal_rec.jahrgang)>0)
   {
      strlimcat(ausgabe_zeile,",\n  year = {",AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   }
   if (strlen(one_journal_rec.band)>0)
   {
     strlimcat(ausgabe_zeile,",\n  volume = {",AUSGABEZEILE_LEN);
     strlimcat(ausgabe_zeile,one_journal_rec.band,AUSGABEZEILE_LEN);
     strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   }
   if (strlen(one_journal_rec.seite_von)>0)
   {
     strlimcat(ausgabe_zeile,",\n  pages = {",AUSGABEZEILE_LEN);
     strlimcat(ausgabe_zeile,one_journal_rec.seite_von,AUSGABEZEILE_LEN);
     if (strlen(one_journal_rec.seite_bis)>0)
     {
        strlimcat(ausgabe_zeile,"--",AUSGABEZEILE_LEN);
        strlimcat(ausgabe_zeile,one_journal_rec.seite_bis,AUSGABEZEILE_LEN);
     }
     strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   }
   if (strlen(one_journal_rec.monat) > 1)
   {
      month_for_bibtex(one_journal_rec.monat,wrtxtbu,WRTXTBU_LEN);
      if (strlen(wrtxtbu) > 0)
      {
         strlimcat(ausgabe_zeile,",\n  month = ",AUSGABEZEILE_LEN);
         strlimcat(ausgabe_zeile,wrtxtbu,AUSGABEZEILE_LEN);
      }
   }


   strlimcat(ausgabe_zeile,"\n}\n\n",AUSGABEZEILE_LEN);
}

static void compile_j2_list_bib(void)
{
   strlimcat(ausgabe_zeile,"  author = {{",AUSGABEZEILE_LEN);
   if (strlen(one_journal_rec.instau) > 0)
   {
     strlimcat(ausgabe_zeile,one_journal_rec.instau,AUSGABEZEILE_LEN);
   } else
   {
     strlimcat(ausgabe_zeile,"Anonymous",AUSGABEZEILE_LEN);
   }
   strlimcat(ausgabe_zeile,"}}",AUSGABEZEILE_LEN);
   if (strlen(one_journal_rec.titel)>0)
   {
     strlimcat(ausgabe_zeile,",\n  title = {{",AUSGABEZEILE_LEN);
     strlimcat(ausgabe_zeile,one_journal_rec.titel,AUSGABEZEILE_LEN);
     /* to be reconsidered: */
     if (satzzeichen(ausgabe_zeile))
     {
        endst_satzzeichen_entfernen(ausgabe_zeile);
     } 
     strlimcat(ausgabe_zeile,"}}",AUSGABEZEILE_LEN);
   }

   strncpy(quell_schluessel,one_journal_rec.kuerzel,KUERZEL_LEN);
   if (locate_ix02(quell_schluessel,&ix02rec) > -1)
   {
       long byte_zeiger;
       byte_zeiger = ix02rec.quell_rptr * sizeof(one_quell_rec);
       fseek(fpsource,byte_zeiger,SEEK_SET);
       fread(&one_quell_rec,sizeof(one_quell_rec),1,fpsource);
       if (strlen(one_quell_rec.quell_zeitschrift)>0)
       { 
         strlimcat(ausgabe_zeile,",\n  journal = {",AUSGABEZEILE_LEN);
         strlimcat(ausgabe_zeile,one_quell_rec.quell_zeitschrift,AUSGABEZEILE_LEN);
         strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
       }
   }
   else
   {
      sprintf(wrtxtbu,"# %s: JOURNAL name corresponding to [%s] not found",haupt_schluessel,quell_schluessel);
      logdatei_schreiben(wrtxtbu);
   }

   if (strlen(one_journal_rec.jahrgang)>0)
   {
      strlimcat(ausgabe_zeile,",\n  year = {",AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   }
   if (strlen(one_journal_rec.band)>0)
   {
     strlimcat(ausgabe_zeile,",\n  volume = {",AUSGABEZEILE_LEN);
     strlimcat(ausgabe_zeile,one_journal_rec.band,AUSGABEZEILE_LEN);
     strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   }
   if (strlen(one_journal_rec.seite_von)>0)
   {
     strlimcat(ausgabe_zeile,",\n  pages = {",AUSGABEZEILE_LEN);
     strlimcat(ausgabe_zeile,one_journal_rec.seite_von,AUSGABEZEILE_LEN);
     if (strlen(one_journal_rec.seite_bis)>0)
     {
        strlimcat(ausgabe_zeile,"--",AUSGABEZEILE_LEN);
        strlimcat(ausgabe_zeile,one_journal_rec.seite_bis,AUSGABEZEILE_LEN);
     }
     strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   }
   if (strlen(one_journal_rec.monat) > 1)
   {
      month_for_bibtex(one_journal_rec.monat,wrtxtbu,WRTXTBU_LEN);
      if (strlen(wrtxtbu) > 0)
      {
         strlimcat(ausgabe_zeile,",\n  month = ",AUSGABEZEILE_LEN);
         strlimcat(ausgabe_zeile,wrtxtbu,AUSGABEZEILE_LEN);
      }
   }


   strlimcat(ausgabe_zeile,"\n}\n\n",AUSGABEZEILE_LEN);
}


static void compile_b1_list_bib(void)
{
   long byte_zeiger;

   compile_aued_list_bbt(fpautorbu, ed_zeile,ix01rec.autorbu_rptr);
   strlimcat(ausgabe_zeile,"  editor = {",AUSGABEZEILE_LEN);
   strlimcat(ausgabe_zeile,ed_zeile,AUSGABEZEILE_LEN);
   strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
   fseek(fpbuch,byte_zeiger,SEEK_SET);
   fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);

   if (strlen(one_buch_rec.titel_bu) > 0)
   {
     strlimcat(ausgabe_zeile,",\n  title = {{",AUSGABEZEILE_LEN);
     strlimcat(ausgabe_zeile,one_buch_rec.titel_bu,AUSGABEZEILE_LEN);
     if (satzzeichen(ausgabe_zeile))
     {
        endst_satzzeichen_entfernen(ausgabe_zeile);
     } 
     strlimcat(ausgabe_zeile,"}}",AUSGABEZEILE_LEN);
   }
   if (strlen(one_journal_rec.band) >0)
   {
      strlimcat(ausgabe_zeile,",\n  edition = {",AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,one_journal_rec.band,AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   }
   if (strlen(one_buch_rec.publ_ort) > 0)
   {
      strlimcat(ausgabe_zeile,",\n  address = {",AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,one_buch_rec.publ_ort,AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   }
   if (strlen(one_buch_rec.verlag) > 0)
   {
      strlimcat(ausgabe_zeile,",\n  publisher = {",AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,one_buch_rec.verlag,AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   }
   if (strlen(one_journal_rec.seite_von)>0)
   {
     strlimcat(ausgabe_zeile,",\n  pages = {",AUSGABEZEILE_LEN);
     strlimcat(ausgabe_zeile,one_journal_rec.seite_von,AUSGABEZEILE_LEN);
     if (strlen(one_journal_rec.seite_bis)>0)
     {
        strlimcat(ausgabe_zeile,"--",AUSGABEZEILE_LEN);
        strlimcat(ausgabe_zeile,one_journal_rec.seite_bis,AUSGABEZEILE_LEN);
     }
     strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   }
   if (strlen(one_journal_rec.jahrgang)>0)
   {
      strlimcat(ausgabe_zeile,",\n  year = {",AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   }
   strlimcat(ausgabe_zeile,"\n}\n\n",AUSGABEZEILE_LEN);
}



static void compile_b2_list_bib(void)
{
   long byte_zeiger;
   compile_aued_list_bbt(fpautorbu, ed_zeile,ix01rec.autorbu_rptr);
   compile_aued_list_bbt(fpautorjl, au_zeile,ix01rec.autorjl_rptr);
   
   strlimcat(ausgabe_zeile,"  editor = {",AUSGABEZEILE_LEN);
   strlimcat(ausgabe_zeile,ed_zeile,AUSGABEZEILE_LEN);
   strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   strlimcat(ausgabe_zeile,",\n  author = {",AUSGABEZEILE_LEN);
   strlimcat(ausgabe_zeile,au_zeile,AUSGABEZEILE_LEN);
   strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   
   byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
   fseek(fpbuch,byte_zeiger,SEEK_SET);
   fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);
   if (strlen(one_buch_rec.titel_bu) > 0)
   {
     strlimcat(ausgabe_zeile,",\n  booktitle = {{",AUSGABEZEILE_LEN);
     strlimcat(ausgabe_zeile,one_buch_rec.titel_bu,AUSGABEZEILE_LEN);
     if (satzzeichen(ausgabe_zeile))
     {
        endst_satzzeichen_entfernen(ausgabe_zeile);
     } 
     strlimcat(ausgabe_zeile,"}}",AUSGABEZEILE_LEN);
   }
   if (strlen(one_journal_rec.titel)>0)
   {
     strlimcat(ausgabe_zeile,",\n  title = {{",AUSGABEZEILE_LEN);
     strlimcat(ausgabe_zeile,one_journal_rec.titel,AUSGABEZEILE_LEN);
     if (satzzeichen(ausgabe_zeile))
     {
        endst_satzzeichen_entfernen(ausgabe_zeile);
     } 
     strlimcat(ausgabe_zeile,"}}",AUSGABEZEILE_LEN);
   }
   if (strlen(one_journal_rec.band) >0)
   {
      strlimcat(ausgabe_zeile,",\n  edition = {",AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,one_journal_rec.band,AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   }
   if (strlen(one_buch_rec.publ_ort) > 0)
   {
      strlimcat(ausgabe_zeile,",\n  address = {",AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,one_buch_rec.publ_ort,AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   }
   if (strlen(one_buch_rec.verlag) > 0)
   {
      strlimcat(ausgabe_zeile,",\n  publisher = {",AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,one_buch_rec.verlag,AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   }
   if (strlen(one_journal_rec.seite_von)>0)
   {
     strlimcat(ausgabe_zeile,",\n  pages = {",AUSGABEZEILE_LEN);
     strlimcat(ausgabe_zeile,one_journal_rec.seite_von,AUSGABEZEILE_LEN);
     if (strlen(one_journal_rec.seite_bis)>0)
     {
        strlimcat(ausgabe_zeile,"--",AUSGABEZEILE_LEN);
        strlimcat(ausgabe_zeile,one_journal_rec.seite_bis,AUSGABEZEILE_LEN);
     }
     strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   }
   if (strlen(one_journal_rec.jahrgang)>0)
   {
      strlimcat(ausgabe_zeile,",\n  year = {",AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   }
   strlimcat(ausgabe_zeile,"\n}\n\n",AUSGABEZEILE_LEN);
}

static void compile_b3_list_bib(void)
{
   long byte_zeiger;

   // compile_aued_list_bbt(fpautorbu, ed_zeile,ix01rec.autorbu_rptr);
   // strlimcat(ausgabe_zeile,"  editor = {",AUSGABEZEILE_LEN);

   /*  next 3 lines put here to make 'insted' field available (changed 
       in v4.1)*/
   byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
   fseek(fpbuch,byte_zeiger,SEEK_SET);
   fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);
   
   strlimcat(ausgabe_zeile,"  editor = {{",AUSGABEZEILE_LEN);
   // strlimcat(ausgabe_zeile,ed_zeile,AUSGABEZEILE_LEN);
   if (strlen(one_buch_rec.insted) > 0)
   {
     strlimcat(ausgabe_zeile,one_buch_rec.insted,AUSGABEZEILE_LEN);
   } else
   {
     strlimcat(ausgabe_zeile,"Anonymous",AUSGABEZEILE_LEN);
   }

   //strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   strlimcat(ausgabe_zeile,"}}",AUSGABEZEILE_LEN);
   /* 
   put upwards in function to make insted field available for 'inst. editors'
   byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
   fseek(fpbuch,byte_zeiger,SEEK_SET);
   fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);
   */
   if (strlen(one_buch_rec.titel_bu) > 0)
   {
     strlimcat(ausgabe_zeile,",\n  title = {{",AUSGABEZEILE_LEN);
     strlimcat(ausgabe_zeile,one_buch_rec.titel_bu,AUSGABEZEILE_LEN);
     if (satzzeichen(ausgabe_zeile))
     {
        endst_satzzeichen_entfernen(ausgabe_zeile);
     } 
     strlimcat(ausgabe_zeile,"}}",AUSGABEZEILE_LEN);
   }
   if (strlen(one_journal_rec.band) >0)
   {
      strlimcat(ausgabe_zeile,",\n  edition = {",AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,one_journal_rec.band,AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   }
   if (strlen(one_buch_rec.publ_ort) > 0)
   {
      strlimcat(ausgabe_zeile,",\n  address = {",AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,one_buch_rec.publ_ort,AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   }
   if (strlen(one_buch_rec.verlag) > 0)
   {
      strlimcat(ausgabe_zeile,",\n  publisher = {",AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,one_buch_rec.verlag,AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   }
   if (strlen(one_journal_rec.seite_von)>0)
   {
     strlimcat(ausgabe_zeile,",\n  pages = {",AUSGABEZEILE_LEN);
     strlimcat(ausgabe_zeile,one_journal_rec.seite_von,AUSGABEZEILE_LEN);
     if (strlen(one_journal_rec.seite_bis)>0)
     {
        strlimcat(ausgabe_zeile,"--",AUSGABEZEILE_LEN);
        strlimcat(ausgabe_zeile,one_journal_rec.seite_bis,AUSGABEZEILE_LEN);
     }
     strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   }
   if (strlen(one_journal_rec.jahrgang)>0)
   {
      strlimcat(ausgabe_zeile,",\n  year = {",AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   }
   strlimcat(ausgabe_zeile,"\n}\n\n",AUSGABEZEILE_LEN);
}

static void compile_m1_list_bib(void)
{
   compile_aued_list_bbt(fpautorjl, au_zeile,ix01rec.autorjl_rptr);
   strlimcat(ausgabe_zeile,"  author = {",AUSGABEZEILE_LEN);
   strlimcat(ausgabe_zeile,au_zeile,AUSGABEZEILE_LEN);
   strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   if (strlen(one_journal_rec.titel)>0)
   {
     strlimcat(ausgabe_zeile,",\n  title = {{",AUSGABEZEILE_LEN);
     strlimcat(ausgabe_zeile,one_journal_rec.titel,AUSGABEZEILE_LEN);
     /* to be reconsidered: */
     if (satzzeichen(ausgabe_zeile))
     {
        endst_satzzeichen_entfernen(ausgabe_zeile);
     } 
     strlimcat(ausgabe_zeile,"}}",AUSGABEZEILE_LEN);
   }

   // strncpy(quell_schluessel,one_journal_rec.kuerzel,KUERZEL_LEN);
   // if (locate_ix02(quell_schluessel,&ix02rec) > -1)
   // {
   //     long byte_zeiger;
   //     byte_zeiger = ix02rec.quell_rptr * sizeof(one_quell_rec);
   //     fseek(fpsource,byte_zeiger,SEEK_SET);
   //     fread(&one_quell_rec,sizeof(one_quell_rec),1,fpsource);
   //     if (strlen(one_quell_rec.quell_zeitschrift)>0)
   //     { 
   //       strlimcat(ausgabe_zeile,",\n  journal = {",AUSGABEZEILE_LEN);
   //       strlimcat(ausgabe_zeile,one_quell_rec.quell_zeitschrift,AUSGABEZEILE_LEN);
   //       strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   //     }
   // }
   // else
   // {
   //    sprintf(wrtxtbu,"# %s: JOURNAL name corresponding to [%s] not found",haupt_schluessel,quell_schluessel);
   //    logdatei_schreiben(wrtxtbu);
   // }

   if (strlen(one_journal_rec.howpublished)>0)
   {
      strlimcat(ausgabe_zeile,",\n  howpublished = {",AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,one_journal_rec.howpublished,AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   }
   if (strlen(one_journal_rec.jahrgang)>0)
   {
      strlimcat(ausgabe_zeile,",\n  year = {",AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   }
   // if (strlen(one_journal_rec.band)>0)
   // {
   //   strlimcat(ausgabe_zeile,",\n  volume = {",AUSGABEZEILE_LEN);
   //   strlimcat(ausgabe_zeile,one_journal_rec.band,AUSGABEZEILE_LEN);
   //   strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   // }
   if (strlen(one_journal_rec.seite_von)>0)
   {
     strlimcat(ausgabe_zeile,",\n  pages = {",AUSGABEZEILE_LEN);
     strlimcat(ausgabe_zeile,one_journal_rec.seite_von,AUSGABEZEILE_LEN);
     if (strlen(one_journal_rec.seite_bis)>0)
     {
        strlimcat(ausgabe_zeile,"--",AUSGABEZEILE_LEN);
        strlimcat(ausgabe_zeile,one_journal_rec.seite_bis,AUSGABEZEILE_LEN);
     }
     strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   }
   if (strlen(one_journal_rec.monat) > 1)
   {
      month_for_bibtex(one_journal_rec.monat,wrtxtbu,WRTXTBU_LEN);
      if (strlen(wrtxtbu) > 0)
      {
         strlimcat(ausgabe_zeile,",\n  month = ",AUSGABEZEILE_LEN);
         strlimcat(ausgabe_zeile,wrtxtbu,AUSGABEZEILE_LEN);
      }
   }


   strlimcat(ausgabe_zeile,"\n}\n\n",AUSGABEZEILE_LEN);
}


static void compile_m2_list_bib(void)
{
   strlimcat(ausgabe_zeile,"  author = {{",AUSGABEZEILE_LEN);
   if (strlen(one_journal_rec.instau) > 0)
   {
     strlimcat(ausgabe_zeile,one_journal_rec.instau,AUSGABEZEILE_LEN);
   } else
   {
     strlimcat(ausgabe_zeile,"Anonymous",AUSGABEZEILE_LEN);
   }
   strlimcat(ausgabe_zeile,"}}",AUSGABEZEILE_LEN);
   if (strlen(one_journal_rec.titel)>0)
   {
     strlimcat(ausgabe_zeile,",\n  title = {{",AUSGABEZEILE_LEN);
     strlimcat(ausgabe_zeile,one_journal_rec.titel,AUSGABEZEILE_LEN);
     /* to be reconsidered: */
     if (satzzeichen(ausgabe_zeile))
     {
        endst_satzzeichen_entfernen(ausgabe_zeile);
     } 
     strlimcat(ausgabe_zeile,"}}",AUSGABEZEILE_LEN);
   }

   // strncpy(quell_schluessel,one_journal_rec.kuerzel,KUERZEL_LEN);
   // if (locate_ix02(quell_schluessel,&ix02rec) > -1)
   // {
   //     long byte_zeiger;
   //     byte_zeiger = ix02rec.quell_rptr * sizeof(one_quell_rec);
   //     fseek(fpsource,byte_zeiger,SEEK_SET);
   //     fread(&one_quell_rec,sizeof(one_quell_rec),1,fpsource);
   //     if (strlen(one_quell_rec.quell_zeitschrift)>0)
   //     { 
   //       strlimcat(ausgabe_zeile,",\n  journal = {",AUSGABEZEILE_LEN);
   //       strlimcat(ausgabe_zeile,one_quell_rec.quell_zeitschrift,AUSGABEZEILE_LEN);
   //       strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   //     }
   // }
   // else
   // {
   //    sprintf(wrtxtbu,"# %s: JOURNAL name corresponding to [%s] not found",haupt_schluessel,quell_schluessel);
   //    logdatei_schreiben(wrtxtbu);
   // }

   if (strlen(one_journal_rec.howpublished)>0)
   {
      strlimcat(ausgabe_zeile,",\n  howpublished = {",AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,one_journal_rec.howpublished,AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   }
   if (strlen(one_journal_rec.jahrgang)>0)
   {
      strlimcat(ausgabe_zeile,",\n  year = {",AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   }
   // if (strlen(one_journal_rec.band)>0)
   // {
   //   strlimcat(ausgabe_zeile,",\n  volume = {",AUSGABEZEILE_LEN);
   //   strlimcat(ausgabe_zeile,one_journal_rec.band,AUSGABEZEILE_LEN);
   //   strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   // }
   if (strlen(one_journal_rec.seite_von)>0)
   {
     strlimcat(ausgabe_zeile,",\n  pages = {",AUSGABEZEILE_LEN);
     strlimcat(ausgabe_zeile,one_journal_rec.seite_von,AUSGABEZEILE_LEN);
     if (strlen(one_journal_rec.seite_bis)>0)
     {
        strlimcat(ausgabe_zeile,"--",AUSGABEZEILE_LEN);
        strlimcat(ausgabe_zeile,one_journal_rec.seite_bis,AUSGABEZEILE_LEN);
     }
     strlimcat(ausgabe_zeile,"}",AUSGABEZEILE_LEN);
   }
   if (strlen(one_journal_rec.monat) > 1)
   {
      month_for_bibtex(one_journal_rec.monat,wrtxtbu,WRTXTBU_LEN);
      if (strlen(wrtxtbu) > 0)
      {
         strlimcat(ausgabe_zeile,",\n  month = ",AUSGABEZEILE_LEN);
         strlimcat(ausgabe_zeile,wrtxtbu,AUSGABEZEILE_LEN);
      }
   }


   strlimcat(ausgabe_zeile,"\n}\n\n",AUSGABEZEILE_LEN);
}



static void compile_aued_list_bbt(FILE * fpaued, 
                                  char * auedstring, 
                                  long zeiger)
{
   int anzahl_n, i, j, anzahl_vornamen;
   long byte_zeiger;
   char vn[2];
   
   strcpy(auedstring,"");
   byte_zeiger = zeiger * sizeof(one_aued_rec);
   fseek(fpaued,byte_zeiger,SEEK_SET);
   fread(&one_aued_rec,sizeof(one_aued_rec),1,fpaued);
   fseek(fpaued,byte_zeiger,SEEK_SET);
   anzahl_n = one_aued_rec.au_n;
   /*
   for (i=1;i<=anzahl_n;i++)
   {
        fread(&one_aued_rec,sizeof(one_aued_rec),1,fpaued);
        anzahl_vornamen = strlen(one_aued_rec.au_vornamen);
        {
           for (j=0;j < anzahl_vornamen;j++)
           {
             vn[0]=one_aued_rec.au_vornamen[j];
             vn[1]='\0';
             strlimcat(auedstring,vn,AUTORZEILE_LEN);
             strlimcat(auedstring,". ",AUTORZEILE_LEN);
           }
        }
        strlimcat(auedstring,one_aued_rec.au_nachname,AUTORZEILE_LEN);
        if  (i<anzahl_n) strlimcat(auedstring," and ",AUTORZEILE_LEN);
   }
   */
   for (i=1;i<=anzahl_n;i++)
   {
        fread(&one_aued_rec,sizeof(one_aued_rec),1,fpaued);
        
        strlimcat(auedstring,one_aued_rec.au_nachname,AUTORZEILE_LEN);
        strlimcat(auedstring,", ",AUTORZEILE_LEN);
        anzahl_vornamen = strlen(one_aued_rec.au_vornamen);
        {
           for (j=0;j < anzahl_vornamen;j++)
           {
             vn[0]=one_aued_rec.au_vornamen[j];
             vn[1]='\0';
             strlimcat(auedstring,vn,AUTORZEILE_LEN);
             strlimcat(auedstring,". ",AUTORZEILE_LEN);
           }
        }
        if  (i<anzahl_n) 
        {
            strlimcat(auedstring,"and ",AUTORZEILE_LEN);
        } else
        {
            rtrim(auedstring,' ');
        }
   }
}

static void month_for_bibtex(char * ziffer_in, char * name_out, int laenge)
{
   trim(ziffer_in,' ');
   ltrim(ziffer_in,'0'); /* 02 -> 2 */
   
   strcpy(name_out,"");
   if (strcmp(ziffer_in,"1")==0)
   {
      strlimcpy(name_out,"jan",laenge);
   }
   if (strcmp(ziffer_in,"2")==0)
   {
      strlimcpy(name_out,"feb",laenge);
   }
   if (strcmp(ziffer_in,"3")==0)
   {
      strlimcpy(name_out,"mar",laenge);
   }
   if (strcmp(ziffer_in,"4")==0)
   {
      strlimcpy(name_out,"apr",laenge);
   }
   if (strcmp(ziffer_in,"5")==0)
   {
      strlimcpy(name_out,"may",laenge);
   }
   if (strcmp(ziffer_in,"6")==0)
   {
      strlimcpy(name_out,"jun",laenge);
   }
   if (strcmp(ziffer_in,"7")==0)
   {
      strlimcpy(name_out,"jul",laenge);
   }
   if (strcmp(ziffer_in,"8")==0)
   {
      strlimcpy(name_out,"aug",laenge);
   }
   if (strcmp(ziffer_in,"9")==0)
   {
      strlimcpy(name_out,"sep",laenge);
   }
   if (strcmp(ziffer_in,"10")==0)
   {
      strlimcpy(name_out,"oct",laenge);
   }
   if (strcmp(ziffer_in,"11")==0)
   {
      strlimcpy(name_out,"nov",laenge);
   }
   if (strcmp(ziffer_in,"12")==0)
   {
      strlimcpy(name_out,"dec",laenge);
   }
   return;
}
