/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/*
    ix04_fun.c -- documentation in ix01_fun.c
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "refs.h"
#include "ix04_fun.h"
#include "str_fun.h"
#include "fl_ut.h"
#include "interf.h"

 extern char wrtxtbu[WRTXTBU_LEN + 1];


 FILE * ix04file;

void mrgeix04(char * srcl_name, char * srcsh_name, char * destin_name)
{
   FILE * srcl;
   FILE * srcsh;
   FILE * destin;
   long i,j;
   long max_srcl, max_srcsh;
   int done_srcl, done_srcsh;

   abstrpix_rec top_srcl, top_srcsh;
   int doneall;
   done_srcl = 0; done_srcsh = 0;

   if ((srcl=fopen(srcl_name,"rb"))==NULL)
   {
      fprintf(stderr,"\nProblem: Cannot open SRCL\n");
      exit(1);
   }

   if(setvbuf(srcl,NULL,_IOFBF,20000)!=0)
   {
      fprintf(stderr,"\nProblem: Failed to set up buffer for srcl\n");
      exit(1);
   }

   if ((srcsh=fopen(srcsh_name,"rb"))==NULL)
   {
      fprintf(stderr,"\nProblem: Cannot open SRCSH\n");
      exit(1);
   }

   if (setvbuf(srcsh,NULL,_IOFBF,4000)!=0)
   {
      fprintf(stderr,"\nProblem: Failed to set up buffer for srcsh\n");
      exit(1);
   }

   if ((destin=fopen(destin_name,"wb"))==NULL)
   {
      fprintf(stderr,"\nProblem: Cannot open DESTIN\n");
      exit(1);
   }

   if (setvbuf(destin,NULL,_IOFBF,25000)!=0)
   {
      fprintf(stderr,"\nProblem: Failed to set up buffer for destin\n");
      exit(1);
   }


   fseek(srcl,0L,SEEK_END); max_srcl=ftell(srcl)/sizeof(top_srcl);
   rewind(srcl);
   fseek(srcsh,0L,SEEK_END); max_srcsh=ftell(srcsh)/sizeof(top_srcsh);
   rewind(srcsh);

   /* wrtxt("(Rebuilding index file: adding keys) "); */
   i=0;j=0;
   doneall = 0;

   if (i >= max_srcl) done_srcl = 1;
   if (i < max_srcl)
   {

       fread(&top_srcl,sizeof(top_srcl),1,srcl);
       i++;
   }

   if (j >= max_srcsh) done_srcsh = 1;
   if (j < max_srcsh)
   {
        fread(&top_srcsh,sizeof(top_srcsh),1,srcsh);
        j++;
   }

   do
   {
      if ((!done_srcsh) && (done_srcl))
      {
        if (fwrite(&top_srcsh,sizeof(top_srcsh),1,destin) < 1) schreibfehler();
        if (j >= max_srcsh) done_srcsh = 1;
        if (j < max_srcsh)
        {
           fread(&top_srcsh,sizeof(top_srcsh),1,srcsh);
           j++;
        }
      }

      else if ((done_srcsh) && (!done_srcl))
      {
        if (fwrite(&top_srcl,sizeof(top_srcl),1,destin) < 1) schreibfehler();
        if (i >= max_srcl) done_srcl = 1;
        if (i < max_srcl)
        {
           fread(&top_srcl,sizeof(top_srcl),1,srcl);
           i++;
        }
      }

      else if (strcmp(top_srcl.kennziffer,top_srcsh.kennziffer) < 0)
      {
           if (fwrite(&top_srcl,sizeof(top_srcl),1,destin) < 1) schreibfehler();
           if (i >= max_srcl) done_srcl = 1;
           if (i < max_srcl)
           {
              fread(&top_srcl,sizeof(top_srcl),1,srcl);
              i++;
           }
      }

      else // ..if ((top_srcl <= top_srcsh))
      {
            if (fwrite(&top_srcsh,sizeof(top_srcsh),1,destin) < 1) schreibfehler();
            if (j >= max_srcsh) done_srcsh = 1;
            if (j < max_srcsh)
            {
               fread(&top_srcsh,sizeof(top_srcsh),1,srcsh);
               j++;
            }
      }
      if (done_srcsh && done_srcl)
          doneall=1;
   } while (!doneall);
   fclose(srcl); fclose(srcsh); fclose(destin);
}


int read_ix04(char * datname)
{
  if ((ix04file=fopen(datname,"rb"))==NULL)
  {
     sprintf(wrtxtbu,"ERROR: Cannot open index file %s for reading\n",datname);
     wrtxt(wrtxtbu);
     return 0;
  }
  return 1;
}

int read_write_ix04(char * datname)
{
  if ((ix04file=fopen(datname,"r+b"))==NULL)
  {
     sprintf(wrtxtbu,"ERROR: Cannot open index file %s for reading and writing\n",datname);
     wrtxt(wrtxtbu);
     return 0;
  }
  return 1;
}

int close_ix04(void)
{
   fclose(ix04file);
   return 1;
}


long locate_ix04(const char * keyval, abstrpix_rec * recd)
{
   long l, r, x, n;
   l = 0;
   fseek(ix04file,0L,SEEK_END);
   n = (ftell(ix04file)/sizeof(abstrpix_rec)) -1;  /* Groesster Wert mit Pos. n-1 */
   r = n;
   while (r >= l)
   {
      x = (l + r)/2;
      fseek(ix04file,x*sizeof(abstrpix_rec),SEEK_SET);
      if (fread(recd,sizeof(abstrpix_rec),1,ix04file)!=1)
      {
         fprintf(stderr,"\nProblem: ERROR in locate_ix04(): Unable to "
            "read index file\n");
         exit(1);
      }

      if (strcmp(keyval,recd->kennziffer) < 0) r = x-1; else l = x+1;
      if (strcmp(keyval,recd->kennziffer) == 0)
      {
         fseek(ix04file,-(long) sizeof(abstrpix_rec),SEEK_CUR);
         return x;
      }
   }
   return -1;
}




void deleteix04(char * ixfile_name, char * srcsh_name, char * destin_name)
{
   FILE * srcsh;
   FILE * destin;
   long i,keyfound;

   abstrpix_rec rec_ix, rec_srcsh;
   long max_ixfile, max_srcsh;

   if ((ix04file=fopen(ixfile_name,"r+b"))==NULL)
   {
       fprintf(stderr,"\nProblem: Cannot open SRCL\n");
       exit(1);
   }

   if(setvbuf(ix04file,NULL,_IOFBF,20000)!=0)
   {
      fprintf(stderr,"\nProblem: Failed to set up buffer for ix04file\n");
      exit(1);
   }

   if ((srcsh=fopen(srcsh_name,"rb"))==NULL)
   {
      fprintf(stderr,"\nProblem: Cannot open SRCSH\n");
      exit(1);
   }

   if (setvbuf(srcsh,NULL,_IOFBF,4000)!=0)
   {
      fprintf(stderr,"\nProblem: Failed to set up buffer for srcsh\n");
      exit(1);
   }

   if ((destin=fopen(destin_name,"wb"))==NULL)
   {
      fprintf(stderr,"\nProblem: Cannot open DESTIN\n");
      exit(1);
   }

   if (setvbuf(destin,NULL,_IOFBF,25000)!=0)
   {
      fprintf(stderr,"\nProblem: Failed to set up buffer for destin\n");
      exit(1);
   }
   fseek(ix04file,0L,SEEK_END); max_ixfile=ftell(ix04file)/sizeof(abstrpix_rec); rewind(ix04file);
   fseek(srcsh,0L,SEEK_END); max_srcsh=ftell(srcsh)/sizeof(abstrpix_rec); rewind(srcsh);

   for (i=0;i<=max_srcsh-1;i++)
   {

      fread(&rec_srcsh,sizeof(abstrpix_rec),1,srcsh);
      keyfound =locate_ix04(rec_srcsh.kennziffer,&rec_ix);
      if (keyfound >= 0)
      {
          rec_ix.abstr_rptr = -1;
          if (fwrite(&rec_ix,sizeof(abstrpix_rec),1,ix04file) < 1) schreibfehler();
      }
   }
   fflush(ix04file);
   rewind(ix04file);
   /* wrtxt("(Rebuilding index file: deleting keys) "); */
   for (i=0;i<=max_ixfile-1;i++)
   {
      fread(&rec_ix,sizeof(abstrpix_rec),1,ix04file);
      if (rec_ix.abstr_rptr > -1) 
      {
        if (fwrite(&rec_ix,sizeof(abstrpix_rec),1,destin) < 1) schreibfehler();
      }
   }
   fclose(ix04file);fclose(srcsh); fclose(destin);

}


void appendix04(char * destin_name, char * src_name)
{
   FILE * src;
   FILE * destin;
   long i;

   long  max_src;
   abstrpix_rec recd;

   if ((src=fopen(src_name,"rb"))==NULL)
   {
       fprintf(stderr,"\nProblem: Cannot open SRCL\n");
       exit(1);
   }

   if(setvbuf(src,NULL,_IOFBF,10000)!=0)
   {
      fprintf(stderr,"\nProblem: Failed to set up buffer for srcl\n");
      exit(1);
   }

   if ((destin=fopen(destin_name,"r+b"))==NULL)
   {
      fprintf(stderr,"\nProblem: Cannot open DESTIN\n");
      exit(1);
   }

   if (setvbuf(destin,NULL,_IOFBF,10000)!=0)
   {
      fprintf(stderr,"\nProblem: Failed to set up buffer for destin\n");
      exit(1);
   }

   fseek(src,0L,SEEK_END); max_src=ftell(src)/sizeof(abstrpix_rec); rewind(src);

   fseek(destin,0L,SEEK_END);
   rewind(src);
   for (i=0;i<=max_src-1;i++)
   {
      fread(&recd,sizeof(abstrpix_rec),1,src);
      if (fwrite(&recd,sizeof(abstrpix_rec),1,destin) < 1) schreibfehler();
   }
   fclose(src); fclose(destin);
}




int ok_appix04(char * destin_name, char * src_name)
{
   FILE * src;
   FILE * destin;
   abstrpix_rec src_rec, destin_rec;
   if ((src=fopen(src_name,"rb"))==NULL)
   {
     fprintf(stderr,"\nProblem: Cannot open SRCL\n");
     exit(1);
   }
   if ((destin=fopen(destin_name,"rb"))==NULL)
   {
       fprintf(stderr,"\nProblem: Cannot open DESTIN\n");
       exit(1);
   }
   rewind(src);
   fseek(destin,-(long) sizeof(abstrpix_rec),SEEK_END);
   fread(&src_rec,sizeof(abstrpix_rec),1,src);
   fread(&destin_rec,sizeof(abstrpix_rec),1,destin);
   /* uncomment for debugging
   sprintf(wrtxtbu,"(src %s, destin %s)\n",src_rec.kennziffer,destin_rec.kennziffer);
   wrtxt(wrtxtbu);
   */
   fclose(src); fclose(destin);
   if (strcmp(destin_rec.kennziffer,src_rec.kennziffer) < 1)
      return 1;
   else return 0;
}


long scanseq_ix04(const char * keyval, abstrpix_rec * recd, char * ix_name)
{
   FILE * ix_fp;
   long i, n;

   if (filesize(ix_name) < sizeof(abstrpix_rec))
   {
      return -1;
   }

   if ((ix_fp=fopen(ix_name,"rb"))==NULL)
   {
      fprintf(stderr,"\nProblem: ERROR in scanseq_ix04: cannot "
         "open %s\n",ix_name);
      exit(1);
   }
   if (setvbuf(ix_fp,NULL,_IOFBF,5000)!=0)
   {
      fprintf(stderr,"\nProblem: ERROR in scanseq_ix04: cannot set up "
          "buffer for reading %s\n",ix_name);
      exit(1);
   }
   fseek(ix_fp,-(long) sizeof(abstrpix_rec),SEEK_END);
   n = (ftell(ix_fp)/sizeof(abstrpix_rec));
   rewind(ix_fp);
   for (i=0;i<=n;i++)
   {
      if (fread(recd,sizeof(abstrpix_rec),1,ix_fp)!=1)
      {
         fprintf(stderr,"\nProblem: ERROR in scanseq_ix04: cannot read "
             "record in %s\n",ix_name);
         exit(1);
      }
      if (strcmp(keyval,recd->kennziffer)==0)
      {
          fseek(ix_fp,-(long) sizeof(abstrpix_rec),SEEK_CUR);
          fclose(ix_fp);
          return i;
      }
   }
   fclose(ix_fp);
   return -1;
}

