'\"
'\" Copyright (c) 2004 Joe English
'\" 
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: ttk_widget.n,v 1.3 2006/12/13 23:04:33 hobbs Exp $
'\" 
.so man.macros
.TH ttk_widget n 8.5 Tk "Tk Themed Widget"
.BS
.SH NAME
ttk_widget \- Standard options and commands supported by Tk themed widgets
.BE

.SH DESCRIPTION
This manual describes common widget options and commands.

.SH "STANDARD OPTIONS"
The following options are supported by all Tk themed widgets:
.OP \-class undefined undefined
Specifies the window class.
The class is used when querying the option database 
for the window's other options, to determine the default
bindtags for the window, and to select the widget's default
layout and style.
This is a read-only option: 
it may only be specified when the window is created,
and may not be changed with the \fBconfigure\fR widget command.
.OP \-cursor cursor Cursor
Specifies the mouse cursor to be used for the widget.
See \fBTk_GetCursor\fR and \fIcursors(n)\fR in the Tk reference manual
for the legal values.
If set to the empty string (the default),
the cursor is inherited from the parent widget.
.OP \-takefocus takeFocus TakeFocus
Determines whether the window accepts the focus during keyboard traversal.  
Either \fB0\fR, \fB1\fR, a command prefix (to which the widget path
is appended, and which should return \fB0\fR or \fB1\fR), 
or the empty string.
See \fIoptions(n)\fR in the Tk reference manual for the full description.
.OP \-style style Style
May be used to specify a custom widget style.

.SH "SCROLLABLE WIDGET OPTIONS"
.PP
The following options are supported by widgets that
are controllable by a scrollbar.  
See \fIscrollbar(n)\fR for more information
.OP \-xscrollcommand xScrollCommand ScrollCommand
A command prefix, used to communicate with horizontal scrollbars.
.br
When the view in the widget's window changes, the widget will
generate a Tcl command by concatenating the scroll command and
two numbers.
Each of the numbers is a fraction between 0 and 1 indicating
a position in the document; 0 indicates the beginning,
and 1 indicates the end.
The first fraction indicates the first information in the widget
that is visible in the window, and the second fraction indicates
the information just after the last portion that is visible.
.br
Typically the \fBxScrollCommand\fR option consists of the path name 
of a \fBscrollbar\fR widget followed by ``set'', e.g. ``.x.scrollbar set''.
This will cause the scrollbar to be updated whenever the view in the 
window changes.
.br
If this option is set to the empty string (the default),
then no command is be executed.
.OP \-yscrollcommand yScrollCommand ScrollCommand
A command prefix, used to communicate with vertical scrollbars.
See the description of \fB-xscrollcommand\fR above for details.

.SH "LABEL OPTIONS"
The following options are supported by labels, buttons,
and other button-like widgets:
.OP \-text text Text
Specifies a text string to be displayed inside the widget
(unless overridden by \fB-textvariable\fR).
.OP \-textvariable textVariable Variable
Specifies the name of variable whose value will be used
in place of the \fB-text\fR resource.
.OP \-underline underline Underline
If set, specifies the integer index (0-based) of a character to underline 
in the text string.
The underlined character is used for mnemonic activation.
.OP \-image image Image
Specifies an image to display.
This is a list of 1 or more elements.
The first element is the default image name.
The rest of the list is a sequence of \fIstatespec / value\fR pairs
as per \fBstyle map\fR, specifying different images to use when
the widget is in a particular state or combination of states.
All images in the list should have the same size.
.OP \-compound compound Compound
Specifies how to display the image relative to the text,
in the case both \fB-text\fR and \fB-image\fR are present.
Valid values are: 
.RS
.IP text
Display text only.
.IP image
Display image only.
.IP center
Display text centered on top of image.
.IP top
.IP bottom
.IP left
.IP right
Display image above, below, left of, or right of the text, respectively.
.IP none
The default; display the image if present, otherwise the text.
.RE
.OP \-width width Width
If greater than zero, specifies how much space, in character widths, 
to allocate for the text label.  
If less than zero, specifies a minimum width.
If zero or unspecified, the natural width of the text label is used.

.SH "COMPATIBILITY OPTIONS"
.OP \-state state State
May be set to \fBnormal\fR or \fBdisabled\fR
to control the \fBdisabled\fR state bit.
This is a ``write-only'' option: setting it changes the
widget state, but the \fBstate\fR widget command does
not affect the state option.

.SH COMMANDS
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If one or more \fIoption\-value\fR pairs are specified,
then the command modifies the given widget option(s) 
to have the given value(s); 
in this case the command returns an empty string.
If \fIoption\fR is specified with no \fIvalue\fR, 
then the command returns a list describing the named option:
the elements of the list are the 
option name, database name, database class, default value, 
and current value.
.\" Note: Ttk widgets don't use TK_OPTION_SYNONYM.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR.
.TP 
\fIpathName \fBinstate\fR \fIstatespec\fR ?\fIscript\fR?
Test the widget's state.
If \fIscript\fR is not specified, returns 1 if 
the widget state matches \fIstatespec\fR and 0 otherwise.
If \fIscript\fR is specified, equivalent to
.CS
if {[\fIpathName\fR instate \fIstateSpec\fR]} \fIscript\fR
.CE
.TP 
\fIpathName \fBstate\fR ?\fIstateSpec\fR
Modify or inquire widget state.
If \fIstateSpec\fR is present, sets the widget state: 
for each flag in \fIstateSpec\fR, sets the corresponding flag
or clears it if prefixed by an exclamation point.
Returns a new state spec indicating which flags were changed:
.CS
set changes [\fIpathName \fRstate \fIspec\fR]
\fIpathName \fRstate $changes
.CE
will restore \fIpathName\fR to the original state.
If \fIstateSpec\fR is not specified, 
returns a list of the currently-enabled state flags.
.SH "WIDGET STATES"
The widget state is a bitmap of independent state flags.
Widget state flags include:
.TP
\fBactive\fR
The mouse cursor is over the widget 
and pressing a mouse button will cause some action to occur.
(aka "prelight" (Gnome), "hot" (Windows), "hover").
.TP
\fBdisabled\fR
Widget is disabled under program control 
(aka "unavailable", "inactive") 
.TP
\fBfocus\fR
Widget has keyboard focus 
.TP
\fBpressed\fR
Widget is being pressed (aka "armed" in Motif). 
.TP
\fBselected\fR
"On", "true", or "current" for things like checkbuttons and radiobuttons. 
.TP
\fBbackground\fR
Windows and the Mac have a notion of an "active" or foreground window.
The \fBbackground\fR state is set for widgets in a background window,
and cleared for those in the foreground window.
.TP
\fBreadonly\fR
Widget should not allow user modification.
.TP
\fBalternate\fR
A widget-specific alternate display format.
For example, used for checkbuttons and radiobuttons 
in the "tristate" or "mixed" state,
and for buttons with \fB-default active\fR.
.TP
\fBinvalid\fR
The widget's value is invalid.
(Potential uses: scale widget value out of bounds, 
entry widget value failed validation.)
.PP
A \fIstate specification\fR or \fIstateSpec\fR is a list
of state names, optionally prefixed with an exclamation point (!)
indicating that the bit is off.

.SH EXAMPLES
.CS
set b [ttk::button .b]

# Disable the widget:
$b state disabled			

# Invoke the widget only if it is currently pressed and enabled:
$b instate {pressed !disabled} { .b invoke }	

# Reenable widget:
$b state !disabled			
.CE

.SH "SEE ALSO"
ttk_intro(n), style(n)

.SH KEYWORDS
state, configure, option
