'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: eval.n,v 1.8 2007/02/18 18:42:54 dkf Exp $
'\" 
.so man.macros
.TH eval n "" Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
eval \- Evaluate a Tcl script
.SH SYNOPSIS
\fBeval \fIarg \fR?\fIarg ...\fR?
.BE

.SH DESCRIPTION
.PP
\fBEval\fR takes one or more arguments, which together comprise a Tcl
script containing one or more commands.
\fBEval\fR concatenates all its arguments in the same
fashion as the \fBconcat\fR command, passes the concatenated string to the
Tcl interpreter recursively, and returns the result of that
evaluation (or any error generated by it).
Note that the \fBlist\fR command quotes sequences of words in such a
way that they are not further expanded by the \fBeval\fR command.
.SH EXAMPLES
Often, it is useful to store a fragment of a script in a variable and
execute it later on with extra values appended. This technique is used
in a number of places throughout the Tcl core (e.g. in \fBfcopy\fR,
\fBlsort\fR and \fBtrace\fR command callbacks). This example shows how
to do this using core Tcl commands:
.CS
set script {
    puts "logging now"
    lappend $myCurrentLogVar
}
set myCurrentLogVar log1
# Set up a switch of logging variable part way through!
after 20000 set myCurrentLogVar log2

for {set i 0} {$i<10} {incr i} {
    # Introduce a random delay
    after [expr {int(5000 * rand())}]
    update    ;# Check for the asynch log switch
    \fBeval\fR $script $i [clock clicks]
}
.CE
.PP
.VS 8.5
Note that in the most common case (where the script fragment is
actually just a list of words forming a command prefix), it is better
to use \fB{*}$script\fR when doing this sort of invocation
pattern.  It is less general than the \fBeval\fR command, and hence
easier to make robust in practice.
.VE 8.5
The following procedure acts in a way that is analogous to the
\fBlappend\fR command, except it inserts the argument values at the
start of the list in the variable:
.CS
proc lprepend {varName args} {
   upvar 1 $varName var
   # Ensure that the variable exists and contains a list
   lappend var
   # Now we insert all the arguments in one go
   set var [\fBeval\fR [list linsert $var 0] $args]
}
.CE
.VS 8.5
However, the last line would now normally be written without
\fBeval\fR, like this:
.CS
set var [linsert $var 0 {*}$args]
.CE
.VE 8.5

.SH KEYWORDS
concatenate, evaluate, script

.SH "SEE ALSO"
catch(n), concat(n), error(n), interp(n), list(n), namespace(n), subst(n), tclvars(n), uplevel(n)
