'\"
'\" Copyright (c) 2003 Donal K. Fellows
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" RCS: @(#) $Id: dict.n,v 1.2 2003/04/10 13:11:06 dkf Exp $
'\"
.so man.macros
.TH dict n 8.5 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
dict \- Manipulate dictionaries.
.SH SYNOPSIS
\fBdict \fIoption arg \fR?\fIarg ...\fR?
.BE

.SH DESCRIPTION
.PP
Performs one of several operations on dictionary values or variables
containing dictionary values, depending on \fIoption\fR.  The legal
\fIoption\fRs (which may be abbreviated) are:
.TP
\fBdict append \fIdictionaryVariable key \fR?\fIstring ...\fR?
This appends the given string (or strings) to the value that the given
key maps to in the dictionary value contained in the given variable,
writing the resulting dictionary value back to that variable.
Non-existent keys are treated as if they map to an empty string.
.TP
\fBdict create \fR?\fIkey value ...\fR?
Create a new dictionary that contains each of the key/value mappings
listed as arguments (keys and values alternating, with each key being
followed by its associated value.)
.TP
\fBdict exists \fIdictionaryValue key \fR?\fIkey ...\fR?
This returns a boolean value indicating whether the given key (or path
of keys through a set of nested dictionaries) exists in the given
dictionary value. This returns a true value exactly when \fBdict
get\fR on that path will succeed.
.TP
\fBdict filter \fIdictionaryValue filterType arg \fR?\fIarg ...\fR?
This takes a dictionary value and returns a new dictionary that
contains just those key/value pairs that match the specified filter
type (which may be abbreviated.)  Supported filter types are:
.RS
.TP
\fBdict filter \fIdictionaryValue \fBkey \fIglobPattern\fR
The key rule only matches those key/value pairs whose keys match the
given pattern (in the style of \fBstring match\fR.)
.TP
\fBdict filter \fIdictionaryValue \fBscript {\fIkeyVar valueVar\fB} \fIscript\fR
The script rule tests for matching by assigning the key to the
\fIkeyVar\fR and the value to the \fIvalueVar\fR, and then evaluating
the given script which should return a boolean value (with the
key/value pair only being included in the result of the \fBdict
filter\fR when a true value is returned.)  Note that the first
argument after the rule selection word is a two-element list.  If the
\fIscript\fR returns with a condition of TCL_BREAK, no further
key/value pairs are considered for inclusion in the resulting
dictionary, and a condition of TCL_CONTINUE is equivalent to a false
result.
.TP
\fBdict filter \fIdictionaryValue \fBvalue \fIglobPattern\fR
The value rule only matches those key/value pairs whose values match
the given pattern (in the style of \fBstring match\fR.)
.RE
.TP
\fBdict for {\fIkeyVar valueVar\fB} \fIdictionaryValue body\fR
This command takes three arguments, the first a two-element list of
variable names (for the key and value respectively of each mapping in
the dictionary), the second the dictionary value to iterate across,
and the third a script to be evaluated for each mapping with the key
and value variables set appropriately (in the manner of \fBforeach\fR.)
The result of the command is an empty string. If any evaluation of the
body generates a TCL_BREAK result, no further pairs from the
dictionary will be iterated over and the \fBdict for\fR command will
terminate successfully immediately. If any evaluation of the body
generates a TCL_CONTINUE result, this shall be treated exactly like a
normal TCL_OK result.  The order of iteration is undefined.
.TP
\fBdict get \fIdictionaryValue \fR?\fIkey ...\fR?
Given a dictionary value (first argument) and a key (second argument),
this will retrieve the value for that key. Where several keys are
supplied, the behaviour of the command shall be as if the result of
\fBdict get $dictVal $key\fR was passed as the first argument to
\fBdict get\fR with the remaining arguments as second (and possibly
subsequent) arguments. This facilitates lookups in nested
dictionaries. For example, the following two commands are equivalent:
.RS
.CS
dict get $dict foo bar spong
dict get [dict get [dict get $dict foo] bar] spong
.CE
If no keys are provided, dict would return a list containing pairs of
elements in a manner similar to \fBarray get\fR. That is, the first
element of each pair would be the key and the second element would be
the value for that key.

It is an error to attempt to retrieve a value for a key that is not
present in the dictionary.
.RE
.TP
\fBdict incr \fIdictionaryVariable key \fR?\fIincrement\fR?
This adds the given increment value (an integer that defaults to 1 if
not specified) to the value that the given key maps to in the
dictionary value contained in the given variable, writing the
resulting dictionary value back to that variable. Non-existent keys
are treated as if they map to 0. It is an error to increment a value
for an existing key if that value is not an integer.
.TP
\fBdict info \fIdictionaryValue\fR
This returns information (intended for display to people) about the
given dictionary though the format of this data is dependent on the
implementation of the dictionary. For dictionaries that are
implemented by hash tables, it is expected that this will return the
string produced by \fBTcl_HashStats\fR, similar to \fBarray info\fR.
.TP
\fBdict keys \fIdictionaryValue \fR?\fIglobPattern\fR?
Return a list of all keys in the given dictionary value. If a pattern
is supplied, only those keys that match it (according to the rules of
\fBstring match\fR) will be returned. The returned keys will be in an
arbitrary implementation-specific order, though where no pattern is
supplied the i'th key returned by \fBdict keys\fR will be the key for
the i'th value returned by \fBdict values\fR applied to the same
dictionary value.
.TP
\fBdict lappend \fIdictionaryVariable key \fR?\fIvalue ...\fR?
This appends the given items to the list value that the given key maps
to in the dictionary value contained in the given variable, writing
the resulting dictionary value back to that variable. Non-existent
keys are treated as if they map to an empty list, and it is legal for
there to be no items to append to the list. It is an error for the
value that the key maps to to not be representable as a list.
.TP
\fBdict remove \fIdictionaryValue \fR?\fIkey ...\fR?
Return a new dictionary that is a copy of an old one passed in as
first argument except without mappings for each of the keys listed.
It is legal for there to be no keys to remove, and it also legal for
any of the keys to be removed to not be present in the input
dictionary in the first place.
.TP
\fBdict replace \fIdictionaryValue \fR?\fIkey value ...\fR?
Return a new dictionary that is a copy of an old one passed in as
first argument except with some values different or some extra
key/value pairs added. It is legal for this command to be called with
no key/value pairs, but illegal for this command to be called with a
key but no value.
.TP
\fBdict set \fIdictionaryVariable key \fR?\fIkey ...\fR? \fIvalue\fR
This operation takes the name of a variable containing a dictionary
value and places an updated dictionary value in that variable
containing a mapping from the given key to the given value. In a
manner analogous to \fBlset\fR, where multiple keys are present, they
do indexing into nested dictionaries.
.TP
\fBdict size \fIdictionaryValue\fR
Return the number of key/value mappings in the given dictionary value.
.TP
\fBdict unset \fIdictionaryVariable key \fR?\fIkey ...\fR?
This operation (the companion to \fBdict set\fR) takes the name of a
variable containing a dictionary value and places an updated
dictionary value in that variable that does not contain a mapping for
the given key. Where multiple keys are present, this describes a path
through nested dictionaries to the mapping to remove. At least one key
must be specified, but the last key on the key-path need not exist.
All other components on the path must exist.
.TP
\fBdict values \fIdictionaryValue \fR?\fIglobPattern\fR?
Return a list of all values in the given dictionary value. If a
pattern is supplied, only those values that match it (according to the
rules of \fBstring match\fR) will be returned. The returned values
will be in an arbitrary implementation-specific order, though where no
pattern is supplied the i'th key returned by \fBdict keys\fR will be
the key for the i'th value returned by \fBdict values\fR applied to
the same dictionary value.

.SH "SEE ALSO"
append(n), array(n), foreach(n), incr(n), list(n), lappend(n), set(n)

.SH KEYWORDS
dictionary, create, update, lookup, iterate, filter
