///////////////////////////////////////////////////////////////////
// Started with the install script from the mozilla activex plugin
// http://www.iol.ie/~locka/mozilla/plugin.htm

var SOFTWARE_NAME  = "Tcl/Tk Plugin";
var VERSION        = "3.0";
var PLID_BASE      = "@mozilla.org/TclPlugin";
var PLID           = PLID_BASE + ",version=" + VERSION;

var FLDR_PLUGINS   = getFolder("Plugins");

// This information is passed in by the script that generates
// the appropriate install.js for each platform's XPI
// TCLKITEXE may be empty if it's not needed on a specific platform
var NPAPIDLL       = new FileToInstall("libnptcl3.0.so", FLDR_PLUGINS);
var TCLKITDLL      = new FileToInstall("tclplugin.so", FLDR_PLUGINS);
var TCLKITEXE      = new FileToInstall("base-tk-solaris-ix86", FLDR_PLUGINS);
// Specified in bytes
var SPACE_REQD     = 6428411;

var filesToAdd     = new Array(NPAPIDLL, TCLKITDLL, TCLKITEXE);

///////////////////////////////////////////////////////////////////


// Invoke initInstall to start the installation
err = initInstall(SOFTWARE_NAME, PLID, VERSION);
if (err == BAD_PACKAGE_NAME)
{
    // HACK: Mozilla 1.1 has a busted PLID parser which doesn't like
    // the equals sign
    PLID = PLID_BASE;
    err = initInstall(SOFTWARE_NAME, PLID, VERSION);
}

if (err == SUCCESS)
{
    // Install plugin files
    err = verifyDiskSpace(FLDR_PLUGINS, SPACE_REQD);
    if (err == SUCCESS)
    {
        for (i = 0; i < filesToAdd.length; i++)
        {
	    if (filesToAdd[i].name == "") { continue }
            err = addFile(PLID, VERSION, filesToAdd[i].name,
			  filesToAdd[i].path, null);
            if (err != SUCCESS)
            {
                alert("Installation of " + filesToAdd[i].name +
		      " failed. Error code " + err);
                logComment("adding file " + filesToAdd[i].name +
			   " failed. Errror code: " + err);
                break;
            }
        }
    }
    else
    {
        logComment("Cancelling current browser install due to lack of space...");
    }
}
else
{
    logComment("Install failed at initInstall level with " + err);
}


if (err == SUCCESS)
{
    err = performInstall();
    if (err == SUCCESS)
    {
	// Refresh plugin list and reload pages (1)
        refreshPlugins(1);
    }
}
else
{
    cancelInstall();
}

/**
 * Function for preinstallation of plugin (FirstInstall).
 * You should not stop the install process because the function failed,
 * you still have a chance to install the plugin for the already
 * installed gecko browsers.
 *
 * @param dirPath	directory path from getFolder
 * @param spaceRequired	required space in kilobytes
 * 
 **/
function verifyDiskSpace(dirPath, spaceRequired)
{
    var spaceAvailable;

    // Get the available disk space on the given path
    spaceAvailable = fileGetDiskSpaceAvailable(dirPath);
 
    // Convert the available disk space into kilobytes
    spaceAvailable = parseInt(spaceAvailable / 1024);

    // do the verification
    if(spaceAvailable < spaceRequired)
    {
        logComment("Insufficient disk space: " + dirPath);
        logComment("  required : " + (spaceRequired / 1024) + " K");
        logComment("  available: " + (spaceAvailable / 1024) + " K");
        return INSUFFICIENT_DISK_SPACE;
    }

    return SUCCESS;
}

function FileToInstall(fileName, dirPath)
{
    this.name = fileName;
    this.path = dirPath;
}
