///////////////////////////////////////////////////////////////////
//
// Tcl plugin install.js script for XPI
//

var SOFTWARE_NAME  = "Tcl/Tk Plugin";
var VERSION        = "3.0";
var PLID_BASE      = "@mozilla.org/TclPlugin";
var PLID           = PLID_BASE + ",version=" + VERSION;

// This information is passed in by the script that generates
// the appropriate install.js for each platform's XPI
// TCLKITEXE may be empty if it's not needed on a specific platform
var NPAPIDLL       = "libnptcl3.0.so";
var TCLKITDLL      = "tclplugin.so";
var TCLKITEXE      = "base-tk-solaris-sparc";
// Specified in bytes
var SPACE_REQD     = 7638723;

var filesToAdd     = new Array(NPAPIDLL, TCLKITDLL, TCLKITEXE);

///////////////////////////////////////////////////////////////////

// Invoke initInstall to start the installation
err = initInstall(SOFTWARE_NAME, PLID, VERSION);
if (err == BAD_PACKAGE_NAME)
{
    // HACK: Mozilla 1.1 has a busted PLID parser which doesn't like
    // the equals sign
    PLID = PLID_BASE;
    err = initInstall(SOFTWARE_NAME, PLID, VERSION);
}

if (err == SUCCESS)
{
    err = doAddFiles();
}
else
{
    logComment("Install failed at initInstall level with " + err);
}

if (err == SUCCESS)
{
    err = performInstall();
    if (err == SUCCESS)
    {
	// Refresh plugin list and reload pages (1)
        refreshPlugins(1);
    }
}
else
{
    cancelInstall();
}

/**
 * Function for preinstallation of plugin (FirstInstall).
 * You should not stop the install process because the function failed,
 * you still have a chance to install the plugin for the already
 * installed gecko browsers.
 *
 * @param dirPath	directory path from getFolder
 * @param spaceRequired	required space in bytes
 * 
 **/
function verifyDiskSpace(dirPath, spaceRequired)
{
    var spaceAvailable;

    // Get the available disk space on the given path in bytes
    spaceAvailable = fileGetDiskSpaceAvailable(dirPath);
 
    // do the verification
    if (spaceAvailable < spaceRequired)
    {
        logComment("Insufficient disk space: " + dirPath);
        logComment("  required : " + parseInt(spaceRequired / 1024) + " K");
        logComment("  available: " + parseInt(spaceAvailable / 1024) + " K");
        return INSUFFICIENT_DISK_SPACE;
    }

    return SUCCESS;
}

function doAddFiles()
{
    // Install plugin files
    var folder = getFolder("Plugins");
    // "Current User" is actually the current profile directory
    var userFolder = getFolder("Current User", "../../plugins");
    if (getPlatform() == "win")
    {
	// Windows has extra /Profiles/ path component
	userFolder = getFolder("Current User", "../../../plugins");
    }

    err = verifyDiskSpace(folder, SPACE_REQD);
    if (err == SUCCESS)
    {
	for (i = 0; i < filesToAdd.length; i++)
	{
	    if (filesToAdd[i] == "") { continue }
	    err = addFile(PLID, VERSION, filesToAdd[i], folder, null);
	    if ((err == ACCESS_DENIED) && (i == 0) && (folder != userFolder)
		&& (verifyDiskSpace(userFolder, SPACE_REQD) == SUCCESS)
		&& confirm("Unable to install to \"" + folder + "\".\n" +
			   "Attempt install to user-specific plugins folder \""
			   + userFolder + "\"?"))
	    {
		File.dirCreate(userFolder); // we don't care about result
		folder = userFolder;
		i = -1;
		continue;
	    }
	    if (err != SUCCESS)
	    {
		alert("Installation of " + filesToAdd[i] +
		      " failed.\nError code " + err);
		logComment("Adding file " + filesToAdd[i] + " to " + folder +
			   " failed. Errror code: " + err);
		return err;
	    }
	}
    }
    else
    {
	logComment("Cancelling current browser install due to lack of space...");
    }
    return err;
}

function getPlatform( )
{
    var platformStr;
    var platformNode;
    if('platform' in Install)
    {
        platformStr = new String(Install.platform);
        if (!platformStr.search(/^Macintosh/))
            platformNode = 'mac';
        else if (!platformStr.search(/^Win/))
            platformNode = 'win';
        else
            platformNode = 'unix';
    }
    else
    {
        var fOSMac  = getFolder("Mac System");
        var fOSWin  = getFolder("Win System");
        logComment("fOSMac: "  + fOSMac);
        logComment("fOSWin: "  + fOSWin);
        if(fOSMac != null)
            platformNode = 'mac';
        else if(fOSWin != null)
            platformNode = 'win';
        else
            platformNode = 'unix';
    }
    return platformNode;
}
