/*
  File: rsa-user.c

  Authors:
        Mika Kojo <mkojo@ssh.fi>
        Tero T Mononen <tmo@ssh.fi>

  Description:
        Description for how to make RSA keys

  Copyright:
        Copyright (c) 2001 SSH Communications Security Corp, Finland.
        All rights reserved.
*/

#include "sshincludes.h"
#include "sshpk.h"
#include "rsa.h"
#include "sshrgf.h"
#include "sshcrypt.h"

#ifdef WITH_RSA
const SshPkSignature ssh_if_modn_signature_schemes[] =
  {
#ifdef SSHDIST_CRYPT_SHA
    { "rsa-pkcs1-sha1", NULL_FNPTR,
      &ssh_rgf_pkcs1_sha1_def,
      ssh_rsa_private_key_max_signature_input_len,
      ssh_rsa_private_key_max_signature_output_len,
      ssh_rsa_public_key_verify,
      NULL_FNPTR,
      ssh_rsa_private_key_sign,
      NULL_FNPTR },
#endif /* SSHDIST_CRYPT_SHA */
#ifdef SSHDIST_CRYPT_MD5
    { "rsa-pkcs1-md5", NULL_FNPTR,
      &ssh_rgf_pkcs1_md5_def,
      ssh_rsa_private_key_max_signature_input_len,
      ssh_rsa_private_key_max_signature_output_len,
      ssh_rsa_public_key_verify,
      NULL_FNPTR,
      ssh_rsa_private_key_sign,
      NULL_FNPTR },
#endif /* SSHDIST_CRYPT_MD5 */










    { "rsa-pkcs1-none", NULL_FNPTR,
      &ssh_rgf_pkcs1_none_def,
      ssh_rsa_private_key_max_signature_unhash_input_len,
      ssh_rsa_private_key_max_signature_output_len,
      ssh_rsa_public_key_verify,
      NULL_FNPTR,
      ssh_rsa_private_key_sign,
      NULL_FNPTR },
    { NULL }
  };

/* Table of all supported encryption schemes for if-modn keys. */

const SshPkEncryption ssh_if_modn_encryption_schemes[] =
  {
#ifdef SSHDIST_CRYPT_SHA
    { "rsa-pkcs1v2-oaep", NULL_FNPTR,
      &ssh_rgf_pkcs1v2_sha1_def,
      ssh_rsa_private_key_max_decrypt_input_len,
      ssh_rsa_private_key_max_decrypt_output_len,
      ssh_rsa_private_key_decrypt,
      NULL_FNPTR,
      ssh_rsa_public_key_max_oaep_encrypt_input_len,
      ssh_rsa_public_key_max_encrypt_output_len,
      ssh_rsa_public_key_encrypt,
      NULL_FNPTR,
      NULL_FNPTR, NULL_FNPTR, NULL_FNPTR, NULL_FNPTR },
    { "rsa-pkcs1-none", NULL_FNPTR,
      &ssh_rgf_pkcs1_sha1_def,
      ssh_rsa_private_key_max_decrypt_input_len,
      ssh_rsa_private_key_max_decrypt_output_len,
      ssh_rsa_private_key_decrypt,
      NULL_FNPTR,
      ssh_rsa_public_key_max_encrypt_input_len,
      ssh_rsa_public_key_max_encrypt_output_len,
      ssh_rsa_public_key_encrypt,
      NULL_FNPTR,
      NULL_FNPTR, NULL_FNPTR, NULL_FNPTR, NULL_FNPTR },
#endif /* SSHDIST_CRYPT_SHA */
    { "rsa-none-none", NULL_FNPTR,
      &ssh_rgf_dummy_def,
      ssh_rsa_private_key_max_decrypt_input_len,
      ssh_rsa_private_key_max_decrypt_output_len,
      ssh_rsa_private_key_decrypt,
      NULL_FNPTR,
      ssh_rsa_public_key_max_none_encrypt_input_len,
      ssh_rsa_public_key_max_encrypt_output_len,
      ssh_rsa_public_key_encrypt,
      NULL_FNPTR,
      ssh_rsa_private_key_none_encrypt, NULL_FNPTR,
      ssh_rsa_public_key_none_decrypt, NULL_FNPTR },
    { NULL }
  };

/* RSA special actions. */
const SshPkAction ssh_pk_if_modn_actions[] =
  {
    /* key type */
    { SSH_PKF_KEY_TYPE, NULL,
      SSH_PK_FLAG_KEY_TYPE | SSH_PK_FLAG_PRIVATE_KEY |
      SSH_PK_FLAG_PUBLIC_KEY | SSH_PK_FLAG_PK_GROUP,
      SSH_PK_SCHEME_NONE, 0, NULL },

    /* Schemes */
    { SSH_PKF_SIGN, "sign",
      SSH_PK_FLAG_SCHEME | SSH_PK_FLAG_PRIVATE_KEY |
      SSH_PK_FLAG_PUBLIC_KEY, SSH_PK_SCHEME_SIGN,
      sizeof(SshPkSignature),
      ssh_if_modn_signature_schemes, NULL_FNPTR },

    { SSH_PKF_ENCRYPT, "encrypt",
      SSH_PK_FLAG_SCHEME | SSH_PK_FLAG_PRIVATE_KEY |
      SSH_PK_FLAG_PUBLIC_KEY, SSH_PK_SCHEME_ENCRYPT,
      sizeof(SshPkEncryption),
      ssh_if_modn_encryption_schemes, NULL_FNPTR },

    /* Handling of RSA parameters. Assuming SshMPInt input. */
    { SSH_PKF_PRIME_P, NULL,
      SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PRIVATE_KEY,
      SSH_PK_SCHEME_NONE, 0, NULL,
      ssh_rsa_action_private_key_put,
      ssh_rsa_action_private_key_get },

    { SSH_PKF_PRIME_Q, NULL,
      SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PRIVATE_KEY,
      SSH_PK_SCHEME_NONE, 0,
      NULL,
      ssh_rsa_action_private_key_put,
      ssh_rsa_action_private_key_get },

    { SSH_PKF_MODULO_N, NULL,
      SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PRIVATE_KEY,
      SSH_PK_SCHEME_NONE, 0,
      NULL,
      ssh_rsa_action_private_key_put,
      ssh_rsa_action_private_key_get },

    { SSH_PKF_MODULO_N, NULL,
      SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PUBLIC_KEY | SSH_PK_FLAG_LIST,
      SSH_PK_SCHEME_NONE, 0,
      NULL,
      ssh_rsa_action_public_key_put,
      ssh_rsa_action_public_key_get },

    { SSH_PKF_SECRET_D, NULL,
      SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PRIVATE_KEY,
      SSH_PK_SCHEME_NONE, 0,
      NULL,
      ssh_rsa_action_private_key_put,
      ssh_rsa_action_private_key_get },

    { SSH_PKF_INVERSE_U, NULL,
      SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PRIVATE_KEY,
      SSH_PK_SCHEME_NONE, 0,
      NULL,
      ssh_rsa_action_private_key_put,
      ssh_rsa_action_private_key_get },

    { SSH_PKF_PUBLIC_E, NULL,
      SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PRIVATE_KEY,
      SSH_PK_SCHEME_NONE, 0,
      NULL,
      ssh_rsa_action_private_key_put,
      ssh_rsa_action_private_key_get },

    { SSH_PKF_PUBLIC_E, NULL,
      SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PUBLIC_KEY | SSH_PK_FLAG_LIST,
      SSH_PK_SCHEME_NONE, 0,
      NULL,
      ssh_rsa_action_public_key_put,
      ssh_rsa_action_public_key_get },

    /* Use some explicit size. Also get size (in bits) from private and
       public keys. */
    { SSH_PKF_SIZE, NULL,
      SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PRIVATE_KEY,
      SSH_PK_SCHEME_NONE, 0,
      NULL,
      ssh_rsa_action_private_key_put,
      ssh_rsa_action_private_key_get },

    { SSH_PKF_SIZE, NULL,
      SSH_PK_FLAG_SPECIAL | SSH_PK_FLAG_PUBLIC_KEY | SSH_PK_FLAG_LIST,
      SSH_PK_SCHEME_NONE, 0,
      NULL,
      NULL_FNPTR,
      ssh_rsa_action_public_key_get },

    /* End of list. */
    { SSH_PKF_END }
  };


const SshPkType ssh_pk_if_modn =
  {
    "if-modn",
    ssh_pk_if_modn_actions,

    /* No group operations available. */
    NULL_FNPTR, NULL_FNPTR, NULL_FNPTR, NULL_FNPTR,
    NULL_FNPTR, NULL_FNPTR, NULL_FNPTR, NULL_FNPTR,
    NULL_FNPTR, NULL_FNPTR, NULL_FNPTR, NULL_FNPTR,
    NULL_FNPTR,

    /* Basic public key operations. */
    ssh_rsa_public_key_init_action,
    ssh_rsa_public_key_make_action,
    ssh_rsa_private_key_init_ctx_free,

    ssh_rsa_public_key_import,
    ssh_rsa_public_key_export,
    ssh_rsa_public_key_free,
    ssh_rsa_public_key_copy,
    NULL_FNPTR, NULL_FNPTR,

    /* Basic private key operations. */
    ssh_rsa_private_key_init_action,
    ssh_rsa_private_key_define_action,
    NULL_FNPTR,
    ssh_rsa_private_key_init_ctx_free,

    ssh_rsa_private_key_import,
    ssh_rsa_private_key_export,
    ssh_rsa_private_key_free,
    ssh_rsa_private_key_derive_public_key,
    ssh_rsa_private_key_copy,
    NULL_FNPTR, NULL_FNPTR,
  };
#endif /* WITH_RSA */
