#ifndef PKCS1_H_INCLUDE
#define PKCS1_H_INCLUDE

#include "sshmp.h"

Boolean
ssh_pkcs1_wrap(const unsigned char *oid,
               const unsigned char *data,
               size_t data_len,
               unsigned char **ber_ret,
               size_t *ber_len_ret);

Boolean
ssh_pkcs1_unwrap(const unsigned char *ber,
                 size_t ber_len,
                 unsigned char **oid_ret,
                 unsigned char **data_ret,
                 size_t *data_len_ret);
                           
Boolean
ssh_pkcs1_pad(SshMPInt output, 
              SshMPInt input,
              unsigned int input_len,
              unsigned int tag_number,
              unsigned int len);


Boolean 
ssh_pkcs1_unpad(unsigned int tag_number,
                SshMPInt input,
                unsigned char *output_buffer,
                size_t output_buffer_length,
                size_t *return_length);

#endif /* PKCS1_H_INCLUDE */
