/*

  libmonitor.c

  Author: Mika Kojo <mkojo@ssh.fi>

  Copyright (C) 1997-2000 SSH Communications Security Oy, Espoo, Finland
  All rights reserved.

  Created: Thu Jun 12 16:32:48 1997 [mkojo]

  Crypto library monitoring functions.

  */

/*
 * $Id: libmonitor.c,v 1.3 2001/11/21 18:40:33 cessu Exp $
 * $Log: libmonitor.c,v $ * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * $EndLog$
 */

#include "sshincludes.h"
#include "sshcrypt.h"
#include "libmonitor.h"

/* Global working pointer, that'll indicate the position of applications
   routine for handling these calls. */

SshCryptoProgressMonitor ssh_crypto_progress_monitor_function = NULL_FNPTR;
void                    *ssh_crypto_progress_context = NULL;

/* Interface from library. */

void ssh_crypto_progress_monitor(SshCryptoProgressID id,
                                 unsigned int time_value)
{
  if (ssh_crypto_progress_monitor_function != NULL_FNPTR)
    (*ssh_crypto_progress_monitor_function)(id, time_value,
                                            ssh_crypto_progress_context);
}

/* Interface from application. */

void
ssh_crypto_library_register_progress_func(SshCryptoProgressMonitor
                                          monitor_function,
                                          void *progress_context)
{
  if (monitor_function == NULL_FNPTR)
    {
      ssh_crypto_progress_monitor_function = NULL_FNPTR;
      ssh_crypto_progress_context = NULL;
      return;
    }

  ssh_crypto_progress_monitor_function = monitor_function;
  ssh_crypto_progress_context = progress_context;
  return;
}

/* libmonitor.c */
