
typedef struct SshDlpInitCtxRec
{
  SshMPIntStruct p, g, q, x, y;
  unsigned int size;
  unsigned int exponent_entropy;
  const char *predefined;

#define DLP_FLAG_IGNORE  0
#define DLP_FLAG_DSA     1
  unsigned int flag;

} SshDLPInitCtx;

typedef struct SshDLParamRec
{
  struct SshDLParamRec *next, *prev;
  SshCStack stack;
  unsigned int reference_count;

  /* Predefined parameter sets have this defined. */
  const char *predefined;

  /* Actual parameter information. */
  SshMPIntStruct p;
  SshMPIntStruct g;
  SshMPIntStruct q;

  /* Precomputed. */
  Boolean base_defined;
  void *base;   /*  SshMPIntModPowPrecomp pointer */

  /* Information about the policy when generating random numbers. */
  unsigned int exponent_entropy;
} *SshDLParam, SshDLParamStruct;

/* Discrete Logarithm key structures. */

/* Public key:

   parameters and
   y - public key (g^x mod p)
   */

typedef struct SshDLPublicKeyRec
{
  SshDLParam param;
  SshMPIntStruct y;
} SshDLPublicKey;

/* Private key:

   parameters and
   y - public key (g^x mod p)
   x - private key
   */

typedef struct SshDLPrivateKeyRec
{
  SshDLParam param;
  SshMPIntStruct x;
  SshMPIntStruct y;
} SshDLPrivateKey;


void ssh_dlp_init_param(SshDLParam param);
void ssh_dlp_init_public_key(SshDLPublicKey *pub_key, SshDLParam param);
void ssh_dlp_init_private_key(SshDLPrivateKey *prv_key, SshDLParam param);

void ssh_dlp_clear_param(SshDLParam param);
void ssh_dlp_clear_public_key(SshDLPublicKey *pub_key);
void ssh_dlp_clear_private_key(SshDLPrivateKey *prv_key);

SshDLParam ssh_dlp_param_list_add(SshDLParam param);
SshDLParam ssh_dlp_param_create_predefined(const char *predefined);
SshDLParam ssh_dlp_param_create(SshMPIntegerConst p,
                                SshMPIntegerConst q,
                                SshMPIntegerConst g);

void *ssh_dlp_action_make(SshDLPInitCtx *ctx,
                          SshDLParam param,
                          int type);

#define SSH_DLP_STACK_RANDOMIZER  0x1

/* Randomizer */

SSH_CSTACK_BEGIN( SshDLStackRandomizer )
  SshMPIntStruct k;
  SshMPIntStruct gk;
SSH_CSTACK_END( SshDLStackRandomizer );
