/*
  File: sshmac.h

  Authors:
        Tero T Mononen <tmo@ssh.fi>

  Description:


  Copyright:
        Copyright (c) 2000, 2001 SSH Communications Security Corp, Finland.
        All rights reserved.
*/

#ifndef SSHMAC_H
#define SSHMAC_H

/* Definition structure for mac functions. */
typedef struct SshMacDefRec
{
  const char *name;
  size_t digest_length;
  /* Some mac functions need to allocate space of variable length, this
     will indicate it. */
  Boolean allocate_key;
  /* Indicate which hash function to use. This should be generic enough
     for all our needs. But if not, then add more options. */
  const SshHashDefStruct *hash_def;
  size_t (*ctxsize)(const SshHashDefStruct *hash_def);
  void (*init)(void *context, const unsigned char *key, size_t keylen,
               const SshHashDefStruct *hash_def);
  void (*start)(void *context);
  void (*update)(void *context, const unsigned char *buf,
                 size_t len);
  void (*final)(void *context, unsigned char *digest);
  void (*mac_of_buffer)(void *context, const unsigned char *buf,
                        size_t len, unsigned char *digest);
} *SshMacDef, SshMacDefStruct;

typedef struct SshCipherMacDefRec
{
  const char *name;
  size_t digest_length;
  size_t (*ctxsize)(void);
  Boolean (*init)(void *context, const unsigned char *key,
                  size_t keylen, Boolean for_encryption);
  void (*cbcmac)(void *context, const unsigned char *src,
                 size_t len, unsigned char *iv);
} *SshCipherMacDef, SshCipherMacDefStruct;

#endif /* SSHMAC_H */
