/*

  genmac.c

  Author: Mika Kojo <mkojo@ssh.fi>

  Copyright (C) 1997-2002 SSH Communications Security Oy, Espoo, Finland
  All rights reserved.

  Created: Thu Jan  9 12:22:52 1997 [mkojo]

  Message authentication code calculation routines.

  */

/*
 * $Id: genmac.c,v 1.7 2002/04/09 17:03:34 sjl Exp $
 * $Log: genmac.c,v $ * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * $EndLog$
 */

#include "sshincludes.h"
#include "sshcrypt.h"
#include "sshbuffer.h"
#include "sshhash/sshhash.h"
#include "sshcipher/sshcipher.h"
#include "sshmac.h"

#ifdef SSHDIST_CRYPT_DES
#include "sshcipher/des.h"
#endif /* SSHDIST_CRYPT_DES */

#ifdef SSHDIST_CRYPT_BLOWFISH
#include "sshcipher/blowfish.h"
#endif /* SSHDIST_CRYPT_BLOWFISH */

#ifdef SSHDIST_CRYPT_CAST
#include "sshcipher/cast.h"
#endif /* SSHDIST_CRYPT_CAST */







#ifdef SSHDIST_CRYPT_TWOFISH
#include "sshcipher/twofish.h"
#endif /* SSHDIST_CRYPT_TWOFISH */

















#ifdef SSHDIST_CRYPT_RIJNDAEL
#include "sshcipher/rijndael.h"
#endif /* SSHDIST_CRYPT_RIJNDAEL */








#ifdef SSHDIST_CRYPT_HMAC
#include "hmac.h"



#endif /* SSHDIST_CRYPT_HMAC */

#ifdef SSHDIST_CRYPT_MD5
#include "sshhash/md5.h"
#endif /* SSHDIST_CRYPT_MD5 */

#ifdef SSHDIST_CRYPT_SHA
#include "sshhash/sha.h"
#include "sshhash/sha256.h"
#endif /* SSHDIST_CRYPT_SHA */

#ifdef SSHDIST_CRYPT_RIPEMD160
#include "sshhash/ripemd160.h"
#endif /* SSHDIST_CRYPT_RIPEMD160 */

#ifndef KERNEL
/* These MACs/hashes can only be used in user-mode code.  To add a
   hash/mac to be used in kernel code, it must be moved outside this
   ifdef both here and later in this file, and added to CRYPT_LNOBJS
   in src/ipsec/engine/Makefile.am.  */









#endif /* !KERNEL */

/* Control structure. */
/* XXX Remove ifdef's for SSHDIST_SSH2, and make a mapping in the ssh2
   protocol library instead. This stuff was committed because there was
   no time for extensive changes before ssh-3.2.0 release. //sjl */
static const SshMacDefStruct ssh_mac_algorithms[] =
{
#ifdef SSHDIST_CRYPT_HMAC

#ifdef SSHDIST_CRYPT_MD5
  { "hmac-md5", 16, FALSE,
    &ssh_hash_md5_def,
    ssh_hmac_ctxsize, ssh_hmac_init,
    ssh_hmac_start, ssh_hmac_update, ssh_hmac_final,
    ssh_hmac_of_buffer },
  { "hmac-md5-96", 12, FALSE,
    &ssh_hash_md5_def,
    ssh_hmac_ctxsize, ssh_hmac_init,
    ssh_hmac_start, ssh_hmac_update, ssh_hmac_96_final,
    ssh_hmac_96_of_buffer },
#endif /* SSHDIST_CRYPT_MD5 */
#ifdef SSHDIST_CRYPT_SHA
  { "hmac-sha1", 20, FALSE,
    &ssh_hash_sha_def,
    ssh_hmac_ctxsize, ssh_hmac_init,
    ssh_hmac_start, ssh_hmac_update, ssh_hmac_final,
    ssh_hmac_of_buffer },
  { "hmac-sha1-96", 12, FALSE,
    &ssh_hash_sha_def,
    ssh_hmac_ctxsize, ssh_hmac_init,
    ssh_hmac_start, ssh_hmac_update, ssh_hmac_96_final,
    ssh_hmac_96_of_buffer },
  {


#ifdef SSHDIST_SSH2
    "hmac-sha256@ssh.com",
#endif /* SSHDIST_SSH2 */
    32, FALSE,
    &ssh_hash_sha256_def,
    ssh_hmac_ctxsize, ssh_hmac_init,
    ssh_hmac_start, ssh_hmac_update, ssh_hmac_final,
    ssh_hmac_of_buffer },
  {


#ifdef SSHDIST_SSH2
    "hmac-sha256-96@ssh.com",
#endif /* SSHDIST_SSH2 */
    12, FALSE,
    &ssh_hash_sha256_96_def,
    ssh_hmac_ctxsize, ssh_hmac_init,
    ssh_hmac_start, ssh_hmac_update, ssh_hmac_96_final,
    ssh_hmac_96_of_buffer },
#endif /* SSHDIST_CRYPT_SHA */
#ifdef SSHDIST_CRYPT_RIPEMD160
  {


#ifdef SSHDIST_SSH2
    "hmac-ripemd160@ssh.com",
#endif /* SSHDIST_SSH2 */
    20, FALSE,
    &ssh_hash_ripemd160_def,
    ssh_hmac_ctxsize, ssh_hmac_init,
    ssh_hmac_start, ssh_hmac_update, ssh_hmac_final,
    ssh_hmac_of_buffer },
  {


#ifdef SSHDIST_SSH2
    "hmac-ripemd160-96@ssh.com",
#endif /* SSHDIST_SSH2 */
    12, FALSE,
    &ssh_hash_ripemd160_def,
    ssh_hmac_ctxsize, ssh_hmac_init,
    ssh_hmac_start, ssh_hmac_update, ssh_hmac_96_final,
    ssh_hmac_96_of_buffer },
#endif /* SSHDIST_CRYPT_RIPEMD160 */

#ifndef KERNEL
  /* The macs below can only be used in user-mode code.  See comments
     above for more information. */




































































































#endif /* !KERNEL */

#endif /* SSHDIST_CRYPT_HMAC */













































































  { "none", 0, FALSE, NULL },
  { NULL }
};

static const SshCipherMacDefStruct ssh_cipher_mac_algorithms[] =
{

























  { NULL }
};

typedef enum
{
  SSH_MAC_TYPE_HASH,
  SSH_MAC_TYPE_CIPHER
} SshMacAlgType;

struct SshMacRec
{
  SshMacAlgType type;
  union {
    const SshMacDefStruct       *hash_ops;
    const SshCipherMacDefStruct *cipher_ops;
  } c;
  Boolean ops_allocated;
  unsigned char *workarea;
  unsigned int   counter;
  void *context;
};

/* Returns a comma-separated list of supported mac types.  The caller
   must return the list with ssh_xfree(). */

char *
ssh_mac_get_supported(void)
{
  int i;
  char *list, *tmp;
  size_t offset, list_len;

  list = NULL;
  offset = list_len = 0;

  for (i = 0; ssh_mac_algorithms[i].name != NULL; i++)
    {
      size_t newsize;
      newsize = offset + 1 + !!offset + strlen(ssh_mac_algorithms[i].name);

      if (list_len < newsize)
        {
          newsize *= 2;

          if ((tmp = ssh_realloc(list, list_len, newsize)) == NULL)
            {
              ssh_free(list);
              return NULL;
            }
          list = tmp;
          list_len = newsize;
        }

      offset += ssh_snprintf(list + offset, list_len - offset, "%s%s",
                             offset ? "," : "",
                             ssh_mac_algorithms[i].name);

    }

  for (i = 0; ssh_cipher_mac_algorithms[i].name != NULL; i++)
    {
      size_t newsize;
      newsize = offset + 1 + !!offset +
        strlen(ssh_cipher_mac_algorithms[i].name);

      if (list_len < newsize)
        {
          newsize *= 2;

          if ((tmp = ssh_realloc(list, list_len, newsize)) == NULL)
            {
              ssh_free(list);
              return NULL;
            }

          list = tmp;
          list_len = newsize;
        }

      offset += ssh_snprintf(list + offset, list_len - offset, "%s%s",
                             offset ? "," : "",
                             ssh_cipher_mac_algorithms[i].name);

    }

  return list;
}

/* Check if given mac name belongs to the set of supported ciphers. */

Boolean
ssh_mac_supported(const char *name)
{
  unsigned int i;

  if (name == NULL)
    return FALSE;

  for (i = 0; ssh_mac_algorithms[i].name != NULL; i++)
    if (strcmp(ssh_mac_algorithms[i].name, name) == 0)
      return TRUE;

  for (i = 0; ssh_cipher_mac_algorithms[i].name != NULL; i++)
    if (strcmp(ssh_cipher_mac_algorithms[i].name, name) == 0)
      return TRUE;

  return FALSE;
}

/* Allocate mac for use in session. */

SshCryptoStatus
ssh_mac_allocate(const char *type,
                 const unsigned char *key, size_t keylen,
                 SshMac *mac_return)
{
  int i;
  SshMac mac;

  *mac_return = NULL;

  /* Find the desired mac type from the array. */
  for (i = 0; ssh_mac_algorithms[i].name != NULL; i++)
    {
      if (strcmp(ssh_mac_algorithms[i].name, type) == 0)
        {
          /* Found the specified mac type.  Initialize the data structure. */
          if (!(mac = ssh_malloc(sizeof(*mac))))
            return SSH_CRYPTO_OPERATION_FAILED;
          mac->type          = SSH_MAC_TYPE_HASH;
          mac->c.hash_ops    = &ssh_mac_algorithms[i];
          mac->ops_allocated = FALSE;
          mac->workarea      = NULL;

          if (mac->c.hash_ops->ctxsize)
            {
              mac->context = ssh_malloc((*mac->c.hash_ops->ctxsize)
                                        (ssh_mac_algorithms[i].hash_def) +
                                        (mac->c.hash_ops->allocate_key ==
                                         TRUE
                                         ? keylen : 0));

              if (!mac->context)
                {
                  ssh_free(mac);
                  return SSH_CRYPTO_OPERATION_FAILED;
                }

              (*mac->c.hash_ops->init)(mac->context, key, keylen,
                                       ssh_mac_algorithms[i].hash_def);
            }
          else
            mac->context = NULL;

          /* Return the MAC context. */
          *mac_return = mac;
          return SSH_CRYPTO_OK;
        }
    }

  /* Cipher macs. */
  for (i = 0; ssh_cipher_mac_algorithms[i].name != NULL; i++)
    {
      if (strcmp(ssh_cipher_mac_algorithms[i].name, type) == 0)
        {
          if (!(mac = ssh_malloc(sizeof(*mac))))
            return SSH_CRYPTO_OPERATION_FAILED;
          mac->type = SSH_MAC_TYPE_CIPHER;
          mac->c.cipher_ops = &ssh_cipher_mac_algorithms[i];
          mac->ops_allocated = FALSE;

          if (mac->c.cipher_ops->ctxsize)
            {
              mac->workarea = ssh_malloc(mac->c.cipher_ops->digest_length +
                                         (*mac->c.cipher_ops->ctxsize)());
              if (!mac->workarea)
                {
                  ssh_free(mac);
                  return SSH_CRYPTO_OPERATION_FAILED;
                }
              mac->context  = mac->workarea +
                mac->c.cipher_ops->digest_length;
              (*mac->c.cipher_ops->init)(mac->context, key, keylen, TRUE);
            }
          else
            {
              mac->context = NULL;
              mac->workarea = NULL;
            }

          /* Return the MAC context. */
          *mac_return = mac;
          return SSH_CRYPTO_OK;
        }
    }

  return SSH_CRYPTO_UNSUPPORTED;
}

void *
ssh_mac_info_derive_from_hash(SshHash hash,
                              SshMacType type)
{
  const SshHashDefStruct *hash_def;
  SshMacDefStruct  *mac_def;
  char buffer[128], *tmp;

  if (hash == NULL)
    return NULL;
  hash_def = ssh_hash_get_definition_internal(hash);
  if (hash_def == NULL)
    return NULL;
  if (hash_def->name == NULL)
    return NULL;

  if (!(mac_def = ssh_malloc(sizeof(SshMacDefStruct))))
    return NULL;
  mac_def->hash_def = hash_def;

  switch (type)
    {
#ifdef SSHDIST_CRYPT_HMAC
    case SSH_MAC_TYPE_HMAC:
      mac_def->digest_length = hash_def->digest_length;
      mac_def->allocate_key  = FALSE;
      mac_def->ctxsize       = ssh_hmac_ctxsize;
      mac_def->init          = ssh_hmac_init;
      mac_def->start         = ssh_hmac_start;
      mac_def->update        = ssh_hmac_update;
      mac_def->final         = ssh_hmac_final;
      mac_def->mac_of_buffer = ssh_hmac_of_buffer;

      /* Build a name for it. */
      ssh_snprintf(buffer, 128, "hmac-%s", hash_def->name);
      if (!(tmp = ssh_malloc(strlen(buffer) + 1)))
        {
          ssh_free(mac_def);
          return NULL;
        }
      memcpy(tmp, buffer, strlen(buffer) + 1);
      mac_def->name = tmp;
      break;
#endif /* SSHDIST_CRYPT_HMAC */






















    default:
      ssh_free(mac_def);
      return NULL;
    }
  return (void *)mac_def;
}

void
ssh_mac_info_free(void *mac_info)
{
  SshMacDef mac_def = mac_info;

  ssh_free((char *)mac_def->name);
  ssh_free(mac_info);
}

/* Derive a mac from a hash. */
SshMac
ssh_mac_allocate_with_info(const void *mac_info,
                           unsigned char *key,
                           size_t keylen)
{
  SshMac mac;

  if (mac_info == NULL)
    return NULL;

  /* Found the specified mac type.  Initialize the data structure. */
  if (!(mac = ssh_malloc(sizeof(*mac))))
    return NULL;
  mac->type          = SSH_MAC_TYPE_HASH;
  mac->c.hash_ops    = (SshMacDef)mac_info;
  mac->ops_allocated = TRUE;
  mac->workarea      = NULL;

  if (mac->c.hash_ops->ctxsize)
    {
      mac->context = ssh_malloc((*mac->c.hash_ops->ctxsize)
                                (mac->c.hash_ops->hash_def) +
                                (mac->c.hash_ops->allocate_key == TRUE
                                 ? keylen : 0));

      if (!mac->context)
        {
          ssh_free(mac);
          return NULL;
        }
      (*mac->c.hash_ops->init)(mac->context, key, keylen,
                               mac->c.hash_ops->hash_def);
    }
  else
    {
      ssh_free(mac);
      return NULL;
    }

  return mac;
}

/* Free the mac. */

void
ssh_mac_free(SshMac mac)
{
  if (mac->ops_allocated)
    {
      ssh_mac_info_free((SshMacDef *)mac->c.hash_ops);
    }
  if (mac->workarea)
    ssh_free(mac->workarea);
  else
    ssh_free(mac->context);
  ssh_free(mac);
}

/* Get the lenght of mac digest */

size_t
ssh_mac_length(SshMac mac)
{
  switch (mac->type)
    {
    case SSH_MAC_TYPE_HASH:
      if (mac->c.hash_ops)
        if (mac->c.hash_ops->digest_length)
          return mac->c.hash_ops->digest_length;
      break;
    case SSH_MAC_TYPE_CIPHER:
      if (mac->c.cipher_ops)
        if (mac->c.cipher_ops->digest_length)
          return mac->c.cipher_ops->digest_length;
      break;
    }
  return 0;
}

/* Reset the mac to its initial state. This should be called before
   processing a new packet/message. */
void
ssh_mac_start(SshMac mac)
{
  switch (mac->type)
    {
    case SSH_MAC_TYPE_HASH:
      if (mac->c.hash_ops)
        if (mac->c.hash_ops->start)
          {
            (*mac->c.hash_ops->start)(mac->context);
            mac->counter = 0;
          }
      break;
    case SSH_MAC_TYPE_CIPHER:
      if (mac->c.cipher_ops)
        {
          memset(mac->workarea, 0, mac->c.cipher_ops->digest_length);
          mac->counter = 0;
        }
      break;
    }
}

void
ssh_mac_update(SshMac mac, const unsigned char *data, size_t len)
{
  switch (mac->type)
    {
    case SSH_MAC_TYPE_HASH:
      if (mac->c.hash_ops)
        if (mac->c.hash_ops->update)
          {
            (*mac->c.hash_ops->update)(mac->context, data, len);
            mac->counter += len;
          }
      break;
    case SSH_MAC_TYPE_CIPHER:
      if (mac->c.cipher_ops)
        if (mac->c.cipher_ops->cbcmac)
          {
            unsigned int i, j;
            unsigned char *b, *iv;

            b = mac->workarea;
            iv = b + mac->c.cipher_ops->digest_length;

            /* Position in the input data. */
            i = 0;

            if (mac->counter != 0)
              {
                for (j = mac->counter;
                     j < mac->c.cipher_ops->digest_length && i < len; i++, j++)
                  b[j] = data[i];

                mac->counter = j % mac->c.cipher_ops->digest_length;
                if (mac->counter)
                  return;

                (*mac->c.cipher_ops->cbcmac)(mac->context,
                                             b,
                                             mac->c.cipher_ops->digest_length,
                                             iv);
              }

            j = (len - i) % mac->c.cipher_ops->digest_length;
            len -= j;

            (*mac->c.cipher_ops->cbcmac)(mac->context, data + i, len - i,
                                         iv);
            if (j)
              {
                memcpy(b, data + len, j);
                mac->counter = j;
              }
          }
      break;
    }
}

void
ssh_mac_final(SshMac mac, unsigned char *digest)
{
  switch (mac->type)
    {
    case SSH_MAC_TYPE_HASH:
      if (mac->c.hash_ops)
        if (mac->c.hash_ops->final)
          (*mac->c.hash_ops->final)(mac->context, digest);
      break;
    case SSH_MAC_TYPE_CIPHER:
      if (mac->c.cipher_ops)
        if (mac->workarea)
          {
            unsigned char *b, *iv;
            unsigned int j;
            b = mac->workarea;
            iv = b + mac->c.cipher_ops->digest_length;

            if (mac->counter != 0)
              {
                for (j = mac->counter;
                     j < mac->c.cipher_ops->digest_length; j++)
                  b[j] = 0;

                (*mac->c.cipher_ops->cbcmac)(mac->context,
                                             b,
                                             mac->c.cipher_ops->digest_length,
                                             iv);
              }

            /* XXX Should we add the total length here also? */

            memcpy(digest, iv, mac->c.cipher_ops->digest_length);
          }
      break;
    }
}
