/*

  ssh2pubkeyencode.h

  Authors:
        Tatu Ylonen <ylo@ssh.fi>
        Markku-Juhani Saarinen <mjos@ssh.fi>
        Timo J. Rinne <tri@ssh.fi>
        Sami Lehtinen <sjl@ssh.fi>

  Copyright (C) 1997-1999, 2001 SSH Communications Security Oy, Espoo, Finland
  All rights reserved.

  Encode and decode ssh2 public key blobs.

*/

#ifndef PUBKEYENCODE_H
#define PUBKEYENCODE_H

#include "sshbuffer.h"
#include "sshmp.h"
#include "sshcrypt.h"

/* the "ssh-dss" type and related formats */
#define SSH_SSH_DSS    "ssh-dss"
#define SSH_SSH_X509_DSS    "x509v3-sign-dss"
#define SSH_CRYPTO_DSS "dl-modp{sign{dsa-nist-sha1},dh{plain}}"
#define SSH_CRYPTO_DSS_SHORT "dl-modp"

/* the "ssh-rsa" type and related formats */
#define SSH_SSH_RSA    "ssh-rsa"
#define SSH_SSH_X509_RSA    "x509v3-sign-rsa"
#define SSH_CRYPTO_RSA "if-modn{sign{rsa-pkcs1-sha1,rsa-pkcs1-md5,rsa-pkcs1-none},encrypt{rsa-pkcs1v2-oaep,rsa-pkcs1-none,rsa-none-none}}"
#define SSH_CRYPTO_RSA_SHORT "if-modn"

/* Encode a public key into a SSH2 format blob. Return size or 0 on
   failure. */

size_t ssh_encode_pubkeyblob(SshPublicKey pubkey, unsigned char **blob);

/* Decode a public key blob. Return NULL on failure. */

SshPublicKey ssh_decode_pubkeyblob(const unsigned char *blob, size_t bloblen);

/* Decode a public key blob or certificate. Return NULL on failure.
   pk_format should be set to "ssh_dss", "x509v3-sign-dss", etc.
   (as defined in ssh2 transport layer document) */
SshPublicKey ssh_decode_pubkeyblob_general(const unsigned char *blob,
                                           size_t bloblen,
                                           const unsigned char *pk_format);

/* Type of the encoded public key in blob.  Have to be freed with
   ssh_xfree. */
char *ssh_pubkeyblob_type(const unsigned char *blob, size_t bloblen);

/* Returns TRUE if pk_format matches one of the defined plain pubkey
   formats */
Boolean
ssh_pubkeyblob_type_plain(const unsigned char *pk_format);





















void
ssh_bufaux_put_mp_int_ssh2style(SshBuffer buffer, SshMPInteger mp);

Boolean
ssh_bufaux_get_mp_int_ssh2style(SshBuffer buffer, SshMPInteger mp);

#endif /* PUBKEYENCODE_H */
